(*  
   File:	$RCSfile: ToyVDM.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyVDM.thy,v 1.12 2003/06/29 21:41:11 a1hloidl Exp $

   Experimental instantiation to VDM
*)

theory ToyVDM = ToyHLderived:   (* Temporarily based on HL: could remove this easily *)

types
  "vdmassn" = "(state \<times> state \<times> val) set"  (* before state, after state, value *)

constdefs
  vdm_valid :: "state expr \<Rightarrow> vdmassn \<Rightarrow> bool"       ("\<Turnstile>\<^sub>v (1_)/ : (1_)" 50)
  "\<Turnstile>\<^sub>v e : P   \<equiv>  (\<forall> s t v. \<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<longrightarrow> (s,t,v) \<in> P)"


text {* Meaning of VDM validity related to Hoare validity: optional *}

lemma VDM_Hoare: "vdm_valid e P  \<equiv>  hoare_valid {(z,s).z=s} e P"
by (simp add: vdm_valid_def hoare_valid_def)

lemma HtoV: "\<Turnstile> {(z,s). z=s} e Q \<Longrightarrow> \<Turnstile>\<^sub>v e : Q"
by (simp add: vdm_valid_def hoare_valid_def)

lemma VtoH: "\<Turnstile>\<^sub>v e : Q \<Longrightarrow> \<Turnstile> {(z,s). z=s} e Q"
by (simp add: vdm_valid_def hoare_valid_def)

lemma VdmI [intro]:
"(\<forall> s t v. \<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<longrightarrow> (s,t,v) \<in> P) \<Longrightarrow> \<Turnstile>\<^sub>v e : P"
by (simp add: vdm_valid_def)

lemma VdmE [elim]: "\<lbrakk> \<Turnstile>\<^sub>v e : P; \<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<rbrakk> \<Longrightarrow> (s,t,v) \<in> P"
by (simp add: vdm_valid_def)

text {* Single structural rule of weakening *}

lemma VW: "\<lbrakk> \<Turnstile>\<^sub>v e : P'; P'\<subseteq>P \<rbrakk> \<Longrightarrow> \<Turnstile>\<^sub>v e:P"
by fastsimp

text {* The main rules *}

lemma VNull:  "\<Turnstile>\<^sub>v NULL : {(s, s', v). (s' = tick s) \<and> (v = RVal Nullref)}"
(* can be derived with: by (rule HtoV, rule HSP, rule HNull, auto) *)
by (auto elim: eval_cases)

lemma VInt:   "\<Turnstile>\<^sub>v (expr.Int i) : {(s,s',v). (s' = tick s) \<and> (v = IVal i)}"
by (auto elim: eval_cases)

lemma VIVar: "\<Turnstile>\<^sub>v (expr.IVar vn) : {(s, s', v). (s' = tick s) \<and> v = IVal s<vn>}"
by (fastsimp elim: eval_cases)


lemma VVarr: "\<Turnstile>\<^sub>v (expr.RVar vn) : {(s, s', v). (s' = tick s) \<and> v = RVal s\<lfloor>vn\<rfloor>}"
by (fastsimp elim: eval_cases)

subsection {* VPrimop, VRPrimop *}

lemma VPrimop: 
  "\<Turnstile>\<^sub>v (expr.Primop f vn1 vn2) : {(s,s',v). s' = tickn 3 s \<and> v = IVal (f (s<vn1>) (s<vn2>))}"
by (fastsimp elim: eval_cases)

lemma VRPrimop: 
  "\<Turnstile>\<^sub>v (expr.RPrimop f vn1 vn2) : {(s,s',v). s'=tickn 3 s \<and> v = IVal (f (s\<lfloor>vn1\<rfloor>) (s\<lfloor>vn2\<rfloor>))}"
by (fastsimp elim: eval_cases)

lemma VGetFi: "\<Turnstile>\<^sub>v (GetFi vn f) : {(s,s',v). s'=tickn 2 s \<and> v = IVal (s<(theloc s\<lfloor>vn\<rfloor>)\<bullet>f>)}"
by (fastsimp elim: eval_cases)

lemma VGetFr: "\<Turnstile>\<^sub>v (GetFr vn f) : {(s,s',v). s'=tickn 2 s \<and> v = RVal (s\<lfloor>(theloc s\<lfloor>vn\<rfloor>)\<diamondsuit>f\<rfloor>)}"
by (fastsimp elim: eval_cases)

lemma VPutFi: 
  "\<Turnstile>\<^sub>v (PutFi vn f valv) : {(s,s',v). s' = tickn 3 (s<(theloc s\<lfloor>vn\<rfloor>)\<bullet>f := (s<valv>)>)
				     \<and> v = IVal (s<valv>)}"
by (fastsimp elim: eval_cases)

lemma VPutFr: 
  "\<Turnstile>\<^sub>v (PutFr vn f valv) : {(s,s',v). s'= tickn 3 (s\<lfloor>(theloc s\<lfloor>vn\<rfloor>)\<diamondsuit>f := (s\<lfloor>valv\<rfloor>)\<rfloor>) 
				     \<and> v = RVal (s\<lfloor>valv\<rfloor>)}"
by (fastsimp elim: eval_cases)

lemma VNew: "\<Turnstile>\<^sub>v (New c ifldvals rfldvals) : 
	  {(s,s',v). s'=tick (newobj s c ifldvals rfldvals) \<and> v = RVal (Ref (freshlocst s))}"
by (fastsimp elim: eval_cases)


subsection {* Conditionals *}

text {* VIf is the first rule which has nested sub-expressions.
  This combines an instance of strengthening pre-condition. 
  *}

lemma VIf : "\<lbrakk> \<Turnstile>\<^sub>v e1 : P1; \<Turnstile>\<^sub>v e2 : P2 \<rbrakk>
          \<Longrightarrow> \<Turnstile>\<^sub>v (IF x THEN e1 ELSE e2) : 
		{(s,s',v).  (s<x>=grailbool True \<longrightarrow> (tick s,s',v)\<in> P1)
		 	  \<and> (s<x>=grailbool False \<longrightarrow> (tick s,s',v)\<in> P2)}"
by (unfold vdm_valid_def, fastsimp elim!: eval_cases)

text {* We can derive a stronger version of this rule which specifies
  additionally that the condition should be true or false (unused
  presently). *}

lemma VIfstrong : "\<lbrakk> \<Turnstile>\<^sub>v e1 : P1; \<Turnstile>\<^sub>v e2 : P2 \<rbrakk>
          \<Longrightarrow> \<Turnstile>\<^sub>v (IF x THEN e1 ELSE e2) : 
		{(s,s',v).  (s<x>=grailbool True \<and> (tick s,s',v)\<in> P1)
		 	  \<or> (s<x>=grailbool False \<and> (tick s,s',v)\<in> P2)}"
by (unfold vdm_valid_def, fastsimp elim!: eval_cases)


subsection {* Composition and assignment *}

text {* The rules for Let combine sequencing with assignment. *}

lemma VLet: "\<lbrakk> \<Turnstile>\<^sub>v e :  P1; \<Turnstile>\<^sub>v e' : P2 \<rbrakk> \<Longrightarrow>
	     \<Turnstile>\<^sub>v (LET x=e IN e' END) : 
	       {(s,s',v). \<exists> s'' v'. (s,s'',v')\<in> P1
				  \<and> (ivarupdate (tick s'') x (theival v'),s',v) \<in> P2}"
by (simp add: vdm_valid_def, fastsimp elim: eval_cases)

lemma VLetR: "\<lbrakk> \<Turnstile>\<^sub>v e : P1;  \<Turnstile>\<^sub>v e' : P2 \<rbrakk> \<Longrightarrow>
	  \<Turnstile>\<^sub>v (LET rf x=e IN e' END) : 
	       {(s,s',v). \<exists> s'' v'. (s,s'',v')\<in> P1
				  \<and> (rvarupdate (tick s'') x (therval v'),s',v) \<in> P2}"
by (simp add: vdm_valid_def, fastsimp elim: eval_cases)


subsection {* Function calls *}

text {*  The basic rule for CALL unwinds the function body. 
  *}

(* FIXME: below is deprecated.  Use better rule next *)
lemma VCall: "\<Turnstile>\<^sub>v (funtable fn) : P  \<Longrightarrow>  
	      \<Turnstile>\<^sub>v (CALL fn) : {(s,s',v). (tickcall s,s',v) \<in> P}"
by (fastsimp elim: eval_cases)

(* FIXME: next rule not proven yet!  See ToyHLbasic.thy.
lemma VCallpost: "\<Turnstile>\<^sub>v (funtable fn) : {(s,s',v). (s,tickcall s',v) \<in> P} \<Longrightarrow>
		  \<Turnstile>\<^sub>v (CALL fn) : P"
*)



(********************************************************************************)

subsection {* Method calls *}

text {* The rules for method invocation are the most delicate.  The operational
  semantics rule adjusts the state in two places: creating a new frame before
  evaluating the method body, and then restoring the old frame 
  afterwards.\footnote{With a small step semantics and a return instruction 
   these two steps could be separated.}
  The basic Voare rule has the same structure, adjusting both the
  pre-condition and the post-condition in the premise.  
  Furthermore, because we use the trick of keeping the 
  old frame in the evaluation rule rather than the machine,
  this rule is really a rule scheme: hence the quantification
  over @{term s_init}.  
  *}
(* typing condition:  mn \<in> dom (meths (classtable c))  *)

lemma VInvokeStatic:
  "\<Turnstile>\<^sub>v (methtable C mn) : P \<Longrightarrow>
   \<Turnstile>\<^sub>v (InvokeStatic C mn vn2) : 
	{(s,s',v). \<exists> s''. (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s'',v) \<in> P
		        \<and> s' = tickn 4 (oldframe s'' s)}"
by (fastsimp elim: eval_cases)


text {* The rule @{text VInvoke} is slightly more complicated.  
  We additionally quantify globally over the location @{text a} of the 
  object, and use @{term "(the (s_init\<guillemotleft>a\<guillemotright>))"} to extract the class
  of the object --- this is a bit ugly, but writing 
  @{term "s_init\<guillemotleft>a\<guillemotright>=Some C"} in the pre-condition (inside
  quantifiers'), we would have to show that this gives the same class 
  as the one in the @{text Invoke} rule.
*}

(*
lemma VInvoke:
  "\<lbrakk> (\<forall> s_init a.
    \<Turnstile>\<^sub>v (methtable (the (s_init\<guillemotleft>a\<guillemotright>)) mn) : P ;
      \<Turnstile>\<^sub>v (Invoke vn1 mn vn2) : 
	{(s,s',v). (s=s_init \<and> s\<lfloor>vn1\<rfloor> = Ref a \<and> s\<guillemotleft>a\<guillemotright> = Some C \<and> 
                   (\<exists> s''. (newframe s mn (Ref a) (s\<lfloor>vn2\<rfloor>),s'',v) \<in> P
		        \<and> s' = tickn 5 (oldframe s'' s)))} ;
      {(s,s',v). (s=s_init \<and> s\<lfloor>vn1\<rfloor> = Ref a \<and> s\<guillemotleft>a\<guillemotright> = Some C \<and> 
                   (\<exists> s''. (newframe s mn (Ref a) (s\<lfloor>vn2\<rfloor>),s'',v) \<in> P
		        \<and> s' = tickn 5 (oldframe s'' s)))} \<subseteq> Q) \<rbrakk> 
   \<Longrightarrow>
   \<Turnstile>\<^sub>v (Invoke vn1 mn vn2) : Q"
oops

lemma whatever:
  "\<Turnstile>\<^sub>v (methtable C mn) : P \<Longrightarrow>
   \<Turnstile>\<^sub>v (InvokeStatic C mn vn2) : 
	{(s,s',v). \<exists> s''. (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s'',v) \<in> P
		        \<and> s' = tickn 4 (oldframe s'' s)}"
by (fastsimp elim: eval_cases)


apply (unfold vdm_valid_def)
apply (rule, rule, rule, rule)
apply clarify
apply (rule_tac x="s''" in exI)
apply (erule eval_cases)
apply (erule_tac x="s" in allE)
apply (erule_tac x="s" in allE)
apply (erule_tac x="t" in allE)
apply (erule_tac x="t" in allE)
apply (erule_tac x="v" in allE)
apply (erule_tac x="v" in allE)
done
*)

text {*  
  Neither of these rules has been well tested in our examples yet and
  alternative formulations may be possible.
*}



(********************************************************************************)

subsection {* VPre, VPost, VMeasure --- rules for assertions *}

text {* Invariants are checked in the operational semantics',
  and their meaning is characterised by these rules. *}

(* FIXME: types are wrong here for pre-assertions: only want assertion on pre-state *)

lemma VPost: "\<lbrakk> \<Turnstile>\<^sub>v e : P \<rbrakk> \<Longrightarrow> \<Turnstile>\<^sub>v (POST P: e) : P"
by (fastsimp elim: eval_cases)

text {* The measure annotation is used to decorate an expression
  with a well-founded decreasing relation on states.  The relation
  decreases when the expression @{term e} is evaluated. *}

(* NB: with measure in op. sems we could derive this:
  lemma VMeasure: "\<lbrakk> \<Turnstile>\<^sub>v e : P \<rbrakk> \<Longrightarrow> \<Turnstile>\<^sub>v (MEASURE M: e) : {(s,s',v). (s,s')\<in> M \<and> (s,s',v)\<in> P}"
 But now we get that measure is ignored: *)
lemma VMeasure: "\<lbrakk> \<Turnstile>\<^sub>v e : P \<rbrakk> \<Longrightarrow> \<Turnstile>\<^sub>v (MEASURE M: e) : {(s,s',v). (s,s',v)\<in> P}"
by (fastsimp elim: eval_cases)

text {* This is a new rule which hasn't been tested yet (previous formulation
  used tables for storing measures rather than syntax). *}


(********************************************************************************)


subsection {* VRecWF --- total correctness rule for recursion *}

text {* From a suggestion of Robert Atkey: we have a separate rule
  for recursion, meaning that we can re-use @{text VRecWF} to derive
  rules for both call and invoke.  The recursion rule
  uses induction along a well-founded relation \cite{Nipkow,Kleymann}. *}
(*
lemma VRecWF:
 "\<lbrakk> wf r; (\<Turnstile>\<^sub>v e : {(s,s',v).(s,s',v)\<in> P \<and> (s,s')\<in> r}) \<longrightarrow> \<Turnstile>\<^sub>v e : {(s,s',v).(s,s',v)\<in> P \<and> s=s'} \<rbrakk>
  \<Longrightarrow> \<Turnstile>\<^sub>v e : P"
apply (rule, rule)
apply (erule_tac a = "s" and 
       P = "\<lambda> s. \<forall> t v. \<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<longrightarrow> (s,t,v)\<in> P" in wf_induct)
apply (erule_tac x="x" in allE)
apply (fastsimp)
done
*)

(********************************************************************************)

subsection {* Collecting the rules together *}

text {* The set @{text vdmbasics} are rules used for non-looping code;
  @{text vdmprocs} are the procedure rules.  These rule sets are
  for interactive use, the VCG uses a custom set. *}

lemmas vdmbasics = VNull VInt VIVar VVarr VPrimop VRPrimop VGetFi VGetFr VPutFi VPutFr VNew VIf  VLet VLetR 

lemmas vdmprocs  = VCall VInvokeStatic 
(* VInvoke  *) (* not yet! *)



subsection {* Cleanup *}

text {* Finally, we adjust the rules known to the classical reasoners so that
  hoare\_valid\_def is never expanded automatically; we restrict to using
  the Hoare rules defined above from now on. *}

declare VdmI [rule del] VdmE [rule del]

end
