(*  
   File:	ToyTest
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyProgsTest.thy,v 1.1 2003/05/22 13:33:37 da Exp $

   Short test on program syntax.
*)

theory ToyProgsTest = ToyProgs:


(* Our old favourite, the count program *)

consts
 Count :: cname
 countmeth :: mname
 b  :: iname
 n :: iname
 one :: iname
 count :: funame


constdefs
  CountProg :: "(((int * int) * state) set) prog"
  "CountProg == 
    CLASS Count = 
       STATIC METH countmeth() = 
          INTVARS [n,b,one];
          FUN count ([n];[]) = INV {((C,N),s). clock s = C + 12 * (N - (s<n>)) \<and> 0 < s<n>}:
			       LET one = 1\<^sup>z; 
				   n = n :--;
			           b = n :< one
			       IN 
			         IF b THEN expr.Int 42 ELSE CALL count
  			       END
        INEXPR ( [class Count]\<bullet>countmeth(param) )
       ENDMETH
    ENDCLASS"

lemma "P(cnames_of_prog CountProg) = P[Count]"
by (simp add: CountProg_def)

lemma "P(funames_of_prog CountProg) = P[count]"
by (simp add: CountProg_def)

lemma "P(mnames_of_prog CountProg) = P[countmeth]"
by (simp add: CountProg_def)

lemma "CountProg \<triangleright> distinct [b,n,one]"
by (simp add: trueInProg_def CountProg_def, auto)


end
