(*  
   File:	ToyProgs
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyProgs.thy,v 1.5 2003/05/28 09:36:24 da Exp $

   Some program syntax for ToyGrail. 
  
   IN PROGRESS

   Somewhat experimental.   A better approach might be to just concentrate
   on printing in Isabelle, and bolt on an external parser.  (That would 
   make things more comfortable by inserting coercions, etc, automatically).

   TODO: extend trueInProg to assert pre-post conditions on function
   and method bodies.
   
   Q: can we generalise polymorphism here by losing it in the type of programs?
   e.g. have  body :: 'a expr \<Rightarrow> progbody.  Problem then I think is that 
   we may never know result type of funtable, which means that we won't be
   able to unfold it? 
*)

header {* Program syntax for ToyGrail. *}

theory ToyProgs = ToyGrailDef + ToyPrelude:

text {*
  This section defines a representation of full programs in ToyGrail.
  Using Isabelle's parser in this way is clumsy: a better strategy
  would be to define a mapping from (a restricted/extended form of) 
  Grail.  The syntax here is still useful for \emph{printing} from
  Isabelle, though. 
  *}
  
(* Allow a mixed up but hierarchical syntax *)

(* NB: mention of function args has no logical meaning *)

datatype 'a prog = 
  Fun funame "iname list" "rname list" "'a expr"
| StaticMeth mname "'a prog" "'a expr"
| Meth mname "'a prog" "'a expr"
| Class cname "ifldname list" "rfldname list" "'a prog"
| IntDecs "iname list"
| RefDecs "rname list"
| Decs "'a prog" "'a prog"	 ("_; _" [200,201] 200)  (*FIXME: pretty nasty with meta-impls *)


(* NB: desirable improvement: replace lists below with syntactic idlist *)
syntax
 "_Fun"    :: "[id,id list,id list,'a expr] \<Rightarrow> 'a prog"  ("(4FUN _ '(_;_') =\ _)"  [1000,1000,1000,1] 210)  
 "_Static" :: "[id,'a prog,'a expr] \<Rightarrow> 'a prog"     ("(4STATIC METH _ '(') =\ _ INEXPR _ ENDMETH)" 210)
 "_Meth"   :: "[id,'a prog,'a expr] \<Rightarrow> 'a prog"     ("(4METH _ '(') =\ _ INEXPR _ ENDMETH)" 210)
 "_Class"  :: "[id,ifldname list,rfldname list,'a prog] \<Rightarrow> 'a prog"  
					   ("(4CLASS _ =\ IFIELDS _;\ RFIELDS _;\ _ ENDCLASS)" 210)
 "_StatClass" :: "[id,ifldname list,rfldname list,'a prog] \<Rightarrow> 'a prog"  
					   ("(4CLASS _ =\ _ ENDCLASS)" 210)
 "_IntDecs" :: "'a list \<Rightarrow> 'a prog"	   ("(INTVARS _)" [230] 220)
 "_RefDecs" :: "'a list \<Rightarrow> 'a prog"	   ("(REFVARS _)" [230] 220)

(* parameter names are ignored in functions; lists of integer variables and ref variables are global *)
translations
 "STATIC METH  m () = fundecs INEXPR exprn ENDMETH"     == "StaticMeth m fundecs exprn"
 "METH m () = fundecs INEXPR exprn ENDMETH"             == "Meth m fundecs exprn"
 "FUN f (iargs; rargs) = exprn"			        == "Fun f iargs rargs exprn" 
 "CLASS C = progm ENDCLASS"			        == "Class C [] [] progm"
 "CLASS C = IFIELDS ints; RFIELDS refs; progm ENDCLASS" == "Class C ints refs progm"
 "INTVARS intvs" == "IntDecs intvs" 
 "REFVARS intvs" == "RefDecs intvs" 

(* grammar checks:
 term "INTVARS [];; X"
 term "Y;; INTVARS []" 
 term "CLASS c = foo ENDCLASS;; INTVARS []"
*)

text {* Extract the functions and classes declared in an program.
  CAREFUL!  The variables used must really be disjoint. *}

consts
 cnames_of_prog  :: "'a prog \<Rightarrow> cname list"
 mnames_of_prog  :: "'a prog \<Rightarrow> mname list"
 funames_of_prog :: "'a prog \<Rightarrow> funame list"
 inames_of_prog  :: "'a prog \<Rightarrow> iname list"
 rnames_of_prog  :: "'a prog \<Rightarrow> rname list"
primrec
 "cnames_of_prog (Fun f inames rnames expr)  = []"
 "cnames_of_prog (Meth m fundecs expr)       = cnames_of_prog fundecs"
 "cnames_of_prog (StaticMeth m fundecs expr) = cnames_of_prog fundecs"
 "cnames_of_prog (Class c ifls rfls methds)   = c#(cnames_of_prog methds)"
 "cnames_of_prog (IntDecs inms)		     = []"
 "cnames_of_prog (RefDecs rnms)	             = []"
 "cnames_of_prog (Decs ds1 ds2)	             = (cnames_of_prog ds1) @ (cnames_of_prog ds2)"
primrec
 "mnames_of_prog (Fun f inames rnames expr)  = []"
 "mnames_of_prog (Meth m fundecs expr)       = m#(mnames_of_prog fundecs)"
 "mnames_of_prog (StaticMeth m fundecs expr) = m#(mnames_of_prog fundecs)"
 "mnames_of_prog (Class c ifls rfls methds)  = mnames_of_prog methds"
 "mnames_of_prog (IntDecs inms)	      	     = []"
 "mnames_of_prog (RefDecs rnms)	      	     = []"
 "mnames_of_prog (Decs ds1 ds2)	      	     = (mnames_of_prog ds1) @ (mnames_of_prog ds2)"
primrec
 "funames_of_prog (Fun f inames rnames expr)  = [f]"
 "funames_of_prog (Meth m fundecs expr)       = funames_of_prog fundecs"
 "funames_of_prog (StaticMeth m fundecs expr) = funames_of_prog fundecs"
 "funames_of_prog (Class c ifls rfls methds)  = funames_of_prog methds"
 "funames_of_prog (IntDecs inms)	      = []"
 "funames_of_prog (RefDecs rnms)	      = []"
 "funames_of_prog (Decs ds1 ds2)	      = (funames_of_prog ds1) @ (funames_of_prog ds2)"
primrec
 "inames_of_prog (Fun f inames rnames expr)  = []"
 "inames_of_prog (Meth m fundecs expr)       = inames_of_prog fundecs"
 "inames_of_prog (StaticMeth m fundecs expr) = inames_of_prog fundecs"
 "inames_of_prog (Class c ifls rfls methds)  = inames_of_prog methds"
 "inames_of_prog (IntDecs inms)	      	     = inms"
 "inames_of_prog (RefDecs rnms)	      	     = []"
 "inames_of_prog (Decs ds1 ds2)	      	     = (inames_of_prog ds1) @ (inames_of_prog ds2)"
primrec
 "rnames_of_prog (Fun f inames rnames expr)  = []"
 "rnames_of_prog (Meth m fundecs expr)       = rnames_of_prog fundecs"
 "rnames_of_prog (StaticMeth m fundecs expr) = rnames_of_prog fundecs"
 "rnames_of_prog (Class c ifls rfls methds)  = rnames_of_prog methds"
 "rnames_of_prog (IntDecs inms)	      	     = []"
 "rnames_of_prog (RefDecs rnms)	      	     = rnms"
 "rnames_of_prog (Decs ds1 ds2)	      	     = (rnames_of_prog ds1) @ (rnames_of_prog ds2)"


text {* Assertions about lookups in the three global tables: *}

consts
 lookups_in_prog :: "'a prog \<Rightarrow> cname \<Rightarrow> bool"
primrec
 "lookups_in_prog(Fun f inames rnames expr) c  = (funtable f = expr)"
 "lookups_in_prog(Meth m fundecs expr) c       = 
  ((methtable c m = expr) \<and> (lookups_in_prog fundecs c))"
 "lookups_in_prog(StaticMeth m fundecs expr) c = 
  ((methtable c m = expr) \<and> (lookups_in_prog fundecs c))"
 (* NB: meths section of class table entry is a dummy, it's not used in formalization yet *)
 "lookups_in_prog(Class c ifls rfls methdecs) c' = 
  ((ifieldtable c = ifls) \<and> (rfieldtable c = rfls) \<and> lookups_in_prog methdecs c)"
 "lookups_in_prog(IntDecs inames) c = True"
 "lookups_in_prog(RefDecs rnames) c = True"
 "lookups_in_prog(Decs d1 d2) c     = (lookups_in_prog d1 c \<and> lookups_in_prog d2 c)"


constdefs
 isProg :: "'a prog \<Rightarrow> bool"
 "isProg prog \<equiv> 
    (distinct (funames_of_prog prog) \<and>
     distinct (cnames_of_prog prog) \<and>
     distinct (mnames_of_prog prog) \<and>
     distinct (inames_of_prog prog) \<and>
     distinct (rnames_of_prog prog) \<and>
     (\<forall> c. lookups_in_prog prog c))"

constdefs
 trueInProg :: "'a prog \<Rightarrow> bool \<Rightarrow> bool"   ("_ \<triangleright> _" [999,0] 999)
 "trueInProg prog P \<equiv> (isProg prog \<longrightarrow> P)"

text {*
  The idea of @{text isProg} is that it allows unfold definitions
  piecemeal without expanding the whole program.  
  *}

lemma isProg [elim!]: "\<lbrakk> (isProg prog); (prog \<triangleright> Q) \<rbrakk> \<Longrightarrow> Q"  (* FIXME: ambiguous input *)
by (simp add: trueInProg_def)


end
