(*  
   File:	ToyHLwp.thy
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyHLwp.thy,v 1.1 2003/07/15 17:08:05 da Exp $

   Weakest preconditions.

   [NB: incomplete]
*)

theory ToyHLwp = ToyHLbasic:

text {* The semantic definition of weakest pre-condition is simply the set of
  states which ensure the post-condition.
  *}

constdefs
 semwp    :: "'a expr \<Rightarrow> 'a postassn \<Rightarrow> 'a preassn"
 "semwp e Q == {(z,s). \<forall> v t. \<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<longrightarrow> (z,t,v) \<in> Q}"

lemma "\<Turnstile> (semwp e Q) e Q"
by (simp add: semwp_def hoare_valid_def)

lemma "\<Turnstile> P e Q \<Longrightarrow> P \<subseteq> (semwp e Q)"
by (simp add: semwp_def hoare_valid_def, auto)



text {* We assume a global table of pre-post pair annotations for both
  functions and methods per class. *}

text {* The @text{meth_assn_table} might be indexed by method name and class,
  to allow for dynamic binding.  Instead we may assume that if we are using
  method overriding, the pre-post pairs in the table check in which class
  the object is being acted upon. *}


consts
 wp :: "'a expr \<Rightarrow> 'a postassn \<Rightarrow> 'a preassn"
 

primrec 
 "wp (expr.Int i) Q    	       = {(z,s). (z,tick s, IVal i) \<in> Q}"

 "wp (expr.IVar x) Q           = {(z,s). (z,tick s, IVal s<x>) \<in> Q}"

 "wp expr.Null Q       	       = {(z,s). (z,tick s, RVal Nullref) \<in> Q}"

 "wp (expr.RVar x) Q           = {(z,s). (z,tick s, RVal s\<lfloor>x\<rfloor>) \<in> Q}"

 "wp (Primop f x y) Q  	       =
	{(z,s). (z,tickn 3 s, IVal (f s<x> s<y>)) \<in> Q}"

 "wp (RPrimop f x y) Q  	       =
	{(z,s). (z,tickn 3 s, IVal (f s\<lfloor>x\<rfloor> s\<lfloor>y\<rfloor>)) \<in> Q}"

 "wp (GetFi vn f) Q = 
	{(z, s). \<exists>  a obj. s<vn> = Some(Ref a) \<and> 
			             fmap_lookup (heap s) a = Some obj \<and> 
				     (z, tickn 2 s, the (snd obj f)) \<in> Q}"
 "wp (PutF vn f valv) Q = 
        {(z,s). \<exists>  a obj rtv. 
		(s<vn> = Some(Ref a) \<and> 
			 fmap_lookup (heap s) a = Some obj \<and> 
		         s<valv> = Some rtv \<and>
			 f mem (flds (classtable (fst obj))) \<and>
			 (z, tickn 3 (objfieldupdate s a obj f rtv), val.Void) \<in> Q)}"

 "wp (New c) Q =
	{(z,s). (z, tickn 1 (newobj s (freshloc (fmap_dom (heap s))) c), 
		    val.Ref (freshloc (fmap_dom (heap s)))) \<in> Q}"

 "wp (If_ x e1 e2) Q = 
	{(z,s). (s<x>=Some (val.Int 1) \<longrightarrow> (z,tickn 1 s)\<in> wp e1 Q) \<and>
		(s<x>=Some (val.Int 0) \<longrightarrow> (z,tickn 1 s)\<in> wp e2 Q)}"  (* NB: smash auxs *)
 
 wpLET:
 "wp (Let x e1 e2) Q = 
	wp e1 {(z,s,v). \<exists> s'. (z,s') \<in> wp e2 Q \<and> s' = varupdate (tickn 1 s) x v}"

(* NB: cases for procedures advised by T. Nipkow, after T. Kleymann *)
 "wp (Invoke vn1 mn vn2) Q = 
  {(z,s). \<forall> t v. (\<forall> z. (z,s) \<in> (fst (meth_assn_table mn)) \<longrightarrow> 
				((z,t,v) \<in> (snd (meth_assn_table mn))) \<longrightarrow> (z,t,v) \<in> Q)}"

 "wp (Call f) Q = {(z,s). \<forall> t v. (\<forall> z. (z,s) \<in> (fst (fun_assn_table f)) \<longrightarrow> 
						     (z,t,v) \<in> (snd (fun_assn_table f)) \<longrightarrow> (z,t,v) \<in> Q)}"


(* The condition of being a weakest pre-condition. *)

constdefs
  WP :: "'a preassn \<Rightarrow> 'a expr \<Rightarrow> 'a postassn \<Rightarrow> bool"
  "WP P e Q \<equiv>  (\<Turnstile> P e Q) \<and> (\<forall> P'. (\<Turnstile> P' e Q) \<longrightarrow> P \<subseteq> P')"

(* The assumption for the global tables of pre-post pairs *)
constdefs 
  WPassm :: bool
  "WPassm  \<equiv>  
    (\<forall> fn. WP (fst (fun_assn_table fn)) (CALL fn) (snd (fun_assn_table fn)))
  \<and> (\<forall> ob meth arg. WP (fst (meth_assn_table meth)) (ob\<bullet>meth(arg)) (snd (meth_assn_table meth)))"

lemma wp_is_pre: "WPassm \<Longrightarrow> \<forall> Q. \<Turnstile> (wp e Q) e Q"
sorry

lemma wp_is_leastpre: "WPassm \<Longrightarrow> (\<forall> P'. (\<Turnstile> P' e Q) \<longrightarrow> (wp e Q) \<subseteq> P')"
sorry

end


