(*  
   File:	ToyHLrec.thy
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyHLrec2.thy,v 1.1 2003/06/08 11:26:19 da Exp $

   Auxiliary material to help prove soundness of recursive
   rules for partial correctness. Proof idea due to Martin Hofmann.
   
   This version uses difference in callcount between two states,
   rather than defining a second op.sems.
*)   

theory ToyHLrec2 = ToyHLbasic:

section {* Relativized validity *}

constdefs 
  hoare_validn :: "nat \<Rightarrow> 'a preassn \<Rightarrow> 'a expr \<Rightarrow> 'a postassn \<Rightarrow> bool"  ("\<Turnstile>\<^sub>_ (1_)/ (_)/ (1_)" 50)

  "\<Turnstile>\<^sub>n P e Q \<equiv> (\<forall> m. m<=n \<longrightarrow> (\<forall> s t v. \<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<longrightarrow> 
					((callcount t) - (callcount s) = m)
					\<longrightarrow> (\<forall> z. (z, s) \<in>  P \<longrightarrow> (z, t, v) \<in> Q)))" 

lemma HoareIn: 
  "(\<forall> m. m<=n \<longrightarrow> (\<forall> s t v. \<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<longrightarrow> ((callcount t) - (callcount s) = m) \<longrightarrow> 
				(\<forall> z. ((z,s)\<in> P \<longrightarrow> (z,t,v)\<in> Q)))) \<Longrightarrow> \<Turnstile>\<^sub>n P e Q"
by (unfold hoare_validn_def, auto)

lemma lowerm: "\<lbrakk>   \<Turnstile>\<^sub>n P e Q; m <= n \<rbrakk> \<Longrightarrow> \<Turnstile>\<^sub>m P e Q"
apply (simp (no_asm) add: hoare_validn_def)
apply (rule, rule)
apply (unfold hoare_validn_def)
apply (erule_tac x=ma in allE)
apply auto
done

lemma valid_validn: "\<Turnstile> P e Q \<Longrightarrow> \<forall> n. \<Turnstile>\<^sub>n P e Q"
apply (rule allI, rule HoareIn)
apply clarify
apply (erule HoareE)
apply auto
done

lemma validn_valid: "\<forall> n. \<Turnstile>\<^sub>n P e Q \<Longrightarrow> \<Turnstile> P e Q"
apply (simp add: hoare_valid_def)
apply clarify
apply (simp add: hoare_validn_def)
apply fastsimp
done

lemma calllemma[rule_format(no_asm)]: 
     "(\<forall> m. m<n \<longrightarrow> (\<Turnstile>\<^sub>m P (CALL fn) Q) \<longrightarrow> (\<Turnstile>\<^sub>m (apsnd (tickn 1 o incrcallcount) ` P)
							  (funtable fn) Q))
		   \<longrightarrow> (\<Turnstile>\<^sub>n P (CALL fn) Q)"
apply (induct_tac n)
apply (simp add: hoare_validn_def)
apply (clarify, erule evalCall_cases)
apply (simp add: state_functions)
apply (drule callcount_mono, simp) (* base case vacuous *)
apply auto
apply (simp (no_asm) add: hoare_validn_def)
apply (rule, case_tac "m=Suc n") (* interesting case first *)
apply rule
apply clarsimp
apply (erule evalCall_cases)
apply (erule_tac x=n in allE)
apply simp
apply (erule thin_rl)
apply (simp add: hoare_validn_def)
apply (erule_tac x="n" in allE)
apply simp
apply (erule_tac x="tickcall s" in allE)
apply (erule_tac x=t in allE)
apply (erule_tac x=v in allE)
apply simp
apply (subgoal_tac "callcount t - Suc (callcount s) = n", simp)
apply fastsimp
apply arith
(* now case by IH immediately *)
apply rule
apply (erule thin_rl)
apply (simp add: hoare_validn_def)
apply (erule_tac x=m in allE)
apply fastsimp
done

end



