(* 				 
   File:	ToyHLproofs.thy
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyHLproofsDeriv.thy,v 1.1 2003/06/10 09:40:13 da Exp $
 *)

header {*  Derived rules in Proof System *}

theory ToyHLproofsDeriv = ToyHLproofs:


lemma hsp :    "\<lbrakk> G \<turnstile> P' e Q; P \<subseteq> P' \<rbrakk> \<Longrightarrow> G \<turnstile> P e Q"   
apply (erule hconseq)
apply auto
done

lemma hwc :    "\<lbrakk> G \<turnstile> P e Q; Q \<subseteq> Q' \<rbrakk> \<Longrightarrow> G \<turnstile> P e Q'"   
apply (erule hconseq)
apply auto
done

lemma hcallrecprepostinv: 
  "\<lbrakk> funtable fn = (PRE P: POST Q: body); 
     ((invimagepre tickcall P,CALL fn,Q)#G) \<turnstile> P body Q;
     R \<subseteq> (invimagepre tickcall P); Q\<subseteq>S \<rbrakk>
  \<Longrightarrow> G \<turnstile> R (CALL fn) S"
apply (rule hconseq)
apply (rule hcall)
apply simp
apply (rule hpre)
apply (rule hpost)
apply assumption
apply auto
done

lemma hleti: "\<lbrakk> G \<turnstile> R e' Q;
	        G \<turnstile> P e {(z,s,v). (z,ivarupdate (tick s) x  (theival v)) \<in> R} \<rbrakk> 
       \<Longrightarrow> G \<turnstile> P (LET x=e IN e' END) Q"
by (rule hlet, auto)

lemma hletri: "\<lbrakk> G \<turnstile> R e' Q;
	         G \<turnstile> P e {(z,s,v). (z,rvarupdate (tick s) x  (therval v)) \<in> R} \<rbrakk> 
       \<Longrightarrow> G \<turnstile> P (LET rf x=e IN e' END) Q"
by (rule hletr, auto)

lemma hwk: "( \<turnstile> P e Q ) \<Longrightarrow> G \<turnstile> P e Q"
by (rule hthin, auto)

lemmas hoareproof_ibasics = 
  hnull [THEN hwk] hint [THEN hwk] hivar [THEN hwk] hrvar [THEN hwk] 
  hprimop [THEN hwk] hrprimop [THEN hwk] 
  hgetfi [THEN hwk] hgetfr [THEN hwk] hputfi [THEN hwk] hputfr [THEN hwk]
  hnew [THEN hwk] 
  hif hleti hletri 

end
