(* 				 
   File:	$RCSfile: ToyHLproofsBD.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyHLproofsBD.thy,v 1.3 2003/07/07 21:30:50 a1hloidl Exp $

   Proof system for Hoare Logic and soundness proof as suggested by Martin.
    
   FIXME: 1. doesn't include rules for invokestatic/invoke
          2. might be considerably simpler if use callcount directly 
             instead of second op.sems (see HLproofs2, HLproofs3)
          3. 

 
   DESIGN CHOICE:  
       1. use \<Turnstile>m P e Q : harmless meta-quantified formulae in all rules
       2. use G \<Turnstile> P e Q 
       3. use G \<turnstile> P e Q, deeper embedding of hoare rules
	  [ adv:    we know proof system exactly and stick to it;
	    disadv: may be incomplete ]

   Some rules for 1,2 are derived below as part of soundness proof.
*)

header {* Hoare logic for Toy Grail: Proof System *}

theory ToyHLproofsBD = ToyHLbasicBD + ToyHLrecBD:

subsection {* Hoare logic derivability *}

types
 'a triple = "'a preassn \<times>  'a expr \<times>  'a postassn"

consts
  hoareproof :: "('a triple list \<times> 'a triple)  set"

syntax
  hoare_deriv :: "'a triple list 
		  \<Rightarrow> 'a preassn \<Rightarrow> 'a expr \<Rightarrow> 'a postassn \<Rightarrow> bool"  
		  ("_ |- (1_)/ (_)/ (1_)" [900,200,100,100] 50)

syntax (xsymbols)
  hoare_deriv :: "'a triple list \<Rightarrow>
		   'a preassn \<Rightarrow> 'a expr \<Rightarrow> 'a postassn \<Rightarrow> bool" 
		  ("_ \<turnstile> (1_)/ (_)/ (1_)" [900,100,200,100] 50)

translations
 "G \<turnstile> P e Q" == "(G,P,e,Q) \<in> hoareproof"

syntax
  hoare_emptyctx :: "'a preassn \<Rightarrow> 'a expr \<Rightarrow> 'a postassn \<Rightarrow> bool" ("\<turnstile> (1_)/ (_)/ (1_)" 40)
translations
  "\<turnstile> P e Q" == "[] \<turnstile> P e Q"


inductive hoareproof intros
 hconseq: "\<lbrakk> G \<turnstile> P' e Q'; 
		       \<forall> s t v. 
		        (\<forall> z. (z,s)\<in> P' \<longrightarrow> (z,t,v)\<in> Q')
			\<longrightarrow>
		        (\<forall> z. (z,s)\<in> P \<longrightarrow> (z,t,v)\<in> Q) \<rbrakk> \<Longrightarrow> G \<turnstile> P e Q"

 hnull:  "\<turnstile> {(z, s). (z,tick s, RVal Nullref)\<in> Q} NULL Q"

 hint:   "\<turnstile> {(z, s). (z,tick s,IVal i) \<in> Q} (expr.Int i) Q"

 hivar:  "\<turnstile> {(z, s). (z, tick s, IVal (s<vn>)) \<in> Q} (expr.IVar vn) Q"

 hrvar : "\<turnstile> {(z, s). (z, tick s, RVal (s\<lfloor>vn\<rfloor>)) \<in> Q} (expr.RVar vn) Q"

 hprimop: 
  "\<turnstile> {(z, s). (z,tickn 3 s, IVal (f (s<vn1>) (s<vn2>))) \<in> P}
      (expr.Primop f vn1 vn2)
      P"

 hrprimop: 
  "\<turnstile> {(z, s). (z,tickn 3 s, IVal (f (s\<lfloor>vn1\<rfloor>) (s\<lfloor>vn2\<rfloor>))) \<in> P}
      (expr.RPrimop f vn1 vn2)
      P"

 hgetfi: "\<turnstile> {(z, s). ( z, tickn 2 s, IVal (s<(theloc s\<lfloor>vn\<rfloor>)\<bullet>f>) ) \<in> Q}
	        (GetFi vn f)
		Q"
 hgetfr: "\<turnstile> {(z, s). ( z, tickn 2 s, RVal (s\<lfloor>(theloc s\<lfloor>vn\<rfloor>)\<diamondsuit>f\<rfloor>) ) \<in> Q}
	        (GetFr vn f)
		Q"
 hputfi: 
  "\<turnstile> {(z, s). (z, tickn 3 (s<(theloc s\<lfloor>vn\<rfloor>)\<bullet>f := (s<valv>)>), IVal (s<valv>)) \<in> Q}
	      (PutFi vn f valv)
	      Q"
 hputfr: 
  "\<turnstile> {(z, s). (z, tickn 3 (s\<lfloor>(theloc s\<lfloor>vn\<rfloor>)\<diamondsuit>f := (s\<lfloor>valv\<rfloor>)\<rfloor>), RVal (s\<lfloor>valv\<rfloor>)) \<in> Q}
	      (PutFr vn f valv)
	       Q"
 hnew: "\<turnstile> {(z, s). (z, tick (newobj s c ifldvals rfldvals), RVal (Ref (freshlocst s))) \<in> P}
	        (New c ifldvals rfldvals)
	   P"

 hif : "\<lbrakk> G \<turnstile> P1 e1 Q;  G \<turnstile> P2 e2 Q; 
               P \<subseteq> {(z,s). (s<x>=1 \<longrightarrow> (z,tick s) \<in> P1)  \<and> 
			    (s<x>=0 \<longrightarrow> (z,tick s) \<in> P2)}
               \<rbrakk>
          \<Longrightarrow> G \<turnstile> P (IF x THEN e1 ELSE e2) Q"

 hlet: "\<lbrakk> G \<turnstile> P e {(z,s,v). (z,ivarupdate (tick s) x (theival v)) \<in> R};
	  G \<turnstile> R e' Q \<rbrakk> 
       \<Longrightarrow> G \<turnstile> P (LET x=e IN e' END) Q"

 hletr: "\<lbrakk> G \<turnstile> P e {(z,s,v). (z,rvarupdate (tick s) x (therval v)) \<in> R};
	   G \<turnstile> R e' Q \<rbrakk> 
       \<Longrightarrow> G \<turnstile> P (LET rf x=e IN e' END) Q"

 hletv: "\<lbrakk> G \<turnstile> P e {(z,s,v). (z,s)\<in> R}; G \<turnstile> R e' Q \<rbrakk> 
       \<Longrightarrow> G \<turnstile> P (LET _=e IN e' END) Q"

(* it turns out that the following rule is slightly more useful
   and not derivable if we have nats in state.
*)
 hcall:  
    "((P,CALL fn,Q)#G) \<turnstile> (imagepre tickcall P) (funtable fn) Q 
      \<Longrightarrow> G \<turnstile> P (CALL fn) Q"
(*
 hcall: 
    "((invimagepre tickcall P,CALL fn,Q)#G) \<turnstile> P (funtable fn) Q 
      \<Longrightarrow> G \<turnstile> (invimagepre tickcall P) (CALL fn) Q"
*)

 hinvokestatic:
  "(\<forall> s_init. 
    (((P,InvokeStatic cn mn vn,Q)#G) \<turnstile>
      {(z, s). s = newframe s_init mn Nullref (s_init\<lfloor>vn\<rfloor>) \<and> (z, s_init) \<in> P}
       (methtable cn mn)
      {(z,s,v). (z,tickn 4 (oldframe s s_init),v) \<in> Q})) \<Longrightarrow>
     (G \<turnstile> P (InvokeStatic cn mn vn) Q)"

 hinvoke:
  "(\<forall> a s_init. 
  (((P,Invoke vn1 mn vn2,Q)#G) \<turnstile> 
      {(z, s). s_init\<lfloor>vn1\<rfloor> = (Ref a) \<and> 
                s = newframe s_init mn (Ref a) (s_init\<lfloor>vn2\<rfloor>) \<and>
                (z, s_init) \<in> P}
      (methtable (the (s_init\<guillemotleft>a\<guillemotright>)) mn)
      {(z,s,v). (z,tickn 5 (oldframe s s_init),v) \<in> Q})) \<Longrightarrow>
  (G \<turnstile> P (Invoke vn1 mn vn2) Q)"

 hpre:  "\<lbrakk> G \<turnstile> P1 e Q; P \<subseteq> P1  \<rbrakk> \<Longrightarrow> G \<turnstile> P (PRE P1: e) Q"

 hpost: "\<lbrakk> G \<turnstile> P e Q1; Q1 \<subseteq> Q \<rbrakk> \<Longrightarrow> G \<turnstile> P (POST Q1: e) Q"

 hmeasure:  "\<lbrakk> G \<turnstile> P e Q \<rbrakk> \<Longrightarrow> 
               G \<turnstile> {(z,s). (z,s)\<in> P \<and> (\<exists> s'. (\<exists> v. (z,s',v)\<in> Q) \<and> (s,s')\<in> M)} (Measure M e) Q"

 hax:       "(P,e,Q) mem G \<Longrightarrow> G \<turnstile> P e Q"

 hthin:     "\<lbrakk> G \<turnstile> P e Q; set G \<subseteq> set H \<rbrakk> \<Longrightarrow> H \<turnstile> P e Q"



section {* Soundness of Hoare Logic *}

subsection {* Context validity *}

constdefs
  hoare_ctxt_valid :: "'a triple list \<Rightarrow> bool"      ("|\<Turnstile> _" 60)
  "|\<Turnstile> G  \<equiv>  (list_all (\<lambda> (P, e, Q). \<Turnstile> P e Q) G)"

(* FIXME: syntax: why is space needed before |\<Turnstile> ? *)

lemma ctx_proj[rule_format]:  "(( |\<Turnstile> G) \<and> ((P,e,Q) mem G) ) \<longrightarrow> (\<Turnstile> P e Q)"
apply (induct_tac G)
apply simp
apply (simp add: hoare_ctxt_valid_def)
done

lemma ctxt_drop: "( |\<Turnstile> ((P,e,Q)#G)) ==> |\<Turnstile> G"
by (simp add: hoare_ctxt_valid_def)

lemma ctxt_ext[simp]: "( |\<Turnstile> ((P,e,Q)#G)) = ((\<Turnstile> P e Q) \<and> ( |\<Turnstile> G))"
by (simp add: hoare_ctxt_valid_def)

lemma ctx_sub[rule_format]:  "(( |\<Turnstile> G) \<and> (set H \<subseteq> set G) ) \<longrightarrow> ( |\<Turnstile> H)"
apply (simp add: hoare_ctxt_valid_def list_all_conv)
apply auto
done

lemma emptyctx [simp]: "|\<Turnstile> []"
by (simp add: hoare_ctxt_valid_def)


text {* Context validity to depth n *}

constdefs
  hoare_ctxt_validn :: "nat \<Rightarrow> 'a triple list \<Rightarrow> bool"      ("|\<Turnstile>\<^sub>_ _" 60)
  "|\<Turnstile>\<^sub>n G  \<equiv>  (list_all (\<lambda> (P, e, Q). \<Turnstile>\<^sub>n P e Q) G)"

lemma ctxt_valid_validn: "( |\<Turnstile> G) \<Longrightarrow> (\<forall> n.( |\<Turnstile>\<^sub>n G))"
apply (simp add: hoare_ctxt_validn_def hoare_ctxt_valid_def)
apply (simp add: list_all_conv)
apply rule
apply rule
apply (drule_tac x=x in bspec, simp)
apply (auto elim: valid_validn [THEN spec])
done

lemma emptyctxn [simp]: "|\<Turnstile>\<^sub>n []"
by (simp add: hoare_ctxt_validn_def)

lemma ctx_projn[rule_format]:  "(( |\<Turnstile>\<^sub>n G) \<and> ((P,e,Q) mem G) ) \<longrightarrow> (\<Turnstile>\<^sub>n P e Q)"
apply (induct_tac G)
apply simp
apply (simp add: hoare_ctxt_validn_def)
done


lemma ctx_subn[rule_format]:  "(( |\<Turnstile>\<^sub>n G) \<and> (set H \<subseteq> set G) ) \<longrightarrow> ( |\<Turnstile>\<^sub>n H)"
apply (simp add: hoare_ctxt_validn_def list_all_conv)
apply auto
done

lemma ctxt_cons: "\<lbrakk> |\<Turnstile> G; \<Turnstile> P e Q \<rbrakk> \<Longrightarrow> ( |\<Turnstile> ((P,e,Q) # G))"
by (simp add: hoare_ctxt_valid_def)

lemma ctxt_validn_valid[rule_format]: "(\<forall> n.( |\<Turnstile>\<^sub>n G)) \<longrightarrow> ( |\<Turnstile> G)"
apply (induct_tac G)
apply simp
apply clarify
apply (rule ctxt_cons)
apply (simp add:  hoare_ctxt_validn_def)
apply (rule validn_valid)
apply (simp add:  hoare_ctxt_validn_def)
done

lemma ctxt_lower: "\<lbrakk> |\<Turnstile>\<^sub>n G; m<n \<rbrakk> \<Longrightarrow> |\<Turnstile>\<^sub>m G"
apply (simp add: hoare_ctxt_validn_def)
apply (simp add: list_all_conv)
apply rule
apply rule
apply (drule_tac x=x in bspec, simp)
apply clarsimp
apply (rule_tac n="n" in lowerm)
apply auto
done

lemma lowerm: "\<lbrakk>  m < n; \<Turnstile>\<^sub>n P e Q  \<rbrakk> \<Longrightarrow> \<Turnstile>\<^sub>m P e Q"
apply (simp (no_asm) add: hoare_validn_def)
apply (rule, rule)
apply (unfold hoare_validn_def)
apply (erule_tac x=ma in allE)
apply auto
done

lemma ctxt_consn: "\<lbrakk> |\<Turnstile>\<^sub>n G; \<Turnstile>\<^sub>n P e Q \<rbrakk> \<Longrightarrow> ( |\<Turnstile>\<^sub>n ((P,e,Q) # G))"
by (simp add: hoare_ctxt_validn_def)


subsection {* Relativized validity in a context *}

constdefs
  hoare_valid_in_ctxt :: "'a triple list \<Rightarrow> 'a preassn \<Rightarrow> 'a expr \<Rightarrow> 'a postassn \<Rightarrow> bool"      
										("_ \<Turnstile> _ _ _" 75)
  "G \<Turnstile> P e Q  \<equiv>  \<forall> n. ( |\<Turnstile>\<^sub>n G ) \<longrightarrow> \<Turnstile>\<^sub>n P e Q"

(*
 1. \<And>G P P1 P2 Q e1 e2 x.
       \<lbrakk>G \<turnstile> P1 e1 Q; G |\<Turnstile> P1 e1 Q; G \<turnstile> P2 e2 Q; G |\<Turnstile> P2 e2 Q;
          P \<subseteq> {(z, s). (s<x> = 1 \<longrightarrow> (z, tick s) \<in> P1) \<and> (s<x> = 0 \<longrightarrow> (z, tick s) \<in> P2)}\<rbrakk>
       \<Longrightarrow> G |\<Turnstile> P IF x THEN e1 ELSE e2 Q
*)

(*lemma "\<lbrakk> G |\<Turnstile> P e Q;  \<Longrightarrow> \<Turnstile> G \<longrightarrow> *)
subsection {* Recursion rules in context *}

lemma CHCall:  
    "\<lbrakk> ((P, CALL fn, Q) # G) \<Turnstile> (imagepre tickcall P) (funtable fn) Q \<rbrakk>
       \<Longrightarrow> G \<Turnstile> P (CALL fn) Q"
apply (simp add: hoare_valid_in_ctxt_def)
apply rule 
apply rule
apply (rule calllemma)
apply (rule, rule, rule)
apply (drule_tac x="m" in spec)
apply (erule impE)
apply (rule ctxt_consn)
apply (erule ctxt_lower)
apply auto
done

(*
lemma CHCallinv:  
    "\<lbrakk> ((invimagepre tickcall P, CALL fn, Q) # G) \<Turnstile> P (funtable fn) Q \<rbrakk>
       \<Longrightarrow> G \<Turnstile> (invimagepre tickcall P) (CALL fn) Q"
apply (simp add: hoare_valid_in_ctxt_def)
apply rule 
apply rule
apply (rule calllemma)
apply simp
apply (rule, rule, rule)
apply (drule_tac x="m" in spec)
apply (erule impE)
apply (rule ctxt_consn)
apply (erule ctxt_lower)
apply auto
apply (simp add: range_iff)
done*)


lemma CHInvokeStatic:
 "\<lbrakk> (\<forall> s_init . ((P, InvokeStatic cn mn vn, Q) # G) \<Turnstile>
                  {(z, s). s = newframe s_init mn Nullref (s_init\<lfloor>vn\<rfloor>) \<and> (z, s_init) \<in> P}
                  (methtable cn mn)
                  {(z,s,v). (z,tickn 4 (oldframe s s_init),v) \<in> Q}) \<rbrakk>
  \<Longrightarrow>
  G \<Turnstile> P (InvokeStatic cn mn vn) Q"
apply (simp add: hoare_valid_in_ctxt_def)
apply (rule, rule)
apply (rule invokestaticlemma)
apply (rule, rule, rule)
apply (rule allI)
apply (erule_tac x="s_init" in allE)
apply (erule_tac x="m" in allE)
apply (erule impE)
apply (rule ctxt_consn)
apply (drule ctxt_lower)
apply auto
done

lemma CHInvoke:
  "\<forall> a s_init. 
     ((P, (Invoke vn1 mn vn2), Q) # G) \<Turnstile> 
      {(z, s). s_init\<lfloor>vn1\<rfloor> = (Ref a) \<and> 
               s = newframe s_init mn (Ref a) (s_init\<lfloor>vn2\<rfloor>) \<and>
               (z, s_init) \<in> P}
      (methtable (the (s_init\<guillemotleft>a\<guillemotright>)) mn)
      {(z,s,v). (z,tickn 5 (oldframe s s_init),v) \<in> Q} \<Longrightarrow>
  G \<Turnstile> P (Invoke vn1 mn vn2) Q"
apply (simp add: hoare_valid_in_ctxt_def)
apply (rule allI)
apply (rule impI)
apply (rule invokelemma)
apply (rule allI)
apply (rule impI)
apply (rule impI)
apply (rule allI)+
apply (erule_tac x="a" in allE)
apply (erule_tac x="s_init" in allE)
apply (erule_tac x="m" in allE)
apply (erule impE)
apply (rule ctxt_consn)
apply (drule ctxt_lower)
apply auto
done

subsection {* Other rules with non-empty contexts *}

text {* Relativized rules which mention the context have
  to be derived afresh from first principles, because
  G \<Turnstile> P e Q  can be true more often than  \<Turnstile> G \<longrightarrow> \<Turnstile> P e Q.
  Former defined as      \<forall> n. \<Turnstile>n G \<longrightarrow> \<Turnstile>n P e Q
  Latter equivalent to   (\<forall> n. \<Turnstile>n G) \<longrightarrow> (\<forall> n. \<Turnstile>n P e Q)
  
 *}

inductive_cases evalIfn_cases : "(s, IF x THEN e1 ELSE e2, n, v, s') \<in> evalexprn"

lemma HIfn : "\<lbrakk>  \<Turnstile>\<^sub>n P1 e1 Q;   \<Turnstile>\<^sub>n P2 e2 Q; 
               P \<subseteq> {(z,s). (s<x>=1 \<longrightarrow> (z,tick s) \<in> P1)  \<and> 
			    (s<x>=0 \<longrightarrow> (z,tick s) \<in> P2)}
               \<rbrakk>
          \<Longrightarrow>  \<Turnstile>\<^sub>n P (IF x THEN e1 ELSE e2) Q"
apply (simp add: hoare_validn_def)
apply clarify 
apply (erule evalIfn_cases)
apply (erule_tac x="na" in allE)
apply (erule_tac x="na" in allE)
apply (case_tac "na<m")
apply fastsimp
apply fastsimp
apply (erule_tac x="na" in allE)
apply (erule_tac x="na" in allE)
apply (case_tac "na<m")
apply fastsimp
apply fastsimp
done

lemma CHIf: "\<lbrakk>G \<Turnstile> P1 e1 Q; G \<Turnstile> P2 e2 Q;
             P \<subseteq> {(z, s). (s<x> = 1 \<longrightarrow> (z, tick s) \<in> P1) \<and> (s<x> = 0 \<longrightarrow> (z, tick s) \<in> P2)}\<rbrakk>
       \<Longrightarrow> G \<Turnstile> P IF x THEN e1 ELSE e2 Q"
apply (simp add: hoare_valid_in_ctxt_def)
apply rule
apply rule
apply (erule_tac x=n in allE)
apply (erule_tac x=n in allE)
apply (simp)
apply (rule HIfn, assumption, assumption, simp)
done

inductive_cases evalLetn_cases : "(s, LET x = e IN e' END, n, v, s') \<in> evalexprn"

lemma HLetn: "\<lbrakk> \<Turnstile>\<^sub>n P e {(z, s, v). (z, (tick s)<x:=theival v>) \<in> R}; \<Turnstile>\<^sub>n R e' Q\<rbrakk>
              \<Longrightarrow>  \<Turnstile>\<^sub>n P LET x = e IN e' END Q"
apply (simp add: hoare_validn_def)
apply clarify 
apply (erule evalLetn_cases)
apply (erule_tac x="na" in allE)
apply (erule_tac x="ma" in allE)
apply (case_tac "(max na ma)<m")
apply (subgoal_tac "na < m \<and> ma < m")
apply fastsimp
apply arith
apply fastsimp
done

lemma CHLet: "\<lbrakk> G \<Turnstile> P e {(z, s, v). (z, (tick s)<x:=theival v>) \<in> R}; G \<Turnstile> R e' Q\<rbrakk>
       \<Longrightarrow> G \<Turnstile> P LET x = e IN e' END Q"
apply (simp add: hoare_valid_in_ctxt_def)
apply rule
apply rule
apply (erule_tac x=n in allE)
apply (erule_tac x=n in allE)
apply (simp)
apply (rule HLetn)
apply fastsimp
apply assumption
done


inductive_cases evalLetrn_cases : "(s, LET rf x = e IN e' END, n, v, s') \<in> evalexprn"

lemma HLetrn: "\<lbrakk> \<Turnstile>\<^sub>n P e {(z, s, v). (z, (tick s)\<lfloor>x:=therval v\<rfloor>) \<in> R}; \<Turnstile>\<^sub>n R e' Q\<rbrakk>
       \<Longrightarrow>  \<Turnstile>\<^sub>n P LET rf x = e IN e' END Q"
apply (simp add: hoare_validn_def)
apply clarify 
apply (erule evalLetrn_cases)
apply (erule_tac x="na" in allE)
apply (erule_tac x="ma" in allE)
apply (case_tac "(max na ma)<m")
apply (subgoal_tac "na < m \<and> ma < m")
apply fastsimp
apply arith
apply fastsimp
done


lemma CHLetr: "\<lbrakk> G \<Turnstile> P e {(z, s, v). (z, (tick s)\<lfloor>x:=therval v\<rfloor>) \<in> R}; G \<Turnstile> R e' Q\<rbrakk>
       \<Longrightarrow> G \<Turnstile> P LET rf x = e IN e' END Q"
apply (simp add: hoare_valid_in_ctxt_def)
apply rule
apply rule
apply (erule_tac x=n in allE)
apply (erule_tac x=n in allE)
apply (simp)
apply (rule HLetrn)
apply fastsimp+
done

inductive_cases evalLetvn_cases : "(s, Letv e ls, n, v, s') \<in> evalexprn"

lemma HLetvn: "\<lbrakk> \<Turnstile>\<^sub>n P e {(z, s, v). (z, s) \<in> R}; \<Turnstile>\<^sub>n R e' Q\<rbrakk>
       \<Longrightarrow>  \<Turnstile>\<^sub>n P LET _ = e IN e' END Q"
apply (simp add: hoare_validn_def)
apply clarify 
apply (erule evalLetvn_cases)
apply (erule_tac x="na" in allE)
apply (erule_tac x="ma" in allE)
apply (case_tac "(max na ma)<m")
apply (subgoal_tac "na < m \<and> ma < m")
apply fastsimp
apply arith
apply fastsimp
done


lemma CHLetv: "\<lbrakk> G \<Turnstile> P e {(z, s, v). (z, s) \<in> R}; G \<Turnstile> R e' Q\<rbrakk>
       \<Longrightarrow> G \<Turnstile> P LET _ = e IN e' END Q"
apply (simp add: hoare_valid_in_ctxt_def)
apply rule
apply rule
apply (erule_tac x=n in allE)
apply (erule_tac x=n in allE)
apply (simp)
apply (rule HLetvn)
apply fastsimp+
done

inductive_cases evalPren_cases  : " (s, PRE P: e, n, v, s') \<in> evalexprn"
inductive_cases evalPostn_cases : "(s, POST P: e, n, v, s') \<in> evalexprn"

lemma HPren: "\<lbrakk> \<Turnstile>\<^sub>n P1 e Q; P \<subseteq> P1\<rbrakk> \<Longrightarrow> \<Turnstile>\<^sub>n P PRE P1: e Q"
apply (simp add: hoare_validn_def)
apply clarify 
apply (erule evalPren_cases)
apply (erule_tac x="na" in allE)
apply (case_tac "na<m")
apply fastsimp+
done

lemma HPostn: "\<lbrakk> \<Turnstile>\<^sub>n P e Q1; Q1 \<subseteq> Q\<rbrakk> \<Longrightarrow> \<Turnstile>\<^sub>n P POST Q1: e Q"
apply (simp add: hoare_validn_def)
apply clarify 
apply (erule evalPostn_cases)
apply (erule_tac x="na" in allE)
apply (case_tac "na<m")
apply fastsimp+
done

lemma CHPre: " \<lbrakk>G \<Turnstile> P1 e Q; P \<subseteq> P1\<rbrakk> \<Longrightarrow> G \<Turnstile> P PRE P1: e Q"
apply (simp add: hoare_valid_in_ctxt_def)
apply (rule, rule)
apply (erule_tac x=n in allE, simp)
apply (rule HPren)
apply fastsimp+
done

lemma CHPost: " \<lbrakk>G \<Turnstile> P e Q1; Q1 \<subseteq> Q\<rbrakk> \<Longrightarrow> G \<Turnstile> P POST Q1: e Q"
apply (simp add: hoare_valid_in_ctxt_def)
apply (rule, rule)
apply (erule_tac x=n in allE, simp)
apply (rule HPostn)
apply fastsimp+
done

inductive_cases evalMeasuren_cases : "(s, MEASURE M: e, n, v, s') \<in> evalexprn"

lemma HMeasuren:  "\<lbrakk> \<Turnstile>\<^sub>n P e Q\<rbrakk> 
       \<Longrightarrow>  \<Turnstile>\<^sub>n {(z, s). (z, s) \<in> P \<and> (\<exists>s'. (\<exists>v. (z, s', v) \<in> Q) \<and> (s, s') \<in> M)} MEASURE M: e Q"
apply (simp add: hoare_validn_def)
apply clarify 
apply (erule evalMeasuren_cases)
apply (erule_tac x="na" in allE)
apply (case_tac "na<m")
apply fastsimp+
done

lemma CHMeasure: "\<lbrakk>G \<Turnstile> P e Q\<rbrakk> 
       \<Longrightarrow> G \<Turnstile> {(z, s). (z, s) \<in> P \<and> (\<exists>s'. (\<exists>v. (z, s', v) \<in> Q) \<and> (s, s') \<in> M)} MEASURE M: e Q"
apply (simp add: hoare_valid_in_ctxt_def)
apply (rule, rule)
apply (erule_tac x=n in allE, simp)
apply (rule HMeasuren)
apply fastsimp+
done


subsection {* Contexts *}

(*lemma Cctx_projn[rule_format]:  "\<lbrakk> |\<Turnstile>\<^sub>  G ; (P,e,Q) mem G \<rbrakk> \<Longrightarrow> \<Turnstile> P e Q"
apply (induct_tac G)
apply simp
apply (simp add: hoare_ctxt_validn_def)
done
*)
subsection {* Main theorem *}

lemma valid_validn: "\<Turnstile> P e Q \<Longrightarrow> \<Turnstile>\<^sub>n P e Q"
apply (rule HoareIn)
apply clarify
apply (erule HoareE)
apply (rule evaln_eval)
apply auto
done

lemma [simp]: "([] \<Turnstile> P e Q) =  (\<forall> n. \<Turnstile>\<^sub>n P e Q)"
by (simp add: hoare_valid_in_ctxt_def)

theorem hsound: "(G \<turnstile> P e Q) \<Longrightarrow> (G \<Turnstile> P e Q)"
apply (erule hoareproof.induct) 
apply (simp add: hoare_valid_in_ctxt_def  hoare_validn_def)
apply (fastsimp)
(* rules with empty contexts are easy: 
   transfered from corresponding validity rule *)
apply (simp, rule, rule valid_validn, rule HNull)
apply (simp, rule, rule valid_validn, rule HInt)
apply (simp, rule, rule valid_validn, rule HVar)
apply (simp, rule, rule valid_validn, rule HVarr)
apply (simp, rule, rule valid_validn, rule HPrimop)
apply (simp, rule, rule valid_validn, rule HRPrimop)
apply (simp, rule, rule valid_validn, rule HGetFi)
apply (simp, rule, rule valid_validn, rule HGetFr)
apply (simp, rule, rule valid_validn, rule HPutFi)
apply (simp, rule, rule valid_validn, rule HPutFr)
apply (simp, rule, rule valid_validn, rule HNew)
apply (rule CHIf CHLet CHLetr CHLetv CHCall CHPre CHPost CHMeasure CHInvokeStatic CHInvoke, simp+)+
apply (simp add: hoare_valid_in_ctxt_def)
apply (rule, rule, fastsimp intro: ctx_projn)
apply (simp add: hoare_valid_in_ctxt_def)
apply (rule, rule, fastsimp intro: ctx_subn)
done


text {* Finally, soundness in an empty context: *}

corollary "(\<turnstile> P e Q)  \<longrightarrow> (\<Turnstile> P e Q)"
apply (rule, frule hsound, auto intro: validn_valid)
done

end
