(* 		 
   File:	ToyHLproofs.thy
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyHLproofs3.thy,v 1.1 2003/07/15 16:15:28 da Exp $

   Proof system for Hoare Logic and soundness proof as suggested by Martin.

   NB: this version built on \<longrightarrow>n defined using clock
    
   FIXME: -- doesn't include rules for invokestatic/invoke
 
   DESIGN CHOICE:  
       1. use \<Turnstile>m P e Q : harmless meta-quantified formulae in all rules
       2. use G \<Turnstile> P e Q 
       3. use G \<turnstile> P e Q, deeper embedding of hoare rules
	  [ adv:    we know proof system exactly and stick to it;
	    disadv: may be incomplete ]

   Some rules for 1,2 are derived below as part of soundness proof.

   NOTICE!!! THIS FILE IS BROKEN/HALF-COMPLETE.
*)

header {* Hoare logic for Toy Grail: Proof System *}

theory ToyHLproofs3 = ToyHLrec3:

subsection {* Hoare logic derivability *}

types
 'a triple = "'a preassn \<times>  'a expr \<times>  'a postassn"

consts
  hoareproof :: "('a triple list \<times> 'a triple)  set"

syntax
  hoare_deriv :: "'a triple list 
		  \<Rightarrow> 'a preassn \<Rightarrow> 'a expr \<Rightarrow> 'a postassn \<Rightarrow> bool"  
		  ("_ |- (1_)/ (_)/ (1_)" [900,200,100,100] 50)

syntax (xsymbols)
  hoare_deriv :: "'a triple list \<Rightarrow>
		   'a preassn \<Rightarrow> 'a expr \<Rightarrow> 'a postassn \<Rightarrow> bool" 
		  ("_ \<turnstile> (1_)/ (_)/ (1_)" [900,100,200,100] 50)

translations
 "G \<turnstile> P e Q" == "(G,P,e,Q) \<in> hoareproof"

syntax
  hoare_emptyctx :: "'a preassn \<Rightarrow> 'a expr \<Rightarrow> 'a postassn \<Rightarrow> bool" ("\<turnstile> (1_)/ (_)/ (1_)" 40)
translations
  "\<turnstile> P e Q" == "[] \<turnstile> P e Q"




inductive hoareproof intros
 hconseq: "\<lbrakk> \<turnstile> P' e Q'; 
		       \<forall> s t v. 
		        (\<forall> z. (z,s)\<in> P' \<longrightarrow> (z,t,v)\<in> Q')
			\<longrightarrow>
		        (\<forall> z. (z,s)\<in> P \<longrightarrow> (z,t,v)\<in> Q) \<rbrakk> \<Longrightarrow> \<turnstile> P e Q"

 hnull:  "\<turnstile> {(z, s). (z,tick s, RVal Nullref)\<in> Q} NULL Q"

 hint:   "\<turnstile> {(z, s). (z,tick s,IVal i) \<in> Q} (expr.Int i) Q"

 hivar:  "\<turnstile> {(z, s). (z, tick s, IVal (s<vn>)) \<in> Q} (expr.IVar vn) Q"

 hrvar : "\<turnstile> {(z, s). (z, tick s, RVal (s\<lfloor>vn\<rfloor>)) \<in> Q} (expr.RVar vn) Q"

 hprimop: 
  "\<turnstile> {(z, s). (z,tickn 3 s, IVal (f (s<vn1>) (s<vn2>))) \<in> P}
      (expr.Primop f vn1 vn2)
      P"

 hrprimop: 
  "\<turnstile> {(z, s). (z,tickn 3 s, IVal (f (s\<lfloor>vn1\<rfloor>) (s\<lfloor>vn2\<rfloor>))) \<in> P}
      (expr.RPrimop f vn1 vn2)
      P"

 hgetfi: "\<turnstile> {(z, s). ( z, tickn 2 s, IVal (s<(theloc s\<lfloor>vn\<rfloor>)\<bullet>f>) ) \<in> Q}
	        (GetFi vn f)
		Q"
 hgetfr: "\<turnstile> {(z, s). ( z, tickn 2 s, RVal (s\<lfloor>(theloc s\<lfloor>vn\<rfloor>)\<diamondsuit>f\<rfloor>) ) \<in> Q}
	        (GetFr vn f)
		Q"
 hputfi: 
  "\<turnstile> {(z, s). (z, tickn 3 (s<(theloc s\<lfloor>vn\<rfloor>)\<bullet>f := (s<valv>)>), IVal (s<valv>)) \<in> Q}
	      (PutFi vn f valv)
	      Q"
 hputfr: 
  "\<turnstile> {(z, s). (z, tickn 3 (s\<lfloor>(theloc s\<lfloor>vn\<rfloor>)\<diamondsuit>f := (s\<lfloor>valv\<rfloor>)\<rfloor>), RVal (s\<lfloor>valv\<rfloor>)) \<in> Q}
	      (PutFr vn f valv)
	       Q"
 hnew: "\<turnstile> {(z, s). (z, tick (newobj s c ifldvals rfldvals), RVal (Ref (freshlocst s))) \<in> P}
	        (New c ifldvals rfldvals)
		P"

 hif : "\<lbrakk> G \<turnstile> P1 e1 Q;  G \<turnstile> P2 e2 Q; 
               P \<subseteq> {(z,s). (s<x>=1 \<longrightarrow> (z,tick s) \<in> P1)  \<and> 
			    (s<x>=0 \<longrightarrow> (z,tick s) \<in> P2)}
               \<rbrakk>
          \<Longrightarrow> G \<turnstile> P (IF x THEN e1 ELSE e2) Q"

 hlet: "\<lbrakk> G \<turnstile> P e {(z,s,v). (z,ivarupdate (tick s) x (theival v)) \<in> R};
	  G \<turnstile> R e' Q \<rbrakk> 
       \<Longrightarrow> G \<turnstile> P (LET x=e IN e' END) Q"

 hletr: "\<lbrakk> G \<turnstile> P e {(z,s,v). (z,rvarupdate (tick s) x (therval v)) \<in> R};
	   G \<turnstile> R e' Q \<rbrakk> 
       \<Longrightarrow> G \<turnstile> P (LET rf x=e IN e' END) Q"

 hcall: (* recursive! *)
    "((P,CALL fn,Q)#G) \<turnstile> (apsnd (tickn 1 o incrcallcount) ` P) (funtable fn) Q 
      \<Longrightarrow> G \<turnstile> P (CALL fn) Q"

(*
 hinvokestatic:
  "(\<forall> s_init. 
    (((P,InvokeStatic C mn vn2,Q)#G) \<turnstile>
      {(z, s). s = newframe s_init mn Nullref (s_init\<lfloor>vn2\<rfloor>) \<and> (z, s_init) \<in> P}
       (methtable C mn)
      {(z,s,v). \<exists> s'. s'=tickn 4 (oldframe s s_init) \<and> (z,s',v) \<in> Q})) \<Longrightarrow>
     (G \<turnstile> P (InvokeStatic C mn vn2) Q)"

 hinvoke:
  "(\<forall> s_init. 
  (((P,Invoke vn1 mn vn2,Q)#G) \<turnstile> 
      {(z, s). s_init\<lfloor>vn1\<rfloor> = (Ref a) \<and> 
                s = newframe s_init mn (Ref a) (s_init\<lfloor>vn2\<rfloor>) \<and>
                (z, s_init) \<in> P}
      (methtable (the (s_init\<guillemotleft>a\<guillemotright>)) mn)
      {(z,s,v). \<exists> s'. s'=tickn 5 (oldframe s s_init) \<and> (z,s',v) \<in> Q})) \<Longrightarrow>
  (G \<turnstile> P (Invoke vn1 mn vn2) Q)"
*)

 hpre:      "\<lbrakk> G \<turnstile> P1 e Q; P \<subseteq> P1  \<rbrakk> \<Longrightarrow> G \<turnstile> P (PRE P1: e) Q"

 hpost:     "\<lbrakk> G \<turnstile> P e Q1; Q1 \<subseteq> Q \<rbrakk>  \<Longrightarrow> G \<turnstile> P (POST Q1: e) Q"

 hmeasure:  "\<lbrakk> G \<turnstile> P e Q \<rbrakk> \<Longrightarrow> 
               G \<turnstile> {(z,s). (z,s)\<in> P \<and> (\<exists> s'. (\<exists> v. (z,s',v)\<in> Q) \<and> (s,s')\<in> M)} (Measure M e) Q"

 hax:       "(P,e,Q) mem G \<Longrightarrow> G \<turnstile> P e Q"

 hthin:     "\<lbrakk> G \<turnstile> P e Q; set G \<subseteq> set H \<rbrakk> \<Longrightarrow> H \<turnstile> P e Q"



section {* Soundness of Hoare Logic *}

subsection {* Context validity *}

constdefs
  hoare_ctxt_valid :: "'a triple list \<Rightarrow> bool"      ("|\<Turnstile> _" 60)
  "|\<Turnstile> G  \<equiv>  (list_all (\<lambda> (P, e, Q). \<Turnstile> P e Q) G)"

(* FIXME: syntax: why is space needed before |\<Turnstile> ? *)

lemma ctx_proj[rule_format]:  "(( |\<Turnstile> G) \<and> ((P,e,Q) mem G) ) \<longrightarrow> (\<Turnstile> P e Q)"
apply (induct_tac G)
apply simp
apply (simp add: hoare_ctxt_valid_def)
done

lemma ctxt_drop: "( |\<Turnstile> ((P,e,Q)#G)) ==> |\<Turnstile> G"
by (simp add: hoare_ctxt_valid_def)

lemma ctxt_ext[simp]: "( |\<Turnstile> ((P,e,Q)#G)) = ((\<Turnstile> P e Q) \<and> ( |\<Turnstile> G))"
by (simp add: hoare_ctxt_valid_def)

lemma ctx_sub[rule_format]:  "(( |\<Turnstile> G) \<and> (set H \<subseteq> set G) ) \<longrightarrow> ( |\<Turnstile> H)"
apply (simp add: hoare_ctxt_valid_def list_all_conv)
apply auto
done

lemma emptyctx [simp]: "|\<Turnstile> []"
by (simp add: hoare_ctxt_valid_def)


text {* Context validity to depth n *}

constdefs
  hoare_ctxt_validn :: "nat \<Rightarrow> 'a triple list \<Rightarrow> bool"      ("|\<Turnstile>\<^sub>_ _" 60)
  "|\<Turnstile>\<^sub>n G  \<equiv>  (list_all (\<lambda> (P, e, Q). \<Turnstile>\<^sub>n P e Q) G)"

lemma ctxt_valid_validn: "( |\<Turnstile> G) \<Longrightarrow> (\<forall> n.( |\<Turnstile>\<^sub>n G))"
apply (simp add: hoare_ctxt_validn_def hoare_ctxt_valid_def)
apply (simp add: list_all_conv)
apply rule
apply rule
apply (drule_tac x=x in bspec, simp)
apply (auto elim: valid_validn [THEN spec])
done

lemma emptyctx [simp]: "|\<Turnstile>\<^sub>n []"
by (simp add: hoare_ctxt_validn_def)

lemma ctx_projn[rule_format]:  "(( |\<Turnstile>\<^sub>n G) \<and> ((P,e,Q) mem G) ) \<longrightarrow> (\<Turnstile>\<^sub>n P e Q)"
apply (induct_tac G)
apply simp
apply (simp add: hoare_ctxt_validn_def)
done


lemma ctx_subn[rule_format]:  "(( |\<Turnstile>\<^sub>n G) \<and> (set H \<subseteq> set G) ) \<longrightarrow> ( |\<Turnstile>\<^sub>n H)"
apply (simp add: hoare_ctxt_validn_def list_all_conv)
apply auto
done

lemma ctxt_cons: "\<lbrakk> |\<Turnstile> G; \<Turnstile> P e Q \<rbrakk> \<Longrightarrow> ( |\<Turnstile> ((P,e,Q) # G))"
by (simp add: hoare_ctxt_valid_def)

lemma ctxt_validn_valid[rule_format]: "(\<forall> n.( |\<Turnstile>\<^sub>n G)) \<longrightarrow> ( |\<Turnstile> G)"
apply (induct_tac G)
apply simp
apply clarify
apply (rule ctxt_cons)
apply (simp add:  hoare_ctxt_validn_def)
apply (rule validn_valid)
apply (simp add:  hoare_ctxt_validn_def)
done

lemma ctxt_lower: "\<lbrakk> |\<Turnstile>\<^sub>n G; m<n \<rbrakk> \<Longrightarrow> |\<Turnstile>\<^sub>m G"
apply (simp add: hoare_ctxt_validn_def)
apply (simp add: list_all_conv)
apply rule
apply rule
apply (drule_tac x=x in bspec, simp)
apply clarsimp
apply (rule_tac n="n" in lowerm)
apply auto
done

lemma lowerm: "\<lbrakk>  m < n; \<Turnstile>\<^sub>n P e Q  \<rbrakk> \<Longrightarrow> \<Turnstile>\<^sub>m P e Q"
apply (simp (no_asm) add: hoare_validn_def)
apply (rule, rule)
apply (unfold hoare_validn_def)
apply (erule_tac x=ma in allE)
apply auto
done

lemma ctxt_consn: "\<lbrakk> |\<Turnstile>\<^sub>n G; \<Turnstile>\<^sub>n P e Q \<rbrakk> \<Longrightarrow> ( |\<Turnstile>\<^sub>n ((P,e,Q) # G))"
by (simp add: hoare_ctxt_validn_def)


subsection {* Relativized validity in a context *}

constdefs
  hoare_valid_in_ctxt :: "'a triple list \<Rightarrow> 'a preassn \<Rightarrow> 'a expr \<Rightarrow> 'a postassn \<Rightarrow> bool"      
										("_ \<Turnstile> _ _ _" 75)
  "G \<Turnstile> P e Q  \<equiv>  \<forall> n. ( |\<Turnstile>\<^sub>n G ) \<longrightarrow> \<Turnstile>\<^sub>n P e Q"

(*
 1. \<And>G P P1 P2 Q e1 e2 x.
       \<lbrakk>G \<turnstile> P1 e1 Q; G |\<Turnstile> P1 e1 Q; G \<turnstile> P2 e2 Q; G |\<Turnstile> P2 e2 Q;
          P \<subseteq> {(z, s). (s<x> = 1 \<longrightarrow> (z, tick s) \<in> P1) \<and> (s<x> = 0 \<longrightarrow> (z, tick s) \<in> P2)}\<rbrakk>
       \<Longrightarrow> G |\<Turnstile> P IF x THEN e1 ELSE e2 Q
*)

(*lemma "\<lbrakk> G |\<Turnstile> P e Q;  \<Longrightarrow> \<Turnstile> G \<longrightarrow> *)
subsection {* Recursion rules in context *}

lemma CHCall:  
    "\<lbrakk> ((P, CALL fn, Q) # G) \<Turnstile> (apsnd (tickn 1 \<circ> incrcallcount) ` P) (funtable fn) Q \<rbrakk>
       \<Longrightarrow> G \<Turnstile> P (CALL fn) Q"
apply (simp add: hoare_valid_in_ctxt_def)
apply rule 
apply rule
apply (rule calllemma)
apply (rule, rule, rule)
apply (drule_tac x="m" in spec)
apply (erule impE)
apply (rule ctxt_consn)
apply (erule ctxt_lower)
apply auto
done

(*
lemma invokestaticsound:

lemma invokesound:
*)

subsection {* Other rules with non-empty contexts *}

lemma HIfn : "\<lbrakk>  \<Turnstile>\<^sub>n P1 e1 Q;   \<Turnstile>\<^sub>n P2 e2 Q; 
               P \<subseteq> {(z,s). (s<x>=1 \<longrightarrow> (z,tick s) \<in> P1)  \<and> 
			    (s<x>=0 \<longrightarrow> (z,tick s) \<in> P2)}
               \<rbrakk>
          \<Longrightarrow>  \<Turnstile>\<^sub>n P (IF x THEN e1 ELSE e2) Q"
apply (simp add: hoare_validn_def)
apply clarify 
apply (case_tac "clock t - clock s = n")
apply (erule evalIf_cases)
apply (erule_tac x="clock t - clock s" in allE)
apply (erule_tac x="clock t - clock s" in allE)
apply fastsimp
apply (erule_tac x=s in allE)
apply (erule_tac x=t in allE)
apply (erule_tac x=t in allE)
apply (erule_tac x="clock t - clock s" in allE)

done

lemma CHIf: "\<lbrakk>G \<Turnstile> P1 e1 Q; G \<Turnstile> P2 e2 Q;
             P \<subseteq> {(z, s). (s<x> = 1 \<longrightarrow> (z, tick s) \<in> P1) \<and> (s<x> = 0 \<longrightarrow> (z, tick s) \<in> P2)}\<rbrakk>
       \<Longrightarrow> G \<Turnstile> P IF x THEN e1 ELSE e2 Q"
apply (simp add: hoare_valid_in_ctxt_def)
apply rule
apply rule
apply (erule_tac x=n in allE)
apply (erule_tac x=n in allE)
apply (simp)
apply (rule HIfn, assumption, assumption, simp)
done

lemma HLetn: "\<lbrakk> \<Turnstile>\<^sub>n P e {(z, s, v). (z, (tick s)<x:=theival v>) \<in> R}; \<Turnstile>\<^sub>n R e' Q\<rbrakk>
              \<Longrightarrow>  \<Turnstile>\<^sub>n P LET x = e IN e' END Q"
apply (simp add: hoare_validn_def)
apply clarify 
apply (erule evalLeti_cases)
apply (erule_tac x="clock s1 - clock s" in allE)
apply (erule_tac x="clock t - clock (tick s1<x:=i>)" in allE)
apply simp
apply (subgoal_tac "clock s1 - clock s \<le> n \<and> clock t - clock s1 \<le> n")
apply simp
apply (erule_tac x=s in allE)
apply (erule_tac x="tick s1<x:=i>" in allE)
apply (erule_tac x=s1 in allE)
apply (erule_tac x=t in allE)
apply (erule_tac x="IVal i" in allE)
apply (erule_tac x=v in allE)
apply simp
apply (rotate_tac 1)
apply (erule thin_rl)
apply (drule clock_mono)
apply (drule clock_mono)
apply (erule thin_rl)
apply (erule thin_rl)
apply simp
apply arith
done

lemma CHLet: "\<lbrakk> G \<Turnstile> P e {(z, s, v). (z, (tick s)<x:=theival v>) \<in> R}; G \<Turnstile> R e' Q\<rbrakk>
       \<Longrightarrow> G \<Turnstile> P LET x = e IN e' END Q"
apply (simp add: hoare_valid_in_ctxt_def)
apply rule
apply rule
apply (erule_tac x=n in allE)
apply (erule_tac x=n in allE)
apply (simp)
apply (rule HLetn)
apply fastsimp
apply assumption
done


lemma HLetrn: "\<lbrakk> \<Turnstile>\<^sub>n P e {(z, s, v). (z, (tick s)\<lfloor>x:=therval v\<rfloor>) \<in> R}; \<Turnstile>\<^sub>n R e' Q\<rbrakk>
       \<Longrightarrow>  \<Turnstile>\<^sub>n P LET rf x = e IN e' END Q"
apply (simp add: hoare_validn_def)
apply clarify 
apply (erule evalLetr_cases)
apply (erule_tac x="clock s1 - clock s" in allE)
apply (erule_tac x="clock t - clock (tick s1\<lfloor>x:=i\<rfloor>)" in allE)
apply simp
apply (subgoal_tac "clock s1 - clock s \<le> n \<and> clock t - clock s1 \<le> n")
apply simp
apply (erule_tac x=s in allE)
apply (erule_tac x="tick s1\<lfloor>x:=r\<rfloor>" in allE)
apply (erule_tac x=s1 in allE)
apply (erule_tac x=t in allE)
apply (erule_tac x="RVal r" in allE)
apply (erule_tac x=v in allE)
apply simp
apply (rotate_tac 1)
apply (erule thin_rl)
apply (drule clock_mono)
apply (drule clock_mono)
apply (erule thin_rl)
apply (erule thin_rl)
apply simp
apply arith
done

lemma CHLetr: "\<lbrakk> G \<Turnstile> P e {(z, s, v). (z, (tick s)\<lfloor>x:=therval v\<rfloor>) \<in> R}; G \<Turnstile> R e' Q\<rbrakk>
       \<Longrightarrow> G \<Turnstile> P LET rf x = e IN e' END Q"
apply (simp add: hoare_valid_in_ctxt_def)
apply rule
apply rule
apply (erule_tac x=n in allE)
apply (erule_tac x=n in allE)
apply (simp)
apply (rule HLetrn)
apply fastsimp+
done

lemma HPren: "\<lbrakk> \<Turnstile>\<^sub>n P1 e Q; P \<subseteq> P1\<rbrakk> \<Longrightarrow> \<Turnstile>\<^sub>n P PRE P1: e Q"
apply (simp add: hoare_validn_def)
apply (fastsimp elim!: evalPre_cases)
done

lemma HPostn: "\<lbrakk> \<Turnstile>\<^sub>n P e Q1; Q1 \<subseteq> Q\<rbrakk> \<Longrightarrow> \<Turnstile>\<^sub>n P POST Q1: e Q"
apply (simp add: hoare_validn_def)
apply (fastsimp elim!: evalPost_cases)
done

lemma CHPre: " \<lbrakk>G \<Turnstile> P1 e Q; P \<subseteq> P1\<rbrakk> \<Longrightarrow> G \<Turnstile> P PRE P1: e Q"
apply (simp add: hoare_valid_in_ctxt_def)
apply (rule, rule)
apply (erule_tac x=n in allE, simp)
apply (rule HPren)
apply fastsimp+
done

lemma CHPost: " \<lbrakk>G \<Turnstile> P e Q1; Q1 \<subseteq> Q\<rbrakk> \<Longrightarrow> G \<Turnstile> P POST Q1: e Q"
apply (simp add: hoare_valid_in_ctxt_def)
apply (rule, rule)
apply (erule_tac x=n in allE, simp)
apply (rule HPostn)
apply fastsimp+
done

lemma HMeasuren:  "\<lbrakk> \<Turnstile>\<^sub>n P e Q\<rbrakk> 
       \<Longrightarrow>  \<Turnstile>\<^sub>n {(z, s). (z, s) \<in> P \<and> (\<exists>s'. (\<exists>v. (z, s', v) \<in> Q) \<and> (s, s') \<in> M)} MEASURE M: e Q"
apply (simp add: hoare_validn_def)
apply (fastsimp elim!: evalMeasure_cases)
done

lemma CHMeasure: "\<lbrakk>G \<Turnstile> P e Q\<rbrakk> 
       \<Longrightarrow> G \<Turnstile> {(z, s). (z, s) \<in> P \<and> (\<exists>s'. (\<exists>v. (z, s', v) \<in> Q) \<and> (s, s') \<in> M)} MEASURE M: e Q"
apply (simp add: hoare_valid_in_ctxt_def)
apply (rule, rule)
apply (erule_tac x=n in allE, simp)
apply (rule HMeasuren)
apply fastsimp+
done


subsection {* Main theorem *}

lemma valid_validn: "\<Turnstile> P e Q \<Longrightarrow> \<Turnstile>\<^sub>n P e Q"
by (simp add: hoare_valid_def hoare_validn_def)

lemma [simp]: "([] \<Turnstile> P e Q) =  (\<forall> n. \<Turnstile>\<^sub>n P e Q)"
by (simp add: hoare_valid_in_ctxt_def)


theorem hsound: "(G \<turnstile> P e Q) \<Longrightarrow> (G \<Turnstile> P e Q)"
apply (erule hoareproof.induct) 
(* rules with empty contexts are easy: 
   transfered from corresponding ordinary validity rule *)
apply (simp, rule, rule valid_validn, drule validn_valid)
apply (erule HConseq, assumption)
apply (simp, rule, rule valid_validn, rule HNull)
apply (simp, rule, rule valid_validn, rule HInt)
apply (simp, rule, rule valid_validn, rule HVar)
apply (simp, rule, rule valid_validn, rule HVarr)
apply (simp, rule, rule valid_validn, rule HPrimop)
apply (simp, rule, rule valid_validn, rule HRPrimop)
apply (simp, rule, rule valid_validn, rule HGetFi)
apply (simp, rule, rule valid_validn, rule HGetFr)
apply (simp, rule, rule valid_validn, rule HPutFi)
apply (simp, rule, rule valid_validn, rule HPutFr)
apply (simp, rule, rule valid_validn, rule HNew)
apply (rule CHIf CHLet CHLetr CHCall CHPre CHPost CHMeasure, simp+)+
apply (simp add: hoare_valid_in_ctxt_def)
apply (rule, rule, fastsimp intro: ctx_projn)
apply (simp add: hoare_valid_in_ctxt_def)
apply (rule, rule, fastsimp intro: ctx_subn)
done

text {* Finally, soundness in an empty context: *}

corollary "\<turnstile> P e Q  \<longrightarrow> \<Turnstile> P e Q"
apply (rule, frule hsound, auto intro: validn_valid)
done

end


