(*  
   File:	ToyHLextras.thy
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyHLextras.thy,v 1.2 2003/06/11 09:38:49 da Exp $

   Extra (probably unused) rules of Hoare Logic for Toy Grail.
   Taken from ToyHLbasic.
*)

theory ToyHLextras = ToyHLderived:

subsection {* Two versions of Call rules *} 

text {* We can derive HCall from HCallinv\<dots> *}

lemma "\<Turnstile> (imagepre tickcall P) (funtable fn) Q \<Longrightarrow> \<Turnstile> P (CALL fn) Q"
apply (rule_tac Q'=Q in HConseq)
apply (erule HCallinv)
apply (subgoal_tac "invimagepre tickcall (imagepre tickcall P) = P")
prefer 2
apply (erule thin_rl)
apply (rule preassninvimage_image)
apply (simp add: state_functions)
apply (rule comp_inj_on)
apply (rule inj_onI)
apply (rule incrcallcount_inj)
apply simp
apply (rule inj_onI)
apply (erule tickn_inj)
apply simp
done


subsection {* Equivalent If rules: for interest's sake *} 

lemma HIf_Alt: "\<lbrakk> \<Turnstile> (apsnd (tickn 1)) ` {(z,s). s<x>=1 \<and> (z, s)\<in> P} e1 Q;
              \<Turnstile> (apsnd (tickn 1)) ` {(z,s). s<x>=0 \<and> (z, s)\<in> P} e2 Q \<rbrakk> 
          \<Longrightarrow> \<Turnstile> P (IF x THEN e1 ELSE e2) Q"
apply (rule HIf)
apply assumption
apply assumption
apply auto
done

(* show that If_Alt implies current version of If *)
lemma "\<lbrakk> \<Turnstile> P1 e1 Q;  \<Turnstile> P2 e2 Q; 
               P \<subseteq> {(z,s). (s<x>=1 \<longrightarrow> (z,tick s) \<in> P1)  \<and> 
			    (s<x>=0 \<longrightarrow> (z,tick s) \<in> P2)} \<rbrakk>
          \<Longrightarrow> \<Turnstile> P (IF x THEN e1 ELSE e2) Q"
apply (rule HIf_Alt)
apply (erule HConseq, auto)
apply (erule thin_rl)
apply (erule HConseq, auto)
done

section {* Defunct procedure/recursion rules *}

text {* Proving CALL with a pre-condition: *}

(* or: *)
lemma HCallPre: 
  "\<lbrakk> funtable fn = (PRE R: body); 
     P \<subseteq> (invimagepre (tickn 1 o incrcallcount) R'); 
     \<Turnstile> R' body Q; 
     P \<subseteq> (invimagepre (tickn 1 o incrcallcount) R) (* VC: check pre-condition *) \<rbrakk>
 \<Longrightarrow> \<Turnstile> P (CALL fn) Q"
apply (rule HCall, simp)
apply (simp add: HPre0 image_def)
apply (rule HSP, assumption)
apply auto
done

text {* Proving CALL with a pre and post-condition pair: *}

lemma HCallPrePost: 
  "\<lbrakk>  funtable fn = (PRE R: POST S: body); 
      P \<subseteq> (invimagepre (tickn 1 o incrcallcount) R);  
      R \<subseteq> R';
      \<Turnstile> R body S; 
      S \<subseteq> Q (* VC: check post-condition *) \<rbrakk> 
 \<Longrightarrow> \<Turnstile> P (CALL fn) Q"
apply (rule HCall, simp)
apply (simp add: HPre0 HPost0 image_def)
oops

text{* TODO:
  \begin{enumerate}
  \item Proving CALL with measure, induction, and pre-post pair.
  \item Same rules for method invocations
  \item Generalising to mutual induction; treating whole programs.
  \end{enumerate}
*}

text {* the one taken from the old VCG (hoare_rec); should do the same as HCallPrePost *}

lemma HCall4VCG: 
  "\<lbrakk> funtable fn = (PRE R: POST S: body); 
     \<Turnstile> R body S ;
     {(z,s). \<exists> s'. (z,s') \<in> P \<and> s = (tickn 1 (incrcallcount s'))} \<subseteq> R ; S \<subseteq> Q \<rbrakk> 
  \<Longrightarrow> 
  \<Turnstile> P (CALL fn) Q"
apply (rule "HCall")
apply simp
apply (rule "HPre")
apply (rule "HPost")
apply assumption
apply assumption
apply auto
done

(* Call + Rec w/ pre-post-assertions in tables *)
(* da: not sure I believe the tickcall P <= R in last but one premise, is that right? *)
lemma HCall4VCGRec: 
  "\<lbrakk> funtable fn = (PRE R: POST S: body); 
     \<forall> s'. (\<Turnstile> {(z,s).(z,s)\<in> R \<and> (s,s')\<in> (fun_wfmeasure_table fn)} (CALL fn) S 
           \<longrightarrow> 
           \<Turnstile> {(z,s). (z,s') \<in> R \<and> s=tick (incrcallcount s')} body S) ;
     {(z,s). \<exists> s'. (z,s') \<in> P \<and> s = (tickn 1 (incrcallcount s'))} \<subseteq> R ; S \<subseteq> Q  \<rbrakk> \<Longrightarrow> 
  \<Turnstile> P (CALL fn) Q"
oops

subsection {* Derived rules for recursion *}

text {* Some particular instantiations of HRec: *}

lemma HRecClockWF:  (* unused *)
 "\<lbrakk> \<forall> s'. ((\<Turnstile> {(z,s).(z,s)\<in> P \<and> nat (clock s) < nat (clock s')} e Q) \<longrightarrow> 
	   (\<Turnstile> {(z,s).(z,s)\<in> P \<and> s=s'} e Q)) \<rbrakk>
  \<Longrightarrow> \<Turnstile> P e Q"
apply (rule_tac r="inv_image less_than (nat o clock)" in HRecWF)
apply (rule wf_inv_image, rule wf_less_than)
apply (simp add: inv_image_def)
done

lemma HRecCallWF:  (* unused *)
 "\<lbrakk> \<forall> s'. ((\<Turnstile> {(z,s).(z,s)\<in> P \<and> nat (callcount s)  < nat (callcount s')} e Q) \<longrightarrow> 
	   (\<Turnstile> {(z,s).(z,s)\<in> P \<and> s=s'} e Q)) \<rbrakk>
  \<Longrightarrow> \<Turnstile> P e Q"
apply (rule_tac r="inv_image less_than (nat o callcount)" in HRecWF)  (* nat o callcount for int *)
apply (rule wf_inv_image, rule wf_less_than)
apply (simp add: inv_image_def)
done




section {* Defunct rules *}

lemma Hbasic': "\<Turnstile> P e {(z,t,v). \<exists> s. (z,s) \<in> P \<and> \<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle>}"
by (fastsimp intro: HoareI elim: HoareE)



lemma HLet0: "\<lbrakk> \<Turnstile> R e' Q;
 	        \<Turnstile> P e {(z,s,v). \<exists> i. v=IVal i \<and> (z,ivarupdate (tick s) x i) \<in> R} \<rbrakk> 
       \<Longrightarrow> \<Turnstile> P (LET x=e IN e' END) Q"
by (simp add: hoare_valid_def, fastsimp elim: evalLeti_cases)


lemma HLetr0: "\<lbrakk> \<Turnstile> R e' Q;
		 \<Turnstile> P e {(z,s,v). \<exists> r. v=RVal r \<and> (z,rvarupdate (tick s) x r) \<in> R} \<rbrakk>
       \<Longrightarrow> \<Turnstile> P (LET rf x=e IN e' END) Q"
by (simp add: hoare_valid_def, fastsimp elim: evalLetr_cases)


lemma HPutFr1: 
  "\<forall> a. \<Turnstile> {(z, s). (s\<lfloor>vn\<rfloor> = Ref a \<and> 
			 (z, tickn 3 (obj_rfieldupdate s a f (s\<lfloor>valv\<rfloor>)), RVal (s\<lfloor>valv\<rfloor>)) \<in> Q)}
	        (PutFr vn f valv)
		Q"
by (fastsimp intro: HoareI elim: HoareE evalPutFr_cases)

lemmas HPutFr_ = HPutFr [THEN HSP]


lemma HCall1: 
  "(\<Turnstile> {(z,s). \<exists> s'. (z, s')\<in>P \<and> s=tick (incrcallcount s')} (funtable fn) Q) \<Longrightarrow> 
		\<Turnstile> P (CALL fn) Q"
by (fastsimp intro: HoareI elim: HoareE evalCall_cases)

lemma HCall2: 
  "(\<forall> s'.\<Turnstile> {(z,s). (z, s') \<in> P \<and> s=tick (incrcallcount s')} 
	(funtable fn) Q) \<Longrightarrow> \<Turnstile> P (CALL fn) Q"
by (fastsimp intro: HoareI elim: HoareE evalCall_cases)



(* da: nedeed? *)
lemmas HCallAux0 = HWC [of _ "CALL fn" _]

lemma HCall3: "\<lbrakk> P \<subseteq> P'; 
	       (\<forall> s'.\<Turnstile> {(z,s). (z, s')\<in>P' \<and> s=tick (incrcallcount s')} (funtable fn) Q) \<rbrakk> \<Longrightarrow> \<Turnstile> P (CALL fn) Q"
by (fastsimp intro: HoareI elim: HoareE evalCall_cases)



lemma HRecWF':
 "\<lbrakk> \<forall> s'. (\<Turnstile> {(z,s).(z,s)\<in> P \<and> (s,s')\<in> r} e Q) \<longrightarrow> \<Turnstile> {(z,s).(z,s)\<in> P \<and> s=s'} e Q;
   wf r \<rbrakk> 
  \<Longrightarrow> \<Turnstile> P e Q"
apply (rule HoareI, rule)
apply (erule_tac a = "s" and 
         P = "\<lambda> s. \<forall> v t. \<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<longrightarrow> (\<forall> z. (z,s)\<in> P \<longrightarrow> (z,t,v)\<in> Q)" in wf_induct)
apply (fastsimp intro: HoareI elim: HoareE)
done



text {* A rule for mathematical induction, using a function 
  which maps a state to some natural number. *}

lemma fs:
 "(\<Turnstile> {(z,s). \<exists> n. (z,s)\<in> P \<and> (F s = n)} e Q) \<Longrightarrow> (\<Turnstile> P e Q)"
by (simp add: hoare_valid_def)

lemma HRec: 
 "\<lbrakk> \<Turnstile> {(z,s). (z,s)\<in> P \<and> F s = 0} e Q;
    \<forall> n. (\<Turnstile> {(z,s). (z,s)\<in> P \<and> (F s = n)} e Q) \<longrightarrow> 
         (\<Turnstile> {(z,s). (z,s)\<in> P \<and> (F s = Suc n)} e Q) \<rbrakk> \<Longrightarrow> 
   \<Turnstile> P e Q"
apply (rule fs, rule HExAll [THEN iffD2])
apply (rule allI)
apply (rule nat_induct)
apply (assumption)
apply (erule_tac x=na in allE)
apply (erule impE, assumption)
apply (assumption)
done


end
