(*  Old rules kept here for reference in case they turn out to be useful *)

subsection {* Derived rules for interactive use *}

text {* The 1 variants of rules combine with an instance of pre-condition strengthening. 
  *}

lemmas HNull1 	= HNull     [THEN HSP]
lemmas HInt1  	= HInt      [THEN HSP]
lemmas HVar1  	= HVar      [THEN HSP]
lemmas HVarr1 	= HVarr     [THEN HSP]
lemmas HPrimop1 = HPrimop   [THEN HSP]
lemmas HGetFi1  = HGetFi    [THEN HSP]
lemmas HGetFr1  = HGetFr    [THEN HSP]
lemmas HPutFi1  = HPutFi    [THEN HSP]
lemmas HPutFr1  = HPutFr    [THEN HSP]
lemmas HNew1    = HNew      [THEN HSP]
lemmas HLet1	= HLet 	    [THEN HSP]
lemmas HLetr1   = HLetr     [THEN HSP]
lemmas HCall1   = HCall     [THEN HSP]
lemmas HInvoke1 = HInvoke   [THEN HSP]
lemmas HPre1    = HPre      [THEN HSP]
lemmas HPost1   = HPost     [THEN HSP]
lemmas HMeasure1 = HMeasure [THEN HSP]
lemmas HInvokeStatic1 = HInvokeStatic [THEN HSP]

lemma HIf1 : "\<lbrakk> P \<subseteq> {(z,s). (s<x>=1 \<longrightarrow> (z,tick s) \<in> P1)  \<and> 
			    (s<x>=0 \<longrightarrow> (z,tick s) \<in> P2)};
               \<Turnstile> P1 e1 Q;  \<Turnstile> P2 e2 Q
               \<rbrakk>
          \<Longrightarrow> \<Turnstile> P (IF x THEN e1 ELSE e2) Q"
by (rule HIf, auto)


lemma Hbasic': "\<Turnstile> P e {(z,t,v). \<exists> s. (z,s) \<in> P \<and> \<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle>}"
by (fastsimp intro: HoareI elim: HoareE)



(* in this rule we know post state preserves vars; but preconds strong for PC *)
lemma HPrimopNothe: "\<Turnstile> {(z, s). (z,tickn 3 s, IVal (f (s<vn1>) (s<vn2>))) \<in> P}
                  (expr.Primop f vn1 vn2)
		   P"
by (fastsimp elim: evalPrimop_cases)


lemma HLet0: "\<lbrakk> \<Turnstile> R e' Q;
 	        \<Turnstile> P e {(z,s,v). \<exists> i. v=IVal i \<and> (z,ivarupdate (tick s) x i) \<in> R} \<rbrakk> 
       \<Longrightarrow> \<Turnstile> P (LET x=e IN e' END) Q"
by (simp add: hoare_valid_def, fastsimp elim: evalLeti_cases)


lemma HLetr0: "\<lbrakk> \<Turnstile> R e' Q;
		 \<Turnstile> P e {(z,s,v). \<exists> r. v=RVal r \<and> (z,rvarupdate (tick s) x r) \<in> R} \<rbrakk>
       \<Longrightarrow> \<Turnstile> P (LET rf x=e IN e' END) Q"
by (simp add: hoare_valid_def, fastsimp elim: evalLetr_cases)


lemma HPutFr1: 
  "\<forall> a. \<Turnstile> {(z, s). (s\<lfloor>vn\<rfloor> = Ref a \<and> 
			 (z, tickn 3 (obj_rfieldupdate s a f (s\<lfloor>valv\<rfloor>)), RVal (s\<lfloor>valv\<rfloor>)) \<in> Q)}
	        (PutFr vn f valv)
		Q"
by (fastsimp elim: evalPutFr_cases)

lemmas HPutFr_ = HPutFr [THEN HSP]


lemma HCall: 
  "(\<forall> s'.\<Turnstile> {(z,s). (z, s') \<in> P \<and> s=tick (incrcallcount s')} 
	(funtable fn) Q) \<Longrightarrow> \<Turnstile> P (CALL fn) Q"
by (fastsimp elim: evalCall_cases)

lemma HCall1: 
  "(\<Turnstile> {(z,s). \<exists> s'. (z, s')\<in>P \<and> s=tick (incrcallcount s')} (funtable fn) Q) \<Longrightarrow> 
		\<Turnstile> P (CALL fn) Q"
by  (fastsimp elim: evalCall_cases)


(* da: nedeed? *)
lemmas HCallAux0 = HWC [of _ "CALL fn" _]

lemma HCall: "\<lbrakk> P \<subseteq> P'; 
	       (\<forall> s'.\<Turnstile> {(z,s). (z, s')\<in>P' \<and> s=tick (incrcallcount s')} (funtable fn) Q) \<rbrakk> \<Longrightarrow> \<Turnstile> P (CALL fn) Q"
by (fastsimp elim: evalCall_cases)



lemma HRecWF':
 "\<lbrakk> \<forall> s'. (\<Turnstile> {(z,s).(z,s)\<in> P \<and> (s,s')\<in> r} e Q) \<longrightarrow> \<Turnstile> {(z,s).(z,s)\<in> P \<and> s=s'} e Q;
   wf r \<rbrakk> 
  \<Longrightarrow> \<Turnstile> P e Q"
apply (rule, rule)
apply (erule_tac a = "s" and 
         P = "\<lambda> s. \<forall> v t. \<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<longrightarrow> (\<forall> z. (z,s)\<in> P \<longrightarrow> (z,t,v)\<in> Q)" in wf_induct)
apply (fastsimp)
done



text {* A rule for mathematical induction, using a function 
  which maps a state to some natural number. *}

lemma fs:
 "(\<Turnstile> {(z,s). \<exists> n. (z,s)\<in> P \<and> (F s = n)} e Q) \<Longrightarrow> (\<Turnstile> P e Q)"
by (simp add: hoare_valid_def)

lemma HRec: 
 "\<lbrakk> \<Turnstile> {(z,s). (z,s)\<in> P \<and> F s = 0} e Q;
    \<forall> n. (\<Turnstile> {(z,s). (z,s)\<in> P \<and> (F s = n)} e Q) \<longrightarrow> 
         (\<Turnstile> {(z,s). (z,s)\<in> P \<and> (F s = Suc n)} e Q) \<rbrakk> \<Longrightarrow> 
   \<Turnstile> P e Q"
apply (rule fs, rule HExAll [THEN iffD2])
apply (rule allI)
apply (rule nat_induct)
apply (assumption)
apply (erule_tac x=na in allE)
apply (erule impE, assumption)
apply (assumption)
done




end
