(*  Extra properties of operational semantics, not needed in main development *)

theory ToyGrailLemmasExtras = ToyGrailLemmas:

section {* Determinacy; operational semantics as a function *}

text {* Of course, we might well have simply written the operational
   semantics as function in the first place. *}

lemma determinacy [rule_format]: 
   "\<lbrakk> \<langle>s,e\<rangle> \<longrightarrow>e \<langle>v1,s1\<rangle> \<rbrakk> \<Longrightarrow> \<forall> v2 s2. \<langle>s,e\<rangle> \<longrightarrow>e \<langle>v2,s2\<rangle> \<longrightarrow> v1=v2 \<and> s1=s2"
apply (erule evalexpr.induct)
apply (fastsimp elim: eval_cases)
apply (fastsimp elim: eval_cases)
apply (fastsimp elim: eval_cases)
apply (fastsimp elim: eval_cases)
apply (fastsimp elim: eval_cases)
apply (fastsimp elim: eval_cases)
apply (fastsimp elim: eval_cases)
apply (fastsimp elim: eval_cases)
apply (fastsimp elim: eval_cases)
apply (fastsimp elim: eval_cases)
apply (fastsimp elim: eval_cases)
apply (rule, rule, rule, erule eval_cases)
apply fastsimp
apply (rotate_tac 1)
apply (erule thin_rl)
apply (erule thin_rl)  (* remove looping rewrite *)
apply fastsimp
apply (rule, rule, rule, erule eval_cases)
apply (rotate_tac 1)
apply (erule thin_rl)
apply (erule thin_rl)  (* remove looping rewrite *)
apply fastsimp
apply fastsimp
apply (rule, rule, rule, erule eval_cases)
apply (erule_tac x="IVal ia" in allE)
apply (erule_tac x=v2 in allE)
apply (erule_tac x=s1a in allE)
apply (erule_tac x=s2a in allE)
apply fastsimp
apply (rule, rule, rule, erule eval_cases)
apply (erule_tac x="RVal ra" in allE)
apply (erule_tac x=v2 in allE)
apply (erule_tac x=s1a in allE)
apply (erule_tac x=s2a in allE)
apply fastsimp
apply (rule, rule, rule, erule eval_cases) (* Letv *)
apply (erule_tac x=rtv1a in allE)
apply (erule_tac x=v2 in allE)
apply (erule_tac x=s1a in allE)
apply (erule_tac x=s2a in allE)
apply simp
apply (rule, rule, rule, erule eval_cases)
apply (erule_tac x=v2 in allE)
apply (erule_tac x=s2 in allE)
apply fastsimp
apply (rule, rule, rule, erule eval_cases)
apply (erule_tac x=v2 in allE)
apply (erule_tac x=s'a in allE)
apply fastsimp
apply (rule, rule, rule, erule eval_cases)
apply (erule_tac x=v2 in allE)
apply (erule_tac x=s'a in allE)
apply fastsimp
apply (rule, rule, rule, erule eval_cases)
apply (erule_tac x=v2 in allE)
apply (erule_tac x=s2 in allE)
apply fastsimp
apply (rule, rule, rule, erule eval_cases)
apply (erule_tac x=v2 in allE)
apply (erule_tac x=s2 in allE)
apply fastsimp
apply (rule, rule, rule, erule eval_cases)
apply (erule_tac x=v2 in allE)
apply (erule_tac x=s2 in allE)
apply fastsimp
done


section {* Positions of state changes *}


lemma clock_add : "\<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<Longrightarrow> \<langle>tickn i s,e\<rangle> \<longrightarrow>e \<langle>v,tickn i t\<rangle>"
apply (erule evalexpr.induct)
prefer 12 (* Treat True/False rules in correct order first *)
apply (rule_tac s="tickn i s" in evalintro_cong, rule evalIf_True, simp+)
prefer 12
apply (rule_tac s="tickn i s" in evalintro_cong, rule evalIf_False, simp+)
apply (rule_tac s="tickn i s" in evalintro_cong, rule evalexpr.intros, simp+)+
done

declare plusone [simp del]

lemma callcount_add: "\<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<Longrightarrow> \<langle>incrcallcount s,e\<rangle> \<longrightarrow>e \<langle>v,incrcallcount t\<rangle>"
apply (erule evalexpr.induct)
prefer 12 (* Treat True/False rules in correct order first *)
apply (rule_tac s="incrcallcount s" in evalintro_cong, rule evalIf_True, simp+)
prefer 12
apply (rule_tac s="incrcallcount s" in evalintro_cong, rule evalIf_False, simp+)
apply (rule_tac s="incrcallcount s" in evalintro_cong, rule evalexpr.intros, simp+)+
done


lemma tickcall_add: "\<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<Longrightarrow> \<langle>tickcall s,e\<rangle> \<longrightarrow>e \<langle>v,tickcall t\<rangle>"
by (drule clock_add, drule callcount_add, simp)




end
