(* SimpleVCG *)

header {* Simple Cerification Condition Generator *}

theory SimpleVCG = ToyHLderived
files "SimpVC.ML":

text {* This is a very simple VCG that applies the Hoare rules
  in a left-constructive (WLP) style. 
  Verification conditions are left in a raw state
  as subset inclusions for manual simplification and solving.
*}

lemmas VCG_leaf_rules = 
  HNull HInt HVar HVarr 
  HPrimop HRPrimop HGetFi HPutFi HGetFr HPutFr HNew
lemmas VCG_let_rules = HLet HLetr
lemmas VCG_if_rules  = HIf
lemmas VCG_call_rules = HCall1  (* pree-post with pre-post rules *)
lemmas VCG_assn_rules = HPre HPost (* HMeasure *)


(*lemmas VCG_assm_rules = HConseq [of _ "CALL ?fn"]*)

lemma HCallasm: "\<Turnstile> P (CALL fn) Q \<Longrightarrow> \<Turnstile> P (CALL fn) Q" by auto

lemma HCallasm1: "\<lbrakk> \<Turnstile> P' ((CALL fn)::'a expr) Q'; 
		       \<forall> s t v. 
		        (\<forall> z. (z,s)\<in> P' \<longrightarrow> (z,t,v)\<in> Q')
			\<longrightarrow>
		        (\<forall> z. (z,s)\<in> P \<longrightarrow> (z,t,v)\<in> Q) \<rbrakk>
		   \<Longrightarrow> \<Turnstile> P ((CALL fn)::'a expr) Q"  (* let's try mono version first*)
by (rule HConseq, simp)

lemmas VCG_assm_rules = HCallasm HCallasm1

(* Recursion rules for Call *)

(*
lemma HCallPrePostRec:  use only the asserted pre-post conditions 
  "\<lbrakk>  funtable fn = (PRE R: POST S: body); 
      P \<subseteq> (invimagepre (tickn 1 o incrcallcount) R); 
      \<Turnstile> R (CALL fn) S \<longrightarrow> \<Turnstile> (apsnd (tickn 1 o incrcallcount) ` R) body S;
      S \<subseteq> Q \<rbrakk> 
 \<Longrightarrow> \<Turnstile> P (CALL fn) Q"
apply (rule HCallRec)
apply simp
apply (rule HPre)
apply auto
apply (rule HPost)
apply (rule HWC)
apply (rule HSP)
apply (erule impE)
apply (rule HSP, rule HWC)
apply assumption
sorry
*)

(*
lemma HCallPreRec:  use the asserted pre-condition with current post-cond 
  "\<lbrakk>  funtable fn = (PRE R: body); 
      P \<subseteq> (invimagepre (tickn 1 o incrcallcount) R); 
      \<Turnstile> R (CALL fn) Q \<Longrightarrow> \<Turnstile> (apsnd (tickn 1 o incrcallcount) ` R) body Q;
      S \<subseteq> Q \<rbrakk> 
 \<Longrightarrow> \<Turnstile> P (CALL fn) Q"
sorry

lemma HCallRec1: 
  "\<lbrakk>  funtable fn = body; 
      P \<subseteq> (invimagepre (tickn 1 o incrcallcount) R); 
      \<Turnstile> R (CALL fn) Q \<Longrightarrow> \<Turnstile> (apsnd (tickn 1 o incrcallcount) ` R) body S;
      S \<subseteq> Q \<rbrakk> 
 \<Longrightarrow> \<Turnstile> P (CALL fn) Q"
sorry

*)


ML {*
 val VCG_let_rules  = thms "VCG_let_rules"
 val VCG_if_rules   = thms "VCG_if_rules"
 val VCG_leaf_rules = thms "VCG_leaf_rules"
 val VCG_call_rules = thms "VCG_call_rules"
 val VCG_assn_rules    = thms "VCG_assn_rules"
 val VCG_assm_rules = thms "VCG_assm_rules"
 val HSP = thm "HSP"

  (* invariant: goal of the form |= ?P e Q to solve completely, instantiating P.
     May leave behind VCs. *)

  fun VCGtac lookuptac i = 
  let fun VCG i st =  
   (FIRST[resolve_tac VCG_leaf_rules i,
          EVERY[resolve_tac VCG_let_rules i,
                VCG (i+1), VCG i],
          EVERY[resolve_tac VCG_if_rules i,
                VCG (i+1), VCG i, rtac subset_refl i],
          EVERY[resolve_tac VCG_assn_rules i, VCG i],		
          eresolve_tac VCG_assm_rules i,
	  EVERY[resolve_tac VCG_call_rules i,
                lookuptac i, (* lookup method/function def *)
		VCG (i+1), rtac subset_refl i]
	  ]) st
  in VCG i end;

  fun vcg_tac tac i thm = SUBGOAL (fn _ =>  (rtac HSP 1) THEN (VCGtac tac 1)) i thm
*}



method_setup vcg = {*
  Method.thms_args (fn thms => 
  Method.METHOD (fn facts => vcg_tac 
		 (asm_simp_tac (HOL_basic_ss addsimps thms)) 1))  *}
  "ToyGrail verification condition generator"


text {* Include some Isabelle dark art to clean up VCs from SimpVC.ML *}

method_setup vcsimp = {*
  Method.no_args (Method.METHOD (fn facts => ALLGOALS set2pred))  *}
  "Verification condition simplifier"


end



