(*
  Method: simpvc  (and variants plainsimpvc, simpvc_only).

  This is a modified version of Nipkow's simplification tactci
  for turning subset inclusion into predicate implications.  It's
  handy for dealing with VC's, reducing them without simplifying
  them into oblivion like clarsimp can do (especially if subterms
  are false).  

  NB: the goal must strictly have the form  A \<subseteq> B for this
  simplification to do anything.
*)

theory SimpVC = Main
files "SimpVC.ML":

text {* Include some Isabelle dark art to clean up VCs from SimpVC.ML *}

method_setup plainsimpvc = {*
  Method.no_args (Method.METHOD (fn facts => set2pred HOL_basic_ss 1))  *}
  "Verification condition simplifier --- only transforms sets to predicates"

(* messy: we delete split_conv below just to avoid duplicate warning message *)
   
method_setup simpvc = {*
  Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => set2pred ((Simplifier.get_local_simpset ctxt)
					delsimps [split_conv]) 1))  *}
  "Verification condition simplifier --- with full simplification"

method_setup simpvc_only = {*
  Method.thms_args (fn thms => 
  Method.METHOD (fn facts => set2pred (HOL_basic_ss addsimps thms) 1))  *}
  "Verification condition simplifier --- with argument simps"

end
