(*  
   File:	ListLength
   Author:	Olha Shkaravska
   Id:		$Id: ListLength.thy,v 1.1 2003/06/11 15:01:58 oshka208 Exp $

   Predicate(s) expressing list length
*)

theory ListLength = PreList + ToyGrailDef:

(*
datatype reflist = Just | Chain ref reflist
consts bas_length :: "reflist \<Rightarrow> nat"
primrec 
"bas_length Just = 0"
"bas_length (Chain r rl) = 1 + (bas_length rl)"
*)

consts
Pstack :: "(rname \<times> rstore \<times> rheap \<times> rfldname \<times> nat) set"
Pheap :: "(ref  \<times> rheap \<times> rfldname \<times> nat) set"

inductive Pheap
intros
Zerolength[intro!]: "(Nullref, rh, tfld, 0) \<in> Pheap"
Poslength[intro!]:
"(rh tfld (theloc r), rh, tfld, n) \<in> Pheap
\<Longrightarrow>
(r, rh, tfld, n+1) \<in> Pheap"

inductive Pstack 
intros
"(rs varname, rh, tfld, n) \<in> Pheap
\<Longrightarrow>
(varname, rs, rh, tfld, n) \<in> Pstack"

end