(*  
   File:	$RCSfile: ExampleSwapVDM.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExampleSwapVDM.thy,v 1.2 2003/06/04 13:02:26 a1hloidl Exp $

   Non-recursive function (VDM style)
*)

theory ExampleSwapVDM = ToyPrelude + ToyVDMderived:

section {* swap two variables *}
(*
 PRE { ((a,X,Y),s).   s<x>=X \<and> s<y>=Y}:
 POST {((a,X,Y),s,v). s<x> = min X Y \<and> s<y> = max X Y \<and> 
			         v = IVal (if (X<=Y) then 0 else 1) }:
*)
locale swap_example =
  fixes    tmp :: iname
    and	   x :: iname
    and	   y :: iname
    and	   q :: iname
    and	   swap      :: funame

  assumes swapfun[simp]:
"funtable swap =  
(POST  {(s,s',v). s'<x> = min s<x> s<y>}:
 (LET 
  q  = x :> y
 IN
  IF q 
    THEN LET
     tmp = IVar x;
     x = IVar y;
     y = IVar tmp
  IN
     1\<^sup>z
  END 
     ELSE 0\<^sup>z
 END) :: state expr)"

 and  vardistinct: "distinct [tmp,x,y,q] \<and> distinct [q,y,x,tmp]"

(* feed in several preconditions to simplify proof *)
lemma (in swap_example) 
   "\<Turnstile>\<^sub>v CALL swap :
      {(s,s',v). 0 < s<x> \<and> 0 < s<y> \<and> s<x> < s<y> \<longrightarrow> s'<x> = s<x>}"
apply (insert vardistinct)
apply (rule VW)
apply (rule vdmprocs)
apply simp
apply (rule VPost)
apply (rule VW)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply clarsimp
apply (case_tac "a<y> < a<x>")
apply (simp add: min_def)
apply (simp add: min_def)
apply (simp add: min_def)
apply (rule subsetI)
apply clarsimp
done

(* proof specification of swap *)
lemma (in swap_example) 
   "\<Turnstile>\<^sub>v CALL swap :
      {(s,s',v). s'<x> = min s<x> s<y>}"
apply (insert vardistinct)
apply (rule VW)
apply (rule vdmprocs)
apply simp
apply (rule VPost)
apply (rule VW)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply clarsimp
apply (case_tac "a<y> < a<x>")
apply (simp add: min_def)
apply (simp add: min_def)
apply (simp add: min_def)
apply (rule subsetI)
apply clarsimp
done
(* exactly proof script as above; lucky us! *)


end

