(*  
   File:	ExampleSwap
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExampleSwapFields.thy,v 1.3 2003/05/27 19:21:56 da Exp $

   Non-recursive function
*)

theory ExampleSwapFields = ToyPrelude + ToyHLderived + SimpleVCG:

locale swap_example =
  fixes    m :: iname
    and	   n :: iname
    and	   q :: iname
    and	   z1 :: iname
    and	   z2 :: iname
    and	   lesser    :: ifldname
    and	   greater   :: ifldname
    and	   swap      :: funame
    and    a :: locn

  assumes swapfun: 
"funtable swap =  
 PRE { ((a,M,N),s).   s\<lfloor>self\<rfloor> = Ref a \<and> s<a\<bullet>lesser> = M \<and> s<a\<bullet>greater> = N }:
 POST {((a,M,N),s,v). s\<lfloor>self\<rfloor> = Ref a \<and> 
			        s<a\<bullet>lesser>  = min M N \<and>
			        s<a\<bullet>greater> = max M N \<and> 
			         v = IVal (if M<=N then 0 else 1) }:
 LET 
  m  = GetFi self lesser ;
  n  = GetFi self greater ;
  q  = n :< m
 IN
  IF q 
    THEN LET
     z1 = PutFi self lesser n ; 
     z2 = PutFi self greater m 
  IN
     1\<^sup>z
  END 
     ELSE 0\<^sup>z
 END"

     and  vardistinct: "distinct [m,n,q,z1,z2]"
     and  flddistinct: "distinct [lesser,greater]"


lemma (in swap_example) 
   "\<Turnstile> {((a,M,N),s). s\<lfloor>self\<rfloor> = Ref a \<and> s<a\<bullet>lesser> = M \<and> s<a\<bullet>greater> = N}
	CALL swap
      {((a,M,N),s,v). s<a\<bullet>lesser> = min M N}"
apply (insert vardistinct flddistinct)
apply (rule HCallPrePost)
apply (simp only: swapfun)
apply auto
apply vcg
apply clarsimp
apply (simp add: max_def min_def)
done

end
