(*  
   File:	ExampleSwap
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExampleSwap.thy,v 1.3 2003/05/28 09:14:35 da Exp $

   Non-recursive function
*)

theory ExampleSwap = ToyPrelude + ToyHLderived + SimpleVCG:

locale swap_example =
  fixes    tmp :: iname
    and	   x :: iname
    and	   y :: iname
    and	   q :: iname
    and	   swap      :: funame

  assumes swapfun[simp]:
"funtable swap =  
 PRE { ((a,X,Y),s).   s<x>=X \<and> s<y>=Y}:
 POST {((a,X,Y),s,v). s<x> = min X Y \<and> s<y> = max X Y \<and> 
			         v = IVal (if (X<=Y) then 0 else 1) }:
 LET 
  q  = x :> y
 IN
  IF q 
    THEN LET
     tmp = IVar x;
     x = IVar y;
     y = IVar tmp
  IN
     1\<^sup>z
  END 
     ELSE 0\<^sup>z
 END"

 and  vardistinct: "distinct [tmp,x,y,q] \<and> distinct [q,y,x,tmp]"

lemma (in swap_example) 
   "\<Turnstile> { ((a,X,Y),s).   s<x>=X \<and> s<y>=Y }
	CALL swap
      {((a,X,Y),s,v). s<x> = min X Y}"
apply (insert vardistinct)
apply (vcg swapfun)
(* Leaves 3 subgoals: main VC, and pre-post matchings *)
apply clarsimp  (* check it out *)
apply (simp add: min_def max_def, auto)
done

end

