(*  
   File:        $RCSfile: ExamplePingVDM.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExamplePingVDM.thy,v 1.1 2003/06/11 21:37:12 a1hloidl Exp $

   Example: ping (simplified for direct recursion; using Invoke) VDM style
*)

theory ExamplePingVDM = ToyPrelude + ToyVDMderived:

section {* Testing the VCGen *}

subsection {* ping example: direct recursion *}

(* --------------------------------------------------------------------------- *)
(* Code                                                                        *)
(* --------------------------------------------------------------------------- *)

(*
  class PingClass = field Pong pong  
               field int count
               method ping () { count := count -1; 
                                if count > 0  PingClass.ping() else return ()
*)

(*  \<and> z<h>=s<h> \<and> z\<lfloor>param\<rfloor> = s\<lfloor>param\<rfloor> *)
(*  \<and> z<h> = s<h> \<and> z\<lfloor>param\<rfloor> = s\<lfloor>param\<rfloor> *)

locale pingI_example =
 fixes  m      	  :: iname
 fixes  n      	  :: iname
 fixes  q      	  :: iname
 fixes  h      	  :: iname
 fixes  x      	  :: iname
 fixes  z      	  :: iname
 fixes  count  	  :: ifldname
 fixes  pong   	  :: ifldname
 fixes  ping   	  :: mname
 fixes  PingClass :: cname
 fixes  l1        :: locn
 assumes ping_methtable[simp]: "methtable PingClass ping =
           (SATISFIES {(s::state,s'::state,v). 0 < s<s\<lceil>param\<rceil>\<bullet>count> \<longrightarrow>
                        v = (IVal 0) \<and> s'<s'\<lceil>param\<rceil>\<bullet>count> = 0 \<and> s\<lceil>param\<rceil> = s'\<lceil>param\<rceil>} : 
            (LET 
                m  = param\<bullet>count ;
                n  = m :-- ;
                z  = (param\<bullet>count := n) ; 
                q  = n :0?
             IN
                IF q 
                  THEN n\<^sup>I
                  ELSE PingClass\<bullet>ping(param)
             END) :: state expr)"
 assumes  vardistinct: "distinct  [m,n,h,q,x,z] \<and> distinct [z,x,q,h,n,m]"

lemma (in pingI_example) bonzo_1915:
 "\<And> s s' mn . \<lbrakk> s = newframe s' mn Nullref (s'\<lfloor>param\<rfloor>) \<rbrakk> \<Longrightarrow> s'\<lfloor>param\<rfloor>=s\<lfloor>param\<rfloor>"
by clarsimp

lemma (in pingI_example) bonzo_1916:
 "\<And> s s' x mn . \<lbrakk> s = newframe s' mn Nullref x \<rbrakk> \<Longrightarrow> s\<lfloor>param\<rfloor>=x"
by clarsimp

(* note the "param never changes" subclause in the specification; needed for this proof *)
lemma (in pingI_example)
   "\<Turnstile>\<^sub>v (PingClass\<bullet>ping(param) :: state expr) :
       {(s::state,s'::state,v). 0 < s<s\<lceil>param\<rceil>\<bullet>count> \<longrightarrow>
          v = (IVal 0) \<and> s'<s'\<lceil>param\<rceil>\<bullet>count> = 0 \<and> s\<lceil>param\<rceil> = s'\<lceil>param\<rceil>}"
apply (insert vardistinct)
apply clarsimp
(* apply (rule VW) *)
apply (rule "VInvokeStaticRecSat2")
apply (simp add: ping_methtable)
apply rule
defer 1
defer 1
apply auto
apply (rule VW)
apply (rule vdmbasicsI)+
apply assumption
(* apply (rule VW) *)
apply (rule vdmbasicsI)+
apply clarsimp
apply rule
apply (case_tac "a<a\<lceil>param\<rceil>\<bullet>count> - 1 = 0 ")
 apply simp
 apply simp
apply (case_tac "a<a\<lceil>param\<rceil>\<bullet>count> - 1 = 0 ")
 apply simp
 apply simp
done


(* old version based on HL; probably doesn't work any more *)
locale ping_example =
 fixes  m      	  :: iname
 fixes  n      	  :: iname
 fixes  q      	  :: iname
 fixes  h      	  :: iname
 fixes  x      	  :: iname
 fixes  y      	  :: iname
 fixes  count  	  :: ifldname
 fixes  pong   	  :: ifldname
 fixes  ping   	  :: mname
 fixes  PingClass :: cname
 fixes  l1        :: locn
 assumes ping_methtable[simp]: "methtable PingClass ping =
           ((PRE  {(z::state,s::state). (z<h>) = s<(theloc (s\<lfloor>param\<rfloor>))\<bullet>count> \<and> 0 < (z<h>)} :
            (POST {(z::state,s::state,v). v = (IVal 0) \<and> s<(theloc (s\<lfloor>param\<rfloor>))\<bullet>count> = 0 \<and> z<h> = s<h> \<and> z\<lfloor>param\<rfloor> = s\<lfloor>param\<rfloor>} : 
            (LET 
                m  = param\<bullet>count ;
                n  = m :-- ;
                z  = (param\<bullet>count := n) ; 
                q  = n :0?
             IN
                IF q 
                  THEN n\<^sup>I
                  ELSE PingClass\<bullet>ping(param)
             END))) :: state expr)"
 assumes  vardistinct:    "distinct [m,n,q,x,z] \<and> distinct [z,x,q,n,m]" 
 assumes  constdistinct': "distinct [param,self]"

lemma (in ping_example)
   "\<Turnstile> {(z::state,s::state). 0 < s<(theloc (s\<lfloor>param\<rfloor>))\<bullet>count> \<and> s<h>=s<(theloc (s\<lfloor>param\<rfloor>))\<bullet>count> \<and> s<h>=s<(theloc (s\<lfloor>param\<rfloor>))\<bullet>count> \<and> z=s}
       (PingClass\<bullet>ping(param) :: state expr)
       {(z::state,s::state,v). v = (IVal 0) \<and> s<(theloc (s\<lfloor>param\<rfloor>))\<bullet>count> = 0 \<and> z<h> = s<h> \<and> 
                               z\<lfloor>param\<rfloor> = s\<lfloor>param\<rfloor>}"
apply (insert vardistinct)
apply (insert constdistinct') 
apply clarsimp
apply (rule "HInvokeStaticRec")
apply (rule allI)
apply (rule impI)
apply (simp add: ping_methtable)
apply (tactic {* all_tac *})
apply (rule "HSP")
apply (rule "HPre")
apply (rule "HSP")
apply (rule "HWC")
apply (rule "HPost")
apply (rule "HLetI")
apply (rule "HLetI")
apply (rule "HLetI")
apply (rule "HLetI")
apply (rule "HIf")
apply (rule hoarebasics)
(* rec call *)
apply assumption
apply (rule subset_refl)
apply (rule hoarebasics)
apply (rule hoarebasics)
apply (rule hoarebasics)
apply (rule hoarebasics)
apply (rule subset_refl)
apply clarsimp
defer 1
apply clarsimp
defer 1
apply (rule subset_refl)
apply clarsimp
defer 1
apply rule
apply rule
apply rule
defer 1
apply clarsimp
apply auto
done


subsection {* ping2 example: mutual recursion *}

(* --------------------------------------------------------------------------- *)
(* Code                                                                        *)
(* --------------------------------------------------------------------------- *)

(*
  class PingClass = 
               field int count
               field int kount
               method ping () { count := count - 1; 
                                if count > 0  PingClass.pong() else return () }
               method pong () { kount := kount + 1; 
                                PingClass.ping() }
*)

locale ping2_example =
 fixes  m      	  :: iname
 fixes  n      	  :: iname
 fixes  q      	  :: iname
 fixes  g      	  :: iname
 fixes  h      	  :: iname
 fixes  x      	  :: iname
 fixes  z      	  :: iname
 fixes  count  	  :: ifldname
 fixes  kount  	  :: ifldname
 fixes  pong   	  :: mname
 fixes  ping   	  :: mname
 fixes  PingClass :: cname
 fixes  l1        :: locn
 assumes ping_methtable[simp]: "methtable PingClass ping =
           ((PRE  {(z::state,s::state). (z<g>) = s<(theloc (s\<lfloor>self\<rfloor>))\<bullet>count> \<and> 0 < (z<g>) \<and>
                                        (z<h>) = s<(theloc (s\<lfloor>self\<rfloor>))\<bullet>kount> \<and> 0 < (z<h>)} :
            (POST {(z::state,s::state,v). v = (IVal 0) \<and> s<(theloc (s\<lfloor>self\<rfloor>))\<bullet>count> = 0 \<and> s<(theloc (s\<lfloor>self\<rfloor>))\<bullet>kount> = z<g>} : 
            (LET 
                m  = self\<bullet>count ;
                n  = m :-- ;
                z  = (self\<bullet>count := n) ; 
                q  = n :0?
             IN
                IF q 
                  THEN n\<^sup>I
                  ELSE PingClass\<bullet>ping(self)
             END))) :: state expr)"
 assumes pong_methtable[simp]: "methtable PingClass pong =
           ((PRE  {(z::state,s::state). (z<g>) = s<(theloc (s\<lfloor>self\<rfloor>))\<bullet>count> \<and> 0 < (z<g>) \<and>
                                        (z<h>) = s<(theloc (s\<lfloor>self\<rfloor>))\<bullet>kount> \<and> 0 < (z<h>)} :
            (POST {(z::state,s::state,v). (z<g>) = s<(theloc (s\<lfloor>self\<rfloor>))\<bullet>count> \<and>
                                          (z<h>)+1 = s<(theloc (s\<lfloor>self\<rfloor>))\<bullet>kount> } : 
            (LET 
                m  = self\<bullet>kount ;
                m  = m :++ ;
                z = (self\<bullet>kount := m) 
             IN
                PingClass\<bullet>ping(self)
             END))) :: state expr)"
 assumes  vardistinct: "distinct  [m,n,q,x,z] \<and> distinct [z,x,q,n,m]"


(* --------------------------------------------------------------------------- *)
(* OLD STUFF *)

constdefs factorPing :: "nat"
"factorPing \<equiv> 5"

constdefs constPing :: "nat"
"constPing \<equiv> 3"

(* Constructing the hoare triple - value N is a "global" input" 
constdefs TRIPLE_PING ::"nat \<Rightarrow> nat \<Rightarrow> (val list) ltriple"
"TRIPLE_PING N T \<equiv> (ping_preassn, mainBody, ping_postassn)"
*)


lemma stupid1: "\<forall> s. \<forall> x. \<forall> rtv . \<exists> s2. (varupdate s x rtv = s1) --> \<langle>s1, Var x\<rangle> \<longrightarrow>e \<langle>rtv, s2\<rangle>"
apply (rule allI)+
apply (rule exI)+
apply (rule impI)
apply (unfold varupdate_def)
apply (auto)
apply (rule evalVar)
apply (unfold get_var_def)
apply (simp)
done
(* OK *)

(*Semantic validity of the triple -- independent from any input! Proof is by
  induction on the external parameter N"*)
(* this fails because of too small constPing; skipped for now
lemma Triple_Ping_valid: "\<forall> i. CONTEXT \<longrightarrow> 
   hoare_lvalid  
       (\<lambda> z s. time T s \<and> (heap s l1) = Some o2 \<and> fst o2 = PingClass \<and> snd o2 count = Some (val.Int (int N)) \<and> snd o2 pong = Some (val.Void) \<and> store s = my_store)
       mainBody 
       (\<lambda> z v s. btime (T + constPing + factorPing * N) s)"
apply(unfold  mainBody_def hoare_lvalid_def)
(* induction on the "input" to the whole thing: the value in the count field *)
apply (induct_tac N)
apply (auto)
apply (erule evalexpr_evallet.elims)
apply (simp add: stupid1)
apply (auto)
apply (erule evalexpr_evallet.elims)
apply (unfold btime_def constPing_def)
apply (simp add: stupid1)
apply (auto)
apply (erule evalexpr_evallet.elims)
apply (simp add: stupid1 clock_tickn)
apply (unfold varupdate_def)
apply (auto)
apply (unfold newframe_def get_var_def varupdate_def)
apply (simp)
apply (erule evalexpr_evallet.elims)
apply (simp add: stupid1 clock_tickn store_tick_invar heap_tick_invar maxstack_tick_invar clock1)
apply (unfold time_def)
apply (auto)
(* False *)
(* fails because the cost of the base case isn't high enough *)
oops
*)

(* --------------------------------------------------------------------------- *)

constdefs factorPing1 :: "nat"
"factorPing1 \<equiv> 5"

constdefs constPing1 :: "nat"
"constPing1 \<equiv> 99"

consts 
  T :: "nat"
  petaQ :: "nat"
  o2 :: "obj"

constdefs my_store :: "store"
"my_store \<equiv> empty (stat1 \<mapsto> (val.Ref l1)) (dummyarg \<mapsto> val.Void) (self \<mapsto> val.Ref l1)"

(*
constdefs my_store :: "store"
"my_store \<equiv> empty (stat1 \<mapsto> (val.Ref l1)) (dummyarg \<mapsto> val.Void) (self \<mapsto> val.Ref l1) (param \<mapsto> val.Void) (m \<mapsto> val.Int (int (Suc petaQ))) (n \<mapsto> val.Int (int petaQ)) (z1 \<mapsto> val.Void) (zero \<mapsto> val.Int 0)"
*)

constdefs prea1 :: "nat \<Rightarrow> 'a preassn"
"prea1 \<equiv> \<lambda> petaQ z s. 
          time T s \<and> 0 < petaQ \<and> 
          heap s l1 = Some (PingClass, empty (count \<mapsto> val.Int (int petaQ)) (pong \<mapsto> val.Void)) \<and> 
          classtable PingClass = \<lparr> flds = [count, pong], meths = bonzo \<rparr> \<and> 
          store s = my_store"

constdefs posta1 :: "nat \<Rightarrow> 'a postassn"
"posta1 \<equiv> \<lambda> petaQ z v s. btime (T + constPing1 + factorPing1 * petaQ) s"

lemma Triple_Ping_valid: "\<forall> N::nat. CONTEXT \<and> PETAQ \<and> PETAQvname \<and> PETAQfldname \<longrightarrow>
   hoare_valid  
       (prea1 N)
       mainBody 
       (posta1 N)"
apply (unfold  prea1_def posta1_def mainBody_def hoare_valid_def)
apply (rule allI)+
apply (unfold my_store_def)
(* induction on the "input" to the whole thing: the value in the count field *)
apply (induct_tac N)
(* ++ base case *)
apply (auto)
(* LET x1 = ... *)
apply (erule evalexpr.elims)
apply (auto)
(*   RETURN x1 *)
apply (unfold varupdate_def)
apply (erule evalexpr.elims)
apply (auto)
apply (unfold newframe_def)
apply (simp_all add: state_functions)
apply (erule evalexpr.elims)
apply (auto)
(* .. simplify the time expression now *) 
apply (simp add: btime_def clock_tickn)
apply (simp only: varupdate_def get_var_def)
(* .. grab mbody out of state *)
apply (simp add: bonzo_def pingMbody_def pingBody_def)
apply (unfold PETAQvname_def)
apply (simp_all add: state_functions)
apply (fold PETAQvname_def)
(* LET m = ... *)
apply (erule evalexpr.elims)
apply (auto)
apply (simp only: varupdate_def get_var_def)
(* LET n = ... *)
apply (erule evalexpr.elims)
apply (auto)
apply (simp only: varupdate_def get_var_def)
apply (erule evalexpr.elims)
apply (auto)
apply (unfold PETAQvname_def, simp_all add: varupdate_def get_var_def clock_tickn, fold PETAQvname_def)
(* LET z1 = ... *)
apply (erule evalexpr.elims)
apply (auto)
apply (unfold PETAQfldname_def,simp_all add: varupdate_def get_var_def tickn_tickn clock_tickn store_store_simp,fold PETAQfldname_def)
apply (erule evalexpr.elims)
apply (auto)
apply (simp_all add: varupdate_def get_var_def tickn_tickn clock_tickn store_store_simp)+
(* LET zero = ... *)
apply (erule evalexpr.elims)
apply (auto)
apply (unfold PETAQvname_def, simp add: state_functions, fold PETAQvname_def)
apply (erule evalexpr.elims)
apply (auto)
apply (simp_all add: varupdate_def get_var_def tickn_tickn clock_tickn store_store_simp)+
(* LET q1 = ... *)
apply (erule evalexpr.elims)
apply (auto)
apply (erule evalexpr.elims)
apply (auto)
apply (simp add: varupdate_def get_var_def)
(* IF q1 ... *)
apply (erule evalexpr.elims)
apply (auto)
apply (simp add: varupdate_def get_var_def)
apply (simp only: store_tick_invar)+
apply (unfold PETAQvname_def, simp add: stupid1 clock_tickn, fold PETAQvname_def)
(* apply (simp_all add:  varupdate_def get_var_def stupid1 clock_tickn clock_tickn tickn_tickn store_store_simp)+ *)
apply (erule evalexpr.elims)
apply (auto)
(*    THEN mainBody ;  recursive call *)
apply (fold mainBody_def)
apply (drule_tac x="tickn (Suc 0)
                    (tickn 4
                      (tickn (Suc (Suc 0))
                        (s(| invokecount := Suc (invokecount s),
                             framestack :=
                               (ping, dummyvar,
                                LET m = self^:count; n = Primop (%x y. x - 1) m m;
                                    z1 = self^.count := n; zero = expr.Int 0;
                                    q1 = Primop (%x y. if y < x then 1 else 0) n zero
                                IN IF q1 THEN mainBody  ELSE Var z1 END,
                                %u. if u = self then Some (Ref l1)
                                    else if u = dummyarg then Some val.Void
                                         else if u = stat1 then Some (Ref l1)
   else None) #
                               framestack s,
                             store := empty(self|->Ref l1)(param|->val.Void),
                             maxstack :=
                               max (Suc (length (framestack s))) (maxstack s),
                             clock := Suc (Suc (Suc (clock s))),
                             store := empty(self|->Ref l1)(param|->val.Void)(m
                               |->val.Int (1 + int na)),
                             clock := 7 + clock s,
                             store := empty(self|->Ref l1)(param|->val.Void)(m
                               |->val.Int (1 + int na))(n|->val.Int (int na)),
                             heap := heap s(l1
                               |->(PingClass,
                                   (%u. if u = pong then Some val.Void
                                        else if u = count
  then Some (val.Int (1 + int na)) else None)
                                   (count|->val.Int (int na)))),
                             clock := 11 + clock s,
                             store := empty(self|->Ref l1)(param|->val.Void)(m
                               |->val.Int (1 + int na))(n|->val.Int (int na))(z1
                               |->val.Void) |))
                       (| store := empty(self|->Ref l1)(param|->val.Void)(m
                            |->val.Int (1 + int na))(n|->val.Int (int na))(z1
                            |->val.Void)(zero|->val.Int 0) |))
                     (| store := empty(self|->Ref l1)(param|->val.Void)(m
                          |->val.Int (1 + int na))(n|->val.Int (int na))(z1
                          |->val.Void)(zero|->val.Int 0)(q1
                          |->val.Int
                              (if 0 < na then 1
                               else 0)) |))" in spec)
apply (drule_tac x="s1" in spec)
apply (auto)
apply (unfold time_def)
apply (simp_all add: state_functions)
defer 1 (* Goal: False !?  check it!!!! *)
defer 1 (* Goal: 0 < na !? why? *)
defer 1
defer 1
apply (unfold constPing1_def factorPing1_def)
apply (simp_all add: state_functions)
(* -- recursion has been resolved at this point, but
       . time expression can't be proven
       . there are unsatisfiable subgoals left
*)
defer 1
defer 1
(* Var z1 -- reaching the base case *)
apply (erule evalexpr.elims)
apply (auto)
(* -- that subgoal is history *)
oops

(* --------------------------------------------------------------------------- *)
(* note that from the state in the failed attempt above you can read off the
   factorPing we need: 18 *)

constdefs factorPing2 :: "nat"
"factorPing2 \<equiv> 18"

constdefs constPing2 :: "nat"
"constPing2 \<equiv> 99"

(* we have that already
consts 
  T :: "nat"
  petaQ :: "nat"
  o2 :: "obj"
*)
(*
constdefs prea2 :: "nat \<Rightarrow> 'a preassn"
"prea2 \<equiv> \<lambda> petaQ z s. 
          time T s \<and> 0 < petaQ \<and> 
          heap s l1 = Some (PingClass, empty (count \<mapsto> val.Int (int petaQ)) (pong \<mapsto> val.Void)) \<and> 
          classtable PingClass = \<lparr> flds = [count, pong], meths = bonzo \<rparr> \<and> 
          store s = my_store"

constdefs posta2 :: "nat \<Rightarrow> 'a postassn"
"posta2 \<equiv> \<lambda> petaQ z v s. btime (T + constPing2 + factorPing2 * petaQ) s"
*)
