theory Bonzo = ToyHLderived:

locale bonzo_example =
  fixes    m         :: iname
    and	   n         :: iname
    and	   r         :: rname
    and	   mfld         :: ifldname
    and	   nfld         :: ifldname
    and	   rfld         :: rfldname
    and	   BonzoClass   :: cname
    and    bonzo :: funame
  assumes  bonzofn[simp]: "funtable bonzo = ((NEW <BonzoClass> ([(mfld,m),(nfld,n)],[(rfld,r)])) :: (int \<times> int) expr)"
  assumes  vardistinct: "distinct [m,n]"

(* m and n remain unchanged *)
lemma (in bonzo_example)
   "\<Turnstile> {((M,N),s). s<m> = M \<and> s<n> = N}
	(CALL bonzo)
      {((M,N),s,v). s<m> = M \<and> s<n> = N}"
apply (insert vardistinct)
apply (rule hoareprocs)
apply simp
apply (rule HSP)
apply (rule HNew)
apply clarsimp
done

end
