(*  Examples from List.cmlt -> Grail*)

theory CmltList = ToyHLderived + ExampleListClass + SimpVC:

section {* Clock count and heap size *}

locale Dalength2 = 
  fixes    tag     :: iname
    and	   h       :: iname
    and    i       :: iname
    and	   b       :: iname
    and    l       :: rname
    and	   f       :: funame
    and	   fBody   :: "(int * int * int * int) expr"
 defines  "fBody == PRE {((N,C,H,I),s). s<i> = I  
				   \<and>  (\<exists> L . (L,s\<lfloor>l\<rfloor>,s) \<in> models \<and> int (length L) = N   
                                                    \<and> hpsize s = H  \<and> clock s = C)}:
                    POST {((N,C,H,I),s,v) . v = IVal (N + I) 
					    \<and> hpsize s = H  \<and> 
					  clock s = C + 19 * N + 9} :
                    LET tag = GetFi l TAG;
                        b = Primop (% x y. if x = 0 then 1 else 0) tag tag
                    IN IF b THEN IVar i (* 9 ticks to here *)
			    ELSE LET  h = GetFi l HD;
                                      i = Primop (% x y. x + 1) i i;
                                  rf  l = (GetFr l TL)
			       IN (Call f) (* 19 ticks to here *) END
                    END"
  assumes  fbdy[simp]:  "funtable f = fBody"
      and  vardistinct:       "distinct [tag,h,i,b] \<and> distinct [b,i,h,tag]"

declare (in Dalength2) fBody_def [simp]

lemma (in Dalength2) 
   "\<Turnstile> {((N,C,H,I),s). s<i> = I  
				   \<and>  (\<exists> L . (L,s\<lfloor>l\<rfloor>,s) \<in> models \<and> int (length L) = N   
                                                    \<and> hpsize s = H  \<and> clock s = C)}
       (CALL f) 
     {((N,C,H,I),s,v) . v = IVal (N + I) 
					    \<and> hpsize s = H  \<and> 
					  clock s = C + 19 * N + 10}"
apply (rule HCallRecPrePostInvAdapt)
apply simp
apply (rule, rule, rule, rule refl, rule refl)
apply (rule HSP)
apply (rule hoarebasics)+
apply (erule assume_adapt)
apply (rule subset_refl)
(*now only side conditions left*)
apply (insert vardistinct)
apply clarsimp
apply rule
apply rule
apply (erule models.elims, simp, clarsimp)
apply (erule models.elims, clarsimp)
apply clarsimp
apply (rule_tac x="int (length t)" in exI)
apply (rule_tac x="19 + clock s" in exI, simp)
apply (rule_tac x="hpsize s" in exI, simp)
apply (rule_tac x="t" in exI, simp)
apply auto
apply (rule_tac x="int (length L)" in exI)
apply (rule_tac x="1 + clock ba" in exI, simp)
apply (rule_tac x="hpsize ba" in exI, simp)
apply (rule_tac x="L" in exI, simp)
done

section {* Functional correctness *}

locale Dalength1 = 
  fixes    tag     :: iname
    and	   h       :: iname
    and    i       :: iname
    and	   b       :: iname
    and    l       :: rname
    and	   f       :: funame
    and	   fBody   :: "int expr"
 defines  "fBody == PRE {(N,s). (\<exists> L . (L,s\<lfloor>l\<rfloor>,s) \<in> models \<and> int (length L) + (s<i>) = N) } :
                    POST {(N,s,v) . v = IVal N} :
                    (*MEASURE inv_image less_than (\<lambda> s. THE M. (\<exists>  L . (L,s\<lfloor>l\<rfloor>,s) \<in> models \<and> length L = M)) :*)
                    LET tag = GetFi l TAG;
                        b = Primop (% x y. if x = 0 then 1 else 0) tag tag
                    IN IF b THEN IVar i ELSE LET  h = GetFi l HD;
                                                  i = Primop (% x y. x + 1) i i;
					       rf l = GetFr l TL
					     IN
						  Call f 
                                             END
                    END"
  assumes  fbdy[simp]:  "funtable f = fBody"
      and  vardistinct:       "distinct [tag,h,i,b] \<and> distinct [b,i,h,tag]"

declare (in Dalength1) fBody_def [simp]


lemma (in Dalength1) 
   "\<Turnstile> {(N,s). (\<exists> L . (L,s\<lfloor>l\<rfloor>,s) \<in> models \<and> int (length L) + (s<i>) = N) }
	        (CALL f) 
                {(N,s,v) . v = IVal N}"
apply (insert vardistinct, clarsimp)
apply (rule HCallRec)
apply simp
apply(rule HPre)
apply(rule HPost)
apply (rule HSP)
apply (rule HLetI)
apply (rule HLetI)
apply (rule HIf)
apply (rule HVar)
apply (rule HLetI)
apply (rule HLetI)
apply (rule HLetrI)
apply assumption
apply (rule HGetFr)
apply (rule hoarebasics)
apply (rule HGetFi)
apply (rule subset_refl)
apply (rule hoarebasics)
apply (rule HGetFi)
(*now only side conditions left*)
apply simp_all
apply clarsimp
apply rule
apply rule
apply (erule models.elims, clarsimp, clarsimp)
apply rule
apply (erule models.elims, clarsimp, clarsimp)
apply (rule_tac x=t in exI, simp)
apply clarsimp
apply (rule_tac x=L in exI, simp)
done



end
