(*  Examples from List.cmlt -> Grail*)

theory ExampleListReverseInplace = ToyHLderived + ExampleListClass + SimpVC:
(* List reversal:
Camelot:
let rev' l acc = 
  match l with Nil@d => acc 
             | Cons (h, t)@d => rev' t (Cons (h, acc)@d )

Grail:   
class ListRevInPlace {
   method public static ListRevInPlace$dia_0 rev' (ListRevInPlace$dia_0 l, ListRevInPlace$dia_0 acc) =
   let

      fun f:rev'(ListRevInPlace$dia_0 l, ListRevInPlace$dia_0 d, ListRevInPlace$dia_0 ?t0, ListRevInPlace$dia_0 d#0, int h, ListRevInPlace$dia_0 t, ListRevInPlace$dia_0 acc, ListRevInPlace$dia_0 l) =
      let
         val tag = getfield l <int ListRevInPlace$dia_0.$>
      in
         if tag = 0
         then f:0(l, d, ?t0, d#0, h, t, acc, l)
         else f:1(l, d, ?t0, d#0, h, t, acc, l)
      end

      fun f:1(ListRevInPlace$dia_0 l, ListRevInPlace$dia_0 d, ListRevInPlace$dia_0 ?t0, ListRevInPlace$dia_0 d#0, int h, ListRevInPlace$dia_0 t, ListRevInPlace$dia_0 acc, ListRevInPlace$dia_0 l) =
      let
         val h = getfield l <int ListRevInPlace$dia_0.f0>
         val t = getfield l <ListRevInPlace$dia_0 ListRevInPlace$dia_0.f1>
         val d#0 = l
         val ?t0 = invokestatic <ListRevInPlace$dia_0 ListRevInPlace$dia_0.fill (ListRevInPlace$dia_0, int, int, ListRevInPlace$dia_0)> (d#0, 1, h, acc)
      in
         invokestatic <ListRevInPlace$dia_0 ListRevInPlace.rev' (ListRevInPlace$dia_0, ListRevInPlace$dia_0)> (t, ?t0)
      end

      fun f:0(ListRevInPlace$dia_0 l, ListRevInPlace$dia_0 d, ListRevInPlace$dia_0 ?t0, ListRevInPlace$dia_0 d#0, int h, ListRevInPlace$dia_0 t, ListRevInPlace$dia_0 acc, ListRevInPlace$dia_0 l) =
      let
         val d = l
      in
         acc
      end
   in
      f:rev'(l, d, ?t0, d#0, h, t, acc, l)
   end
}

ToyGrail:
class ListRevInPlace {
   method public static List rev' (List l, List acc) =
   let fun f(List l, List acc) =
        let  tag = getfield l TAG
        in if tag = 0
           then acc
           else let  h = getfield l HD
                     t = getfield l TL
                     one = 1
                     () = putfield l TAG one
                     () = putfield l HD h
                     () = putfield l TL acc
                     acc = l
                     l = t
                in f(l,acc)
                end
   in
      f(l, acc)
   end
}
*)

locale RevInplace = 
  fixes    tag     :: iname    and	   h       :: iname    and	   b       :: iname   and one :: iname
    and    l       :: rname    and         acc     :: rname    and         t       :: rname  
    and	   f       :: funame   and	   fBody   :: "int expr"
 defines  "fBody == PRE {(H,s). HSize s = H} :
                    POST {(H,s,v) . HSize s = H} :
                    LET tag = GetFi l TAG;
                        b = Primop (% x y. if x < 1 then 1 else 0) tag tag
                    IN IF b THEN RVar acc 
                            ELSE LET  h   = GetFi l HD;
                                      rf t   = GetFr l TL;
                                      one = expr.Int 1;
                                      one = PutFi l TAG one; 
                                      h   = PutFi l HD h;
                                      rf acc = PutFr l TL acc;
                                      rf acc = RVar l;
                                      rf l   = RVar t 
                                 IN CALL f END
                    END"

  assumes  fbdy[simp]:  "funtable f = fBody"
      and  vardistinct:     "distinct [tag,h,b,one] \<and> distinct [one,b,h,tag] \<and> distinct[l,acc,t] \<and> distinct [t,acc,l]"

declare (in RevInplace) fBody_def [simp]

lemma (in RevInplace)
"\<Turnstile> {(H,s). HSize s = H} (CALL f) {(H,s,v) . HSize s = H}"
apply (insert vardistinct, clarsimp)
apply (rule HCallRec)
apply simp
apply(rule HPre)
apply(rule HPost)
apply (rule HSP)
apply (rule hoarebasics)+
apply assumption
apply (rule subset_refl)
by (clarsimp, simp, fastsimp)

locale RevInplaceClock = 
  fixes    tag     :: iname    and	   h       :: iname    and	   b       :: iname   and one :: iname
    and    l       :: rname    and         acc     :: rname    and         t       :: rname  
    and	   f       :: funame   and	   fBody   :: "(nat \<times> nat \<times> int \<times> (ref set) \<times> (ref set)) expr"
 defines  "fBody == PRE {((N,ACC,C,X,Y),s). clock s = C \<and> (N,s\<lfloor>l\<rfloor>,X,getheap s) \<in> LLength \<and> (ACC,s\<lfloor>acc\<rfloor>,Y, getheap s) \<in> LLength
                                            \<and> X Int Y = {}} :
                    POST {((N,ACC,C,X,Y),s,v) . clock s = C + 33 * (int N) + 9} :
                    LET tag = GetFi l TAG;
                        b = Primop (% x y. if x < 1 then 1 else 0) tag tag
                    IN IF b THEN RVar acc 
                            ELSE LET  h   = GetFi l HD;
                                      rf t   = GetFr l TL;
                                      one = expr.Int 1;
                                      one = PutFi l TAG one; 
                                      h   = PutFi l HD h;
                                      rf acc = PutFr l TL acc;
                                      rf acc = RVar l;
                                      rf l   = RVar t 
                                 IN CALL f END
                    END"

  assumes  fbdy[simp]:  "funtable f = fBody"
      and  vardistinct: "distinct [tag,h,b,one] \<and> distinct [one,b,h,tag] \<and> distinct[l,acc,t] \<and> distinct [t,acc,l]"

declare getheap_def [simp]
declare (in RevInplaceClock) fBody_def [simp]

lemma (in RevInplaceClock)
"HD \<noteq> TAG \<and> TAG \<noteq> HD \<longrightarrow> 
  \<Turnstile> {((N,ACC,C,X,Y),s). clock s = C \<and> (N,s\<lfloor>l\<rfloor>,X,getheap s) \<in> LLength \<and> (ACC,s\<lfloor>acc\<rfloor>,Y,getheap s) \<in> LLength
                    \<and> X Int Y = {}}
   (CALL f) 
   {((N,ACC,C,X,Y),s,v) . clock s = C + 33 * (int N) + 10}"
apply clarsimp
apply (rule HCallRecPrePostInvAdapt)
apply simp
apply (rule, rule, rule, rule refl, rule refl)
apply (rule HSP)
apply (rule hoarebasics)+
apply (erule assume_adapt)
apply (rule subset_refl)
(*now only side conditions left*)
prefer 2
  apply clarsimp
  apply(rule_tac x=a in exI, simp)
  apply(rule_tac x="aa" in exI)
  apply(rule_tac x="ac" in exI, simp)
  apply(rule_tac x=b in exI, simp)
apply (insert vardistinct)
apply clarsimp
apply rule
apply rule
apply (erule LLength.elims, simp, clarsimp)
apply rule
apply (subgoal_tac "baa<baa\<lceil>l\<rceil>\<bullet>TAG> = 1 \<and> (\<exists> N. a = Suc N) \<and> (\<exists> rl . baa\<lfloor>l\<rfloor> = Ref rl)")
prefer 2
  apply (erule LLength.elims, clarsimp, clarsimp)
apply clarsimp
apply (subgoal_tac "\<exists> racc. (baa\<lfloor>acc\<rfloor> = Ref racc \<and> Ref racc \<in> ba)")
prefer 2
  apply (rotate_tac 6)
  apply (erule LLength.elims, clarsimp, clarsimp)
apply clarsimp
apply (erule LLength.elims, clarsimp, clarsimp)
apply (rule_tac x="i" in exI, simp)
apply (subgoal_tac "\<exists> rtl. baa\<lfloor>la\<diamondsuit>TL\<rfloor> = Ref rtl")
prefer 2
  apply (rotate_tac -3)
  apply (erule LLength.elims, clarsimp, clarsimp)
apply clarsimp
apply (rule_tac x="Suc aa" in exI)
apply (rule_tac x="X - {Ref la}" in exI, simp)
apply (rule_tac x="ba Un {Ref la}" in exI, simp)
apply rule
prefer 2
  apply fastsimp
apply(rule CONS_LL, fastsimp+)
apply (subgoal_tac "(aa, Ref racc, ba,
           \<lparr>objhp = oheap baa, inthp = (iheap baa)(TAG := (iheap baa TAG)(la := 1), HD := iheap baa HD),
              refhp = (rheap baa)(TL := (rheap baa TL)(la := Ref racc))\<rparr>)
          \<in> LLength")
apply (subgoal_tac "insert (Ref la) ba - {Ref la} = ba", fastsimp, fastsimp)
by (subgoal_tac "Ref la \<notin> ba", fastsimp, fastsimp)


(*Here is the variant where the heap domains of the lists are not carried around as auxiliary varaibles
  but asserted as part of the pre-condition*)
locale RevInplaceClock2 = 
  fixes    tag     :: iname    and	   h       :: iname    and	   b       :: iname   and one :: iname
    and    l       :: rname    and         acc     :: rname    and         t       :: rname  
    and	   f       :: funame   and	   fBody   :: "(nat \<times> nat \<times> int) expr"
 defines  "fBody == PRE {((N,ACC,C),s). \<exists> X Y . ( clock s = C \<and> (N,s\<lfloor>l\<rfloor>,X,getheap s) \<in> LLength \<and> (ACC,s\<lfloor>acc\<rfloor>,Y,getheap s) \<in> LLength
                                            \<and> X Int Y = {} \<and> s\<lfloor>l\<rfloor> \<notin> (X Un Y Un {s\<lfloor>acc\<rfloor>}) \<and> s\<lfloor>acc\<rfloor> \<notin> (X Un Y Un {s\<lfloor>l\<rfloor>}))} :
                    POST {((N,ACC,C),s,v) . clock s = C + 33 * (int N) + 9} :
                    LET tag = GetFi l TAG;
                        b = Primop (% x y. if x < 1 then 1 else 0) tag tag
                    IN IF b THEN RVar acc 
                            ELSE LET  h   = GetFi l HD;
                                      rf t   = GetFr l TL;
                                      one = expr.Int 1;
                                      one = PutFi l TAG one; 
                                      h   = PutFi l HD h;
                                      rf acc = PutFr l TL acc;
                                      rf acc = RVar l;
                                      rf l   = RVar t 
                                 IN CALL f END
                    END"

  assumes  fbdy[simp]:  "funtable f = fBody"
      and  vardistinct:     "distinct [tag,h,b,one] \<and> distinct [one,b,h,tag] \<and> distinct[l,acc,t] \<and> distinct [t,acc,l]"

declare (in RevInplaceClock2) fBody_def [simp]

lemma (in RevInplaceClock2)
"\<Turnstile> {((N,ACC,C),s). \<exists> X Y . (clock s = C \<and> (N,s\<lfloor>l\<rfloor>,X,getheap s) \<in> LLength \<and> (ACC,s\<lfloor>acc\<rfloor>,Y,getheap s) \<in> LLength
                \<and> X Int Y = {} \<and> s\<lfloor>l\<rfloor> \<notin> (X Un Y Un {s\<lfloor>acc\<rfloor>}) \<and> s\<lfloor>acc\<rfloor> \<notin> (X Un Y Un {s\<lfloor>l\<rfloor>}))}
   (CALL f) 
   {((N,ACC,C),s,v) . clock s = C + 33 * (int N) + 10}"
apply clarsimp
apply (rule HCallRecPrePostInvAdapt)
apply simp
apply (rule, rule, rule, rule refl, rule refl)
apply (rule HSP)
apply (rule hoarebasics)+
apply (erule assume_adapt)
apply (rule subset_refl)
(*now only side conditions left*)
apply (insert vardistinct)
apply clarsimp
apply rule
apply rule
apply (erule LLength.elims, simp, clarsimp)
apply (erule LLength.elims, clarsimp)
apply clarsimp
apply clarsimp
by (rule_tac x="a" in exI, simp, rule_tac x="aa" in exI,rule_tac x="X" in exI, simp, rule_tac x="Y" in exI, simp)

text {*Now a variation using the simpler predicate LocLength, and without mentioning ACC in the precondition. 
       Also, instead of occurring as an auxiliary variable, X is quantified over in the precondition.
       Furthermore, we switch to letv and use the correct ticks*}
locale RevInplaceClockLoc = 
  fixes    tag     :: iname    and	   h       :: iname    and	   b       :: iname   and one :: iname
    and    l       :: rname    and         acc     :: rname    and         t       :: rname  
    and	   f       :: funame
 assumes  fbdy: "funtable f == 
                          PRE {((N,C),s). \<exists> X loc . clock s = C \<and> s\<lfloor>l\<rfloor> = Ref loc \<and> (N,loc,X,getheap s) \<in> LocLength}:
                          POST {((N,C),s,v) . clock s = C + 30 * (int N) + 9} :
                          LET tag = GetFi l TAG;
                              b = Primop (% x y. if x < 1 then 1 else 0) tag tag
                          IN IF b THEN RVar acc 
                                  ELSE LET  h   = GetFi l HD;
                                         rf t   = GetFr l TL;
                                            one = expr.Int 1;
                                            _   = PutFi l TAG one; 
                                            _   = PutFi l HD h;
                                            _   = PutFr l TL acc;
                                         rf acc = RVar l;
                                         rf l   = RVar t 
                                       IN CALL f END
                          END"

      and  vardistinct: "distinct [tag,h,b,one] \<and> distinct [one,b,h,tag] \<and>
                         distinct[l,acc,t] \<and> distinct [t,acc,l] \<and> 
                         distinct[HD,TAG]"

declare (in RevInplaceClockLoc) getheap_def [simp]
declare (in RevInplaceClockLoc) fbdy [simp]

lemma (in RevInplaceClockLoc)
" \<Turnstile> {((N,C),s). \<exists> X loc . clock s = C \<and> s\<lfloor>l\<rfloor> = Ref loc \<and> (N,loc,X,getheap s) \<in> LocLength}
   (CALL f) 
   {((N,C),s,v) . clock s = C + 30 * (int N) + 10}"
apply clarsimp
apply (rule HCallRecPrePostInvAdapt)
apply simp
apply (rule, rule, rule, rule refl, rule refl)
apply (rule HSP)
apply (rule hoarebasics)+
apply (erule assume_adapt)
apply (rule subset_refl)
(*now only side conditions left*)
apply (insert vardistinct)
apply clarsimp
apply rule
apply (erule LocLength.elims, clarsimp, clarsimp)
apply (erule LocLength.elims, clarsimp, clarsimp)
apply (rule_tac x="i" in exI, simp)
by (rule_tac x="Xa - {la}" in exI, fastsimp+)

end
