(*  Examples from List.cmlt -> Grail*)

theory ExampleListAppend = ToyHLderived + ExampleListClass:
(* Camelot:
  let app l m lrev = match l with Nil@d => (match lrev with Nil@e => m
                                                          | Cons(h,t)@e => app (Nil@d) (Cons(h,m)@e) t)
                                | Cons(h,t)@d => app t m (Cons(h,lrev)@d)
Grail:
method public static List$dia_0 app (List$dia_0 l, List$dia_0 m, List$dia_0 lrev) =
   let
      fun f(l, lrev, e, ?t6, e#0, ?t5, d, int h, t, d, ?t7, d#0, int h#0, t#0, m) =
      let
         val tag = getfield l TAG
      in
         if tag = 0
         then f:0(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
         else f:1(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
      end

      fun f:1(\<dots>) =
      let
         val h#0 = getfield l <int List$dia_0.f1>
         val t#0 = getfield l <List$dia_0 List$dia_0.f0>
         val d#0 = l
         val () = putfield d#0 <int List$dia_0.$> 1
         val () = putfield d#0 <int List$dia_0.f1> h#0
         val () = putfield d#0 <List$dia_0 List$dia_0.f0> lrev
         val ?t7 = d#0
      in
         f:2(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
      end

      fun f:2(\<dots>) =
         invokestatic <List$dia_0 List.app (List$dia_0, List$dia_0, List$dia_0)> (t#0, m, ?t7)

      fun f:0(\<dots>) =
      let
         val d = l
         val tag = getfield lrev <int List$dia_0.$>
      in
         if tag = 0
         then f:3(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
         else f:4(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
      end

      fun f:4(\<dots>) =
      let
         val h = getfield lrev <int List$dia_0.f1>
         val t = getfield lrev <List$dia_0 List$dia_0.f0>
         val e#0 = lrev
         val () = putfield d <int List$dia_0.$> 0
         val ?t5 = d
      in
         f:5(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
      end

      fun f:5() =
      let
         val () = putfield e#0 <int List$dia_0.$> 1
         val () = putfield e#0 <int List$dia_0.f1> h
         val () = putfield e#0 <List$dia_0 List$dia_0.f0> m
         val ?t6 = e#0
      in
         f:6(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
      end

      fun f:6(\<dots>) =
         invokestatic <List$dia_0 List.app (List$dia_0, List$dia_0, List$dia_0)> (?t5, ?t6, t)

      fun f:3(\<dots>) =
      let
         val e = lrev
      in
         m
      end
   in
      f:app(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
   end

ToyGrail:
method public static List$dia_0 app (List$dia_0 l, List$dia_0 m, List$dia_0 lrev) =
   let
      fun f(l,m,lrev) =
      let
         val tag = getfield l TAG
      in
         if tag = 0
         then let val tag = getfield lrev TAG
              in if tag = 0
                 then m
                 else let val h = getfield lrev HD
                          val t = getfield lrev TL
                          val () = putfield l TAG 0
                          val () = putfield lrev TAG 1
                          val () = putfield lrev HD h
                          val () = putfield lrev TL m
                          val m = lrev
                          lrev = t
                      in f (l, m, lrev)
                      end
              end
         else let val h = getfield l HD
                  val t = getfield l TL
                  val () = putfield l TAG 1
                  val () = putfield l HD h
                  val () = putfield l TL lrev
                  val lrev = l
                  l = t
              in f (l, m, lrev)
              end
     end
   in
      f(l, m, lrev)
   end
*)

(*This is the version with LocLength*)
locale AppendClockLoc = 
  fixes    tag :: iname and h :: iname and b :: iname and one  :: iname and zero :: iname
    and    l   :: rname and m :: rname and t :: rname and lrev :: rname
    and	   f   :: funame
 assumes fbdy: "funtable f == 
                    PRE {((L,LREV,C),s). \<exists> X Z rl rlrev. clock s = C \<and> 
                                              s\<lfloor>l\<rfloor> = Ref rl \<and> (L,rl,X,getheap s) \<in> LocLength \<and> 
                                              s\<lfloor>lrev\<rfloor> = Ref rlrev \<and> (LREV,rlrev,Z,getheap s) \<in> LocLength \<and>
                                              X Int Z = {}}:
                    POST {((L,LREV,C),s,v) . clock s = C + 43 * (int LREV + int L) + 30 * (int L) + 17} :
                    LET tag = GetFi l TAG;
                        b   = Primop (% x y. if x < 1 then 1 else 0) tag tag 
                        (*7 steps until here*)
                    IN IF b THEN LET tag = GetFi lrev TAG;
                                     b   = Primop (% x y. if x < 1 then 1 else 0) tag tag 
                                     (*15 steps until here*)
                                 IN IF b THEN RVar m (*17*)
                                         ELSE LET h       = GetFi lrev HD;
                                                  rf t    = GetFr lrev TL;
                                                  zero    = expr.Int 0;
                                                  _       = PutFi l TAG zero;
                                                  one     = expr.Int 1;
                                                  _       = PutFi lrev TAG one;
                                                  _       = PutFi lrev HD h;
                                                  _       = PutFr lrev TL m;
                                                  rf m    = RVar lrev;
                                                  rf lrev = RVar t 
                                              IN CALL f (*43*)
                                              END
                                 END
                            ELSE LET h       = GetFi l HD;
                                     rf t    = GetFr l TL;
                                     one     = expr.Int 1;
                                     _       = PutFi l TAG one;
                                     _       = PutFi l HD h;
                                     _       = PutFr l TL lrev;
                                     rf lrev = RVar l;
                                     rf l    = RVar t 
                                 IN CALL f END (*30*) 
                    END"

      and  vardistinct: "distinct [tag,h,b,one,zero] \<and> distinct [zero,one,b,h,tag] \<and> 
                         distinct[l,m,t,lrev] \<and> distinct [lrev,t,m,l] \<and>
                         distinct [HD,TAG]"


declare (in AppendClockLoc) fbdy [simp]
declare (in AppendClockLoc) getheap_def [simp]

lemma (in AppendClockLoc)
"\<Turnstile> {((L,LREV,C),s). \<exists> X Z rl rlrev. clock s = C \<and> 
                                              s\<lfloor>l\<rfloor> = Ref rl \<and> (L,rl,X,getheap s) \<in> LocLength \<and> 
                                              s\<lfloor>lrev\<rfloor> = Ref rlrev \<and> (LREV,rlrev,Z,getheap s) \<in> LocLength \<and>
                                              X Int Z = {}}
   (CALL f)
   {((L,LREV,C),s,v) . clock s = C + 43 * (int LREV + int L) + 30 * (int L) + 18}"
apply clarsimp
apply (rule HCallRecPrePostInvAdapt)
apply simp
apply (rule, rule, rule, rule refl, rule refl)
apply (rule HSP)
apply (rule hoarebasics)+
apply (erule assume_adapt)
apply (rule subset_refl)
apply (rule hoarebasics)+
apply (erule assume_adapt)
apply (rule subset_refl)
prefer 2
  apply fastsimp
apply (insert vardistinct)
apply clarsimp
apply (erule LocLength.elims, clarsimp+)
apply (erule LocLength.elims, clarsimp+)
apply(rule_tac x=0 in exI, rule_tac x=i in exI, simp)
apply(rule_tac x="{la}" in exI, simp, rule)
apply (rule NIL_LocL, fastsimp, fastsimp, fastsimp)
apply(rule_tac x="X - {laa}" in exI, rule)
apply(subgoal_tac "la \<notin> X - {laa}")
prefer 2 apply fastsimp
apply(subgoal_tac "laa \<notin> X - {laa}")
prefer 2 apply fastsimp
defer 1 (*apply fastsimp??*)
apply fastsimp
apply (erule LocLength.elims, clarsimp+)
apply(rule_tac x=i in exI, rule_tac x=1 in exI, simp)
apply(rule_tac x="Xa - {la}" in exI, rule)
apply(subgoal_tac "la \<notin> Xa - {la}", fastsimp, fastsimp)
apply(rule_tac x="{la,laa}" in exI, rule)
apply(rule CONS_LocL)
apply fastsimp+
apply (rule NIL_LocL)
apply (fastsimp, fastsimp, fastsimp, fastsimp)
apply clarsimp
apply(rule_tac x=i in exI, rule_tac x="ia + 2" in exI, simp)
apply(rule_tac x="Xa - {la}" in exI, rule)
apply(subgoal_tac "la \<notin> Xa - {la}", fastsimp, fastsimp)
apply(rule_tac x="Xb Un {la}" in exI, rule)
apply(rule CONS_LocL, fastsimp+)
apply(rule CONS_LocL)
apply fastsimp
apply fastsimp
apply fastsimp
apply (subgoal_tac "refhp \<lparr>objhp = oheap ba, inthp = (iheap ba)(TAG := (iheap ba TAG)(la := 1), HD := iheap ba HD),
                   refhp = (rheap ba)(TL := (rheap ba TL)(la := Ref laa))\<rparr>
           TL laa =
          Ref tta")
apply fastsimp
apply fastsimp
apply fastsimp
apply fastsimp
apply (subgoal_tac "Xb \<union> {la} - {la} - {laa} = Xb - {laa}")
apply clarsimp
apply fastsimp
apply fastsimp
apply fastsimp
oops (* the deferred goal should be provable by fastsimp but isn't*)


locale App = 
  fixes    tag :: iname and h :: iname and b :: iname and one  :: iname and zero :: iname
    and    l   :: rname and m :: rname and t :: rname and lrev :: rname
    and	   f   :: funame and fBody   :: "int expr"
 defines  "fBody == PRE {(H,s). HSize s = H} :
                    POST {(H,s,v) . HSize s = H} :
                    LET tag = GetFi l TAG;
                        b   = Primop (% x y. if x < 1 then 1 else 0) tag tag 
                    IN IF b THEN LET tag = GetFi lrev TAG;
                                     b   = Primop (% x y. if x < 1 then 1 else 0) tag tag 
                                 IN IF b THEN RVar m
                                         ELSE LET h       = GetFi lrev HD;
                                                  rf t    = GetFr lrev TL;
                                                  zero    = expr.Int 0;
                                                  zero    = PutFi l TAG zero;
                                                  one     = expr.Int 1;
                                                  one     = PutFi lrev TAG one;
                                                  h       = PutFi lrev HD h;
                                                  rf m    = PutFr lrev TL m;
                                                  rf m    = RVar lrev;
                                                  rf lrev = RVar t 
                                              IN CALL f 
                                              END
                                 END
                            ELSE LET h       = GetFi l HD;
                                     rf t    = GetFr l TL;
                                     one     = expr.Int 1;
                                     one     = PutFi l TAG one;
                                     h       = PutFi l HD h;
                                     rf lrev = PutFr l TL lrev;
                                     rf lrev = RVar l;
                                     rf l    = RVar t 
                                 IN CALL f END
                    END"

  assumes  fbdy[simp]:  "funtable f = fBody"
      and  vardistinct: "distinct [tag,h,b,one,zero] \<and> distinct [zero,one,b,h,tag] \<and> distinct[l,m,t,lrev] \<and> distinct [lrev,t,m,l]"


declare (in App) fBody_def [simp]
lemma (in App)
"\<Turnstile> {(H,s). HSize s = H} (CALL f) {(H,s,v) . HSize s = H}"
apply (insert vardistinct, clarsimp)
apply (rule HCallRec)
apply simp
apply(rule HPre)
apply(rule HPost)
apply (rule HSP)
apply (rule hoarebasics)+
apply assumption
apply (rule subset_refl)
apply (rule hoarebasics)+
apply assumption
apply (rule subset_refl)
by (clarsimp, simp, fastsimp)

locale AppendClock = 
  fixes    tag :: iname and h :: iname and b :: iname and one  :: iname and zero :: iname
    and    l   :: rname and m :: rname and t :: rname and lrev :: rname
    and	   f   :: funame and fBody   :: "(nat \<times> nat \<times> nat \<times> int \<times> (ref set) \<times> (ref set) \<times> (ref set)) expr"
 defines  "fBody == PRE {((L,M,LREV,C,X,Y,Z),s). clock s = C \<and> 
                                                (L,s\<lfloor>l\<rfloor>,X,getheap s) \<in> LLength \<and> 
                                                (M,s\<lfloor>m\<rfloor>,Y,getheap s) \<in> LLength \<and> 
                                                (LREV,s\<lfloor>lrev\<rfloor>,Z,getheap s) \<in> LLength \<and>
                                                 X Int Y = {} \<and> X Int Z = {} \<and> Y Int Z = {}}:
                    POST {((L,M,LREV,C,X,Y,Z),s,v) . clock s = C + 47 * (int LREV) + 33 * (int L) + 17} :
                    LET tag = GetFi l TAG;
                        b   = Primop (% x y. if x < 1 then 1 else 0) tag tag 
                        (*7 steps until here*)
                    IN IF b THEN LET tag = GetFi lrev TAG;
                                     b   = Primop (% x y. if x < 1 then 1 else 0) tag tag 
                                     (*15 steps until here*)
                                 IN IF b THEN RVar m (*17*)
                                         ELSE LET h       = GetFi lrev HD;
                                                  rf t    = GetFr lrev TL;
                                                  zero    = expr.Int 0;
                                                  zero    = PutFi l TAG zero;
                                                  one     = expr.Int 1;
                                                  one     = PutFi lrev TAG one;
                                                  h       = PutFi lrev HD h;
                                                  rf m    = PutFr lrev TL m;
                                                  rf m    = RVar lrev;
                                                  rf lrev = RVar t 
                                              IN CALL f (*47*)
                                              END
                                 END
                            ELSE LET h       = GetFi l HD;
                                     rf t    = GetFr l TL;
                                     one     = expr.Int 1;
                                     one     = PutFi l TAG one;
                                     h       = PutFi l HD h;
                                     rf lrev = PutFr l TL lrev;
                                     rf lrev = RVar l;
                                     rf l    = RVar t 
                                 IN CALL f END (*33*) 
                    END"

  assumes  fbdy[simp]:  "funtable f = fBody"
      and  vardistinct:     "distinct [tag,h,b,one,zero] \<and> distinct [zero,one,b,h,tag] \<and> distinct[l,m,t,lrev] \<and> distinct [lrev,t,m,l]"


declare (in AppendClock) fBody_def [simp]
declare getheap_def [simp]

lemma (in AppendClock)
"TAG \<noteq> HD \<and> HD \<noteq> TAG \<longrightarrow> 
 \<Turnstile> {((L,M,LREV,C,X,Y,Z),s). clock s = C \<and> (L,s\<lfloor>l\<rfloor>,X,getheap s) \<in> LLength \<and> 
                                           (M,s\<lfloor>m\<rfloor>,Y,getheap s) \<in> LLength \<and> 
                                           (LREV,s\<lfloor>lrev\<rfloor>,Z,getheap s) \<in> LLength \<and>
                                           X Int Y = {} \<and> X Int Z = {} \<and> Y Int Z = {}}
   (CALL f)
   {((L,M,LREV,C,X,Y,Z),s,v) . clock s = C + 47 * (int LREV) + 33 * (int L) + 18}"
apply clarsimp
apply (rule HCallRecPrePostInvAdapt)
apply simp
apply (rule, rule, rule, rule refl, rule refl)
apply (rule HSP)
apply (rule hoarebasics)+
apply (erule assume_adapt)
apply (rule subset_refl)
apply (rule hoarebasics)+
apply (erule assume_adapt)
apply (rule subset_refl)
apply (insert vardistinct)
apply clarsimp
apply rule
apply rule
apply (subgoal_tac "ab = 0 \<and> baa<baa\<lceil>lrev\<rceil>\<bullet>TAG> = 0")
  prefer 2
  apply(rotate_tac 8)
  apply (erule LLength.elims, clarsimp, clarsimp)
apply clarsimp
apply rule
apply rule
apply (subgoal_tac "a = 0 \<and> baa<baa\<lceil>l\<rceil>\<bullet>TAG> = 0")
  prefer 2
  apply (erule LLength.elims, clarsimp, clarsimp)
apply clarsimp
apply rule
apply (subgoal_tac "\<exists> N . a = Suc N \<and> baa<baa\<lceil>l\<rceil>\<bullet>TAG> = 1")
  prefer 2
  apply (erule LLength.elims, clarsimp, clarsimp)
apply clarsimp
apply (subgoal_tac "\<exists> rlrev . baa\<lfloor>lrev\<rfloor> = Ref rlrev \<and> fmap_lookup (objhp \<lparr>objhp = oheap baa, inthp = iheap baa, refhp = rheap baa\<rparr>) rlrev = Some LST \<and> inthp \<lparr>objhp = oheap baa, inthp = iheap baa, refhp = rheap baa\<rparr> TAG rlrev = 0 \<and> Ref rlrev \<in> ba")
prefer 2
  apply(rotate_tac 8)
  apply(erule LLength.elims, clarsimp, clarsimp)
apply clarsimp
apply (subgoal_tac "\<exists> rl . baa\<lfloor>l\<rfloor> = Ref rl")
prefer 2
  apply(erule LLength.elims, clarsimp, clarsimp)
apply clarsimp
apply (rule_tac x=N in exI)
apply (rule_tac x="aa" in exI)
apply (rule_tac x="Suc 0" in exI)
apply rule
apply (erule LLength.elims, clarsimp, clarsimp)
apply (rule_tac x="X - {Ref la}" in exI)
apply rule
apply (subgoal_tac "(i, baa\<lfloor>la\<diamondsuit>TL\<rfloor>, X - {Ref la},
           \<lparr>objhp = oheap baa, inthp = (iheap baa)(TAG := (iheap baa TAG)(la := 1)),
              refhp = (rheap baa)(TL := (rheap baa TL)(la := baa\<lfloor>lrev\<rfloor>))\<rparr>)
          \<in> LLength")
prefer 2
apply clarsimp
apply fastsimp
apply (rule_tac x="ae" in exI)
apply rule
apply fastsimp
apply (rule_tac x="{Ref la, Ref rlrev}" in exI)
apply rule
apply (rule CONS_LL)
apply fastsimp
apply fastsimp
apply fastsimp
apply fastsimp
apply fastsimp
apply fastsimp
apply(rule NIL_LL)
apply fastsimp
apply fastsimp
apply fastsimp
apply rule
oops
end
(*AppendClock2 is the variant where the heap domains of the lists are not carried around as auxiliary varaibles
  but asserted as part of the pre-condition*)
locale AppendClock2 = 
  fixes    tag :: iname and h :: iname and b :: iname and one  :: iname and zero :: iname
    and    l   :: rname and m :: rname and t :: rname and lrev :: rname
    and	   f   :: funame and fBody   :: "(nat \<times> nat \<times> nat \<times> int) expr"
 defines  "fBody == PRE {((L,M,LREV,C),s). \<exists> X Y Z . (clock s = C \<and> 
                                            (L,s\<lfloor>l\<rfloor>,X,s) \<in> LLength \<and> (M,s\<lfloor>m\<rfloor>,Y,s) \<in> LLength \<and> (LREV,s\<lfloor>lrev\<rfloor>,Z, s) \<in> LLength \<and>
                                                 X Int Y = {} \<and> X Int Z = {} \<and> Y Int Z = {} \<and> 
                                                 s\<lfloor>l\<rfloor> \<notin> (X Un Y Un Z Un {s\<lfloor>m\<rfloor> ,s\<lfloor>lrev\<rfloor>}) \<and> s\<lfloor>m\<rfloor> \<notin> (X Un Y Un Z Un {s\<lfloor>l\<rfloor>,s\<lfloor>lrev\<rfloor>}) \<and> 
                                                 s\<lfloor>lrev\<rfloor> \<notin> (X Un Y Un Z Un {s\<lfloor>l\<rfloor>,s\<lfloor>m\<rfloor>}))} :
                    POST {((L,M,LREV,C),s,v) . clock s = C + 47 * (int LREV) + 33 * (int L) + 17} :
                    LET tag = GetFi l TAG;
                        b   = Primop (% x y. if x < 1 then 1 else 0) tag tag 
                        (*7 steps until here*)
                    IN IF b THEN LET tag = GetFi lrev TAG;
                                     b   = Primop (% x y. if x < 1 then 1 else 0) tag tag 
                                     (*15 steps until here*)
                                 IN IF b THEN RVar m (*17*)
                                         ELSE LET h       = GetFi lrev HD;
                                                  rf t    = GetFr lrev TL;
                                                  zero    = expr.Int 0;
                                                  zero    = PutFi l TAG zero;
                                                  one     = expr.Int 1;
                                                  one     = PutFi lrev TAG one;
                                                  h       = PutFi lrev HD h;
                                                  rf m    = PutFr lrev TL m;
                                                  rf m    = RVar lrev;
                                                  rf lrev = RVar t 
                                              IN CALL f (*47*)
                                              END
                                 END
                            ELSE LET h       = GetFi l HD;
                                     rf t    = GetFr l TL;
                                     one     = expr.Int 1;
                                     one     = PutFi l TAG one;
                                     h       = PutFi l HD h;
                                     rf lrev = PutFr l TL lrev;
                                     rf lrev = RVar l;
                                     rf l    = RVar t 
                                 IN CALL f END (*33*) 
                    END"

  assumes  fbdy[simp]:  "funtable f = fBody"
      and  vardistinct:     "distinct [tag,h,b,one,zero] \<and> distinct [zero,one,b,h,tag] \<and> distinct[l,m,t,lrev] \<and> distinct [lrev,t,m,l]"


declare (in AppendClock2) fBody_def [simp]

(*The proof is exactly as before*)
lemma (in AppendClock2)
"\<Turnstile> {((L,M,LREV,C),s). clock s = C \<and> (L,s\<lfloor>l\<rfloor>,X,s) \<in> LLength \<and> (M,s\<lfloor>m\<rfloor>,Y,s) \<in> LLength \<and> (LREV,s\<lfloor>lrev\<rfloor>,Z,s) \<in> LLength \<and>
                                           X Int Y = {} \<and> X Int Z = {} \<and> Y Int Z = {} \<and> 
                                           s\<lfloor>l\<rfloor> \<notin> (X Un Y Un Z Un {s\<lfloor>m\<rfloor> ,s\<lfloor>lrev\<rfloor>}) \<and> s\<lfloor>m\<rfloor> \<notin> (X Un Y Un Z Un {s\<lfloor>l\<rfloor>,s\<lfloor>lrev\<rfloor>}) \<and> 
                                           s\<lfloor>lrev\<rfloor> \<notin> (X Un Y Un Z Un {s\<lfloor>l\<rfloor>,s\<lfloor>m\<rfloor>})}
   (CALL f)
   {((L,M,LREV,C),s,v) . clock s = C + 47 * (int LREV) + 33 * (int L) + 18}"
apply (rule HCallRecPrePostInvAdapt)
apply simp
apply (rule, rule, rule, rule refl, rule refl)
apply (rule HSP)
apply (rule hoarebasics)+
apply (erule assume_adapt)
apply (rule subset_refl)
apply (rule hoarebasics)+
apply (erule assume_adapt)
apply (rule subset_refl)
(*now only side conditions left*)
apply (insert vardistinct)
apply clarsimp
apply rule
apply rule
apply rule
apply rule
apply (erule LLength.elims, clarsimp)
apply (erule LLength.elims, clarsimp)
apply (erule LLength.elims, clarsimp)
apply clarsimp
apply clarsimp
apply clarsimp
apply clarsimp
apply (rule_tac x="0" in exI, clarsimp)
apply rule
apply (erule LLength.elims, clarsimp, clarsimp)
apply (erule LLength.elims, clarsimp, clarsimp)
apply rule
apply rule
apply rule
apply (rule_tac x="0" in exI, clarsimp)
apply (erule LLength.elims, clarsimp, clarsimp)
apply rule
apply (rule_tac x="0" in exI, clarsimp)
apply (erule LLength.elims, clarsimp, clarsimp)
(*last goal*)
apply clarsimp
apply (rule_tac x="0" in exI, clarsimp)
apply (rule, erule LLength.elims, clarsimp, rule NIL_LL, simp)
apply clarsimp
apply (rule)
by (rule_tac x="0" in exI,
    (erule LLength.elims, clarsimp)+,
    rule NIL_LL, clarsimp+)+


end
