(*  
   File:	$RCSfile: ExampleKonstVDM.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExampleKonstVDM.thy,v 1.6 2003/06/09 16:50:31 da Exp $

   Trying out VDM version of canonical example which requires adaptation.
*)

theory ExampleKonstVDM = ToyPrelude + ToyVDMderived:

locale konst_flat_example =
  fixes    n         :: iname
    and	   q         :: iname
    and	   z         :: iname
    and    const     :: funame
 assumes funtable[simp]:
  "funtable const = SATISFIES {(s,s',v). s<n> = s'<n>}:
		       LET
                         q =  Primop (\<lambda> x y. if x<0 then 1 else 0) n n
                       IN 
                         IF q
                           THEN n\<^sup>I
                           ELSE LET
                                  n = n :--  ;
                                  z = CALL const ;
                                  n = n:++
                                IN 
                                  n\<^sup>I
                                END
                       END"
  assumes  vardistinct: "distinct [n,q,z]"


lemma (in konst_flat_example)
  "\<Turnstile>\<^sub>v (CALL const) : {(s,s',v). s<n> = s'<n>}"
apply (insert vardistinct)
apply (rule VCallRecSat)
apply (simp, rule, (rule refl)+)  (* instantiation *)
apply (rule VW)		 (* play out vcg *)
apply (rule vdmbasicsI)+
apply (assumption)	 (* induction hyp *)
apply (rule vdmbasicsI)+
apply clarsimp
apply (case_tac "a<n> < 0")   (* NB: manual case distinction seems needed *)
apply fastsimp+
done

end
