(*  
   File:        $RCSfile: ExampleKonst.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExampleKonst.thy,v 1.7 2003/06/09 10:40:39 da Exp $

   A test of the Hoare Logic demonstrating manual use of adaptation.

   [NB: correctness only so no question over with clock/callcount position]
*)

theory ExampleKonst = ToyHLderived + ToyPrelude:

locale konst_flat_example =
  fixes    n         :: iname
    and	   q         :: iname
    and	   z         :: iname
    and    konst     :: funame
 assumes [simp]:
  "funtable konst = (LET
                         q =  Primop (\<lambda> x y. if x<0 then 1 else 0) n n
                       IN 
                         IF q
                           THEN n\<^sup>I
                           ELSE LET
                                  n = n :--  ;
                                  z = CALL konst ;
                                  n = n:++
                                IN 
                                  n\<^sup>I
                                END
                       END :: int expr)"
  assumes  vardistinct: "distinct [n,q,z]"


lemma (in konst_flat_example)
      constadapt:  "\<Turnstile> {(N,s). s<n> =  N} (CALL konst) {(N,s,v). s<n> =  N} \<Longrightarrow> 
                    \<Turnstile> {(N,s). s<n> + 1 =  N} (CALL konst) {(N,s,v). s<n> + 1 =  N}"
apply (erule HConseq)
apply auto
done

lemma (in konst_flat_example) 
   "\<Turnstile> {(N,s). s<n> =  N}
	(CALL konst)
      {(N,s,v). s<n> =  N}"
apply (insert vardistinct)
apply (rule HCallRec)
apply simp
apply (rule HSP)
apply (rule HLetI)
apply (rule HIf)
apply (rule HVar)
apply (rule HLetI)
apply (rule HLetI)
apply (rule HLetI)
apply (rule hoarebasics)
apply (rule hoarebasics)
apply clarsimp
apply (rule constadapt)
apply assumption
apply (rule hoarebasics)
apply (rule subset_refl)
apply (rule hoarebasics)
apply auto
done

end
