(*  
   File:	$RCSfile: ExampleEvenOddVDM.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExampleEvenOddVDM.thy,v 1.5 2003/06/11 21:37:12 a1hloidl Exp $

   Example of mutual recursive functions using VDM style
*)

theory ExampleEvenOddVDM = ToyPrelude + ToyVDMderived: 

constdefs
 Even :: "int \<Rightarrow> bool"
 "Even i \<equiv> \<exists> k. i=2*k"
 Odd :: "int \<Rightarrow> bool"
 "Odd i \<equiv> \<exists> k. i=2*k+1"

lemma [simp]: "Even (x + 1) = Odd(x)"
by (simp add: Even_def Odd_def, arith)

lemma [simp]:  "Odd(x + 1) = Even(x)"
by (simp add: Even_def Odd_def)
(* arith failed, presburger succeeded! *)

(* the next two lemmas aren't really needed, just simplify a bit more *)
lemma [simp]: "(\<not> Odd(x)) = Even(x)"
by (simp add: Even_def Odd_def, arith)   

lemma [simp]: "(\<not> Even(x)) = Odd(x)"
by (simp add: Even_def Odd_def, arith)

lemma [simp]: "Odd 0 = False"
by (simp add: Odd_def, arith)

lemma [simp]: "Even 0 = True"
by (simp add: Even_def)


lemma bonzo_999: "Even x --> \<not> Odd x"
by (simp add: Even_def Odd_def, arith)

lemma bonzo_998: "Odd x --> \<not> Even x"
by (simp add: Even_def Odd_def, arith)

(* ngoqvam moHbogh vImuSqu' !!!! *)
lemma bonzo_997: "0 < x --> Even (x) = Odd(x - 1)"
by (simp add: Even_def Odd_def, arith)

(* ngoqvam moHbogh vImuSqu' !!!! *)
lemma bonzo_996: "0 < x --> Odd (x) = Even (x - 1)"
by (simp add: Even_def Odd_def, arith)

lemma bonzo_995: "0 <= x ==> Odd x --> 0 < x"
by (simp add: Even_def Odd_def, arith)


(*
PRE  {(N,s).   N = s<x> \<and> 0 <= s<x>}:
		  POST {(N,s,v). v=IVal (grailbool (Even N))}:
		  
PRE  {(N,s). N = s<x> \<and> 0 <= s<x>}:
 	         POST {(N,s,v). v=IVal (grailbool (Odd N))}:
*)
   
constdefs untickinccc :: "state => state"
 "untickinccc s == s (| clock := (clock s) - 1, callcount :=  (callcount s) - 1 |)"

lemma untickinccc_rightinv_tickinc: 
  "\<And>a. [| 0 < clock a ; 0 ~= callcount a |] ==> tick (incrcallcount (untickinccc a)) = a"
apply (simp add: untickinccc_def)
done

lemma untickinccc_istore:
 "\<And>a n. [| 0 < clock a ; 0 ~= callcount a |] ==> (istore (untickinccc a)) = istore a"
by (simp add: untickinccc_def)

lemma untickinccc_rstore:
 "\<And>a n. [| 0 < clock a ; 0 ~= callcount a |] ==> (rstore (untickinccc a)) = rstore a"
by (simp add: untickinccc_def)

declare untickinccc_istore[simp]
declare untickinccc_rstore[simp]

(*

*)
                   
locale evenodd_example =
(* Simulating the typical example
      even(x) = let fun even x = if x=0 then true else odd(x-1)
                    fun odd x = if x=0 then false else even(x-1)
                in even(x)
 *)
  fixes    x :: iname
  fixes    b :: iname
  fixes	   even    :: funame
  fixes    odd     :: funame

  assumes funtable_even:
 "funtable even = (SATISFIES {(s,s',v). (0 <= s<x>) \<longrightarrow> (v = IVal (grailbool (Even (s<x>))))} :
                   
                          (LET   b = x :0?;
			   x = x :--
			   IN 
			      IF b THEN tt ELSE CALL odd
  			   END) :: state expr)"
  assumes funtable_odd:
 "funtable odd =  (SATISFIES {(s,s',v). (0 <= s<x>) \<longrightarrow> (v = IVal (grailbool (Odd (s<x>))))}:
                    (LET   b = x :0?;
			   x = x :--
		      IN 
			   IF b THEN ff ELSE CALL even
  		     END) :: state expr)"

  assumes  vardistinct:   "distinct[b,x] \<and> distinct[x,b]"

subsection {* Version requiring only case distinct, no instantiation; uses new VCallRecSat *}

(* petaq' bortaS *)
lemma (in evenodd_example) 
  "\<Turnstile>\<^sub>v (CALL even) :
     {(s,s',v). (0 <= s<x>) \<longrightarrow> (v = IVal (grailbool (Even (s<x>))))}"
apply (insert vardistinct)
apply (rule VCallRecSat)
apply (simp only: funtable_even)
apply (rule VW)
apply (rule vdmbasicsI)+
apply (rule VCall)
apply (simp only: funtable_odd)
(* apply (rule VW) *)
apply (rule VPost)
apply (rule VW)
apply (rule vdmbasicsI)+
apply (assumption)
apply (rule vdmbasicsI)+
defer 1
apply (rule vdmbasicsI)+
apply (clarsimp)  
apply (rule conjI)
apply (rule impI)
apply (case_tac "0 < a<x>")
 apply (simp add: bonzo_997 bonzo_996)
 apply simp
apply (rule impI)
apply (case_tac "0 < a<x>")
 apply simp
 apply (simp add: bonzo_997 bonzo_996)
apply (subgoal_tac "a<x> = 0")
apply simp
apply simp
apply clarsimp
apply clarsimp
apply (rule conjI)
apply (case_tac "0 < a<x>")
 apply (simp add: bonzo_997 bonzo_996)
 apply simp
defer 1
apply (rule impI)
apply (case_tac "0 < a<x>")
 apply (simp add: bonzo_997 bonzo_996)
 apply simp
apply (subgoal_tac "a<x> = 0")
apply clarsimp
apply simp
done

subsection {* Version with explicit unickinccc in the proof *}

(* DA: notice that the assumption in the proof below is FALSE,
   so anything can be proven as a consequence. *)
(* HWL: I left the assumption unproven, figuring it would be easy prove iff we
   initialise clock and callcount to one; only used in untickinccc_rightinv_tickinc;
   anyway, with new rules this isn't needed any more *)

lemma (in evenodd_example) 
  "[| \<forall> (s::state). 0 < clock s \<and> 0 < callcount s |] ==>
   \<Turnstile>\<^sub>v (CALL even) :
     {(s,s',v). (0 <= s<x>) \<longrightarrow> (v = IVal (grailbool (Even (s<x>))))}"
apply (insert vardistinct)
apply (rule VCallRec)
apply (simp only: funtable_even)
apply (rule VW)
apply (rule VPost)
apply (rule VW)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply (rule VCall)
apply (simp only: funtable_odd)
(* apply (rule VW) *)
apply (rule VPost)
apply (rule VW)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply assumption
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
defer 1
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
(* VCs *)
apply clarsimp
apply (rule conjI)
apply (rule impI)
apply (case_tac "0 < a<x>")
 apply (simp add: bonzo_997 bonzo_996)
 apply simp
apply (rule impI)
apply (case_tac "0 < a<x>")
 apply simp
 apply (simp add: bonzo_997 bonzo_996)
apply (subgoal_tac "a<x> = 0")
apply simp
apply simp
apply clarsimp
apply (rule_tac x="untickinccc a" in exI)
apply (erule_tac x="a" in allE)
apply (simp add: untickinccc_rightinv_tickinc)
defer 1
apply clarsimp
apply (rule conjI)
apply (rule impI)
apply (subgoal_tac "0 < a<x>")
apply (simp add: bonzo_997 bonzo_996)
defer 1
apply (rule impI)
apply (case_tac "0 < a<x>")
 apply (simp add: bonzo_997 bonzo_996)
 apply simp
apply (rule impI)
apply (simp add: bonzo_999 bonzo_998)
apply (rotate_tac -1)
apply (frule bonzo_995)
apply simp
done

(*Slightly shorter proof follows - of course essentially nothing new*)
declare untickinccc_rightinv_tickinc [simp add]
lemma (in evenodd_example) 
  "[| \<forall> (s::state). 0 < clock s \<and> 0 < callcount s |] ==>
   \<Turnstile>\<^sub>v (CALL even) :
     {(s,s',v). (0 <= s<x>) \<longrightarrow> (v = IVal (grailbool (Even (s<x>))))}"
apply (insert vardistinct)
apply (rule VCallRec)
apply (simp only: funtable_even)
apply (rule VW)
apply (rule VPost)
apply (rule VW)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply (rule VCall)
apply (simp only: funtable_odd)
(* apply (rule VW) *)
apply (rule VPost)
apply (rule VW)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
apply assumption
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
defer 1
apply (rule vdmbasicsI)
apply (rule vdmbasicsI)
(* VCs *)
(* We first discharge VC 2*)
prefer 2
apply clarsimp
apply (rule_tac x="untickinccc a" in exI)
apply (erule_tac x="a" in allE, simp add: bonzo_999)
(* The proofs for VCs 1 and 3 are identical, so we do them by + *) 
apply (clarsimp, erule_tac x=a in allE, rule,
       (rule,
        case_tac "a<x> = 0", fastsimp,
        case_tac "a<x> < 0", fastsimp, simp add: bonzo_997 bonzo_996)+)+
done
end
