(*  
   File:        $RCSfile: ExampleEvenOddDeriv.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExampleEvenOddDeriv.thy,v 1.1 2003/06/16 18:44:45 da Exp $

   Another test of the Hoare Logic demonstrating use of adaptation
   with mutually-recursive functions.

   [NB: correctness only so no question over with clock/callcount position]
*)

theory ExampleEvenOddproofs = ToyPrelude + ToyHLproofsDeriv + SimpVC:

constdefs
 Even :: "int \<Rightarrow> bool"
 "Even i \<equiv> \<exists> k. i=2*k"
 Odd :: "int \<Rightarrow> bool"
 "Odd i \<equiv> \<exists> k. i=2*k+1"

lemma [simp]: "Even (x + 1) = Odd(x)"
by (simp add: Even_def Odd_def, arith)

lemma [simp]:  "Odd(x + 1) = Even(x)"
by (simp add: Even_def Odd_def)
(* arith failed, presburger succeeded! *)

(* the next two lemmas aren't really needed, just simplify a bit more *)
lemma [simp]: "(\<not> Odd(x)) = Even(x)"
by (simp add: Even_def Odd_def, arith)   

lemma [simp]: "(\<not> Even(x)) = Odd(x)"
by (simp add: Even_def Odd_def, arith)

lemma [simp]: "Odd 0 = False"
by (simp add: Odd_def, arith)

lemma [simp]: "Even 0 = True"
by (simp add: Even_def)

lemma [simp]: "Even(x - 1) = (\<not> Even(x))"
by (simp add: Even_def, arith)
   
lemma [simp]: "Odd(x - 1) = Even(x)"
by (simp add: Even_def Odd_def, arith)

locale evenodd_example =
(* Simulating the typical example
      even(x) = let fun even x = if x=0 then true else odd(x-1)
                    fun odd x = if x=0 then false else even(x-1)
                in even(x)
 *)
  fixes    x :: iname
    and    b :: iname
    and	   even    :: funame
    and    odd     :: funame

  assumes funtable_even:
 "funtable even = PRE  {(N,s).   N = s<x> \<and> 0 <= s<x>}:
		  POST {(N,s,v). v=IVal (grailbool (Even N))}:
		     LET   b = x :0?;
			   x = x :--
			   IN 
			      IF b THEN tt ELSE CALL odd
  			   END"

  and funtable_odd:
 "funtable odd = PRE  {(N,s). N = s<x> \<and> 0 <= s<x>}:
 	         POST {(N,s,v). v=IVal (grailbool (Odd N))}:
		     LET   b = x :0?;
			   x = x :--
		      IN 
			   IF b THEN ff ELSE CALL even
  		     END"

  and  vardistinct:   "distinct[b,x] \<and> distinct[x,b] \<and> distinct[even,odd]"

text {* It's easier to express the adaption rules using
 Isabelle's implication than in the proof system context. *}
  

lemma (in evenodd_example)
  evenadapt:   "(G \<turnstile> {(N,s). N = s<x> \<and> 0 <= s<x>} (CALL even) {(N,s,v). v=IVal (grailbool (Even N))})
		\<Longrightarrow> G \<turnstile> {(N,s). N = (s<x> + 1) \<and> 0 <= s<x>} (CALL even)
		          {(N,s,v). v=IVal (grailbool (Odd N))}"
apply (rule hconseq)
apply assumption
apply auto
done


lemma (in evenodd_example)
  oddadapt:   "(G \<turnstile> {(N,s). N = s<x> \<and> 0 <= s<x>} (CALL odd) {(N,s,v). v=IVal (grailbool (Odd N))})
	      \<Longrightarrow> (G \<turnstile> {(N,s). N = (s<x> + 1) \<and> 0 <= s<x>} (CALL odd)
		          {(N,s,v). v=IVal (grailbool (Even N))})"
apply (rule hconseq)
apply assumption      
apply auto
done

lemma (in evenodd_example) "\<turnstile> {(N,s). N = s<x> \<and> 0 <= s<x>} 
				(CALL even) 
			      {(N,s,v). v=IVal (grailbool (Even N))}"
apply (insert vardistinct)
apply (rule hcall)
apply (simp only: funtable_even)
apply (rule hsp)       (* playout the VCG *)
apply (rule hoareproof_ibasics hpre hpost)+
(* now unravel odd: first using adaptation to make pre-post match up *)
apply (rule oddadapt)
(* now let's examine call to odd *)
apply (rule hcall)
apply (simp only: funtable_odd)
apply (rule hoareproof_ibasics hpre hpost)+
(* now apply induction hypothesis and adaptation for even *)
apply (rule evenadapt)
apply (rule hax, simp)
apply (rule subset_refl)
apply (rule hoareproof_ibasics)
apply (rule hsp, rule hoareproof_ibasics)
apply clarsimp
apply (rule subset_refl)
apply clarsimp
apply (rule subset_refl)
apply (rule hoareproof_ibasics | rule hsp)+
prefer 3
apply (rule subset_refl)
apply auto
done



section {* The example again using "automatic" adaptation *}

lemma (in evenodd_example) "\<turnstile> {(N,s). N = s<x> \<and> 0 <= s<x>} 
				(CALL even) 
			      {(N,s,v). v=IVal (grailbool (Even N))}"
apply (insert vardistinct)
apply (rule hcallrecprepostinvadapt)
apply (simp only: funtable_even, rule hsp)
apply (rule hoareproof_ibasics)+
apply (rule hcallrecprepostinvadapt)
apply (simp only: funtable_odd, rule hsp)
apply (rule hoareproof_ibasics)+
(* instantiation here is just to pick out right premise: context could be made
   into a map, maybe\<dots> *)
apply (rule_tac P="invimagepre tickcall {(N, s). N = s<x> \<and> 0 \<le> s<x>}"
	and Q="{(N, s, v). v = IVal (if Even N then 1 else 0)}" in haxadapt)
apply simp
apply (rule subset_refl)
apply (rule hoareproof_ibasics)+
apply (simpvc, arith)
apply (rule subset_refl)+
apply (rule hoareproof_ibasics)+
apply (simpvc, arith)
apply auto
done

end
