(*  
   File:        $RCSfile: ExampleEvenOdd.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExampleEvenOdd.thy,v 1.12 2003/06/16 18:56:00 da Exp $

   Another test of the Hoare Logic demonstrating use of adaptation
   with mutually-recursive functions.

   [NB: correctness only so no question over with clock/callcount position]
*)

theory ExampleEvenOdd = ToyPrelude + ToyHLderived: 

constdefs
 Even :: "int \<Rightarrow> bool"
 "Even i \<equiv> \<exists> k. i=2*k"
 Odd :: "int \<Rightarrow> bool"
 "Odd i \<equiv> \<exists> k. i=2*k+1"

lemma [simp]: "Even (x + 1) = Odd(x)"
by (simp add: Even_def Odd_def, arith)

lemma [simp]:  "Odd(x + 1) = Even(x)"
by (simp add: Even_def Odd_def)
(* arith failed, presburger succeeded! *)

(* the next two lemmas aren't really needed, just simplify a bit more *)
lemma [simp]: "(\<not> Odd(x)) = Even(x)"
by (simp add: Even_def Odd_def, arith)   

lemma [simp]: "(\<not> Even(x)) = Odd(x)"
by (simp add: Even_def Odd_def, arith)

lemma [simp]: "Odd 0 = False"
by (simp add: Odd_def, arith)

lemma [simp]: "Even 0 = True"
by (simp add: Even_def)

   

locale evenodd_example =
(* Simulating the typical example
      even(x) = let fun even x = if x=0 then true else odd(x-1)
                    fun odd x = if x=0 then false else even(x-1)
                in even(x)
 *)
  fixes    x :: iname
    and    b :: iname
    and	   even    :: funame
    and    odd     :: funame

  assumes funtable_even:
 "funtable even = PRE  {(N,s).   N = s<x> \<and> 0 <= s<x>}:
		  POST {(N,s,v). v=IVal (grailbool (Even N))}:
		     LET   b = x :0?;
			   x = x :--
			   IN 
			      IF b THEN tt ELSE CALL odd
  			   END"

  and funtable_odd:
 "funtable odd = PRE  {(N,s). N = s<x> \<and> 0 <= s<x>}:
 	         POST {(N,s,v). v=IVal (grailbool (Odd N))}:
		     LET   b = x :0?;
			   x = x :--
		      IN 
			   IF b THEN ff ELSE CALL even
  		     END"

  and  vardistinct:   "distinct[b,x] \<and> distinct[x,b]"


lemma (in evenodd_example)
  evenadapt:   "\<Turnstile> {(N,s). N = s<x> \<and> 0 <= s<x>} (CALL even)
	          {(N,s,v). v=IVal (grailbool (Even N))}
		    \<Longrightarrow> \<Turnstile> {(N,s). N = (s<x> + 1) \<and> 0 <= s<x>} (CALL even)
		          {(N,s,v). v=IVal (grailbool (Odd N))}"
by (erule HConseq, simp)

lemma (in evenodd_example)
  oddadapt:   "\<Turnstile> {(N,s). N = s<x> \<and> 0 <= s<x>} (CALL odd)
	          {(N,s,v). v=IVal (grailbool (Odd N))}
		    \<Longrightarrow> \<Turnstile> {(N,s). N = (s<x> + 1) \<and> 0 <= s<x>} (CALL odd)
		          {(N,s,v). v=IVal (grailbool (Even N))}"
by (erule HConseq, simp)


lemma (in evenodd_example) "\<Turnstile> {(N,s). N = s<x> \<and> 0 <= s<x>} 
				(CALL even) 
			      {(N,s,v). v=IVal (grailbool (Even N))}"
apply (insert vardistinct)
apply (rule HCallRec)
apply (simp only: funtable_even)
apply (rule HSP)       (* playout the VCG *)
apply (rule HPre)
apply (rule HSP)
apply (rule HPost)
apply (rule HLetI)
apply (rule HLetI)
apply (rule HIf)
apply (rule HInt)
(* now unravel odd: first using adaptation to make pre-post match up *)
apply (rule oddadapt)
(* now let's examine call to odd *)
apply (rule HCall)
apply (simp only: funtable_odd)
apply (rule HPre)
apply (rule HPost)
apply (rule HLetI)
apply (rule HLetI)
apply (rule HIf)
apply (rule HInt)
(* now apply induction hypothesis and adaptation for even *)
apply (rule evenadapt)
apply (assumption)
apply (rule subset_refl)
apply (rule hoarebasics)
apply (rule HSP, rule hoarebasics)
defer 1
apply fastsimp
defer 1
apply (rule subset_refl)
apply (rule hoarebasics)
apply (rule hoarebasics)
prefer 3
apply (rule subset_refl)
apply auto
done


locale evenodd_Heap =
(* Simulating the typical example
      even(x) = let fun even x = if x=0 then true else odd(x-1)
                    fun odd x = if x=0 then false else even(x-1)
                in even(x)
 *)
  fixes    x :: iname
    and    b :: iname
    and	   even    :: funame
    and    odd     :: funame

  assumes funtable_even:
 "funtable even = PRE  {((N,H),s). N = s<x> \<and> 0 <= s<x> \<and> hpsize s = H}:
		  POST {((N,H),s,v). v=IVal (grailbool (Even N)) \<and> hpsize s = H}:
		     LET   b = x :0?;
			   x = x :--
			   IN 
			      IF b THEN tt ELSE CALL odd
  			   END"

  and funtable_odd:
 "funtable odd = PRE  {((N,H),s). N = s<x> \<and> 0 <= s<x> \<and> hpsize s = H}:
 	         POST {((N,H),s,v). v=IVal (grailbool (Odd N)) \<and> hpsize s = H}:
		     LET   b = x :0?;
			   x = x :--
		      IN 
			   IF b THEN ff ELSE CALL even
  		     END"

  and  vardistinct:   "distinct[b,x] \<and> distinct[x,b]"


lemma (in evenodd_Heap)
  evenadapt:   "\<Turnstile> {((N,H),s). N = s<x> \<and> 0 <= s<x> \<and> hpsize s = H} (CALL even)
	          {((N,H),s,v). v=IVal (grailbool (Even N)) \<and> hpsize s = H}
		    \<Longrightarrow> \<Turnstile> {((N,H),s). N = (s<x> + 1) \<and> 0 <= s<x> \<and> hpsize s = H} (CALL even)
		          {((N,H),s,v). v=IVal (grailbool (Odd N)) \<and> hpsize s = H}"
by (erule HConseq, simp)

lemma (in evenodd_Heap)
  oddadapt:   "\<Turnstile> {((N,H),s). N = s<x> \<and> 0 <= s<x> \<and> hpsize s = H} (CALL odd)
	          {((N,H),s,v). v=IVal (grailbool (Odd N)) \<and> hpsize s = H}
		    \<Longrightarrow> \<Turnstile> {((N,H),s). N = (s<x> + 1) \<and> 0 <= s<x> \<and> hpsize s = H} (CALL odd)
		          {((N,H),s,v). v=IVal (grailbool (Even N)) \<and> hpsize s = H}"
by (erule HConseq, simp)

(*exactly the same proof as before!*)
lemma (in evenodd_Heap) "\<Turnstile> {((N,H),s). N = s<x> \<and> 0 <= s<x> \<and> hpsize s = H} 
				(CALL even) 
			      {((N,H),s,v). v=IVal (grailbool (Even N)) \<and> hpsize s = H}"
apply (insert vardistinct)
apply (rule HCallRec)
apply (simp only: funtable_even)
apply (rule HSP)       (* playout the VCG *)
apply (rule HPre, rule HSP, rule HPost, (rule hoarebasics)+)
(* now unravel odd: first using adaptation to make pre-post match up *)
apply (rule oddadapt)
(* now let's examine call to odd *)
apply (rule HCall)
apply (simp only: funtable_odd)
apply (rule HPre, rule HSP, rule HPost, (rule hoarebasics)+)
(* now apply induction hypothesis and adaptation for even *)
apply (rule evenadapt)
apply (assumption)
apply (rule subset_refl)+
prefer 3
apply (rule subset_refl)
prefer 5
apply (rule subset_refl)
apply auto
done

constdefs
 EvenEvenClock :: "int \<Rightarrow> int \<Rightarrow> bool"
 "EvenEvenClock i C \<equiv> \<exists> k. (i=2*k \<and> C = 11 + 19 * k)"
 EvenOddClock :: "int \<Rightarrow> int \<Rightarrow> bool"
 "EvenOddClock i C \<equiv> \<exists> k. (i=2*k \<and> C = 20 + 18 * k)"
 OddOddClock :: "int \<Rightarrow> int \<Rightarrow> bool"
 "OddOddClock i C \<equiv> \<exists> k. (i=2*k+1 \<and> C = 20 + 19 * k)"
 OddEvenClock :: "int \<Rightarrow> int \<Rightarrow> bool"
 "OddEvenClock i C \<equiv> \<exists> k. (i=2*k+1 \<and> C = 11 + 19 * k)"

locale evenodd_Clock =
(* Simulating the typical example
      even(x) = let fun even x = if x=0 then true else odd(x-1)
                    fun odd x = if x=0 then false else even(x-1)
                in even(x)
 *)
  fixes    x :: iname
    and    b :: iname
    and	   even    :: funame
    and    odd     :: funame

  assumes funtable_even:
 "funtable even = PRE  {((N,C),s). N = s<x> \<and> 0 <= s<x> \<and> clock s = C}:
		  POST {((N,C),s,v). v=IVal (grailbool (EvenEvenClock N (clock s - C)))}:
		     LET   b = x :0?;
			   x = x :--
			   IN 
			      IF b THEN tt ELSE CALL odd
  			   END"

  and funtable_odd:
 "funtable odd = PRE  {((N,C),s). N = s<x> \<and> 0 <= s<x> \<and> clock s = C}:
 	         POST {((N,C),s,v). v=IVal (grailbool (OddOddClock N (clock s - C)))}:
		     LET   b = x :0?;
			   x = x :--
		      IN 
			   IF b THEN ff ELSE CALL even
  		     END"

  and  vardistinct:   "distinct[b,x] \<and> distinct[x,b]"


lemma (in evenodd_Clock)
  evenadapt:   "\<Turnstile> {((N,C),s). N = s<x> \<and> 0 <= s<x> \<and> clock s = C} (CALL even)
	          {((N,C),s,v). v=IVal (grailbool (EvenEvenClock N (clock s - C)))}
		    \<Longrightarrow> \<Turnstile> {((N,C),s). N = (s<x> + 1) \<and> 0 <= s<x> \<and> clock s = C} (CALL even)
		          {((N,C),s,v). v=IVal (grailbool (OddEvenClock N (clock s - C)))}"
by (erule HConseq, simp add: EvenEvenClock_def OddEvenClock_def)


lemma (in evenodd_Clock)
  oddadapt:   "\<Turnstile> {((N,C),s). N = s<x> \<and> 0 <= s<x> \<and> clock s = C} (CALL odd)
	          {((N,C),s,v). v=IVal (grailbool (OddOddClock N (clock s - C)))}
		    \<Longrightarrow> \<Turnstile> {((N,C),s). N = (s<x> + 1) \<and> 0 <= s<x> \<and> clock s = C} (CALL odd)
		          {((N,C),s,v). v=IVal (grailbool (EvenEvenClock N (clock s - C)))}"
apply (erule HConseq, simp add: OddOddClock_def EvenOddClock_def)
apply auto
sorry

lemma (in evenodd_Clock) "\<Turnstile> {((N,C),s). N = s<x> \<and> 0 <= s<x> \<and> clock s = C} 
				(CALL even) 
			      {((N,C),s,v). v=IVal (grailbool (EvenEvenClock N (clock s - C)))}"
apply (insert vardistinct)
apply (rule HCallRec)
apply (simp only: funtable_even)
apply (rule HSP)       (* playout the VCG *)
apply (rule HPre)
apply (rule HSP)
apply (rule HPost)
apply (simp (no_asm)) (* remove trivial intersect from HPost so adapt will work *)
apply (rule HLetI)
apply (rule HLetI)
apply (rule HIf)
apply (rule HInt)
(* now unravel odd: first using adaptation to make pre-post match up *)
apply (rule oddadapt)
(* now let's examine call to odd *)
apply (rule HCall)
apply (simp only: funtable_odd)
apply (rule HPre)
apply (rule HPost)
apply (rule HLetI)
apply (rule HLetI)
apply (rule HIf)
apply (rule HInt)
(* now apply induction hypothesis and adaptation for even *)
(* apply (simp (no_asm)) *) (* remove trivial intersect from HPost *)
apply (rule evenadapt)
apply (assumption)
apply (rule subset_refl)
apply (rule hoarebasics)
apply (rule HSP, rule hoarebasics)
defer 1
apply fastsimp
defer 1
apply (rule subset_refl)
apply (rule hoarebasics)
apply (rule hoarebasics)
prefer 5
apply clarsimp defer 1
apply (rule subset_refl)
prefer 2
apply (rule subset_refl) apply(simp_all add: EvenClock_def OddClock_def)
oops
apply clarsimp
apply clarsimp
apply clarsimp
done

end

