(*  
   File:        $RCSfile: ExampleEOI.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExampleEOI.thy,v 1.3 2003/06/11 21:37:12 a1hloidl Exp $

   Example: even/odd with invoke
*)

theory ExampleEOI = ToyPrelude + ToyHLbasic + ToyHLderived:

section {* Testing the VCGen *}

subsection {* *}

constdefs
 Even :: "int \<Rightarrow> bool"
 "Even i \<equiv> \<exists> k. i=2*k"
 Odd :: "int \<Rightarrow> bool"
 "Odd i \<equiv> \<exists> k. i=2*k+1"

lemma [simp]: "Even (x + 1) = Odd(x)"
by (simp add: Even_def Odd_def, arith)

lemma [simp]:  "Odd(x + 1) = Even(x)"
by (simp add: Even_def Odd_def)
(* arith failed, presburger succeeded! *)

(* the next two lemmas aren't really needed, just simplify a bit more 
lemma [simp]: "( Odd(x)) = Even(x)"
by (simp add: Even_def Odd_def, arith)   

lemma [simp]: "( Even(x)) = Odd(x)"
by (simp add: Even_def Odd_def, arith)

lemma [simp]: "Odd 0 = False"
by (simp add: Odd_def, arith)

lemma [simp]: "Even 0 = True"
by (simp add: Even_def)
*)
   

subsection {* even/odd example: direct recursion *}

constdefs OHSize ::"state \<Rightarrow> int"
"OHSize s == int (card (fmap_dom (oheap s)))"
(* IHsize and RHsize need sum over all i/rflds
constdefs OHSize ::"state \<Rightarrow> int"
"OHSize s == int (card (fmap_dom (oheap s))) + int (card (dom (iheap s))) + int (card (dom (rheap s)))"
*)

declare OHSize_def [simp]

locale evenoddInv =
  fixes    n         :: iname    
  fixes    m         :: iname    
  fixes    b         :: iname 
  fixes    one       :: iname
  fixes    z         :: iname 
  fixes    h         :: iname
  fixes    count     :: ifldname
  fixes	   even_odd  :: mname
  fixes    EvenOddClass :: cname
  assumes even_odd_methtable[simp]: "
          methtable EvenOddClass even_odd =
                     (PRE  {(z::state,s::state).   0 <= s<s\<lceil>param\<rceil>\<bullet>count> \<and> z = s}:
		     (POST {(z::state,s::state,v). v=IVal (grailbool (Even z<z\<lceil>param\<rceil>\<bullet>count>))}:
                      (LET 
                        n = param\<bullet>count ;
		        b = n :0?
		       IN IF b 
                           THEN tt
                           ELSE LET 
                                  n = n:-- ;
		                  b = n :0?
		                IN 
                                  IF b 
                                    THEN ff
                                    ELSE LET
                                           n = n:-- ;
                                           z = param\<bullet>count := n ;
                                           b = EvenClass\<bullet>even(param)
                                         IN
                                           b\<^sup>I
                                         END
                                END 
                        END)) :: state expr)"
 assumes vardistinct:  "distinct [n,m,b,one] \<and> distinct [one,b,m,n]"


(*
      and  even_wfmeasure[simp]: "fun_wfmeasure_table even = inv_image less_than (\<lambda> s. nat (s<n>))"
*)
(*
      and  postAss[simp]: 
                "fun_postassn_table even = 
                  {(z,s,v). ((v = (IVal 1) \<longrightarrow> (\<exists> k . z<n> = 2 * k \<and> 0 <= k)) \<and> 
                             (v = (IVal 0) \<longrightarrow> (\<exists> k . z<n> = 2 * k + 1 \<and> 0 <= k)) \<and>
                             (v = IVal 0 \<or> v = IVal 1))}"
      and  preAss[simp]: 
                "fun_preassn_table even = 
                 {(z,s). 0 <= z<n> \<and> 0 <= s<n> \<and> (\<exists> k . s<n> = z<n> - 2 * k \<and> 0 <= k)}"
*)

lemma adaptme:
 "\<Turnstile> {(z, s). 0 \<le> s<s\<lceil>param\<rceil>\<bullet>count> \<and> z = s} 
     EvenOddClass\<bullet>even_odd(param)
    {(z::state,s::state,v). v=IVal (grailbool (Even z<z\<lceil>param\<rceil>\<bullet>count>))}
 \<Longrightarrow>
 \<Turnstile> {(z, s). 0 \<le> s<s\<lceil>self\<rceil>\<bullet>count> \<and> z = s} 
    EvenOddClass\<bullet>even_odd(param)
 {(z::state,s::state,v). v=IVal (grailbool (Odd (z<z\<lceil>param\<rceil>\<bullet>count> - 1)))}"
sorry
(* not really sorry at all *)
 
lemma (in evenoddInv) 
   "\<Turnstile> {(z::state,s::state). 0 <= s<s\<lceil>param\<rceil>\<bullet>count> \<and> z = s}
       EvenOddClass\<bullet>even_odd(param)
      {(z::state,s::state,v). v=IVal (grailbool (Even z<z\<lceil>param\<rceil>\<bullet>count>))}"
apply (insert vardistinct)
apply clarsimp
apply (rule "HInvokeStaticRec")
apply (rule allI)
apply (rule impI)
apply (simp add: even_odd_methtable)
(* shove it *)
apply simp
apply (tactic {* all_tac *})
apply (rule "HSP")
apply (rule "HPre")
apply (rule "HSP")
apply (rule "HWC")
apply (rule "HPost")
apply (rule "HLetI")
apply (rule "HLetI")
apply (rule "HIf")
apply (rule hoarebasics)
apply (rule "HLetI")
apply (rule "HLetI")
apply (rule "HIf")
apply (rule hoarebasics)
apply (rule "HLetI")
apply (rule "HLetI")
apply (rule "HLetI")
apply (rule hoarebasics)
(* rec call *)
apply simp
(* fails! need to adapt *)
apply assumption
oops

(*
apply vcg1_simp
(* VCs look ok *)
apply simp
apply auto
apply (rule_tac x="0" in exI)
apply clarsimp
apply (rule_tac x="0" in exI)
apply clarsimp
done
*)
lemma (in evenoddInv) 
   "[|  \<Turnstile> (fun_preassn_table even) (CALL even) (fun_postassn_table even) |] ==>
    \<Turnstile> {(z,s). 0 <= z<n> \<and> s<n> = z<n> \<and> z<h> = HSize s} 
       (CALL even)
       {(z,s,v). ((v = (IVal 1) \<longrightarrow> (\<exists> k . z<n> = 2 * k \<and> 0 <= k)) \<and> 
                  (v = (IVal 0) \<longrightarrow> (\<exists> k . z<n> = 2 * k + 1 \<and> 0 <= k)) \<and>
                  (v = IVal 0 \<or> v = IVal 1) \<and>
                  HSize s = z<h>)}"
apply (insert vardistinct)
apply clarsimp
apply vcg_rec_simp
(* VCs look ok !! *)
apply auto
apply (rule_tac x="0" in exI)
apply clarsimp
apply (rule_tac x="0" in exI)
apply clarsimp
done

subsection {* even/odd example: mutual recursion *}

(* doesn't work yet *)

locale evenodd_example =
(* Simulating the typical example
      even(x) = let fun even x = if x=0 then true else odd(x-1)
                    fun odd x = if x=0 then false else even(x-1)
                in even(x)
 *)
  fixes    x :: iname
    and    y :: iname
    and    z :: iname
    and    q :: iname
    and    Z :: int
    and	   evenfn  :: funame
    and    oddfn   :: funame
    and	   evenBody :: expr
    and    oddBody  :: expr
  defines  "evenBody == LET 
                          q = x :0?
                       IN 
                         IF q 
                           THEN tt
                           ELSE LET 
                                  x = x :-- ;
                                  y = CALL oddfn ;
                                  z = : y
                                IN 
                                  z\<^sup>I
  			        END
                       END"
  defines  "oddBody == LET  
                        q = x :0?
                      IN
                         IF q 
                           THEN ff
                           ELSE LET 
                                  x = x :-- ;
                                  y = CALL evenfn ;
                                  z = : y
                                IN 
                                  z\<^sup>I
  			        END
                       END"
  assumes  even_fnbdy:     "funtable evenfn = evenBody"
      and  odd_fnbdy:      "funtable oddfn = oddBody"
      and  even_wfmeasure: "fun_wfmeasure_table evenfn = inv_image less_than (\<lambda> s. nat (get_ivar s x))"
      and  odd_wfmeasure:  "fun_wfmeasure_table oddfn = inv_image less_than (\<lambda> s. nat (get_ivar s x))"
      and  vardistinct: "distinct [x,y,z,q]"
      (* invariants *)
      and  even_preinv: "fun_preassn_table evenfn == {(z,s). 0 < z<x> \<and> z<x> = s<x>}"
      and  even_postinv: "fun_postassn_table evenfn == {(z,s,v). ( v=(IVal 1) --> 2 dvd z<x> ) \<and> ( v=IVal 0 -->  (2 dvd z<x>) )}"

      and  odd_preinv: "fun_preassn_table oddfn == {(z,s). 0 < z<x> \<and> z<x> = s<x>}"
      and  odd_postinv: "fun_postassn_table oddfn == {(z,s,v). ( v=(IVal 0) --> 2 dvd z<x> ) \<and> ( v=IVal 1 -->  (2 dvd z<x>) )}"

declare (in evenodd_example) evenBody_def   [simp]
declare (in evenodd_example) oddBody_def    [simp]
declare (in evenodd_example) even_fnbdy     [simp]
declare (in evenodd_example) odd_fnbdy      [simp]
declare (in evenodd_example) even_wfmeasure [simp]
declare (in evenodd_example) odd_wfmeasure  [simp]
declare (in evenodd_example) even_preinv    [simp]
declare (in evenodd_example) even_postinv   [simp]
declare (in evenodd_example) odd_preinv     [simp]
declare (in evenodd_example) odd_postinv    [simp]

lemma (in evenodd_example) 
   "\<Turnstile> {(z,s). \<exists> k . 0 < z<x> \<and> (s<x>=2*k) \<and> s<x>=z<x>}	
	evenBody
      {(z,s,v). v=IVal 1}"
apply (insert vardistinct)
apply (simp)
apply vcg1_simp
apply (simp add:  cntxt_hoare_valid_def)
apply (rule HCallMutRec)
apply (tactic {* res_inst_tac [("P","fun_preassn_table")] (thm "HCallMutRec") 1 *})
defer 1
defer 1
defer 1
oops

lemma (in evenodd_example) 
   "\<Turnstile> {(z,s). 0 < z \<and> (s<x>=2*z)}	
	evenBody
      {(z,s,v). v=IVal 1}"
apply (insert vardistinct)
apply (simp)
apply hoare_rec_simp
(* *)
prefer 3
apply simp
apply clarsimp
prefer 3
apply hoare_rec_step
defer 1
apply simp
apply simp
prefer 4
apply hoare_rec_step
defer 1
apply hoare_rec_step
defer 1
apply hoare_rec_step
defer 1
apply hoare_rec_step
defer 1
apply hoare_rec_step
apply hoare_rec_step
defer 1
apply hoare_rec_step
defer 1
apply hoare_rec_step
apply simp
apply hoare_rec_step
defer 1
apply simp
apply simp
apply simp
oops

end
