(*  
   File:	$RCSfile: ExampleDecVDM.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExampleDecVDM.thy,v 1.1 2003/06/04 13:02:26 a1hloidl Exp $

   Trivial straight-line code, mainly as sanity checks for VDM rules.
*)

theory ExampleDecVDM = ToyPrelude + ToyVDMderived:

section {* \texttt{decN}: decrement a field *}

(* straight-line examples to narrow down problems with VDM rules *)

locale dec1_example =
  fixes    m         :: iname
    and	   n         :: iname
    and	   decN      :: funame
  assumes  decN_fnbdy[simp]: "funtable decN = 
              ((LET 
                m    = n :-- 
               IN
                m\<^sup>I
               END) :: state expr)"
  assumes  vardistinct: "distinct [n,m]"

lemma (in dec1_example) 
   "\<Turnstile>\<^sub>v CALL decN :
        {(s,s',v). 0 < s<n> --> v = IVal (s<n> - 1) }"
apply (insert vardistinct)
apply (rule VW)
apply (rule VCall)
apply simp
apply (rule VLetI)
apply (rule VIVar)
apply (rule VPrimop)
apply clarsimp
done
(* OK *)

locale dec2_example =
  fixes    m         :: iname
    and	   n         :: iname
    and	   decN      :: funame
  assumes  decN_fnbdy[simp]: "funtable decN = 
              ((LET 
                m    = n :--  ;
                n    = m\<^sup>I
               IN
                m\<^sup>I
               END) :: state expr)"
  assumes  vardistinct: "distinct [n,m]"

lemma (in dec2_example) 
   "\<Turnstile>\<^sub>v CALL decN :
        {(s,s',v). 0 < s<n> --> v = IVal (s<n> - 1) }"
apply (insert vardistinct)
apply (rule VW)
apply (rule VCall)
apply simp
apply (rule VLetI)
apply (rule VLetI)
apply (rule VIVar)
apply (rule VIVar)
apply (rule VPrimop)
apply clarsimp
done
(* OK *)

locale dec3_example =
  fixes    m         :: iname
    and	   n         :: iname
    and	   decN      :: funame
  assumes  decN_fnbdy[simp]: "funtable decN = 
              ((LET 
                m    = n :--  ;
                n    = m\<^sup>I
               IN
                m\<^sup>I
               END) :: state expr)"
  assumes  vardistinct: "distinct [n,m]"

lemma (in dec3_example) 
   "\<Turnstile>\<^sub>v CALL decN :
        {(s,s',v). 0 < s<n> --> v = IVal (s<n> - 1) }"
apply (insert vardistinct)
apply (rule VW)
apply (rule VCall)
apply simp
apply (rule VLetI)
apply (rule VLetI)
apply (rule VIVar)
apply (rule VIVar)
apply (rule VPrimop)
apply clarsimp
done
(* OK *)

locale dec4_example =
  fixes    m         :: iname
    and	   q         :: iname
    and	   decN      :: funame
  assumes  decN_fnbdy[simp]: "funtable decN = 
              ((IF q 
                  THEN m\<^sup>I
                  ELSE 1\<^sup>z
                ) :: state expr)"
  assumes  vardistinct: "distinct [q,m]"

lemma (in dec4_example) 
   "\<Turnstile>\<^sub>v CALL decN :
        {(s,s',v). s<q> = grailbool True --> v = IVal (s<m>) }"
apply (insert vardistinct)
apply (rule VW)
apply (rule VCall)
apply simp
apply (rule VIf)
apply (rule VIVar)
apply (rule VInt)
apply clarsimp
done
(* OK *)

locale decN_example =
  fixes    m         :: iname
    and	   n         :: iname
    and	   q         :: iname
    and	   zero      :: iname
    and    N         :: int    
    and	   decN      :: funame
  assumes  decN_fnbdy[simp]: "funtable decN = 
              ((LET 
                m    = n :-- ;
                zero = 0\<^sup>z ;
                q    = n :> zero
              IN
                IF q 
                  THEN m\<^sup>I
                  ELSE zero\<^sup>I
              END) :: state expr)"
  assumes  vardistinct: "distinct [n,m,zero,q]"

lemma (in decN_example) 
   "\<Turnstile>\<^sub>v CALL decN :
        {(s,s',v). 0 < s<n> --> v = IVal (s<n> - 1) }"
apply (insert vardistinct)
apply (rule VW)
apply (rule VCall)
apply simp
apply (rule VLetI)
apply (rule VLetI)
apply (rule VLetI)
apply (rule VIf)
apply (rule VIVar)
apply (rule VIVar)
apply (rule VPrimop)
apply (rule VInt)
apply (rule VPrimop)
apply clarsimp
done

end
