(*  
   File:	$RCSfile: ExampleDECIVDMBD.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExampleDECIVDMBD.thy,v 1.1 2003/06/16 22:21:14 a1hloidl Exp $

   Decrement w/ invoke using VDM rules.
*)

theory ExampleDecIVDMBD = ToyPreludeBD + ToyVDMderivedBD:

section {* \texttt{decI}: decrement a field *}

(* straight-line examples to narrow down problems with VDM rules *)

locale decI_example =
  fixes    m         :: iname
  fixes	   n         :: iname
  fixes	   q         :: iname
  fixes	   z         :: iname
  fixes    count     :: ifldname
  fixes	   decI      :: mname
  fixes    DecClass  :: cname
  assumes  decI_methtable[simp]: "methtable DecClass decI = 
              ((LET 
                m    = param\<bullet>count ;
                q    = m :0?
                IN 
                  IF q
                    THEN m\<^sup>I
                    ELSE LET
                           n = m :-- ;
                           z = param\<bullet>count := n
                         IN
                           n\<^sup>I
                         END
               END) :: state expr)"
  assumes  vardistinct: "distinct [m,n,q,z] \<and> distinct [z,q,n,m]"

lemma (in decI_example) 
   "\<Turnstile>\<^sub>v DecClass\<bullet>decI(self) :
        {(s,s',v). 0 < s<s\<lceil>self\<rceil>\<bullet>count> --> v = IVal (s<s\<lceil>self\<rceil>\<bullet>count> - 1) }"
apply (insert vardistinct)
apply (rule VW)
apply (rule VInvokeStatic)
apply simp
apply (rule vdmbasicsI)+
apply clarsimp
done


end
