(*  
   File:	ExampleCount
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExampleCountproofs.thy,v 1.1 2003/06/10 09:40:46 da Exp $

   Simplest recursive function.
*)

theory ExampleCountproofs = ToyHLproofsDeriv + ToyPrelude:

locale count_example =
  fixes    one        :: iname
    and	   n          :: iname
    and	   b          :: iname
    and    Count      :: cname
    and	   countfn    :: funame

  assumes  countfnbdy[simp]:  
"funtable countfn = 
	PRE  {((C,N),s).   clock s = C + 12 * (N - s<n>) + 1 \<and> 0 < s<n>}:
	POST {((C,N),s,v). clock s = C + 12 * N + 1}:
	LET one = 1\<^sup>z; 
	    n = n :--;
	    b = n :< one
	IN 
	  IF b THEN expr.Int 42 ELSE CALL countfn
	END"

      and  vardistinct:   "distinct [one,n,b] \<and> distinct [b,n,one]"

lemma (in count_example) 
   "\<turnstile> {((C,N),s). clock s = C \<and> N = s<n> \<and> 0 < (s<n>)}
        (CALL countfn)
      {((C,N),s,v). clock s = C + 12 * N + 1}"
apply (insert vardistinct)
apply (rule hcallrecprepostinv)
apply (simp, (rule, rule refl)+, rule refl)
apply (rule hsp)
apply (rule hoareproof_ibasics | rule hax, simp, rule subset_refl)+
apply (clarsimp)
apply auto
done

end
