(*  
   File:	ExampleCount
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExampleCountVDM.thy,v 1.5 2003/06/19 13:21:09 da Exp $

   Resource usage properties for very simple recursive function.
*)

theory ExampleCountVDM = ToyVDMderived + ToyPrelude:


locale count_example =
  fixes    one        :: iname
    and	   n          :: iname
    and	   b          :: iname
    and    Count      :: cname
    and	   countfn    :: funame

(* da: The important thing in the specification below is that it covers
   both the step case and base case of the function definition, hence the
   conditions.  
*)

assumes  countfnbdy[simp]:  
"funtable countfn = 
  SATISFIES {(s,s',v). clock s' = clock s + (if s<n><=0 then 12 else 12 * s<n>)
	         \<and> callcount s' = callcount s + (if (1 < s<n>) then (s<n> - 1) else 0)}:
   LET one = 1\<^sup>z; 
       n = n :--;
       b = n :< one
   IN 
     IF b THEN expr.Int 42 ELSE CALL countfn
   END"

      and  vardistinct:   "distinct [one,n,b] \<and> distinct [b,n,one]"

lemma (in count_example) 
   "\<Turnstile>\<^sub>v (CALL countfn) : {(s,s',v). 0 < s<n> \<longrightarrow> 
				  (clock s' = (clock s) + 12 * s<n> + 1
				   \<and> callcount s' = callcount s + s<n>) }"
apply (insert vardistinct)
apply (rule VCallRecSat)
apply (simp, rule, (rule refl)+)
apply (rule VW)
apply (rule vdmbasicsI)+
apply (assumption)
apply (rule vdmbasicsI)+
apply (clarsimp)  
apply auto
done


end
