(*  
   File:	ExampleCount
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExampleCount.thy,v 1.3 2003/06/09 10:40:02 da Exp $

   Resource usage properties for very simple recursive function.
*)

theory ExampleCount = ToyHLderived + ToyPrelude:

locale count_example =
  fixes    one        :: iname
    and	   n          :: iname
    and	   b          :: iname
    and    Count      :: cname
    and	   countfn    :: funame

  assumes  countfnbdy[simp]:  
"funtable countfn = 
   PRE  {((C,N,CC),s).   clock s = C + 12 * (N - s<n>) \<and> 
			 callcount s = CC + (N - s<n>) \<and> 0<s<n>}:

   POST {((C,N,CC),s,v). clock s = C + 12 * N + 1 \<and> callcount s = CC+N}:
   LET one = 1\<^sup>z; 
       n = n :--;
       b = n :< one
   IN 
     IF b THEN expr.Int 42 ELSE CALL countfn
   END"

      and  vardistinct:   "distinct [one,n,b] \<and> distinct [b,n,one]"

text {* First proof uses rule which treats pre-condition as referring
  to state before CALL. *}

lemma (in count_example) 
   "\<Turnstile> {((C,N,CC),s). clock s = C \<and> N = s<n> \<and> 0 < (s<n>) \<and> callcount s = CC}
        (CALL countfn)
      {((C,N,CC),s,v). clock s = C + 12 * N + 1 \<and> callcount s = CC + N}"
apply (insert vardistinct)
apply (rule HCallRecPrePost)
apply simp			(* FIXME: improve instantiation here *)
apply (rule, rule refl)
apply (rule, rule refl)
apply (rule refl)
apply (rule HSP)
apply (rule hoarebasics)+
apply (assumption)
apply (rule subset_refl)
apply (clarsimp)
apply auto
done


locale count_example2 =
  fixes    one        :: iname
    and	   n          :: iname
    and	   b          :: iname
    and    Count      :: cname
    and	   countfn    :: funame

  assumes  countfnbdy[simp]:  
"funtable countfn = 
   PRE  {((C,N,CC),s).   clock s = C + 12 * (N - s<n>) + 1 \<and> 
			 callcount s = CC + (N - s<n>) + 1 \<and> 0<s<n>}:

   POST {((C,N,CC),s,v). clock s = C + 12 * N + 1 \<and> callcount s = CC+N}:
   LET one = 1\<^sup>z; 
         n = n :--;
         b = n :< one
   IN 
       IF b THEN expr.Int 42 ELSE CALL countfn
   END"

      and  vardistinct:   "distinct [one,n,b] \<and> distinct [b,n,one]"

text {* This proof of an identical triple uses the derivable rule HCallRecPrePostinv, 
  considering the pre-condition to refer to the body.  Notice the small change
  to the invariant above by adding an extra tick and call count. *}

lemma (in count_example2) 
   "\<Turnstile> {((C,N,CC),s). clock s = C \<and> N = s<n> \<and> 0 < (s<n>) \<and> callcount s = CC}
        (CALL countfn)
      {((C,N,CC),s,v). clock s = C + 12 * N + 1 \<and> callcount s = CC + N}"
apply (insert vardistinct)
apply (rule HCallRecPrePostinv)
apply simp			(* FIXME: improve instantiation here *)
apply (rule, rule refl)
apply (rule, rule refl)
apply (rule refl)
apply (rule HSP)
apply (rule hoarebasics)+
apply (assumption)
apply (rule subset_refl)
apply (clarsimp)
apply auto
done

end
