structure mkTheory :> mkTheory =
struct

  type Filename = string

type Tycon = string
type Con = string * int
type Ty = string
type Fldname = string

datatype Constr = constr of Con * ((Ty * Fldname) list)
datatype Typedec = typedec of Tycon * (Constr list)

datatype assumption = ass of string
datatype conclusion = concl of string
datatype proof = prf of string
datatype CnameDecl = cnd of string
datatype ModelsDecl = mdl of string

datatype rule = rl of string * assumption * conclusion
datatype lemma = lem of string * assumption * conclusion * proof 

fun generateEntry (tpname,fldname) i = 
  if tpname = "int" then "ifields " ^ fldname ^ " = a" ^ Int.toString i
  else "(\\<exists> ll . rfields " ^ fldname ^ 
        " = Ref ll \\<and> (ll,s,a" ^ Int.toString i ^ ") \\<in> models_" ^ tpname ^ ")"

fun generateEntries [] i = ""
  | generateEntries (tpindex :: tpIndices) i = 
      (generateEntry tpindex i) ^ " \\<and> " ^ generateEntries tpIndices (i+1)

fun makeArgs [] i = ""
  | makeArgs (h :: t) i = " a" ^ (Int.toString i) ^ (makeArgs t (i+1))

fun g tycon (constr ((cn,i), tylist)) =
  let val a = "\\<exists> ifields rfields . s \\<lless>l\\<ggreater> = Some("^ 
                       tycon ^ ",ifields,rfields) \\<and> " ^ (generateEntries tylist 0) ^ 
                       " ifields TAG = " ^ (Int.toString i)
      val c = "(l, s, " ^ cn ^ (makeArgs tylist 0) ^ ") \\<in> models_" ^ tycon
  in (rl (cn, (ass a), (concl c)),
      lem (cn ^ "_intro", ass a, concl c, prf ("by (rule " ^ cn ^ ",simp)")),
      lem (cn ^ "_elim", ass c, concl a, prf "")) (*proof will be filled in once we know the name*)
  end

fun mkConstructors clb = 
            let fun mkComponents [] = ("", Binaryset.empty String.compare, Binaryset.empty String.compare)
                  | mkComponents ((t,fld) :: comps) = 
                      let val (A,iB,rB) = mkComponents comps
                      in (case t of "int" => ("\"" ^ t ^ "\" " ^ A, Binaryset.add (iB ,fld), rB) 
                                  | _ => ("\"" ^ t ^ "_tp\" " ^ A, iB, Binaryset.add (rB ,fld)))
                      end
                fun mkConstr con l = let val (A,iB,rB) = mkComponents l in (con ^ " " ^ A, iB, rB) end
            in case clb of [] => ("", Binaryset.empty String.compare, Binaryset.empty String.compare)
                         | ([constr((con,_),l)]) => mkConstr con l
                         | (constr((con,_),l) :: constrs) => let val (A,iB,rB) = mkConstr con l 
                                                                  val (C,iD,rD) = mkConstructors constrs
                                                              in (A ^ "| " ^ C, 
                                                                  Binaryset.union(iB,iD), 
                                                                  Binaryset.union(rB,rD))
                                                              end
            end

fun h (typedec (tc, cbl)) = 
    let val (A, iB, rB) = mkConstructors cbl
    in ((tc ^ "_tp = " ^ A, iB, rB),
        cnd (tc ^ " :: cname"),
        mdl ("models_" ^ tc ^ ":: \"(locn \\<times> state \\<times> " ^ tc ^ "_tp) set\""),
        "models_" ^ tc,
        List.foldl (fn (cb,(rules,intros,elims)) => 
                       let val (r,i,e) = g tc cb
                       in (r :: rules, i :: intros, e :: elims)
                      end)
                   ([],[],[]) 
                   cbl
       )
   end

fun mkTpDecls [] = ""
  | mkTpDecls [S] = S ^ "\n"
  | mkTpDecls (S::decls) = S ^ "\n and \t" ^ mkTpDecls decls

fun mkFile L filename = 
  let val (D,iFD,rFD,C,M,N,(R,I,E)) = 
      foldr (fn (td,(tpdecls,ifdecls,rfdecls,cnds,mdcls,names,(rules,intros,elims))) =>
                let val ((d,iflds,rflds),c,m,n,(r,i,e)) = h td 
                in (d :: tpdecls, Binaryset.union(ifdecls,iflds),Binaryset.union(rfdecls,rflds), 
                    c :: cnds, m :: mdcls, n :: names,(r @ rules, i @ intros, e @ elims))
                end) 
            ([],Binaryset.empty String.compare,Binaryset.empty String.compare,[],[],[],([],[],[]))
            L
  val header = let fun f [] = "Gen = ToyVCG:\n\n"
                     | f (typedec(s,_) :: tl) = s ^ f tl
               in "theory " ^ f L end
  val introsname = foldr (fn (n,s) => n ^ " " ^ s) "" N
  fun mkRln [] = "" | mkRln [h] = h | mkRln (h :: t) = h ^ "_" ^ (mkRln t)
  val rulename = mkRln N
  val mkTpDecls = "datatype " ^ mkTpDecls D ^ "\n"
  val mkIFldnames = let fun f [] = "TAG :: ifldname\n\n"
                         | f [s] = "\t" ^ s ^ ":: ifldname\n\tTAG :: ifldname\n\n"
                         | f (s :: ss) = "\t" ^ s ^ ":: ifldname\n" ^ f ss
                   in f (Binaryset.listItems iFD) end
  val mkRFldnames = let fun f [] = "\n"
                         | f [s] = "\t" ^ s ^ ":: rfldname\n"
                         | f (s :: ss) = "\t" ^ s ^ ":: rfldname\n" ^ f ss
                   in f (Binaryset.listItems rFD) end
  val mkCnames = "consts \t" ^ (foldl (fn (cnd S, s) => S ^ "\n \t" ^ s)) "\n" C
  val mkModels = "consts \t" ^ (foldl (fn (mdl S, s) => S ^ "\n \t" ^ s)) "\n" M
  val mkRules = foldl (fn (rl(S,ass ASS, concl CONCL),s) => 
                        S ^ ": \"\\<lbrakk> " ^ ASS ^ "\\<rbrakk> \n \\<Longrightarrow> " ^ 
                        CONCL ^ "\" \n" ^ s)
                "\n" R
  val mkIntros = foldl (fn(lem(NM,ass ASS, concl CONCL, prf P),s) => 
                        "lemma " ^ NM ^ ": \"" ^ ASS ^ "\n \\<Longrightarrow> " ^ CONCL ^
                        "\"\n" ^ P ^ "\n\n" ^ s) "" I
  val mkElims = foldl (fn(lem(NM,ass ASS, concl CONCL, prf P),s) => 
                        "lemma " ^ NM ^ ": \"" ^ ASS ^ "\n \\<Longrightarrow> " ^ CONCL ^
                        "\"\n by (erule " ^ rulename ^ ".elims, simp_all)\n\n" ^ s) "" E
  val os = TextIO.openOut filename
  val X = TextIO.output(os,
                        header ^ mkTpDecls ^ mkCnames ^ mkRFldnames ^ mkIFldnames ^ mkModels ^ 
                        "inductive " ^ introsname ^ " intros\n" ^ 
                        mkRules ^ mkIntros ^ mkElims ^ "\n end"
                       ) ; 
  in TextIO.closeOut os
  end

 end
