theory newSL = Dynsem:

consts semanticsValue::"Value => State => RTVal option"
primrec
"semanticsValue (VARval x) s = (if x: (dom (locals s)) then Some(s<x>) else None)"
"semanticsValue (INTval i) s = Some(rtInt i)"
"semanticsValue (NULLval cn) s = Some(rtRef nullRef)"

consts semanticsBOPAux::"int => BinOp => RTVal => RTVal option"
primrec
"semanticsBOPAux i1 bop (rtInt i2) = 
  (if bop = ADDop then Some(rtInt (i1 + i2))
   else if bop = SUBop then Some(rtInt (i1 - i2))
   else Some(rtInt(i1 * i2)))" 
"semanticsBOPAux i1 bop rtVoid = None "
"semanticsBOPAux i1 bop (rtBool b) = None "
"semanticsBOPAux i1 bop (rtString str) = None "
"semanticsBOPAux i1 bop (rtRef r) = None "

consts semanticsBOP2::"RTVal => BinOp => RTVal => RTVal option"
primrec
"semanticsBOP2 (rtInt i1) bop rtv2 = semanticsBOPAux i1 bop rtv2"
"semanticsBOP2 rtVoid bop rtv2 = None"
"semanticsBOP2 (rtBool b) bop rtv2 = None"
"semanticsBOP2 (rtString str) bop rtv2 = None"
"semanticsBOP2 (rtRef r) bop rtv2 = None"

consts semanticsBOP1::"RTVal => BinOp => RTVal option => RTVal option"
primrec
"semanticsBOP1 rtv1 bop None = None"
"semanticsBOP1 rtv1 bop (Some rtv2) = semanticsBOP2 rtv1 bop rtv2"

consts semanticsBOP::"RTVal option => BinOp => RTVal option => RTVal option"
primrec
"semanticsBOP None bop rtv2 = None"
"semanticsBOP (Some rtv1) bop rtvOpt2 = semanticsBOP1 rtv1 bop rtvOpt2"

consts semanticsGF2::"Fields => FieldDesc => RTVal option"
primrec
"semanticsGF2 flds (FDESC ty fld) = flds fld"

consts semanticsGF1::"Reference => State => FieldDesc => RTVal option"
primrec
"semanticsGF1 nullRef s fdesc = Some (rtRef nullRef)"
"semanticsGF1 (locRef l) s fdesc = 
  (if l : (dom (oheap s)) then semanticsGF2 (snd(get_obj s l)) fdesc
   else None)"

consts semanticsGetfield::"RTVal => State => FieldDesc => RTVal option"
primrec
"semanticsGetfield (rtRef r) s fdesc = semanticsGF1 r s fdesc"
"semanticsGetfield rtVoid s fdesc = None"
"semanticsGetfield (rtBool b) s fdesc = None"
"semanticsGetfield (rtInt i) s fdesc = None"
"semanticsGetfield (rtString str) s fdesc = None"

consts semanticsPrimop::"PrimOp => State => RTVal option"
(*no equations for new and putfield*)
primrec
"semanticsPrimop (VALop v) s = semanticsValue v s"
"semanticsPrimop (BINop bop v1 v2) s = 
   semanticsBOP (semanticsValue v1 s) bop (semanticsValue v2 s)"
"semanticsPrimop (GETFIELDop x fdesc) s = 
   (if x: (dom (locals s)) then semanticsGetfield (s<x>) s fdesc else None)" 

datatype exp =
    RTVexp "RTVal"
  | PROPexp "PrimOp" 

datatype assert =
    emp
  | single "exp" "Obj" (*only objects on rhs?!*)
  | star "assert" "assert"
  | equals "exp" "exp"
  | conj "assert" "assert"

consts fvValue::"Value => Vname set"
primrec
"fvValue (VARval x) = {x}"
"fvValue (INTval i) = {}"
"fvValue (NULLval str) = {}"

consts fvPrimop::"PrimOp => Vname set"
primrec
"fvPrimop (VALop v) = fvValue v"
"fvPrimop (BINop bop v1 v2) = (fvValue v1) Un (fvValue v2)"
"fvPrimop (NEWop Cn) = {}"
"fvPrimop (GETFIELDop x fdesc) = {x}"
"fvPrimop (PUTFIELDop x fdesc v) = {x} Un (fvValue v)"

consts fvExp::"exp => Vname set"
primrec
"fvExp (RTVexp rtv) = {}"
"fvExp (PROPexp prop) = fvPrimop prop"

consts fv::"assert => Vname set"
primrec
"fv emp = {}"
"fv (single e OBJ) = fvExp e"
"fv (star p q) = (fv p) Un (fv q)"
"fv (equals e1 e2) = (fvExp e1) Un (fvExp e2)"
"fv (conj p q) = (fv p) Un (fv q)"

consts semanticsExp::"exp => State => RTVal option"
primrec
"semanticsExp (RTVexp rtv) s = Some rtv"
"semanticsExp (PROPexp prop) s = semanticsPrimop prop s " 

consts semanticsAss::"assert => State => bool"
primrec
"semanticsAss emp s = (dom (oheap s) ={})"
"semanticsAss (single e obj) s = 
  (EX l.((dom (oheap s) = {l}) & 
         (semanticsExp e s = Some(rtRef(locRef l))) & 
         ((oheap s) l = Some obj)))"
"semanticsAss (star ass1 ass2) s =
  (EX H K. (((dom H) Int (dom K) = {}) &
            (oheap s = H ++K) &
            (semanticsAss ass1 (s(|oheap := H|))) &
            (semanticsAss ass2 (s(|oheap := K|)))))"
"semanticsAss (equals e1 e2) s = (semanticsExp e1 s = semanticsExp e2 s)"
"semanticsAss (conj ass1 ass2) s = (semanticsAss ass1 s & semanticsAss ass2 s)"

lemma "semanticsAss (star ass1 ass2) s = semanticsAss (star ass2 ass1) s"
apply(auto)
apply(subgoal_tac "dom K Int dom H = {} &
              H ++ K = K ++ H &
              semanticsAss ass2 (s(| oheap := K |)) &
              semanticsAss ass1 (s(| oheap := H |))")
apply(auto)
apply(simp add: Int_def dom_def)
apply(auto)
apply(rule)
apply(case_tac "H x")
apply(simp add: dom_def Int_def override_def)
apply(auto)
apply(case_tac "K x")
apply(auto)
apply(case_tac "K x")
apply(simp add: dom_def Int_def override_def)
apply(simp add: dom_def Int_def override_def)
apply(auto)
apply(subgoal_tac "dom K Int dom H = {} &
              H ++ K = K ++ H &
              semanticsAss ass1 (s(| oheap := K |)) &
              semanticsAss ass2 (s(| oheap := H |))")
apply(auto)
apply(simp add: Int_def dom_def)
apply(auto)
apply(rule)
apply(case_tac "H x")
apply(simp add: dom_def Int_def override_def)
apply(auto)
apply(case_tac "K x")
apply(auto)
apply(case_tac "K x")
apply(simp_all add: dom_def Int_def override_def)
apply(auto)
done

(*no-abort condition omitted*)
constdefs triple::"assert => LetDec => assert => bool"
"triple p c q == 
  (ALL s.(semanticsAss p s -->
          (ALL rtv t. (((c,s,rtv,t) : eval_LetDec) --> (semanticsAss q t)))))"

constdefs Var2Exp::"Vname => exp"
"Var2Exp x == PROPexp (VALop (VARval x))"

constdefs mkSingle::"Vname => Obj => assert"
"mkSingle x OBJ == single (Var2Exp x) OBJ"

consts modifies::"LetDec => Vname set"
primrec
"modifies (VOIDdec primop) = {}"
"modifies (VALdec x primop) = {x}"

constdefs subheap::"ObjHeap => ObjHeap => bool"
"subheap H0 H == (ALL x OBJ. (H0 x = Some OBJ --> H x = Some OBJ))"

(*
lemma "(\<langle>c,s\<rangle> \<longrightarrow>\<^sub>l \<langle>rtv,t\<rangle> &
        H0 ++ H1 = (oheap s) & (dom H0) Int (dom H1) = {} & 
        \<langle>c,s(|oheap := H0|)\<rangle> \<longrightarrow>\<^sub>l \<langle>rtvv,tt\<rangle>) --> (dom (oheap tt)) Int (dom H1) = {} & oheap t = oheap tt ++ H1"
apply(clarify)
apply(case_tac c)
apply(clarify)
apply(case_tac "PrimOp")
apply(simp_all)
apply(clarify)
apply(case_tac "Value")
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(simp_all add:get_local_def)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(simp_all add: lupd_def tick_def get_local_def dom_def Int_def)
apply(clarify)
apply(rule)
apply(auto)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(simp_all add: lupd_def tick_def get_local_def dom_def Int_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(erule eval_Value.elims)
apply(simp_all add: lupd_def tick_def get_local_def dom_def Int_def)
apply(clarify)
apply(rule)
apply(erule eval_Value.elims)
apply(simp_all add: lupd_def tick_def get_local_def dom_def Int_def)
apply(auto)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(erule eval_Value.elims)
apply(simp_all add: lupd_def tick_def get_local_def dom_def Int_def)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp add: override_def lupd_def tick_def get_local_def dom_def Int_def)
apply(clarify)
apply(auto)
apply(subgoal_tac "(ALL a b. H0 x ~= Some (a, b)) | (ALL a b. H1 x ~= Some (a, b))")
apply(auto)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(erule eval_Value.elims)
apply(simp_all add: lupd_def tick_def get_local_def dom_def Int_def)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp add: override_def lupd_def tick_def get_local_def dom_def Int_def)
apply(clarify)
apply(clarify)
apply(auto)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(erule eval_Value.elims)
apply(erule eval_Value.elims)
apply(erule eval_Value.elims)
apply(simp_all add: lupd_def tick_def get_local_def dom_def Int_def)
apply(clarify)
apply(auto)
apply(erule eval_Value.elims)
apply(erule eval_Value.elims)
apply(simp_all add: lupd_def tick_def get_local_def dom_def Int_def)
apply(clarify)
apply(auto)
apply(erule eval_Value.elims)
apply(erule eval_Value.elims)
apply(simp_all add: lupd_def tick_def get_local_def dom_def Int_def)
apply(clarify)
apply(auto)
apply(erule eval_Value.elims)
apply(erule eval_Value.elims)
apply(erule eval_Value.elims)
apply(simp_all add: lupd_def tick_def get_local_def dom_def Int_def)
apply(erule eval_Value.elims)
apply(clarify)
apply(auto)
apply(erule eval_Value.elims)
apply(erule eval_Value.elims)
apply(simp_all add: lupd_def tick_def get_local_def dom_def Int_def)
apply(erule eval_Value.elims)
apply(clarify)
apply(auto)
apply(auto)
apply(erule eval_Value.elims)
apply(erule eval_Value.elims)
apply(simp_all add: lupd_def tick_def get_local_def dom_def Int_def)
apply(erule eval_Value.elims)
apply(clarify)
apply(auto)
apply(auto)
apply(erule eval_Value.elims)
apply(erule eval_Value.elims)
apply(erule eval_Value.elims)
apply(simp_all add: lupd_def tick_def get_local_def dom_def Int_def)
apply(erule eval_Value.elims)
apply(clarify)
apply(auto)
apply(erule eval_Value.elims)
apply(erule eval_Value.elims)
apply(simp_all add: lupd_def tick_def get_local_def dom_def Int_def)
apply(erule eval_Value.elims)
apply(clarify)
apply(auto)
apply(auto)
apply(erule eval_Value.elims)
apply(erule eval_Value.elims)
apply(simp_all add: lupd_def tick_def get_local_def dom_def Int_def)
apply(erule eval_Value.elims)
apply(clarify)
apply(auto)
apply(auto)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(erule eval_Value.elims)
apply(erule eval_Value.elims)
apply(erule eval_Value.elims)
apply(simp_all add: lupd_def tick_def get_local_def dom_def Int_def)
apply(clarify)
apply(auto)
apply(erule eval_Value.elims)
apply(erule eval_Value.elims)
apply(simp_all add: lupd_def tick_def get_local_def dom_def Int_def)
apply(clarify)
apply(auto)
apply(erule eval_Value.elims)
apply(erule eval_Value.elims)
apply(simp_all add: lupd_def tick_def get_local_def dom_def Int_def)
apply(clarify)
apply(auto)
apply(erule eval_Value.elims)
apply(erule eval_Value.elims)
apply(erule eval_Value.elims)
apply(simp_all add: lupd_def tick_def get_local_def dom_def Int_def)
apply(erule eval_Value.elims)
apply(simp_all add: lupd_def tick_def get_local_def dom_def Int_def)
apply(clarify)
apply(auto)
apply(erule eval_Value.elims)
apply(erule eval_Value.elims)
apply(simp_all add: lupd_def tick_def get_local_def dom_def Int_def)
apply(erule eval_Value.elims)
apply(simp_all add: lupd_def tick_def get_local_def dom_def Int_def)
apply(clarify)
apply(auto)
apply(erule eval_Value.elims)
apply(erule eval_Value.elims)
apply(simp_all add: lupd_def tick_def get_local_def dom_def Int_def)
apply(erule eval_Value.elims)
apply(simp_all add: lupd_def tick_def get_local_def dom_def Int_def)
apply(clarify)
apply(auto)
apply(erule eval_Value.elims)
apply(erule eval_Value.elims)
apply(erule eval_Value.elims)
apply(simp_all add: lupd_def tick_def get_local_def dom_def Int_def)
apply(erule eval_Value.elims)
apply(simp_all add: lupd_def tick_def get_local_def dom_def Int_def)
apply(clarify)
apply(auto)
apply(erule eval_Value.elims)
apply(erule eval_Value.elims)
apply(simp_all add: lupd_def tick_def get_local_def dom_def Int_def)
apply(erule eval_Value.elims)
apply(simp_all add: lupd_def tick_def get_local_def dom_def Int_def)
apply(clarify)
apply(auto)
apply(erule eval_Value.elims)
apply(erule eval_Value.elims)
apply(simp_all add: lupd_def tick_def get_local_def dom_def Int_def)
apply(erule eval_Value.elims)
apply(simp_all add: lupd_def tick_def get_local_def dom_def Int_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(simp_all add: override_def new_obj_def lupd_def tick_def get_local_def dom_def Int_def)
apply(case_tac "x = la")
apply(auto)
apply(simp add: newAddr_def)
apply(case_tac "H0 la")
apply(auto)
apply(case_tac "oheap s la")
apply(auto)
apply(subgoal_tac "l=la")
apply(clarify)
apply(auto)
apply(case_tac "option_case (H0 la) Some (H1 la)")
apply(simp_all)
apply(auto)
apply(subgoal_tac "(%x. option_case (H0 x) Some (H1 x)) la = None")
apply(auto)
oops
*)

constdefs without::"ObjHeap => loc set => ObjHeap"
"without H locs l == (if l:locs then None else H l)"

lemma FrameRule:
  "ALL r.
   (((((fv r) Int (modifies c)) = {}) & (triple p c q))
    --> (triple (star p r) c (star q r)))"
apply(clarify)
apply(simp add: triple_def)
apply(auto)
apply(subgoal_tac "dom (without (oheap t) (dom H)) Int dom K = {} &
                   oheap t = (without (oheap t) (dom H)) ++ K & semanticsAss q (t(| oheap := (without (oheap t) (dom H)) |)) & semanticsAss r (t(| oheap := K |))")
apply(auto)


lemma FrameRule:
  "ALL r.
   (((((fv r) Int (modifies c)) = {}) & (triple p c q))
    --> (triple (star p r) c (star q r)))"
apply(auto)
apply(case_tac "r")
apply(simp add: triple_def)
apply(auto)
apply(rule)
apply(rule)
apply(subgoal_tac "dom (oheap s) Int (dom empty) = {} &
              oheap t = (oheap s) ++ empty & semanticsAss q (t(| oheap := oheap s |)) & (dom empty) = {}")
apply(auto)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(simp_all add: lupd_def tick_def dom_def Int_def get_local_def)
apply(clarify)
apply(rule)
apply(rule)
apply(subgoal_tac "(ALL x. (ALL a b. (H ++ K) x ~= Some (a, b)) | (ALL a b. empty x ~= Some (a, b))) &
              H ++ K = (H ++ K) ++ empty &
              semanticsAss q
               (sc(| clock := Suc (clock sc),
                     locals := locals sc(str|->the (locals sc xb)), oheap := H ++ K |)) &
              (ALL x a b. empty x ~= Some (a, b))")
apply(auto)
apply(simp add: override_def)
oops
apply(auto)
apply(erule eval_Value.elims)
apply(erule eval_Value.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(simp add: override_def new_obj_def)
apply(auto)
apply(case_tac "oheap sb l")
apply(auto)
apply(simp add: newAddr_def)
apply(subgoal_tac "option_case (H l) Some (K l) = None")
apply(auto)
apply(case_tac "H l")
apply(auto)
apply(case_tac "K l")
apply(auto)
apply(subgoal_tac "(ALL a b. H l ~= Some (a, b)) | (ALL a b. K l ~= Some (a, b))")
apply(auto)

apply(subgoal_tac "semanticsAss q (lupd str (sc<xb>) (tick sc(| oheap := H |)))")
prefer 2
apply(subgoal_tac "\<langle>VALdec str
                               (VALop
                                 (VARval
                                   xb)),sc(| oheap := H |)\<rangle> \<longrightarrow>\<^sub>l \<langle>rtVoid,lupd str (sc<xb>) (tick sc(| oheap := H |))\<rangle>")
apply(auto)
apply(simp add: lupd_def tick_def get_local_def)
apply(subgoal_tac "oheap lupd' str|->sc<xb> tick sc = H ++ K")
prefer 2
apply(rule)
apply(simp add: lupd_def get_local_def tick_def dom_def)
apply(subgoal_tac "dom H Int dom K = {}")
prefer 2
apply(simp add: dom_def Int_def)
apply(rule)
apply(rule)
apply(rule)
apply(assumption)
apply(rule)
apply(assumption)
apply(rule)
apply(auto)
apply(simp add: lupd_def tick_def get_local_def dom_def override_def)
apply(case_tac "semanticsAss q
            (sc(| clock := Suc (clock sc), locals := locals sc(str|->the (locals sc xb)),
                  oheap := H |))")
apply(auto)
apply(simp add: update_def)
apply(subgoal_tac "sc(| clock := Suc (clock sc), oheap := H,
                 locals := locals sc(str|->the (locals sc xb)) |) =
                   sc(| clock := Suc (clock sc), locals := locals sc(str|->the (locals sc xb)),
                  oheap := H |)")
prefer 2
apply(rule)
apply(rule)
apply(auto)
apply(subgoal_tac "dom H Int dom K = {} &
              H ++ K = H ++ K &
              semanticsAss q (lupd str (sc<xb>) (tick sc(| oheap := H |))) & dom K = {}")
apply(auto)
prefer 2
apply(simp add: lupd_def get_local_def tick_def dom_def)
apply(induct_tac r)
oops

apply(subgoal_tac "dom H Int dom K = {} &
              oheap (lupd str (sc<xb>) (tick sc)) = H ++ K &
              semanticsAss q (lupd str (sc<xb>) (tick sc(| oheap := H |))) &
              semanticsAss r (lupd str (sc<xb>) (tick sc(| oheap := K |)))")
apply(auto)
apply(rule)
apply(simp add: get_local_def tick_def lupd_def dom_def override_def Int_def)
apply(auto)


lemma LookupLocal:
  "(v ~= vv & OBJ = (Cn,flds) & fdesc = FDESC tp fld & flds fld = Some rtv)
   --> 
   (triple (conj (equals (Var2Exp v) (Var2Exp vv))
                 (mkSingle x OBJ))
           (VALdec v (GETFIELDop x fdesc))
           (conj (equals (Var2Exp v) (RTVexp rtv))
                 (mkSingle (if x=v then vv else x) OBJ)))"
apply(clarify)
apply(simp add: triple_def mkSingle_def Var2Exp_def dom_def get_local_def)
apply(auto)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(simp_all)
apply(simp add: get_local_def tick_def lupd_def get_field_def get_obj_def)
apply(auto)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(simp_all)
apply(simp add: get_local_def tick_def lupd_def get_field_def get_obj_def)
apply(auto)
apply(case_tac "vv = v")
apply(auto)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(simp_all)
apply(simp add: get_local_def tick_def lupd_def get_field_def get_obj_def)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(simp_all)
apply(simp add: get_local_def tick_def lupd_def get_field_def get_obj_def)
apply(auto)
apply(case_tac "vv=v")
apply(auto)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(simp_all)
apply(simp add: get_local_def tick_def lupd_def get_field_def get_obj_def)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(simp_all)
apply(simp add: get_local_def tick_def lupd_def get_field_def get_obj_def)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(simp_all)
apply(simp add: get_local_def tick_def lupd_def get_field_def get_obj_def)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(simp_all)
apply(simp add: get_local_def tick_def lupd_def get_field_def get_obj_def)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(simp_all)
apply(simp add: get_local_def tick_def lupd_def get_field_def get_obj_def)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(simp_all)
apply(simp add: get_local_def tick_def lupd_def get_field_def get_obj_def)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(simp_all)
apply(simp add: get_local_def tick_def lupd_def get_field_def get_obj_def)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(simp_all)
apply(simp add: get_local_def tick_def lupd_def get_field_def get_obj_def)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(simp_all)
apply(simp add: get_local_def tick_def lupd_def get_field_def get_obj_def)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(simp_all)
apply(simp add: get_local_def tick_def lupd_def get_field_def get_obj_def)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(simp_all)
apply(simp add: get_local_def tick_def lupd_def get_field_def get_obj_def)
done

lemma AllocationLocal:
  "triple emp (VALdec v (NEWop Cn)) (mkSingle v (Cn,empty))"
apply(simp add: triple_def mkSingle_def)
apply(auto)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(auto)
apply(simp add: dom_def lupd_def tick_def new_obj_def Var2Exp_def get_local_def empty_def)
done

lemma MutationLocal:"(OBJ = (Cn,flds) & fdesc = FDESC C fld & newObj = (Cn,flds( fld |-> rtv)))
       --> 
       (triple (conj (mkSingle x OBJ) 
                     (equals (PROPexp (VALop v)) (RTVexp rtv)))
              (VOIDdec (PUTFIELDop x fdesc v))
              (single (PROPexp (VALop (VARval x))) newObj))"
apply(clarify)
apply(simp add: triple_def mkSingle_def)
apply(auto)
apply(simp add: dom_def get_local_def)
apply(erule eval_LetDec.elims)
apply(simp)
apply(erule eval_PrimOp.elims)
apply(simp)
apply(erule eval_Value.elims)
apply(simp)
apply(erule eval_Value.elims)
apply(simp)
apply(auto)
apply(erule eval_Value.elims)
apply(simp)
apply(erule eval_Value.elims)
apply(simp)
apply(auto)
apply(simp add: get_local_def dom_def tick_def put_field_def upd_obj_def Let_def)
apply(auto)
apply(subgoal_tac "(l = l -->
               {a. a ~= l --> (EX aa b. oheap sa a = Some (aa, b))} = {l} &
               flds(fld|->the (locals sa xa)) = flds(fld|->rtv)) &
              (l ~= l -->
               {a. a ~= l --> (EX aa b. oheap sa a = Some (aa, b))} = {l} &
               l = l & oheap sa l = Some (Cn, flds(fld|->rtv)))")
apply(auto)
apply(simp add: if_def get_local_def Var2Exp_def)
apply(rule)
apply(auto)
apply(case_tac "a : {a. EX aa b. oheap sa a = Some (aa, b)}")
apply(auto)
apply(case_tac "a : {a. EX aa b. oheap sa a = Some (aa, b)}")
apply(auto)
apply(case_tac "a : {a. EX aa b. oheap sa a = Some (aa, b)}")
apply(auto)
apply(simp add: get_local_def dom_def Var2Exp_def)
apply(rule)
apply(auto)
apply(case_tac "locals sa xa")
apply(auto)
apply(simp add: get_local_def)
apply(simp add: tick_def put_field_def Var2Exp_def get_local_def dom_def upd_obj_def Let_def)
apply(auto)
apply(simp add: tick_def put_field_def Var2Exp_def get_local_def dom_def upd_obj_def Let_def)
apply(auto)
apply(erule eval_LetDec.elims)
apply(simp)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(simp_all add: tick_def put_field_def Var2Exp_def get_local_def dom_def upd_obj_def Let_def)
apply(auto)
done

lemma RuleOfConsequence:
  "((ALL s. ((semanticsAss pp s) --> (semanticsAss p s))) &
    (triple p c q) &
    (ALL s. ((semanticsAss q s) --> (semanticsAss qq s)))) 
   --> 
   (triple pp c qq)"
apply(clarify)
apply(simp add: triple_def)
apply(auto)
done

(*this should become Mutation (global*)
lemma "(OBJ = (Cn,flds) & 
        fdesc = FDESC C fld & 
        newObj = (Cn,flds( fld |-> rtv)))
       --> 
       (triple (conj (star (mkSingle x OBJ) r) 
                     (equals (PROPexp (VALop v)) (RTVexp rtv)))
              (VOIDdec (PUTFIELDop x fdesc v))
              (star (single (PROPexp (VALop (VARval x))) newObj) r))"
apply(clarify)
apply(simp add: triple_def mkSingle_def)
apply(simp add: dom_def get_local_def)
apply(auto)
prefer 2
apply(erule eval_LetDec.elims)
apply(simp)
apply(erule eval_PrimOp.elims)
apply(simp)
apply(erule eval_Value.elims)
apply(simp)
apply(erule eval_Value.elims)
apply(simp)
apply(clarify)
apply(clarify)
apply(clarify)
apply(clarify)
apply(clarify)
apply(clarify)
apply(simp add: Let_def tick_def put_field_def upd_obj_def)
apply(erule eval_Value.elims)
apply(simp)
apply(erule eval_Value.elims)
apply(simp)
apply(clarify)
apply(simp add: get_local_def)
apply(clarify)
apply(simp add: get_local_def)
apply(clarify)
apply(clarify)
(*now 1 goal left*)
apply(simp add: Int_def override_def)
apply(erule eval_LetDec.elims)
apply(simp)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(simp add:get_local_def tick_def put_field_def upd_obj_def dom_def Let_def)
apply(auto)
apply(subgoal_tac "(ALL x.
                  (ALL a b. H x ~= Some (a, b)) |
                  (ALL a b. K x ~= Some (a, b))) &
              (%x. option_case (H x) Some (K x))(l
              |->(aa, b(fld|->the (locals sd xc)))) =
              (%x. option_case (H x) Some (K x)) &
              {a. EX aa b. H a = Some (aa, b)} = {l} &
              H l = Some (Cn, flds(fld|->rtv)) &
              semanticsAss r
               (sd(| oheap := (%x. option_case (H x) Some (K x))(l
                       |->(aa, b(fld|->the (locals sd xc)))),
                     clock := Suc (clock sd), oheap := K |))")
apply(auto)
apply(subgoal_tac "(ALL x.
                  (ALL a b. H x ~= Some (a, b)) |
                  (ALL a b. K x ~= Some (a, b))) &
              (%x. option_case (H x) Some (K x)) =
              (%x. option_case (H x) Some (K x)) &
              {a. EX aa b. H a = Some (aa, b)} = {l} &
              H l = Some (Cn, flds) &
              semanticsAss r
               (sd(| oheap := %x. option_case (H x) Some (K x),
                     clock := Suc (clock sd), oheap := K |))")
apply(auto)
prefer 2
apply(rule)
apply(auto)
apply(case_tac "locals sd xc")
apply(auto)
apply(case_tac "K l")
apply(auto)
apply(rule)
oops
