theory TwoOneList = ListPred + ListReverseProgram:
(*Verification of Reynolds' ListRev for the input list [2,1], 
  plus some experimental stuff also using conrrete input data*)

(* -------------------- Concrete states and verification* ----------------*)

(*concrete states*)
constdefs intCons:: "loc => int => loc => ObjHeap => ObjHeap"
"intCons loc1 n loc2 H == 
 H( loc1 |-> (LIST, empty(head |-> (rtInt n))(tail |-> (rtRef (locRef loc2))) ))"

constdefs mkState:: "ObjHeap => State"
"mkState H == \<lparr> oheap = H, heap = emptyHeap, locals = emptyLocals, clock = 0, heapsz = 0 \<rparr>"

constdefs myListOne:: "Obj"
"myListOne == (LIST, empty(head |-> (rtInt(int 1)))(tail |-> rtRef(nullRef)))"

constdefs oneObjHeap:: "ObjHeap"
"oneObjHeap == empty(l1 |-> myListOne)"

constdefs oneState:: "State"
"oneState == mkState oneObjHeap"

constdefs twoOneObjHeap:: "ObjHeap"
"twoOneObjHeap == intCons l2 2 l1 oneObjHeap"

lemma "dom twoOneObjHeap = {l1,l2}"
apply(simp add: twoOneObjHeap_def oneObjHeap_def intCons_def)
apply(auto)
done

constdefs twoOneState:: "State"
"twoOneState == mkState twoOneObjHeap"

lemma "listPred [(int 1)] (rtRef (locRef l1)) (rtRef nullRef) oneState"
apply(auto)
apply(subgoal_tac " single l1 (LIST, empty(head|->rtInt 1)(tail|->rtRef nullRef)) oneState ")
apply(auto)
apply(simp_all add: single_def oneState_def mkState_def)
apply(simp_all add: oneObjHeap_def dom_def)
apply(simp_all add: myListOne_def)
done

lemma "(l1 ~= l2) -->
       (listPred [int 2, int 1]
                (rtRef (locRef l2))
                (rtRef nullRef)
                twoOneState)"
apply(clarify)
apply(subgoal_tac " extStar (single l2 (LIST, empty(head|->rtInt 2)(tail|->rtRef (locRef l1))))
            (listPredLoc [1] l1 (rtRef nullRef)) (restr (oheap twoOneState) {l2})
            (restr (oheap twoOneState) (dom (oheap twoOneState) - {l2})) twoOneState")
apply(auto)
apply(simp add: extStar_def single_def twoOneState_def mkState_def twoOneObjHeap_def oneObjHeap_def intCons_def myListOne_def)
apply(auto)
apply(simp_all add:dom_def restr_def orthogonal_def extEq_def)
apply(auto)
apply(case_tac "x = l2")
apply(auto)
apply(case_tac "x = l1")
apply(auto)
apply(simp add:override_def)
done

lemma "(l1 = l2) -->
       (listPred [int 2]
                (rtRef (locRef l2))
                (rtRef (locRef l2))
                twoOneState)"
apply(clarify)
apply(simp add: extStar_def single_def twoOneState_def mkState_def twoOneObjHeap_def oneObjHeap_def intCons_def myListOne_def dom_def restr_def orthogonal_def extEq_def override_def emp_def)
apply(auto)
done

constdefs myList:: "int list"
"myList == [2,1]"

constdefs loopInvAux::"(int list) => (int list) => ObjHeap => ObjHeap => ass"
"loopInvAux a b K L s == (i: dom (locals s) & 
               j: dom (locals s) &
               (extStar (listPred a (get_local s i) (rtRef nullRef)) 
                                      (listPred b (get_local s j) (rtRef nullRef)) 
                                      K L s)
               & 
               reverse myList = (reverse a) @ b
               )"

constdefs loopInv:: "ass"
"loopInv s == (EX a b K L. (loopInvAux a b K L s))"

consts mySingleAux2:: "Reference => Obj => ass"
primrec
"mySingleAux2 nullRef obj s = False"
"mySingleAux2 (locRef l) obj s = single l obj s"

consts mySingleAux1:: "RTVal => Obj => ass"
primrec
"mySingleAux1 (rtRef r) obj s = mySingleAux2 r obj s"
"mySingleAux1 (rtInt n) obj s = False"
"mySingleAux1 (rtBool b) obj s = False"
"mySingleAux1 (rtString str) obj s = False"
"mySingleAux1 (rtVoid) obj s = False"

constdefs mySingle :: "Vname => Obj => ass"
"mySingle x obj s == mySingleAux1 (s<x>)  obj s"

constdefs loopBeforeOne::"int => (int list) => (int list) => ass"
"loopBeforeOne A a b s == (i: dom (locals s) & 
                     j: dom (locals s) &
                    (EX exK M N K L. (extStar (mySingle i (mkLIST A exK))
                                             ((extStar (listPred a (get_local s k) (rtRef nullRef)) 
                                                       (listPred b (get_local s j) (rtRef nullRef)) 
                                                        K L))
                                            M N s
                              &  
                              reverse myList = (reverse (A # a)) @ b)
                    )  
                   )"

constdefs InitialState :: "State"
"InitialState == lupd i (rtRef (locRef l2)) twoOneState"

lemma AuxLemma1: "((i ~= j & l1 ~= l2 & a = [2,1] & b = [] & L = empty & K = (empty(l1
                           |->(LIST, empty(head|->rtInt 1)(tail
                               |->rtRef nullRef)))
                           (l2|->(LIST, empty(head|->rtInt 2)(tail
                                  |->rtRef (locRef l1)))))) -->
       (
           (listPredLoc a l2 (rtRef nullRef)
                   (| oheap = K, heap = %l. None,
                      locals = (%x. None)(i|->rtRef (locRef l2))(j
                        |->rtRef nullRef),
                      clock = Suc 0, heapsz = 0 |) &
                  b = [] &
                  (orthogonal K L &
                         extEq (K ++ L)
                          (empty(l1
                           |->(LIST, empty(head|->rtInt 1)(tail
                               |->rtRef nullRef)))
                           (l2|->(LIST, empty(head|->rtInt 2)(tail
                                  |->rtRef (locRef l1))))))) &
           [1, 2] = reverse a @ b
       ))"
apply(clarify)
apply(case_tac "[2,1]=[]")
apply(simp_all)
apply(rule)
prefer 2
apply(simp add:orthogonal_def extEq_def dom_def)
apply(simp add:set_diff_def)
apply(subgoal_tac "extStar
                (single l2
                  (LIST, empty(head|->rtInt 2)(tail|->rtRef (locRef l1))))
                (listPredLoc [1] l1 (rtRef nullRef))
                (restr
                  (empty(l1
                   |->(LIST, empty(head|->rtInt 1)(tail|->rtRef nullRef)))
                   (l2|->(LIST, empty(head|->rtInt 2)(tail
                          |->rtRef (locRef l1)))))
                  {l2})
                (restr
                  (empty(l1
                   |->(LIST, empty(head|->rtInt 1)(tail|->rtRef nullRef)))
                   (l2|->(LIST, empty(head|->rtInt 2)(tail
                          |->rtRef (locRef l1)))))
                  {x. x = l1 & x ~= l2})
                (| oheap = empty(l1
                     |->(LIST, empty(head|->rtInt 1)(tail|->rtRef nullRef)))
                     (l2|->(LIST, empty(head|->rtInt 2)(tail
                            |->rtRef (locRef l1)))),
                   heap = %l. None,
                   locals = (%x. None)(i|->rtRef (locRef l2))(j
                     |->rtRef nullRef),
                   clock = Suc 0, heapsz = 0 |)")
apply(simp_all add: extStar_def restr_def)
apply(auto)
apply(simp add: single_def dom_def)
apply(simp add: single_def dom_def)
apply(auto)
apply(simp add: orthogonal_def dom_def Int_def)
apply(simp add:extEq_def)
apply(auto)
apply(simp add:override_def)
done

lemma AuxLemma2: "[1,2] = reverse [2,1] @ []"
apply(simp)
done

constdefs S1 :: "State"
"S1 == tick (lupd j (rtRef nullRef) InitialState)"

lemma "(VALdec j (VALop (NULLval LIST)), InitialState, rtv, t) \<in> eval_LetDec --> (t = S1)"
apply(clarify)
apply(simp_all add: S1_def InitialState_def twoOneState_def mkState_def twoOneObjHeap_def intCons_def oneObjHeap_def emptyHeap_def emptyLocals_def myListOne_def)
apply(erule eval_LetDec.elims)
apply(auto)
apply(erule eval_PrimOp.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(simp_all add: InitialState_def twoOneState_def mkState_def twoOneObjHeap_def loopInv_def lupd_def tick_def)
done

lemma "( i ~= j & l1 ~= l2) --> ((S1<i> ~= rtRef(nullRef)) & loopInv S1) "
apply(clarify)
apply(simp_all add: loopInv_def S1_def tick_def InitialState_def intCons_def oneObjHeap_def emptyHeap_def emptyLocals_def 
                    myListOne_def twoOneState_def lupd_def mkState_def twoOneObjHeap_def oneObjHeap_def myListOne_def get_local_def)
apply(subgoal_tac "
           loopInvAux [2,1] [] (empty(l1 |-> (LIST, empty(head |-> rtInt 1)(tail |-> rtRef nullRef)))
                                     (l2 |-> (LIST, empty(head |-> rtInt 2)(tail |-> rtRef (locRef l1)))))
                               empty
                               (| oheap = empty(l1 |-> (LIST, empty(head|->rtInt 1)(tail|->rtRef nullRef)))
                                               (l2 |-> (LIST, empty(head|->rtInt 2)(tail|->rtRef (locRef l1)))),
                                  heap = %l. None,
                                  locals = (%x. None)(i|->rtRef (locRef l2))(j |->rtRef nullRef),
                                  clock = Suc 0, 
                                  heapsz = 0 |)")
apply(auto)
apply(simp_all add: tick_def get_local_def loopInvAux_def loopInv_def emptyObjHeap_def)
apply(simp_all only: extStar_def twoOneState_def myList_def get_local_def)
apply(simp_all add:dom_def lupd_def mkState_def twoOneObjHeap_def emptyLocals_def intCons_def oneObjHeap_def myListOne_def )
apply(simp_all add: extEq_def single_def extStar_def restr_def)
apply(simp_all add: dom_def orthogonal_def)
apply(auto)
apply(case_tac "((%a. if a = l2
              then (empty(l1
                    |->(LIST, empty(head|->rtInt 1)(tail|->rtRef nullRef)))
                    (l2|->(LIST, empty(head|->rtInt 2)(tail
                           |->rtRef (locRef l1)))))
                    a
              else None) ++
         (%a. if (a ~= l1 --> a = l2) & a ~= l2
              then (empty(l1
                    |->(LIST, empty(head|->rtInt 1)(tail|->rtRef nullRef)))
                    (l2|->(LIST, empty(head|->rtInt 2)(tail
                           |->rtRef (locRef l1)))))
                    a
              else None))
         l2")
apply(auto)
done

(* S2 represents the state after executing the first instructionn of the
   loop during the first iteration*)
constdefs S2::"State"
"S2 == tick( lupd k (rtRef (locRef l1)) S1)"

lemma "(head ~= tail & i ~= j & j ~= k & i ~= k & l1 ~= l2 & 
        (VALdec k (GETFIELDop i tailDesc),S1,rtv,t) \<in> eval_LetDec) 
       --> (t = S2)" 
apply(clarify)
apply(simp_all add: S1_def S2_def InitialState_def twoOneState_def mkState_def 
                    twoOneObjHeap_def intCons_def oneObjHeap_def emptyHeap_def emptyLocals_def myListOne_def tick_def lupd_def)
apply(erule eval_LetDec.elims)
apply(auto)
apply(erule eval_PrimOp.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(simp_all add: lupd_def tick_def get_field_def get_obj_def headDesc_def tailDesc_def get_local_def)
done

constdefs Aux7::"int list => int list => ObjHeap => ObjHeap => ass"
"Aux7 a b K L s == 
  (extStar (listPred a (get_local s k) (rtRef nullRef)) 
           (listPred b (get_local s j) (rtRef nullRef)) 
           K 
           L
           s)"
constdefs Aux6:: "(int list) => (int list) =>  ass"
"Aux6 a b s == EX K L. Aux7 a b (restr (oheap s) K) (restr (oheap s) L) s"
constdefs Aux5::"int => (int list) => (int list) => (loc set) => (loc set) => 
                 ass"
"Aux5 A a b M N s == EX rtv.
                     extStar (mySingle i (mkLIST A rtv))
                             (Aux6 a b) 
                             (restr (oheap s) M)
                             (restr (oheap s) N)
                             s"
constdefs Aux4::"int => (int list) => (int list) => ass"
"Aux4 A a b s == EX M N. Aux5 A a b M N s"
constdefs Aux3::"int => (int list) => (int list) => ass"
"Aux3 A a b s ==
    i: dom (locals s) & 
    j: dom (locals s) &
    k: dom (locals s) &
    reverse myList = (reverse (A # a)) @ b &
    Aux4 A a b s"
constdefs Aux2::"int => (int list) => ass"
"Aux2 A a s == EX b. Aux3 A a b s"
constdefs Aux1::"int => ass"
"Aux1 A s == EX a. Aux2 A a s"

(*the propoerty holding for S2*)
constdefs Prop2::"ass"
"Prop2 s == EX A. Aux1 A s"

lemma "k: dom (locals S2)"
apply(simp add: S2_def dom_def tick_def lupd_def)
done
lemma "i: dom (locals S2)"
apply(simp add: S2_def dom_def tick_def lupd_def S1_def InitialState_def)
done
lemma "j: dom (locals S2)"
apply(simp add: S2_def dom_def tick_def lupd_def S1_def InitialState_def)
done

lemma "(head ~= tail & i ~= j & j ~= k & i ~= k & l1 ~= l2) --> (Prop2 S2)"
apply(clarify)
apply(simp add: Prop2_def S2_def tick_def lupd_def S1_def 
                InitialState_def twoOneState_def twoOneObjHeap_def intCons_def
                oneObjHeap_def myListOne_def mkState_def emptyHeap_def
                emptyLocals_def)
apply(subgoal_tac "Aux1 2 (| oheap = empty(l1
                    |->(LIST, empty(head|->rtInt 1)(tail|->rtRef nullRef)))
                    (l2|->(LIST, empty(head|->rtInt 2)(tail
                           |->rtRef (locRef l1)))),
                  heap = %l. None,
                  locals = (%x. None)(i|->rtRef (locRef l2))(j
                    |->rtRef nullRef)(k|->rtRef (locRef l1)),
                  clock = Suc (Suc 0), heapsz = 0 |)")
apply(auto)
apply(simp_all add:Aux1_def)
apply(subgoal_tac "Aux2 2 [1] (| oheap = empty(l1
                    |->(LIST, empty(head|->rtInt 1)(tail|->rtRef nullRef)))
                    (l2|->(LIST, empty(head|->rtInt 2)(tail
                           |->rtRef (locRef l1)))),
                  heap = %l. None,
                  locals = (%x. None)(i|->rtRef (locRef l2))(j
                    |->rtRef nullRef)(k|->rtRef (locRef l1)),
                  clock = Suc (Suc 0), heapsz = 0 |)")
apply(auto)
apply(simp_all add:Aux2_def)
apply(subgoal_tac "Aux3 2 [1] [] (| oheap = empty(l1
                    |->(LIST, empty(head|->rtInt 1)(tail|->rtRef nullRef)))
                    (l2|->(LIST, empty(head|->rtInt 2)(tail
                           |->rtRef (locRef l1)))),
                  heap = %l. None,
                  locals = (%x. None)(i|->rtRef (locRef l2))(j
                    |->rtRef nullRef)(k|->rtRef (locRef l1)),
                  clock = Suc (Suc 0), heapsz = 0 |)")
apply(auto)
apply(simp_all add:Aux3_def myList_def Aux4_def)
apply(subgoal_tac "Aux5 2 [1] [] {l2} {l1} (| oheap = empty(l1
                 |->(LIST, empty(head|->rtInt 1)(tail|->rtRef nullRef)))(l2
                 |->(LIST, empty(head|->rtInt 2)(tail
                     |->rtRef (locRef l1)))),
               heap = %l. None,
               locals = (%x. None)(i|->rtRef (locRef l2))(j|->rtRef nullRef)
                 (k|->rtRef (locRef l1)),
               clock = Suc (Suc 0), heapsz = 0 |)")
apply(auto)
apply(simp_all add:Aux5_def)
apply(subgoal_tac "extStar (mySingle i (mkLIST 2 (get_local (| oheap = empty(l1
                 |->(LIST, empty(head|->rtInt 1)(tail|->rtRef nullRef)))(l2
                 |->(LIST, empty(head|->rtInt 2)(tail
                     |->rtRef (locRef l1)))),
               heap = %l. None,
               locals = (%x. None)(i|->rtRef (locRef l2))(j|->rtRef nullRef)
                 (k|->rtRef (locRef l1)),
               clock = Suc (Suc 0), heapsz = 0 |) k))) (Aux6 [1] [])
            (restr
              (empty(l1
               |->(LIST, empty(head|->rtInt 1)(tail|->rtRef nullRef)))(l2
               |->(LIST, empty(head|->rtInt 2)(tail|->rtRef (locRef l1)))))
              {l2})
            (restr
              (empty(l1
               |->(LIST, empty(head|->rtInt 1)(tail|->rtRef nullRef)))(l2
               |->(LIST, empty(head|->rtInt 2)(tail|->rtRef (locRef l1)))))
              {l1})
            (| oheap = empty(l1
                 |->(LIST, empty(head|->rtInt 1)(tail|->rtRef nullRef)))(l2
                 |->(LIST, empty(head|->rtInt 2)(tail
                     |->rtRef (locRef l1)))),
               heap = %l. None,
               locals = (%x. None)(i|->rtRef (locRef l2))(j|->rtRef nullRef)
                 (k|->rtRef (locRef l1)),
               clock = Suc (Suc 0), heapsz = 0 |)")
apply(auto)
apply(simp add: get_local_def extStar_def mySingle_def restr_def)
apply(auto)
apply(simp_all add: get_local_def single_def dom_def)
apply(simp_all add: Aux6_def)
apply(subgoal_tac "Aux7 [1] []
            (restr
              (%a. if a = l1
                   then (empty(l1
                         |->(LIST, empty(head|->rtInt 1)(tail
                             |->rtRef nullRef)))
                         (l2|->(LIST, empty(head|->rtInt 2)(tail
                                |->rtRef (locRef l1)))))
                         a
                   else None) {l1})
                (restr
              (%a. if a = l1
                   then (empty(l1
                         |->(LIST, empty(head|->rtInt 1)(tail
                             |->rtRef nullRef)))
                         (l2|->(LIST, empty(head|->rtInt 2)(tail
                                |->rtRef (locRef l1)))))
                         a
                   else None) {})
              (| oheap =
                 %a. if a = l1
                     then (empty(l1
                           |->(LIST, empty(head|->rtInt 1)(tail
                               |->rtRef nullRef)))
                           (l2|->(LIST, empty(head|->rtInt 2)(tail
                                  |->rtRef (locRef l1)))))
                           a
                     else None,
               heap = %l. None,
               locals = (%x. None)(i|->rtRef (locRef l2))(j|->rtRef nullRef)
                 (k|->rtRef (locRef l1)),
               clock = Suc (Suc 0), heapsz = 0 |)")
apply(auto)
apply(simp_all add: Aux7_def restr_def extStar_def extEq_def
                    get_local_def single_def dom_def orthogonal_def override_def)
apply(auto)
done

constdefs S3::"State"
"S3 == tick( put_field S2 l2 tail (get_local S2 j))"

lemma "(head ~= tail & i ~= j & j ~= k & i ~= k & l1 ~= l2 & 
        (VOIDdec (PUTFIELDop i tailDesc (VARval j)),S2,rtv,t) 
        \<in> eval_LetDec)
       --> (t = S3)" 
apply(clarify)
apply(simp_all add: S1_def S2_def S3_def 
                    InitialState_def twoOneState_def mkState_def 
                    twoOneObjHeap_def intCons_def oneObjHeap_def emptyHeap_def
                    emptyLocals_def myListOne_def tick_def lupd_def 
                    put_field_def)
apply(erule eval_LetDec.elims)
apply(auto)
apply(erule eval_PrimOp.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(simp_all add: lupd_def tick_def get_field_def get_obj_def headDesc_def tailDesc_def get_local_def put_field_def)
done

(*Very similar to the lemma showing Prop2 S2*)
lemma "(head ~= tail & i ~= j & j ~= k & i ~= k & l1 ~= l2) --> (Prop2 S3)"
apply(clarify)
apply(simp add: Prop2_def S2_def S3_def tick_def lupd_def S1_def 
                InitialState_def twoOneState_def twoOneObjHeap_def intCons_def
                oneObjHeap_def myListOne_def mkState_def emptyHeap_def
                emptyLocals_def)
apply(subgoal_tac "Aux1 2
               (put_field
                 (| oheap = empty(l1
                      |->(LIST, empty(head|->rtInt 1)(tail
                          |->rtRef nullRef)))
                      (l2|->(LIST, empty(head|->rtInt 2)(tail
                             |->rtRef (locRef l1)))),
                    heap = %l. None,
                    locals = (%x. None)(i|->rtRef (locRef l2))(j
                      |->rtRef nullRef)(k|->rtRef (locRef l1)),
                    clock = Suc (Suc 0), heapsz = 0 |)
                 l2 tail
                 ((| oheap = empty(l1
                       |->(LIST, empty(head|->rtInt 1)(tail
                           |->rtRef nullRef)))
                       (l2|->(LIST, empty(head|->rtInt 2)(tail
                              |->rtRef (locRef l1)))),
                     heap = %l. None,
                     locals = (%x. None)(i|->rtRef (locRef l2))(j
                       |->rtRef nullRef)(k|->rtRef (locRef l1)),
                     clock = Suc (Suc 0), heapsz = 0 |)<j>)
                (| clock :=
                     Suc (clock
                           (put_field
                             (| oheap = empty(l1
                                  |->(LIST, empty(head|->rtInt 1)(tail
|->rtRef nullRef)))
                                  (l2|->(LIST, empty(head|->rtInt 2)(tail
   |->rtRef (locRef l1)))),
                                heap = %l. None,
                                locals = (%x. None)(i|->rtRef (locRef l2))(j
                                  |->rtRef nullRef)(k|->rtRef (locRef l1)),
                                clock = Suc (Suc 0), heapsz = 0 |)
                             l2 tail
                             ((| oheap = empty(l1
                                   |->(LIST, empty(head|->rtInt 1)(tail
 |->rtRef nullRef)))
                                   (l2|->(LIST, empty(head|->rtInt 2)(tail
    |->rtRef (locRef l1)))),
                                 heap = %l. None,
                                 locals = (%x. None)(i|->rtRef (locRef l2))
                                   (j|->rtRef nullRef)(k
                                   |->rtRef (locRef l1)),
                                 clock = Suc (Suc 0),
                                 heapsz = 0 |)<j>))) |))")
apply(auto)
apply(simp_all add:Aux1_def)
apply(subgoal_tac "Aux2 2 [1]
               (put_field
                 (| oheap = empty(l1
                      |->(LIST, empty(head|->rtInt 1)(tail
                          |->rtRef nullRef)))
                      (l2|->(LIST, empty(head|->rtInt 2)(tail
                             |->rtRef (locRef l1)))),
                    heap = %l. None,
                    locals = (%x. None)(i|->rtRef (locRef l2))(j
                      |->rtRef nullRef)(k|->rtRef (locRef l1)),
                    clock = Suc (Suc 0), heapsz = 0 |)
                 l2 tail
                 ((| oheap = empty(l1
                       |->(LIST, empty(head|->rtInt 1)(tail
                           |->rtRef nullRef)))
                       (l2|->(LIST, empty(head|->rtInt 2)(tail
                              |->rtRef (locRef l1)))),
                     heap = %l. None,
                     locals = (%x. None)(i|->rtRef (locRef l2))(j
                       |->rtRef nullRef)(k|->rtRef (locRef l1)),
                     clock = Suc (Suc 0), heapsz = 0 |)<j>)
                (| clock :=
                     Suc (clock
                           (put_field
                             (| oheap = empty(l1
                                  |->(LIST, empty(head|->rtInt 1)(tail
|->rtRef nullRef)))
                                  (l2|->(LIST, empty(head|->rtInt 2)(tail
   |->rtRef (locRef l1)))),
                                heap = %l. None,
                                locals = (%x. None)(i|->rtRef (locRef l2))(j
                                  |->rtRef nullRef)(k|->rtRef (locRef l1)),
                                clock = Suc (Suc 0), heapsz = 0 |)
                             l2 tail
                             ((| oheap = empty(l1
                                   |->(LIST, empty(head|->rtInt 1)(tail
 |->rtRef nullRef)))
                                   (l2|->(LIST, empty(head|->rtInt 2)(tail
    |->rtRef (locRef l1)))),
                                 heap = %l. None,
                                 locals = (%x. None)(i|->rtRef (locRef l2))
                                   (j|->rtRef nullRef)(k
                                   |->rtRef (locRef l1)),
                                 clock = Suc (Suc 0),
                                 heapsz = 0 |)<j>))) |))")
apply(auto)
apply(simp_all add:Aux2_def)
apply(subgoal_tac "Aux3 2 [1] []
               (put_field
                 (| oheap = empty(l1
                      |->(LIST, empty(head|->rtInt 1)(tail
                          |->rtRef nullRef)))
                      (l2|->(LIST, empty(head|->rtInt 2)(tail
                             |->rtRef (locRef l1)))),
                    heap = %l. None,
                    locals = (%x. None)(i|->rtRef (locRef l2))(j
                      |->rtRef nullRef)(k|->rtRef (locRef l1)),
                    clock = Suc (Suc 0), heapsz = 0 |)
                 l2 tail
                 ((| oheap = empty(l1
                       |->(LIST, empty(head|->rtInt 1)(tail
                           |->rtRef nullRef)))
                       (l2|->(LIST, empty(head|->rtInt 2)(tail
                              |->rtRef (locRef l1)))),
                     heap = %l. None,
                     locals = (%x. None)(i|->rtRef (locRef l2))(j
                       |->rtRef nullRef)(k|->rtRef (locRef l1)),
                     clock = Suc (Suc 0), heapsz = 0 |)<j>)
                (| clock :=
                     Suc (clock
                           (put_field
                             (| oheap = empty(l1
                                  |->(LIST, empty(head|->rtInt 1)(tail
|->rtRef nullRef)))
                                  (l2|->(LIST, empty(head|->rtInt 2)(tail
   |->rtRef (locRef l1)))),
                                heap = %l. None,
                                locals = (%x. None)(i|->rtRef (locRef l2))(j
                                  |->rtRef nullRef)(k|->rtRef (locRef l1)),
                                clock = Suc (Suc 0), heapsz = 0 |)
                             l2 tail
                             ((| oheap = empty(l1
                                   |->(LIST, empty(head|->rtInt 1)(tail
 |->rtRef nullRef)))
                                   (l2|->(LIST, empty(head|->rtInt 2)(tail
    |->rtRef (locRef l1)))),
                                 heap = %l. None,
                                 locals = (%x. None)(i|->rtRef (locRef l2))
                                   (j|->rtRef nullRef)(k
                                   |->rtRef (locRef l1)),
                                 clock = Suc (Suc 0),
                                 heapsz = 0 |)<j>))) |))")
apply(auto)
apply(simp_all add: Aux3_def myList_def Aux4_def get_local_def)
apply(auto)
apply(simp_all add:put_field_def upd_obj_def Let_def)
apply(subgoal_tac "Aux5 2 [1] [] {l2} {l1}
            (| oheap = empty(l1
                 |->(LIST, empty(head|->rtInt 1)(tail|->rtRef nullRef)))(l2
                 |->(LIST, empty(head|->rtInt 2)(tail|->rtRef nullRef))),
               heap = %l. None,
               locals = (%x. None)(i|->rtRef (locRef l2))(j|->rtRef nullRef)
                 (k|->rtRef (locRef l1)),
               clock = Suc (Suc (Suc 0)), heapsz = 0 |)")
apply(auto)
apply(simp_all add:Aux5_def)
apply(subgoal_tac "extStar (mySingle i (mkLIST 2 (get_local (| oheap = empty(l1
                 |->(LIST, empty(head|->rtInt 1)(tail|->rtRef nullRef)))(l2
                 |->(LIST, empty(head|->rtInt 2)(tail|->rtRef nullRef))),
               heap = %l. None,
               locals = (%x. None)(i|->rtRef (locRef l2))(j|->rtRef nullRef)
                 (k|->rtRef (locRef l1)),
               clock = Suc (Suc (Suc 0)), heapsz = 0 |) j))) (Aux6 [1] [])
            (restr
              (empty(l1
               |->(LIST, empty(head|->rtInt 1)(tail|->rtRef nullRef)))(l2
               |->(LIST, empty(head|->rtInt 2)(tail|->rtRef nullRef))))
              {l2})
            (restr
              (empty(l1
               |->(LIST, empty(head|->rtInt 1)(tail|->rtRef nullRef)))(l2
               |->(LIST, empty(head|->rtInt 2)(tail|->rtRef nullRef))))
              {l1})
            (| oheap = empty(l1
                 |->(LIST, empty(head|->rtInt 1)(tail|->rtRef nullRef)))(l2
                 |->(LIST, empty(head|->rtInt 2)(tail|->rtRef nullRef))),
               heap = %l. None,
               locals = (%x. None)(i|->rtRef (locRef l2))(j|->rtRef nullRef)
                 (k|->rtRef (locRef l1)),
               clock = Suc (Suc (Suc 0)), heapsz = 0 |)")
apply(auto)
apply(simp_all add: extStar_def mySingle_def restr_def get_local_def)
apply(auto)
apply(simp_all add: get_local_def single_def dom_def)
apply(simp_all add: Aux6_def)
apply(subgoal_tac "Aux7 [1] []
            (restr
              (%a. if a = l1
                   then (empty(l1
                         |->(LIST, empty(head|->rtInt 1)(tail
                             |->rtRef nullRef)))
                         (l2|->(LIST, empty(head|->rtInt 2)(tail
                                |->rtRef nullRef))))
                         a
                   else None)
              {l1})
            (restr
              (%a. if a = l1
                   then (empty(l1
                         |->(LIST, empty(head|->rtInt 1)(tail
                             |->rtRef nullRef)))
                         (l2|->(LIST, empty(head|->rtInt 2)(tail
                                |->rtRef nullRef))))
                         a
                   else None)
              {})
            (| oheap =
                 %a. if a = l1
                     then (empty(l1
                           |->(LIST, empty(head|->rtInt 1)(tail
                               |->rtRef nullRef)))
                           (l2|->(LIST, empty(head|->rtInt 2)(tail
                                  |->rtRef nullRef))))
                           a
                     else None,
               heap = %l. None,
               locals = (%x. None)(i|->rtRef (locRef l2))(j|->rtRef nullRef)
                 (k|->rtRef (locRef l1)),
               clock = Suc (Suc (Suc 0)), heapsz = 0 |)")
apply(auto)
apply(simp_all add: Aux7_def restr_def extStar_def extEq_def
                    get_local_def single_def dom_def orthogonal_def override_def)
apply(auto)
done

constdefs S4::"State"
"S4 == tick( lupd j (get_local S3 i) S3)"

lemma "(head ~= tail & i ~= j & j ~= k & i ~= k & l1 ~= l2) -->
       (S4 = tick (lupd j (rtRef(locRef l2)) S3))"
apply(clarify)
apply(simp add: S4_def S3_def S2_def tick_def get_local_def lupd_def
                put_field_def upd_obj_def Let_def S1_def InitialState_def 
                twoOneState_def mkState_def twoOneObjHeap_def intCons_def 
                oneObjHeap_def emptyHeap_def emptyLocals_def) 
done

lemma "(head ~= tail & i ~= j & j ~= k & i ~= k & l1 ~= l2 & 
        (VALdec j (VALop (VARval i)),S3,rtv,t) \<in> eval_LetDec)
       --> (t = S4)" 
apply(clarify)
apply(simp_all add: S1_def S2_def S3_def S4_def
                    InitialState_def twoOneState_def mkState_def 
                    twoOneObjHeap_def intCons_def oneObjHeap_def emptyHeap_def
                    emptyLocals_def myListOne_def tick_def lupd_def 
                    put_field_def)
apply(erule eval_LetDec.elims)
apply(auto)
apply(erule eval_PrimOp.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(simp_all add: lupd_def tick_def get_field_def get_obj_def headDesc_def 
                    tailDesc_def get_local_def put_field_def upd_obj_def)
done

constdefs Aux4_3::"(int list) => (int list) => ass"
"Aux4_3 a b s == 
  EX M N. (extStar (listPred a (get_local s k) (rtRef nullRef)) 
                   (listPred b (get_local s j) (rtRef nullRef)) 
                   M 
                   N
                   s)"

constdefs Aux4_2::"(int list) => (int list) => ass"
"Aux4_2 a b s ==
    i: dom (locals s) & 
    j: dom (locals s) &
    k: dom (locals s) &
    reverse myList = (reverse a) @ b &
    Aux4_3 a b s"
constdefs Aux4_1::"(int list) => ass"
"Aux4_1 a s == EX b. Aux4_2 a b s"

(*the propoerty holding for S2*)
constdefs Prop4::"ass"
"Prop4 s == EX a. Aux4_1 a s"

lemma "(head ~= tail & i ~= j & j ~= k & i ~= k & l1 ~= l2) --> (Prop4 S4)"
apply(clarify)
apply(simp add: Prop4_def)
apply(subgoal_tac "Aux4_1 [1] S4")
apply(auto)
apply(simp add:Aux4_1_def)
apply(subgoal_tac "Aux4_2 [1] [2] S4")
apply(auto)
apply(simp add:Aux4_2_def Aux4_3_def)
apply(subgoal_tac "extStar (listPred [1] (S4<k>) (rtRef nullRef))
                           (listPred [2] (S4<j>) (rtRef nullRef))
                           (restr (oheap S4) {l1})
                           (restr (oheap S4) {l2})
                           S4")
apply(auto)
apply(simp_all add: extStar_def restr_def S1_def S2_def S3_def S4_def
                    InitialState_def twoOneState_def mkState_def 
                    twoOneObjHeap_def intCons_def oneObjHeap_def emptyHeap_def
                    emptyLocals_def myListOne_def tick_def lupd_def 
                    put_field_def get_field_def get_obj_def headDesc_def 
                    tailDesc_def get_local_def upd_obj_def Let_def dom_def 
                    override_def orthogonal_def extEq_def single_def 
                    myList_def extStar_def)
apply(auto)
done

constdefs S5::"State"
"S5 == tick( lupd i (get_local S4 k) S4)"

lemma "(head ~= tail & i ~= j & j ~= k & i ~= k & l1 ~= l2) -->
       (S5 = tick (lupd i (rtRef(locRef l1)) S4))"
apply(clarify)
apply(simp add: S5_def S4_def S3_def S2_def tick_def get_local_def lupd_def
                put_field_def upd_obj_def Let_def S1_def InitialState_def 
                twoOneState_def mkState_def twoOneObjHeap_def intCons_def 
                oneObjHeap_def emptyHeap_def emptyLocals_def) 
apply(auto)
done

lemma "(head ~= tail & i ~= j & j ~= k & i ~= k & l1 ~= l2 & 
        (VALdec i (VALop (VARval k)),S4,rtv,t) \<in> eval_LetDec)
       --> (t = S5)" 
apply(clarify)
apply(simp_all add: S1_def S2_def S3_def S4_def S5_def
                    InitialState_def twoOneState_def mkState_def 
                    twoOneObjHeap_def intCons_def oneObjHeap_def emptyHeap_def
                    emptyLocals_def myListOne_def tick_def lupd_def 
                    put_field_def)
apply(erule eval_LetDec.elims)
apply(auto)
apply(erule eval_PrimOp.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(simp_all add: lupd_def tick_def get_field_def get_obj_def headDesc_def 
                    tailDesc_def get_local_def put_field_def upd_obj_def)
done

constdefs Aux5_3::"(int list) => (int list) => ass"
"Aux5_3 a b s == 
  EX M N. (extStar (listPred a (get_local s i) (rtRef nullRef)) 
                   (listPred b (get_local s j) (rtRef nullRef)) 
                   M 
                   N
                   s)"

constdefs Aux5_2::"(int list) => (int list) => ass"
"Aux5_2 a b s ==
    i: dom (locals s) & 
    j: dom (locals s) &
    k: dom (locals s) &
    reverse myList = (reverse a) @ b &
    Aux5_3 a b s"
constdefs Aux5_1::"(int list) => ass"
"Aux5_1 a s == EX b. Aux5_2 a b s"

(*the propoerty holding for S5*)
constdefs Prop5::"ass"
"Prop5 s == EX a. Aux5_1 a s"

lemma "(head ~= tail & i ~= j & j ~= k & i ~= k & l1 ~= l2) --> (Prop5 S5)"
apply(clarify)
apply(simp add: Prop5_def)
apply(subgoal_tac "Aux5_1 [1] S5")
apply(auto)
apply(simp add:Aux5_1_def)
apply(subgoal_tac "Aux5_2 [1] [2] S5")
apply(auto)
apply(simp add:Aux5_2_def Aux5_3_def)
apply(subgoal_tac "extStar (listPred [1] (S5<i>) (rtRef nullRef))
                           (listPred [2] (S5<j>) (rtRef nullRef))
                           (restr (oheap S5) {l1})
                           (restr (oheap S5) {l2})
                           S5")
apply(auto)
apply(simp_all add: extStar_def restr_def S1_def S2_def S3_def S4_def S5_def
                    InitialState_def twoOneState_def mkState_def 
                    twoOneObjHeap_def intCons_def oneObjHeap_def emptyHeap_def
                    emptyLocals_def myListOne_def tick_def lupd_def 
                    put_field_def get_field_def get_obj_def headDesc_def 
                    tailDesc_def get_local_def upd_obj_def Let_def dom_def 
                    override_def orthogonal_def extEq_def single_def 
                    myList_def extStar_def)
apply(auto)
done

lemma "(head ~= tail & i ~= j & j ~= k & i ~= k & l1 ~= l2) --> 
       ((S5<i> ~= rtRef(nullRef)) & loopInv S5) "
apply(clarify)
apply(simp_all add: loopInv_def S5_def get_local_def)
apply(auto)
apply(simp add: tick_def lupd_def S4_def S3_def S2_def S1_def 
                InitialState_def intCons_def oneObjHeap_def emptyHeap_def 
                emptyLocals_def twoOneState_def lupd_def mkState_def 
                twoOneObjHeap_def oneObjHeap_def myListOne_def get_local_def
                put_field_def upd_obj_def Let_def)
apply(case_tac "k=j")
apply(auto)
apply(subgoal_tac 
  "loopInvAux [1] 
              [2] 
              (restr (oheap (tick lupd' i|->Datatype.the (locals S4 k) S4)) 
                     {l1})
              (restr (oheap (tick lupd' i|->Datatype.the (locals S4 k) S4))
                     {l2}) 
              (tick lupd' i|->Datatype.the (locals S4 k) S4)")
apply(auto)
apply(simp add: loopInvAux_def restr_def tick_def lupd_def S4_def S3_def 
                S2_def S1_def 
                InitialState_def intCons_def oneObjHeap_def emptyHeap_def 
                emptyLocals_def twoOneState_def lupd_def mkState_def 
                twoOneObjHeap_def oneObjHeap_def myListOne_def get_local_def
                put_field_def upd_obj_def Let_def extStar_def myList_def 
                single_def orthogonal_def extEq_def override_def dom_def)
apply(auto)
done

(*State after executing the first instruction of the loop in iuteration2*)
constdefs S6::"State"
"S6 == tick( lupd k (rtRef (nullRef)) S5)"

lemma "(head ~= tail & i ~= j & j ~= k & i ~= k & l1 ~= l2 & 
        (VALdec k (GETFIELDop i tailDesc),S5,rtv,t) \<in> eval_LetDec) 
       --> (t = S6)" 
apply(clarify)
apply(erule eval_LetDec.elims)
apply(auto)
apply(erule eval_PrimOp.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(simp add: S6_def S5_def lupd_def get_field_def restr_def tick_def 
                lupd_def S4_def S3_def S2_def S1_def 
                twoOneState_def lupd_def mkState_def 
                twoOneObjHeap_def oneObjHeap_def myListOne_def get_local_def
                put_field_def upd_obj_def Let_def extStar_def myList_def 
                single_def orthogonal_def extEq_def override_def dom_def 
                get_obj_def InitialState_def twoOneState_def mkState_def 
                twoOneObjHeap_def intCons_def oneObjHeap_def emptyHeap_def 
                emptyLocals_def myListOne_def tick_def lupd_def tailDesc_def)
apply(auto)
done

lemma "(head ~= tail & i ~= j & j ~= k & i ~= k & l1 ~= l2) --> (Prop2 S6)"
apply(clarify)
apply(simp add: Prop2_def)
apply(subgoal_tac "Aux1 1 S6")
apply(auto)
apply(simp add: Aux1_def)
apply(subgoal_tac "Aux2 1 [] S6")
apply(auto)
apply(simp add: Aux2_def)
apply(subgoal_tac "Aux3 1 [] [2] S6")
apply(auto)
apply(simp add: Aux3_def Aux4_def)
apply(auto)
prefer 5
apply(subgoal_tac "Aux5 1 [] [2] {l1} {l2} S6")
apply(auto)
apply(simp add: Aux5_def)
apply(subgoal_tac "extStar (mySingle i (mkLIST 1 (S6<k>))) (Aux6 [] [2])
            (restr (oheap S6) {l1}) (restr (oheap S6) {l2}) S6")
apply(auto)
apply(simp_all add: S6_def S5_def lupd_def get_field_def restr_def tick_def 
                lupd_def S4_def S3_def S2_def S1_def 
                twoOneState_def lupd_def mkState_def 
                twoOneObjHeap_def oneObjHeap_def myListOne_def get_local_def
                put_field_def upd_obj_def Let_def extStar_def myList_def 
                single_def orthogonal_def extEq_def override_def dom_def 
                get_obj_def InitialState_def twoOneState_def mkState_def 
                twoOneObjHeap_def intCons_def oneObjHeap_def emptyHeap_def 
                emptyLocals_def myListOne_def tick_def lupd_def tailDesc_def)
apply(auto)
apply(simp_all add: get_local_def mySingle_def Aux6_def single_def dom_def)
apply(subgoal_tac "Aux7 [] [2]
            (restr
              (%a. if a = l2
                   then (empty(l1
                         |->(LIST, empty(head|->rtInt 1)(tail
                             |->rtRef nullRef)))
                         (l2|->(LIST, empty(head|->rtInt 2)(tail
                                |->rtRef nullRef))))
                         a
                   else None)
              {})
            (restr
              (%a. if a = l2
                   then (empty(l1
                         |->(LIST, empty(head|->rtInt 1)(tail
                             |->rtRef nullRef)))
                         (l2|->(LIST, empty(head|->rtInt 2)(tail
                                |->rtRef nullRef))))
                         a
                   else None)
              {l2})
             (| oheap =
                 %a. if a = l2
                     then (empty(l1
                           |->(LIST, empty(head|->rtInt 1)(tail
                               |->rtRef nullRef)))
                           (l2|->(LIST, empty(head|->rtInt 2)(tail
                                  |->rtRef nullRef))))
                           a
                     else None,
               heap = %l. None,
               locals = (%x. None)(j|->rtRef (locRef l2))(i
                 |->rtRef (locRef l1))(k|->rtRef nullRef),
               clock = Suc (Suc (Suc (Suc (Suc (Suc 0))))), heapsz = 0 |)")
apply(auto)
apply(simp add: Aux7_def extStar_def restr_def get_local_def single_def dom_def
                orthogonal_def extEq_def)
apply(auto)
done

constdefs S7::"State"
"S7 == tick( put_field S6 l1 tail (get_local S6 j))"

lemma "(head ~= tail & i ~= j & j ~= k & i ~= k & l1 ~= l2 & 
        (VOIDdec (PUTFIELDop i tailDesc (VARval j)),S6,rtv,t) 
        \<in> eval_LetDec)
       --> (t = S7)" 
apply(clarify)
apply(erule eval_LetDec.elims)
apply(auto)
apply(erule eval_PrimOp.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(simp_all add: S1_def S2_def S3_def S4_def S5_def S6_def S7_def
                    InitialState_def twoOneState_def mkState_def 
                    twoOneObjHeap_def intCons_def oneObjHeap_def emptyHeap_def
                    emptyLocals_def myListOne_def tick_def lupd_def 
                    put_field_def lupd_def tick_def get_field_def get_obj_def 
                    headDesc_def tailDesc_def get_local_def put_field_def)
apply(simp add: upd_obj_def)
apply(simp add: Let_def upd_obj_def)
apply(auto)
apply(simp add: upd_obj_def Let_def)
apply(auto)
done

(*Very similar to the lemma showing Prop2 S6*)
lemma "(head ~= tail & i ~= j & j ~= k & i ~= k & l1 ~= l2) --> (Prop2 S7)"
apply(clarify)
apply(simp add:Prop2_def)
apply(subgoal_tac "Aux1 1 S7")
apply(auto)
apply(simp add: Aux1_def)
apply(subgoal_tac "Aux2 1 [] S7")
apply(auto)
apply(simp add: Aux2_def)
apply(subgoal_tac "Aux3 1 [] [2] S7")
apply(auto)
apply(simp add: Aux3_def)
apply(auto)
apply(simp_all add: S7_def S6_def S5_def S4_def S3_def S2_def S1_def 
                twoOneState_def lupd_def mkState_def InitialState_def 
                twoOneObjHeap_def oneObjHeap_def myListOne_def get_local_def
                put_field_def upd_obj_def lupd_def get_field_def tick_def
                intCons_def emptyHeap_def emptyLocals_def)
apply(auto)
apply(simp_all add:dom_def Let_def)
apply(simp_all add: Aux4_def myList_def)
apply(subgoal_tac "Aux5 1 [] [2] {l1} {l2}
            (| oheap = empty(l2
                 |->(LIST, empty(head|->rtInt 2)(tail|->rtRef nullRef)))(l1
                 |->(LIST, empty(head|->rtInt 1)(tail
                     |->rtRef (locRef l2)))),
               heap = %l. None,
               locals = (%x. None)(j|->rtRef (locRef l2))(i
                 |->rtRef (locRef l1))(k|->rtRef nullRef),
               clock = Suc (Suc (Suc (Suc (Suc (Suc (Suc 0)))))),
               heapsz = 0 |)")
apply(auto)
apply(simp add: Aux5_def)
apply(subgoal_tac "extStar (mySingle i (mkLIST 1 ((| oheap = empty(l2
                 |->(LIST, empty(head|->rtInt 2)(tail|->rtRef nullRef)))(l1
                 |->(LIST, empty(head|->rtInt 1)(tail
                     |->rtRef (locRef l2)))),
               heap = %l. None,
               locals = (%x. None)(j|->rtRef (locRef l2))(i
                 |->rtRef (locRef l1))(k|->rtRef nullRef),
               clock = Suc (Suc (Suc (Suc (Suc (Suc (Suc 0)))))),
               heapsz = 0 |)<j>))) (Aux6 [] [2])
            (restr
              (empty(l2
               |->(LIST, empty(head|->rtInt 2)(tail|->rtRef nullRef)))(l1
               |->(LIST, empty(head|->rtInt 1)(tail|->rtRef (locRef l2)))))
              {l1})
            (restr
              (empty(l2
               |->(LIST, empty(head|->rtInt 2)(tail|->rtRef nullRef)))(l1
               |->(LIST, empty(head|->rtInt 1)(tail|->rtRef (locRef l2)))))
              {l2})
            (| oheap = empty(l2
                 |->(LIST, empty(head|->rtInt 2)(tail|->rtRef nullRef)))(l1
                 |->(LIST, empty(head|->rtInt 1)(tail
                     |->rtRef (locRef l2)))),
               heap = %l. None,
               locals = (%x. None)(j|->rtRef (locRef l2))(i
                 |->rtRef (locRef l1))(k|->rtRef nullRef),
               clock = Suc (Suc (Suc (Suc (Suc (Suc (Suc 0)))))),
               heapsz = 0 |)")
apply(auto)
apply(simp_all add: extStar_def get_local_def Aux6_def)
apply(auto)
apply(simp add: mySingle_def restr_def single_def dom_def get_local_def)
apply(subgoal_tac "Aux7 [] [2]
            (restr
              (restr
                (empty(l2
                 |->(LIST, empty(head|->rtInt 2)(tail|->rtRef nullRef)))(l1
                 |->(LIST, empty(head|->rtInt 1)(tail
                     |->rtRef (locRef l2)))))
                {l2})
              {})
            (restr
              (restr
                (empty(l2
                 |->(LIST, empty(head|->rtInt 2)(tail|->rtRef nullRef)))(l1
                 |->(LIST, empty(head|->rtInt 1)(tail
                     |->rtRef (locRef l2)))))
                {l2})
              {l2})
            (| oheap =
                 restr
                  (empty(l2
                   |->(LIST, empty(head|->rtInt 2)(tail|->rtRef nullRef)))
                   (l1|->(LIST, empty(head|->rtInt 1)(tail
                          |->rtRef (locRef l2)))))
                  {l2},
               heap = %l. None,
               locals = (%x. None)(j|->rtRef (locRef l2))(i
                 |->rtRef (locRef l1))(k|->rtRef nullRef),
               clock = Suc (Suc (Suc (Suc (Suc (Suc (Suc 0)))))),
               heapsz = 0 |)")
apply(auto)
apply(simp_all add: restr_def dom_def orthogonal_def override_def extEq_def
                    Aux7_def extStar_def get_local_def single_def )
apply(auto)
done

constdefs S8::"State"
"S8 == tick( lupd j (get_local S7 i) S7)"

lemma "(head ~= tail & i ~= j & j ~= k & i ~= k & l1 ~= l2) -->
       (S8 = tick (lupd j (rtRef(locRef l1)) S7))"
apply(clarify)
apply(simp add: S8_def S7_def S6_def S5_def S4_def S3_def S2_def tick_def 
                get_local_def lupd_def
                put_field_def upd_obj_def Let_def S1_def InitialState_def 
                twoOneState_def mkState_def twoOneObjHeap_def intCons_def 
                oneObjHeap_def emptyHeap_def emptyLocals_def myListOne_def)
apply(auto)
done

lemma "(head ~= tail & i ~= j & j ~= k & i ~= k & l1 ~= l2 & 
        (VALdec j (VALop (VARval i)),S7,rtv,t) \<in> eval_LetDec)
       --> (t = S8)" 
apply(clarify)
apply(erule eval_LetDec.elims)
apply(auto)
apply(erule eval_PrimOp.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(simp_all add: S1_def S2_def S3_def S4_def S5_def S6_def S7_def S8_def
                    InitialState_def twoOneState_def mkState_def 
                    twoOneObjHeap_def intCons_def oneObjHeap_def emptyHeap_def
                    emptyLocals_def myListOne_def tick_def lupd_def 
                    put_field_def lupd_def tick_def get_field_def get_obj_def 
                    headDesc_def tailDesc_def get_local_def put_field_def)
done

constdefs myListTwo:: "Obj"
"myListTwo == (LIST, empty(head |-> (rtInt(int 2)))(tail |-> rtRef(nullRef)))"

constdefs twoObjHeap:: "ObjHeap"
"twoObjHeap == empty(l2 |-> myListTwo)"

constdefs twoState:: "State"
"twoState == mkState twoObjHeap"

constdefs oneTwoObjHeap:: "ObjHeap"
"oneTwoObjHeap == intCons l1 1 l2 twoObjHeap"

lemma "dom oneTwoObjHeap = {l1,l2}"
apply(simp add: oneTwoObjHeap_def twoObjHeap_def intCons_def)
done

constdefs oneTwoState:: "State"
"oneTwoState == mkState oneTwoObjHeap"

constdefs S8direct::"State"
"S8direct == tick ( tick ( tick ( tick ( tick ( tick ( tick ( tick ( lupd k (rtRef nullRef) (lupd j (rtRef (locRef l1)) (lupd i (rtRef (locRef l1)) oneTwoState))))))))))"

lemma "(head ~= tail & i ~= j & j ~= k & i ~= k & l1 ~= l2) --> S8 = S8direct"
apply(simp add: S8_def S7_def S6_def S5_def S4_def S3_def S2_def S1_def 
                twoOneState_def lupd_def mkState_def InitialState_def 
                twoOneObjHeap_def oneObjHeap_def myListOne_def get_local_def
                put_field_def upd_obj_def lupd_def get_field_def tick_def
                intCons_def emptyHeap_def emptyLocals_def Let_def
                S8direct_def)
apply(auto)
apply(simp add: oneTwoState_def mkState_def oneTwoObjHeap_def intCons_def twoObjHeap_def emptyHeap_def myListTwo_def emptyLocals_def)
apply(rule)
apply(auto)
done

lemma "(head ~= tail & i ~= j & j ~= k & i ~= k & l1 ~= l2) --> (Prop4 S8direct)"
apply(clarify)
apply(simp add: Prop4_def)
apply(subgoal_tac "Aux4_1 [] S8direct")
apply(auto)
apply(simp add:Aux4_1_def)
apply(subgoal_tac "Aux4_2 [] [1,2] S8direct")
apply(auto)
apply(simp add: Aux4_2_def Aux4_3_def)
apply(auto)
apply(simp_all add: dom_def S8direct_def oneTwoState_def mkState_def 
                    oneTwoObjHeap_def intCons_def twoObjHeap_def emptyHeap_def
                    myListTwo_def emptyLocals_def tick_def lupd_def myList_def
                    get_local_def)
apply(subgoal_tac "extStar (listPred [] (rtRef nullRef) (rtRef nullRef))
            (listPred [1, 2] (rtRef (locRef l1)) (rtRef nullRef)) empty (empty(l2
                 |->(LIST, empty(head|->rtInt 2)(tail|->rtRef nullRef)))(l1
                 |->(LIST, empty(head|->rtInt 1)(tail
                     |->rtRef (locRef l2)))))
            (| oheap = empty(l2
                 |->(LIST, empty(head|->rtInt 2)(tail|->rtRef nullRef)))(l1
                 |->(LIST, empty(head|->rtInt 1)(tail
                     |->rtRef (locRef l2)))),
               heap = %l. None,
               locals = (%x. None)(i|->rtRef (locRef l1))(j
                 |->rtRef (locRef l1))(k|->rtRef nullRef),
               clock = Suc (Suc (Suc (Suc (Suc (Suc (Suc (Suc 0))))))),
               heapsz = 0 |)")
apply(auto)
apply(simp add: extStar_def dom_def extEq_def single_def dom_def restr_def 
                orthogonal_def override_def)
apply(auto)
done

constdefs S9 :: "State"
"S9 == tick (lupd i (S8direct<k>) S8direct)"

lemma "(head ~= tail & i ~= j & j ~= k & i ~= k & l1 ~= l2) --> (Prop5 S9)"
apply(clarify)
apply(simp add: Prop5_def)
apply(subgoal_tac "Aux5_1 [] S9")
apply(auto)
apply(simp add: Aux5_1_def)
apply(subgoal_tac "Aux5_2 [] [1,2] S9")
apply(auto)
apply(simp add: Aux5_2_def Aux5_3_def myList_def)
apply(auto)
prefer 4
apply(subgoal_tac "extStar (listPred [] (S9<i>) (rtRef nullRef))
            (listPred [1, 2] (S9<j>) (rtRef nullRef)) (restr (oheap S9) {})
            (oheap S9) S9")
apply(auto)
apply(simp_all add: extStar_def dom_def get_local_def S9_def S8direct_def 
                    oneTwoState_def mkState_def oneTwoObjHeap_def intCons_def
                    twoObjHeap_def emptyHeap_def emptyLocals_def tick_def 
                    lupd_def myList_def single_def orthogonal_def restr_def 
                    extEq_def override_def myListTwo_def)
apply(auto)
done

lemma "(head ~= tail & i ~= j & j ~= k & i ~= k & l1 ~= l2) --> 
       ((S9<i> = rtRef(nullRef)) & loopInv S9) "
apply(clarify)
apply(simp add: loopInv_def)
apply(subgoal_tac "S9<i> = rtRef nullRef & (loopInvAux [] [1,2] (restr (oheap S9) {}) (oheap S9) S9)")
apply(auto)
apply(simp_all add: extStar_def dom_def get_local_def S9_def S8direct_def 
                    oneTwoState_def mkState_def oneTwoObjHeap_def intCons_def
                    twoObjHeap_def emptyHeap_def emptyLocals_def tick_def 
                    lupd_def myList_def single_def orthogonal_def restr_def 
                    extEq_def override_def myListTwo_def loopInvAux_def)
apply(auto)
done

lemma "(head ~= tail & i ~= j & j ~= k & i ~= k & l1 ~= l2) --> 
       (listPred (reverse myList) (S9<j>) (rtRef nullRef) S9)"
apply(simp add: extStar_def dom_def get_local_def S9_def S8direct_def 
                    oneTwoState_def mkState_def oneTwoObjHeap_def intCons_def
                    twoObjHeap_def emptyHeap_def emptyLocals_def tick_def 
                    lupd_def myList_def single_def orthogonal_def restr_def 
                    extEq_def override_def myListTwo_def)
apply(auto)
done

(*Great up to here -- the last instr fulfills the invariant and S9.i = null!*)
(*
lemma "(head ~= tail & i ~= j & j ~= k & i ~= k & l1 ~= l2) --> (Prop4 S8)"
this proof takes too long to complete
apply(clarify)
apply(simp add: Prop4_def)
apply(subgoal_tac "Aux4_1 [] S8")
apply(auto)
apply(simp add:Aux4_1_def)
apply(subgoal_tac "Aux4_2 [] [1,2] S8")
apply(auto)
apply(simp add: Aux4_2_def Aux4_3_def)
apply(auto)
apply(simp add: S8_def S7_def S6_def S5_def S4_def S3_def S2_def S1_def 
                twoOneState_def lupd_def mkState_def InitialState_def 
                twoOneObjHeap_def oneObjHeap_def myListOne_def get_local_def
                put_field_def upd_obj_def lupd_def get_field_def tick_def
                intCons_def emptyHeap_def emptyLocals_def Let_def
                dom_def)
apply(simp add: S8_def S7_def S6_def S5_def S4_def S3_def S2_def S1_def 
                twoOneState_def lupd_def mkState_def InitialState_def 
                twoOneObjHeap_def oneObjHeap_def myListOne_def get_local_def
                put_field_def upd_obj_def lupd_def get_field_def tick_def
                intCons_def emptyHeap_def emptyLocals_def Let_def
                dom_def)
apply(simp add: S8_def S7_def S6_def S5_def S4_def S3_def S2_def S1_def 
                twoOneState_def lupd_def mkState_def InitialState_def 
                twoOneObjHeap_def oneObjHeap_def myListOne_def get_local_def
                put_field_def upd_obj_def lupd_def get_field_def tick_def
                intCons_def emptyHeap_def emptyLocals_def Let_def
                dom_def)
apply(simp add: myList_def)
apply(subgoal_tac "extStar (listPred [] (S8<k>) (rtRef nullRef))
            (listPred [1, 2] (S8<j>) (rtRef nullRef)) 
            (restr (oheap S8) {}) (restr (oheap S8) {l1,l2}) S8")
apply(auto)
apply(simp add: extStar_def)
apply(auto)
apply(simp add: S8_def S7_def S6_def S5_def S4_def S3_def S2_def S1_def 
                twoOneState_def lupd_def mkState_def InitialState_def 
                twoOneObjHeap_def oneObjHeap_def myListOne_def get_local_def
                put_field_def upd_obj_def lupd_def get_field_def tick_def
                intCons_def emptyHeap_def emptyLocals_def Let_def)
apply(auto)
defer 1
apply(simp add: S8_def S7_def S6_def S5_def S4_def S3_def S2_def S1_def 
                twoOneState_def lupd_def mkState_def InitialState_def 
                twoOneObjHeap_def oneObjHeap_def myListOne_def get_local_def
                put_field_def upd_obj_def lupd_def get_field_def tick_def
                intCons_def emptyHeap_def emptyLocals_def Let_def)
apply(auto)
apply(simp add: orthogonal_def dom_def restr_def)
apply(simp add: S8_def S7_def S6_def S5_def S4_def S3_def S2_def S1_def 
                twoOneState_def lupd_def mkState_def InitialState_def 
                twoOneObjHeap_def oneObjHeap_def myListOne_def get_local_def
                put_field_def upd_obj_def lupd_def get_field_def tick_def
                intCons_def emptyHeap_def emptyLocals_def Let_def)
apply(auto)
apply(simp add: orthogonal_def dom_def restr_def override_def extEq_def)
apply(simp add: S8_def S7_def S6_def S5_def S4_def S3_def S2_def S1_def)
apply(simp add: lupd_def InitialState_def 
                get_local_def
                put_field_def upd_obj_def lupd_def get_field_def tick_def
                intCons_def emptyHeap_def emptyLocals_def)
apply(subgoal_tac "j ~= i")
prefer 2
oops 
apply(simp)
apply(auto)
apply(simp add: orthogonal_def dom_def restr_def dom_def extStar_def single_def)
apply(auto)
apply(simp_all add: restr_def dom_def)
apply(simp_all add: extStar_def single_def dom_def restr_def)
apply(simp_all add: orthogonal_def dom_def extEq_def)
apply(rule)
prefer 2
apply(rule)
apply(auto)
apply(clarify)
apply(rule)
apply(auto)
apply(simp add: S8_def S7_def S6_def S5_def S4_def S3_def S2_def S1_def 
                twoOneState_def lupd_def mkState_def InitialState_def 
                twoOneObjHeap_def oneObjHeap_def myListOne_def get_local_def
                put_field_def upd_obj_def lupd_def get_field_def tick_def
                intCons_def emptyHeap_def emptyLocals_def Let_def myList_def 
                dom_def restr_def extStar_def orthogonal_def extEq_def
                single_def dom_def override_def)
apply(auto)
apply(simp add: S8_def S7_def S6_def S5_def S4_def S3_def S2_def S1_def 
                twoOneState_def lupd_def mkState_def InitialState_def 
                twoOneObjHeap_def oneObjHeap_def myListOne_def get_local_def
                put_field_def upd_obj_def lupd_def get_field_def tick_def
                intCons_def emptyHeap_def emptyLocals_def Let_def)
apply(auto)
apply(simp_all add: dom_def restr_def extStar_def orthogonal_def extEq_def
                single_def dom_def override_def)
apply(simp_all add: S8_def S7_def S6_def S5_def S4_def S3_def S2_def S1_def 
                twoOneState_def lupd_def mkState_def InitialState_def 
                twoOneObjHeap_def oneObjHeap_def myListOne_def get_local_def
                put_field_def upd_obj_def lupd_def get_field_def tick_def
                intCons_def emptyHeap_def emptyLocals_def Let_def)
apply(auto)
apply(case_tac "x = l1")
apply(auto)
apply(case_tac "x = l1")
apply(auto)
apply(case_tac "l=l1")
apply(auto)
apply(simp add: S8_def S7_def S6_def S5_def S4_def S3_def S2_def S1_def 
                twoOneState_def lupd_def mkState_def InitialState_def 
                twoOneObjHeap_def oneObjHeap_def myListOne_def get_local_def
                put_field_def upd_obj_def lupd_def get_field_def tick_def
                intCons_def emptyHeap_def emptyLocals_def Let_def)
apply(case_tac "(if x = l1 then if x = l1 | x = l2 then oheap S8 x else None
           else None) =
          Some (a, b)")
apply(auto)
???
done
*)

lemma "(head ~= tail & i ~= j & j ~= k & i ~= k & l1 ~= l2 & 
        (VALdec k (GETFIELDop i tailDesc),S1,rtv,t) \<in> eval_LetDec) 
       --> (t = S2)" 
apply(clarify)
apply(simp_all add: S1_def S2_def InitialState_def twoOneState_def mkState_def 
                    twoOneObjHeap_def intCons_def oneObjHeap_def emptyHeap_def emptyLocals_def myListOne_def tick_def lupd_def)
apply(erule eval_LetDec.elims)
apply(auto)
apply(erule eval_PrimOp.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(simp_all add: lupd_def tick_def get_field_def get_obj_def headDesc_def tailDesc_def get_local_def)
done

(*Try all this again ...
lemma "(i ~= j & l1 ~=l2 ) --> loopInv (lupd i (rtRef (locRef l2)) (lupd j (rtRef nullRef) twoOneState))"
apply(clarify)
apply(simp_all add: twoOneState_def mkState_def twoOneObjHeap_def)
apply(simp_all add: loopInv_def)
apply(auto)
apply(simp_all add: dom_def lupd_def get_local_def oneObjHeap_def extStar_def)
apply(auto)
apply(subgoal_tac "(EX K. listPredLoc myList l2 (rtRef nullRef)
                (| oheap = K, heap = emptyHeap,
                   locals = emptyLocals(j|->rtRef nullRef)(i
                     |->rtRef (locRef l2)),
                   clock = 0, heapsz = 0 |) &
               [] = [] &
               (EX L. orthogonal K L &
                      extEq (K ++ L)
                       (intCons l2 2 l1 (empty(l1|->myListOne))))) &
        reverse myList = reverse myList @ []")
apply(auto)
apply(subgoal_tac "listPredLoc myList l2 (rtRef nullRef)
               (| oheap = (intCons l2 2 l1 (empty(l1|->myListOne))), heap = emptyHeap,
                  locals = emptyLocals(j|->rtRef nullRef)(i
                    |->rtRef (locRef l2)),
                  clock = 0, heapsz = 0 |) &
              (EX L. orthogonal (intCons l2 2 l1 (empty(l1|->myListOne))) L &
                     extEq ((intCons l2 2 l1 (empty(l1|->myListOne))) ++ L)
                      (intCons l2 2 l1 (empty(l1|->myListOne))))")
apply(auto)
apply(simp_all add:single_def myList_def extStar_def intCons_def myListOne_def restr_def extEq_def orthogonal_def emptyHeap_def dom_def override_def)
apply(auto)
done
*)
(*
lemma "(i ~= j & i ~= k & loopInv s & (get_local s i ~= rtRef nullRef)) --> loopBeforeOne s"
apply(clarify)
apply(simp_all add: loopInv_def loopBeforeOne_def get_local_def)
apply(auto)
apply(simp_all add: extStar_def mySingle_def extEq_def myList_def)
apply(auto)
apply(case_tac "b")
apply(auto)
apply(case_tac "ba")
apply(auto)
apply(case_tac "Reference")
apply(auto)
apply(case_tac "(s (|oheap := (restr (oheap s) {loc}) |)<i>)")
apply(case_tac "a")
apply(auto)
apply(case_tac "list")
apply(case_tac "bb")
apply(auto)
apply(case_tac "Referencea")
apply(auto)
apply(subgoal_tac "mySingleAux1 (s(|oheap := restr K {loc}|)<i>) (mkLIST 1 (rtRef nullRef)) (s(|oheap := K|))")
prefer 2
apply(auto)
apply(simp_all add: restr_def get_local_def)
apply(auto)
apply(case_tac "a")
apply(simp)
apply(case_tac "bb")
apply(simp_all)
apply(clarify)
apply(case_tac "list")
apply(simp_all)
apply(subgoal_tac "single loc (mkLIST 2 (rtRef nullRef)) (s(|oheap := K|)) & listPred ")
apply(simp_all)
apply(auto)
apply(subgoal_tac "EX exK M. mySingleAux1 (s(| oheap := M |)<i>) (mkLIST 1 exK) (s(| oheap := M |)) &
                                (EX N K. listPred [] (Datatype.the (locals s k)) (rtRef nullRef) (s(| oheap := N, oheap := K |)) &
                                         (EX L. listPred [2] ba (rtRef nullRef) (s(| oheap := N, oheap := L |)) &
                                                orthogonal K L &
                                                (ALL l. (K ++ L) l = N l) & orthogonal M N & (ALL l. (M ++ N) l = oheap s l))) &
                     [1, 2] = reverse [] @ 1 # [2]")
prefer 2
apply(auto)
apply(subgoal_tac " mySingleAux1 (s(| oheap := M |)<i>) (mkLIST 1 exK) (s(| oheap := M |)) &
                     (EX N K. listPred [] (Datatype.the (locals s k)) (rtRef nullRef) (s(| oheap := N, oheap := K |)) &
                              (EX L. listPred [2] ba (rtRef nullRef) (s(| oheap := N, oheap := L |)) &
                                     orthogonal K L & (ALL l. (K ++ L) l = N l) & orthogonal M N & (ALL l. (M ++ N) l = oheap s l)))")

constdefs loopAfterOne::"ass"
"loopAfterOne s == (i: dom (locals s) & 
                    j: dom (locals s) &
                    k: dom (locals s) &
                    (EX A a b M N K L. (extStar (mySingle i (mkLIST A (get_local s k)))
                                             ((extStar (listPred a (get_local s k) (rtRef nullRef)) 
                                                       (listPred b (get_local s j) (rtRef nullRef)) 
                                                        K L))
                                            M N s
                              &  
                              reverse myList = (reverse (A #a)) @ b)
                    )  
                   )"
*)
end

lemma "(i ~= j & i ~= k & j ~= k & loopInv s & (get_local s i ~= rtRef nullRef) & 
        (VALdec k (GETFIELDop i tailDesc),s,rtv,t) \<in> eval_LetDec) --> loopAfterOne t" 
apply(clarify)
apply(erule eval_LetDec.elims)
apply(auto)
apply(erule eval_PrimOp.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(simp_all add:loopInv_def loopAfterOne_def lupd_def get_field_def)
apply(auto)
apply(simp_all add:dom_def tick_def get_obj_def)
apply(simp_all add: lupd_def get_local_def oneObjHeap_def extStar_def)
apply(simp_all add:extEq_def mySingle_def)
apply(simp_all add: lupd_def get_local_def oneObjHeap_def extStar_def single_def)
apply(case_tac "ba")
apply(simp_all)
apply(case_tac "aa")
(* aa = [] *)
  apply(simp)
  apply(case_tac "bb")
  apply(clarify)
  apply(simp)
  apply(clarify)
  apply(simp)
(*aa = ab # list*)
  apply(simp)
  apply(case_tac "list")
    apply(clarify)
    apply(case_tac "bb")
      apply(simp add:myList_def)
      apply(simp)
      apply(simp add:myList_def)
      apply(case_tac "Reference")
      apply(auto)
      apply(simp_all add: single_def)
oops
apply(case_tac "K a")
(*Case K a = None*)
  apply(auto)
  apply(case_tac "aa")
  apply(auto)
  apply(simp_all add:single_def extStar_def single_def restr_def)
(*Case K a = Some*)
  apply(case_tac "aa")
  (*Case aa = []*)
    apply(simp add: mySingle_def single_def myList_def)
  (*Case aa = ac # list*) 
    apply(simp add: mySingle_def single_def myList_def)
    apply(case_tac "s<j>")
    apply(auto)
    apply(simp add:extEq_def orthogonal_def dom_def Int_def get_local_def)
    apply(subgoal_tac "oheap s a = Some (LIST, empty(head|->rtInt ac)(tail|->rtRef nullRef))")    
    apply(auto)
    apply(simp_all add: tailDesc_def)
oops
    apply(simp_all add:single_def)
    apply(case_tac "list")
    apply(auto)
    apply(subgoal_tac "(EX M. dom M = {a} &
                     M a = Some (LIST, empty(tail|->rtRef nullRef)) &
                     aa = [] &
                     (EX N K L. listPredAux1 [2] Reference (rtRef nullRef)
                                 (s(| clock := Suc (clock s), locals := locals s(k|->rtRef nullRef), oheap := N, oheap := L |)) &
                                (ALL x. (ALL a b. K x ~= Some (a, b)) | (ALL a b. L x ~= Some (a, b))) &
                                (ALL l. (K ++ L) l = N l) &
                                (ALL x. (ALL a b. M x ~= Some (a, b)) | (ALL a b. N x ~= Some (a, b))) & (ALL l. (M ++ N) l = oheap s l))) &
              [1, 2] = reverse aa @ 1 # [2]")
    apply(clarify)
    apply(simp)
    apply(case_tac "(K ++ L) a") 
    apply(auto)
    apply(case_tac "list")
    (*case list = []*)
      apply(auto)
      apply(simp_all add: single_def)
      apply(subgoal_tac "(EX M. dom M = {a} &
                     M a = Some (mkLIST (int 1) (Datatype.the (snd (Datatype.the (oheap s a)) fldname))) &
                     (EX N K. listPred [] (Datatype.the (snd (Datatype.the (oheap s a)) fldname)) (rtRef nullRef)
                               (s(| clock := Suc (clock s), locals := locals s(k|->Datatype.the (snd (Datatype.the (oheap s a)) fldname)),
                                    oheap := N, oheap := K |)) &
                              (EX L. listPredAux1 [int 2] Reference (rtRef nullRef)
                                      (s(| clock := Suc (clock s),
                                           locals := locals s(k|->Datatype.the (snd (Datatype.the (oheap s a)) fldname)), oheap := N,
                                           oheap := L |)) &
                                     (ALL x. (ALL a b. K x ~= Some (a, b)) | (ALL a b. L x ~= Some (a, b))) &
                                     (ALL l. (K ++ L) l = N l) &
                                     (ALL x. (ALL a b. M x ~= Some (a, b)) | (ALL a b. N x ~= Some (a, b))) &
                                     (ALL l. (M ++ N) l = oheap s l)))) &
              [1, 2] = reverse [] @ (int 1) # [int 2]")
      apply(auto)
      apply(subgoal_tac "(EX M. dom M = {a} &
                     M a = Some (mkLIST 1 (Datatype.the (snd (Datatype.the (oheap s a)) fldname))) &
                     (EX N K. listPred [] (Datatype.the (snd (Datatype.the (oheap s a)) fldname)) (rtRef nullRef)
                               (s(| clock := Suc (clock s), locals := locals s(k|->Datatype.the (snd (Datatype.the (oheap s a)) fldname)),
                                    oheap := N, oheap := K |)) &
                              (EX L. listPredAux1 [2] Reference (rtRef nullRef)
                                      (s(| clock := Suc (clock s),
                                           locals := locals s(k|->Datatype.the (snd (Datatype.the (oheap s a)) fldname)), oheap := N,
                                           oheap := L |)) &
                                     (ALL x. (ALL a b. K x ~= Some (a, b)) | (ALL a b. L x ~= Some (a, b))) &
                                     (ALL l. (K ++ L) l = N l) &
                                     (ALL x. (ALL a b. M x ~= Some (a, b)) | (ALL a b. N x ~= Some (a, b))) &
                                     (ALL l. (M ++ N) l = oheap s l)))) &
              [1, 2] = reverse [] @ 1 # [2]")
      apply(auto)
      apply(case_tac "bb")
      (*case bb = []*)
      apply(auto)
    apply(simp_all add:single_def get_obj_def)(*extEq_def orthogonal_def dom_def Int_def*)
    apply(subgoal_tac "EX aa b.
              (EX M. dom M = {a} &
                     M a =
                     Some
                      (mkLIST 1
                        (Datatype.the
                          (snd (Datatype.the (oheap s a)) fldname))) &
                     (EX N K.
                         listPred aa
                          (Datatype.the
                            (snd (Datatype.the (oheap s a)) fldname))
                          (rtRef nullRef)
                          (s(| clock := Suc (clock s),
                               locals := locals s(k
                                 |->Datatype.the
                                     (snd (Datatype.the (oheap s a))
 fldname)),
                               oheap := N, oheap := K |)) &
                         (EX L. listPredAux1 b Reference (rtRef nullRef)
                                 (s(| clock := Suc (clock s),
locals := locals s(k
  |->Datatype.the (snd (Datatype.the (oheap s a)) fldname)),
oheap := N, oheap := L |)) &
                                (ALL x.
                                    (ALL a b. K x ~= Some (a, b)) |
                                    (ALL a b. L x ~= Some (a, b))) &
                                (ALL l. (K ++ L) l = N l) &
                                (ALL x.
                                    (ALL a b. M x ~= Some (a, b)) |
                                    (ALL a b. N x ~= Some (a, b))) &
                                (ALL l. (M ++ N) l = oheap s l)))) &
              [1, 2] = reverse aa @ 1 # b")
    apply(auto)
    apply(subgoal_tac "
              (EX M. dom M = {a} &
                     M a =
                     Some
                      (mkLIST 1
                        (Datatype.the
                          (snd (Datatype.the (oheap s a)) fldname))) &
                     (EX N K.
                         listPred aa
                          (Datatype.the
                            (snd (Datatype.the (oheap s a)) fldname))
                          (rtRef nullRef)
                          (s(| clock := Suc (clock s),
                               locals := locals s(k
                                 |->Datatype.the
                                     (snd (Datatype.the (oheap s a))
 fldname)),
                               oheap := N, oheap := K |)) &
                         (EX L. listPredAux1 b Reference (rtRef nullRef)
                                 (s(| clock := Suc (clock s),
locals := locals s(k
  |->Datatype.the (snd (Datatype.the (oheap s a)) fldname)),
oheap := N, oheap := L |)) &
                                (ALL x.
                                    (ALL a b. K x ~= Some (a, b)) |
                                    (ALL a b. L x ~= Some (a, b))) &
                                (ALL l. (K ++ L) l = N l) &
                                (ALL x.
                                    (ALL a b. M x ~= Some (a, b)) |
                                    (ALL a b. N x ~= Some (a, b))) &
                                (ALL l. (M ++ N) l = oheap s l)))) &
              reverse aa @ 1 # b = reverse aa @ A # b")
    apply(auto)
    apply(simp_all add: dom_def)
    apply(auto)
    apply(subgoal_tac "
              (EX M. mySingleAux1
                      (s(| clock := Suc (clock s), locals := locals s(k|->Datatype.the (snd (get_obj s a) fldname)),
                           oheap := M |)<i>)
                      (mkLIST ac
                        (s(| clock := Suc (clock s), locals := locals s(k|->Datatype.the (snd (get_obj s a) fldname)) |)<k>))
                      (s(| clock := Suc (clock s), locals := locals s(k|->Datatype.the (snd (get_obj s a) fldname)),
                           oheap := M |)) &
                     (EX N K. listPred list
                               (s(| clock := Suc (clock s),
                                    locals := locals s(k|->Datatype.the (snd (get_obj s a) fldname)) |)<k>)
                               (rtRef nullRef)
                               (s(| clock := Suc (clock s), locals := locals s(k|->Datatype.the (snd (get_obj s a) fldname)),
                                    oheap := N, oheap := K |)) &
                              (EX L. listPred bb
                                      (s(| clock := Suc (clock s),
                                           locals := locals s(k|->Datatype.the (snd (get_obj s a) fldname)) |)<j>)
                                      (rtRef nullRef)
                                      (s(| clock := Suc (clock s),
                                           locals := locals s(k|->Datatype.the (snd (get_obj s a) fldname)), oheap := N,
                                           oheap := L |)) &
                                     orthogonal K L & extEq (K ++ L) N & orthogonal M N & extEq (M ++ N) (oheap s)))) &
              reverse list @ ac # bb = reverse list @ ac # bb")
    apply(simp)
    apply(simp_all)
    apply(auto)
    apply(simp_all add: extEq_def orthogonal_def) 
    apply(auto)
done

lemma "(i ~= j & l1 ~=l2 & loopInv s & (get_local s i ~= rtRef nullRef) & (loopBody,s,rtv,t) \<in> eval_FunBody) --> loopInv t" 
apply(clarify)
apply(simp_all add:loopBody_def loopInv_def)
apply(erule eval_PrimRes_eval_Result_eval_FunBody.elims)
apply(simp)
apply(clarify)
apply(erule eval_LetDecs.elims)
apply(simp)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp)
apply(clarify)
apply(auto)
apply(erule eval_Value.elims)
apply(simp)
apply(clarify)
apply(auto)
oops
(*and so on*)
done

(*For total correctness, we also need:*)
lemma "(i ~= j & l1 ~=l2 & loopInv s & (get_local s i ~= rtRef nullRef)) --> (EX rtv t. (loopBody,s,rtv,t) \<in> eval_FunBody)" 
apply(clarify)
apply(simp_all add:loopBody_def)
apply(clarify)
done
(*
datatype Argtype = REFarg "Reference" | VARarg "Vname"
*)
consts ListLength::"nat => Reference => Reference => ass"
primrec
"ListLength 0 r1 r2 s = (emp s & r1 = r2)"
"ListLength (Suc n) r1 r2 s = (EX flds. 
                               (EX r3.
                                (star (single (the r1) (LIST,flds)) (ListLength n r3  r2) s & 
                                           head : dom flds & flds tail = Some (rtRef r3)))) "

constdefs S1 :: "ass"
"S1 s == EX rtv.
         (\<langle> LD1, emptyState\<rangle> 
          \<longrightarrow>\<^sub>l 
          \<langle>rtv, s\<rangle>)"

lemma "S1 s --> (EX l. (EX obj. (single l obj s & is_LIST_object obj)))"
apply(simp add: S1_def single_def emptyState_def LD1_def)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all add: tick_def new_obj_def emptyObjHeap_def override_def newAddr_def emptyLocals_def lupd_def)
apply(auto)
done

constdefs "initialAss:: ass"
"initialAss == ListLength n locRef nullRef"
*) 
*)
end
