theory Seplogic = Dynsem:
types
  ass = "State => bool" 
(*  triple = "ass * Expr * ass"*)
  (* Idea: {P} e {Q} \in triple means that
     \forall E. IF P(H,S) AND (E,H,S,Expr,(v,H')) \in Expr THEN Q(H',S)*)


constdefs orthogonal:: "ObjHeap => ObjHeap => bool"
"orthogonal H K == (dom H) Int (dom K) = {}" 

(*Formulae:*)
(*Emp*)
constdefs emp :: "ass"
 "emp s == dom (oheap s) = {}"

(*Singleton*)
constdefs single :: "loc => Obj => ass"
"single l obj s == dom (oheap s) = {l} & 
                             (oheap s l = Some obj)"
(*Separating conjunction:*)
constdefs star:: "ass => ass => ass"
"star phi psi s ==
  (\<exists> K. (\<exists> L. phi (s (| oheap := K |)) &
                psi (s (| oheap := L|)) &
                orthogonal K L &
                K ++ L = oheap s))"

(*Separating implication*)
constdefs sepImpl:: "ass => ass => ass"
"sepImpl phi psi s ==
  (ALL K. (((dom K) Int (dom (oheap s)) = {} & phi (s (|oheap := K|))) 
          --> psi (s (| oheap := K ++ (oheap s)|))))"

(*Extensional equality of heaps and its relation to =*)
constdefs extEq:: "ObjHeap => ObjHeap => bool"
"extEq H K == ALL l. H l = K l"

(*Extensional formulae:*)
lemma Aux1: "(ALL x a b. oheap s x ~= Some (a, b)) ==> (ALL x. oheap s x = None)"
apply(auto)
apply(case_tac "oheap s x")
apply(auto)
done

lemma ExtensionalEmpty: "(emp s) = (extEq (oheap s) empty)"
apply(simp_all add:emp_def extEq_def dom_def)
apply(auto)
apply(insert Aux1 [of s])
apply(auto)
done

constdefs singleHeap :: "loc => Obj => ObjHeap"
"singleHeap l obj == empty(l |-> obj)"

lemma "(single l obj s) = (extEq (oheap s) (singleHeap l obj))"
apply(auto)
apply(simp_all add:single_def extEq_def singleHeap_def dom_def)
apply(auto)
done

constdefs extStar :: "ass => ass => ObjHeap => ObjHeap => ass" 
"extStar phi psi K L s == phi (s (| oheap := K|)) &
                        psi (s (| oheap := L|)) &
                        orthogonal K L &
                        extEq (K ++ L) (oheap s)"
(*
lemma "(star phi psi s) = (EX K. EX L. extStar phi psi K L s)"
apply(auto)
apply(simp_all add:star_def extStar_def extEq_def)
apply(auto)
apply(clarify)
*)

(*Properties*)
lemma "emp emptyState"
apply (unfold emptyState_def)
apply (unfold emptyObjHeap_def)
apply (unfold emp_def)
apply(simp)
apply(auto)
done

(*restriction operation - should be useful when splitting 
 heaps for star operation*)
constdefs restr :: "ObjHeap => (loc set) => ObjHeap"
"restr H locs == %a. (if a:locs then H a else None)"

constdefs RESTR:: "State => (loc set) => State"
"RESTR s locs == s(|oheap := restr (oheap s) locs|)"

constdefs X :: "(loc set) => State => ass => ass => ObjHeap"
"X locs s psi phi == restr (oheap s) locs"

lemma L1: "(l:N & N Int M = {}) --> ((restr h N ++ restr h M) l = h l)"
apply(clarify)
apply(simp add: restr_def override_def)
apply(auto)
done

lemma L2a: "ALL l. 
            ((l:M & h l = Some b) --> (restr h N ++ restr h M) l = Some b)"
apply(clarify)
apply(simp_all add: restr_def override_def)
done

lemma L2b: "ALL l. ((l:M & h l = None) --> (restr h N ++ restr h M) l = None)"
apply(clarify)
apply(simp_all add: restr_def override_def)
done
(*
lemma L2: "l ~: N --> l ~: dom (restr h N)"
apply(auto)
apply(simp add: restr_def override_def)
done

lemma L3: "(l:M & N Int M = {}) --> l ~:N"
apply(auto)
done
*)

lemma L4a: "(l:M & N Int M = {} & h l = Some a) --> 
           ((restr h N ++ restr h M) l = Some a)"
apply(clarify)
apply(simp add: restr_def override_def)
done 

lemma L4b: "(l:M & N Int M = {} & h l = None) --> 
           ((restr h N ++ restr h M) l = None)"
apply(clarify)
apply(simp add: restr_def override_def)
done

lemma L5a: "ALL b x y.(((if b then Some(x) else None) = Some y) --> b)"
apply(auto)
done

lemma L5b: "ALL b x y.(((if b then Some(x) else None) = Some y) --> (x= y))"
apply(auto)
done

lemma L5c: "ALL b A y.(((if b then A else None) = Some y) --> b)"
apply(auto)
done

lemma L5a1: "(((if b then Some(x) else None) = Some y) --> b)"
apply(auto)
done

lemma L5b1: "(((if b then Some(x) else None) = Some y) --> (x= y))"
apply(auto)
done

lemma L5c1: "(((if b then H x else None) = Some y) --> b)"
apply(auto)
done

lemma L6a: 
      "((((%a. if a:M then H a else None) ++
          (%a. if (EX aa b. H a = Some (aa, b)) & a ~: M then H a else None)
         ) l = Some a
        ) 
        --> 
        H l = Some a
       )"
apply(case_tac "l:M")
apply(auto)
apply(insert override_SomeD [of "(%a. if a:M then H a else None)"
                               "(%a. if (EX aa b. H a = Some (aa, b)) & a ~: M
                                    then H a else None)" l a])
apply(auto)
apply(subgoal_tac "(EX aa b. H l = Some(aa,b)) = (H l = Some a)")
apply(clarify)
apply(auto)
done

lemma L6b:
      "ALL H.
       ((((%a. if a:M then H a else None) ++
          (%a. if (EX aa b. H a = Some (aa, b)) & a ~: M then H a else None)
         ) l = Some a
        ) 
        --> 
        H l = Some a
       )"
apply(case_tac "l:M")
apply(auto)
apply(subgoal_tac "(EX aa b. H l = Some(aa,b)) = (H l = Some a)")
apply(clarify)
apply(auto)
done

(*lemma "ALL H M. 
       ((((%a. if a:M then H a else None) ++
          (%a. if (EX aa b. H a = Some (aa, b)) & a ~: M then H a else None)
         ) l = Some a
        ) 
        --> 
        H l = Some a
       )"
apply(clarify)
apply(case_tac "l:M")
apply(auto)
apply(subgoal_tac "(EX aa b. H l = Some(aa,b)) = (EX c. H l = Some c)")
apply(auto)
apply(subgoal_tac "(if EX aa b. H l = Some (aa, b) then H l else None) = 
                   (if EX aa b. H l = Some (aa, b) then Some (aa,b) else None)")
apply(auto)
done
*)

lemma L6c:
      "ALL H M l a.
       ((((%a. if a:M then H a else None) ++
          (%a. if (EX aa b. H a = Some (aa, b)) & a ~: M then H a else None)
         ) l = Some a
        ) 
        --> 
        H l = Some a
       )"
apply(clarify)
apply(case_tac "l:M")
apply(auto)
apply(case_tac "H l")
apply(auto)
done

(*
lemma L6d: 
      "ALL M H l.
       (l : dom (((%a. if a:M then H a else None) ++
          (%a. if (a :(dom H) & a ~: M) then H a else None)
         )
        ) 
        --> 
        l : dom H
       )"
apply(clarify)
apply(case_tac "l:M")
apply(auto)
apply(insert override_SomeD [of "(%a. if a:M then H a else None)"
                               "(%a. if (EX aa b. H a = Some (aa, b)) & a ~: M
                                    then H a else None)" l a])
apply(auto)
apply(subgoal_tac "(EX aa b. H l = Some(aa,b)) = (EX c. H l = Some c)")
apply(auto)
done
*)

lemma "ALL locs. (ALL s. (ALL psi. (ALL phi. (
       (phi (RESTR s locs)
        & 
        psi (RESTR s (dom (oheap s) - locs))
       ) --> (extStar phi psi (restr (oheap s) locs) (restr (oheap s) (dom (oheap s) - locs)) s )))))"
apply(simp add:RESTR_def restr_def extStar_def orthogonal_def extEq_def dom_def restr_def)
apply(clarify)
apply(rule)
apply(auto)
apply(case_tac "oheap s l")
apply(auto)
apply(case_tac "((%a. if a : locs then oheap s a else None) ++
            (%a. if (EX aa b. oheap s a = Some (aa, b)) & a ~: locs then oheap s a else None))
            l")
apply(simp_all)
apply(case_tac "l: locs")
apply(simp_all)
apply(case_tac "l: locs")
apply(auto)
done

lemma "ALL H L. (extEq (restr H L ++ restr H (dom H - L)) H)"
apply(clarify)
apply(simp add: restr_def extEq_def dom_def override_def)
apply(auto)
apply(case_tac "H l")
apply(auto)
done



(* Preliminary stuff*)
consts the:: "Reference => loc"
primrec
"the (locRef a) = a"
(*is there a problem if I leave this undefined for nullRef?*)

constdefs anonymous::"ass"
"anonymous s == (EX a. (EX obj. (single a obj s)))"

consts HS::"nat => ass"
primrec 
"HS 0 = emp "
"HS (Suc n) s = (EX a. (EX obj. (star (HS n) (single a obj) s)))"

consts extHS::"nat => ass"
primrec 
"extHS 0 = emp "
"extHS (Suc n) s = (EX a obj K L. (extStar (HS n) (single a obj) K L s))"

lemma ExtApply: "ALL H K. ((H = K) --> (H l = K l))"
apply(auto)
done

lemma EmpEmp_Emp: "extStar emp emp (oheap s) (oheap s) s --> emp s"
apply(simp add: extStar_def emp_def orthogonal_def Int_def dom_def)
done

lemma Emp_EmpEmp: "emp s --> extStar emp emp (oheap s) (oheap s) s"
apply(simp add: extStar_def emp_def orthogonal_def Int_def dom_def extEq_def)
apply(auto)
apply(case_tac "oheap s l")
apply(auto)
done

lemma EmpEmpEmp: "extStar emp emp (oheap s) (oheap s) s = emp s"
apply(auto)
apply(simp add: EmpEmp_Emp)
apply(simp add: Emp_EmpEmp)
done


(*For star instead of extStar these lemmas are more difficult and still not proven...*)
(*
lemma "star emp emp s --> emp s"
apply(simp add: star_def emp_def orthogonal_def Int_def dom_def)
apply(auto)
apply(case_tac "K x")
apply(case_tac "L x")
apply(case_tac "(K ++ L) x")
apply(auto)
apply(simp_all add: ExtApply)
apply(auto)
apply(case_tac "(K ++ L) x")
apply(auto)
apply(case_tac "K x")
apply(auto)
apply(case_tac "L x")
apply(auto)
apply(auto)
done
*)
end
