theory SLExamples = Seplogic:

consts LIST :: "Cname"
consts TREE :: "Cname"

consts is_LIST_object:: "Obj => bool"
primrec
"is_LIST_object (cname,fields) = (cname = LIST)"

consts is_TREE_object:: "Obj => bool"
primrec
"is_TREE_object (cname,fields) = (cname = TREE)"

consts L :: "Vname"
consts i :: "Vname"

constdefs LD1::"LetDec"
"LD1 == VALdec L (NEWop LIST)"

constdefs S1 :: "ass"
"S1 s == EX rtv.
         (\<langle> LD1, emptyState\<rangle> 
          \<longrightarrow>\<^sub>l 
          \<langle>rtv, s\<rangle>)"

lemma "S1 s --> (EX l. (EX obj. (single l obj s & is_LIST_object obj)))"
apply(simp add: S1_def single_def emptyState_def LD1_def)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all add: tick_def new_obj_def emptyObjHeap_def override_def newAddr_def emptyLocals_def lupd_def)
apply(auto)
done

consts head :: "Vname"
constdefs headDesc :: "FieldDesc"
"headDesc == FDESC INTty head"

consts tail :: "Vname"
constdefs tailDesc :: "FieldDesc"
"tailDesc == FDESC (REFty LIST) tail"

constdefs Two :: "Value"
"Two == INTval (int 2)"

constdefs NIL_LIST :: "Value"
"NIL_LIST == NULLval LIST"

consts l :: "loc"

(*an explicitly constructed state with one List-object*)
constdefs myS1 :: "State"
"myS1 == (|oheap = emptyObjHeap(l |-> (LIST, % fn. None)),
           heap = emptyHeap,
           locals = %x. if x = L then (Some (rtRef(locRef l))) else None,
           clock  = 0,
           heapsz = 0|)"

(*a predicate which is true if a state results from myS1 by executing a putfield head*)
constdefs S2a :: "ass"
"S2a s == EX rtv.
         (\<langle> PUTFIELDop L headDesc Two, myS1\<rangle> 
          \<longrightarrow>\<^sub>o
          \<langle>rtv, s\<rangle>)"

(*States fulfilling S2a have singleton heaps, and the one object is a LIST object*)
lemma "S2a s --> (EX obj. (single l obj s & is_LIST_object obj))"
apply(simp add: S2a_def myS1_def single_def)
apply(simp add: emptyObjHeap_def emptyHeap_def headDesc_def Two_def)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(simp)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(simp)
apply(erule eval_Value.elims)
apply(simp_all add: tick_def put_field_def upd_obj_def)
apply(clarify)
apply(rule conjI)
apply(simp_all add: dom_def Let_def get_local_def)
done

(* A little program with 2 instructions*)
constdefs LD2:: "LetDecs" 
"LD2 == FULLdec (VALdec L (NEWop LIST)) 
        ( FULLdec (VOIDdec (PUTFIELDop L headDesc Two))
          EMPTYdec )"

(* S2b is true of states which are reachable from emptyState by executing LD2*)
constdefs S2b:: "ass"
"S2b s == EX rtv.
         (\<langle> LD2, emptyState\<rangle> 
          \<longrightarrow>\<^sub>1 
          \<langle>rtv, s\<rangle>
         )"

(* If we know which location was chosen for the new object, the resulting state
   again is a singleton*)
lemma "ALL l. ((S2b s & (newAddr emptyState = locRef l)) --> (EX obj. ((single l obj s) & is_LIST_object obj)))" 
apply(clarify)
apply(simp add: S2b_def single_def emptyState_def emptyObjHeap_def emptyLocals_def emptyHeap_def headDesc_def Two_def LD2_def)
apply(clarify)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(auto)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all add: tick_def new_obj_def emptyObjHeap_def override_def newAddr_def emptyLocals_def lupd_def put_field_def)
apply(clarify)
apply(auto)
apply(erule eval_Value.elims)
apply(clarify)
apply(auto)
apply(erule eval_Value.elims)
apply(simp_all)
apply(simp_all add:upd_obj_def dom_def)
apply(clarify)
apply(auto)
apply(simp_all add: dom_def Let_def get_local_def)
apply(auto)
apply(case_tac "x=lb")
apply(auto)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all add: tick_def new_obj_def emptyObjHeap_def override_def newAddr_def emptyLocals_def lupd_def put_field_def headDesc_def)
apply(clarify)
apply(auto)
apply(erule eval_Value.elims)
apply(clarify)
apply(auto)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(auto)
apply(simp_all add:upd_obj_def dom_def)
apply(simp_all add: dom_def Let_def get_local_def)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all add: tick_def new_obj_def emptyObjHeap_def override_def newAddr_def emptyLocals_def lupd_def put_field_def headDesc_def)
apply(clarify)
apply(auto)
apply(erule eval_Value.elims)
apply(clarify)
apply(auto)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(auto)
apply(simp_all add: upd_obj_def dom_def Let_def get_local_def)
done

constdefs LD3:: "LetDecs" 
"LD3 == FULLdec (VALdec L (NEWop LIST)) 
        ( FULLdec (VOIDdec (PUTFIELDop L headDesc Two))
          ( FULLdec (VOIDdec (PUTFIELDop L tailDesc NIL_LIST))
            EMPTYdec ))"

(* S3 is true of states which are reachable from emptyState by executing LD3*)
constdefs S3:: "ass"
"S3 s == EX rtv.
         (\<langle> LD3, emptyState\<rangle> 
          \<longrightarrow>\<^sub>1 
          \<langle>rtv, s\<rangle>
         )"

(* If we know which location was chosen for the new object, the resulting state
   again is a singleton*)
lemma "ALL l. ((S3 s & (newAddr emptyState = locRef l)) --> 
               (EX obj. ((single l obj s) & is_LIST_object obj)))" 
apply(clarify)
apply(simp add: S3_def single_def emptyState_def emptyObjHeap_def emptyLocals_def emptyHeap_def headDesc_def Two_def LD3_def)
apply(clarify)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(simp_all add: tick_def new_obj_def emptyObjHeap_def override_def newAddr_def emptyLocals_def lupd_def put_field_def upd_obj_def dom_def tailDesc_def Let_def get_local_def headDesc_def)
apply(clarify)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(auto)
apply(case_tac "x=la")
apply(simp_all)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(auto)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(auto)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(auto)
done

(*Maybe change this to : we extend LD3 by getfield...*)

(*We now extend LD2 by another instruction, a getfield head*)
constdefs LD4:: "LetDecs" 
"LD4 == FULLdec (VALdec L (NEWop LIST)) 
        ( FULLdec (VOIDdec (PUTFIELDop L headDesc Two))
          ( FULLdec (VALdec i (GETFIELDop L headDesc))
            EMPTYdec ) )"

(*AGain, the property describing that a state is reachable from emptyState by executing LD4*)
constdefs S4:: "ass"
"S4 s == EX rtv.
         (\<langle> LD4, emptyState\<rangle> 
          \<longrightarrow>\<^sub>1 
          \<langle>rtv, s\<rangle>
         )"

(*similar property as for LD2: the resulting state's heap is a singleton and contains a LIST Object*)
lemma "ALL l. ((S4 s & (newAddr emptyState = locRef l)) --> (EX obj. (single l obj s) & is_LIST_object obj))" 
apply(clarify)
apply(simp add: S4_def single_def emptyState_def emptyObjHeap_def emptyLocals_def emptyHeap_def headDesc_def Two_def LD4_def)
apply(clarify)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(auto)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all add: tick_def new_obj_def emptyObjHeap_def override_def newAddr_def emptyLocals_def lupd_def put_field_def)
apply(clarify)
apply(auto)
apply(erule eval_Value.elims)
apply(clarify)
apply(auto)
apply(erule eval_Value.elims)
apply(simp_all)
apply(simp_all add:upd_obj_def dom_def)
apply(clarify)
apply(auto)
apply(simp_all add: dom_def Let_def get_local_def)
apply(auto)
apply(erule eval_Value.elims)
apply(clarify)
apply(auto)
apply(case_tac "x=la")
apply(auto)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all add: tick_def new_obj_def emptyObjHeap_def override_def newAddr_def emptyLocals_def lupd_def put_field_def headDesc_def)
apply(clarify)
apply(auto)
apply(erule eval_Value.elims)
apply(clarify)
apply(auto)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(simp_all add:upd_obj_def dom_def)
apply(simp_all add: dom_def Let_def get_local_def)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all add: tick_def new_obj_def emptyObjHeap_def override_def newAddr_def emptyLocals_def lupd_def put_field_def headDesc_def)
apply(clarify)
apply(auto)
apply(erule eval_Value.elims)
apply(clarify)
apply(auto)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(auto)
apply(erule eval_PrimOp.elims)
apply(simp_all add: tick_def new_obj_def emptyObjHeap_def override_def newAddr_def emptyLocals_def lupd_def put_field_def headDesc_def)
apply(clarify)
apply(auto)
apply(erule eval_Value.elims)
apply(clarify)
apply(auto)
apply(erule eval_Value.elims)
apply(clarify)
apply(auto)
apply(simp_all add: upd_obj_def dom_def Let_def get_local_def)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(auto)
apply(erule eval_PrimOp.elims)
apply(simp_all add: tick_def new_obj_def emptyObjHeap_def override_def newAddr_def emptyLocals_def lupd_def put_field_def headDesc_def)
apply(clarify)
apply(auto)
apply(erule eval_Value.elims)
apply(clarify)
apply(auto)
done

lemma "ALL a. (restr (oheap myS1) {l} a = (oheap myS1) a)"
apply(simp add:myS1_def emptyObjHeap_def)
apply(clarify)
apply(rule conjI)
apply(simp_all add:restr_def)
done

lemma "ALL m. (m ~=l --> (ALL a. restr (oheap myS1) {m} a = emptyObjHeap a))"
apply(simp add:myS1_def emptyObjHeap_def restr_def)
done


consts ListLength::"nat => Reference => Reference => ass"
primrec
"ListLength 0 r1 r2 s = (emp s & r1 = r2)"
"ListLength (Suc n) r1 r2 s = (EX flds. 
                               (EX r3.
                                (star (single (the r1) (LIST,flds)) (ListLength n r3  r2) s & 
                                           head : dom flds & flds tail = Some (rtRef r3)))) "

(*Lemmas about extStar - not yet working if extStar is replaced by star*) 
lemma "S1 s --> 
      (EX l. (EX obj. ((extStar (single l obj) emp (oheap (RESTR s {l})) (oheap (RESTR s {})) s) 
                       & is_LIST_object obj)))"
apply(simp_all add: S1_def LD1_def)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(erule eval_PrimOp.elims)
apply(simp_all add: single_def extStar_def emp_def emptyState_def tick_def new_obj_def
                    emptyObjHeap_def override_def newAddr_def emptyLocals_def lupd_def
                    RESTR_def restr_def dom_def orthogonal_def extEq_def)
apply(auto)
done

(*Lemmas about ListLength, not yet working*)
lemma "ALL r1. ALL r2. ALL s. (ListLength 0 r1 r2 s --> HS 0 s)"
apply(clarify)
apply(auto)
done
lemma "ALL s. ALL n.
       ((ALL r1. ALL r2. (ListLength n r1 r2 s --> extHS n s)) --> 
        (ALL r1. ALL r2. (ListLength (Suc n) r1 r2 s --> extHS (Suc n) s)))"
apply(clarify)
apply(auto)
apply(simp_all add: star_def single_def orthogonal_def dom_def)
apply(auto)
apply(subgoal_tac "extStar (HS n) (single (the r1) (LIST,flds)) K L s")
apply(auto)
apply(simp_all add:extStar_def single_def dom_def extEq_def)
apply(rule)
apply(auto)
done

(* does not yest work
lemma "ALL s. ALL n.
       ((ALL r1. ALL r2. (ListLength n r1 r2 s --> HS n s)) --> 
        (ALL r1. ALL r2. (ListLength (Suc n) r1 r2 s --> HS (Suc n) s)))"
apply(clarify)
apply(auto)
apply(simp_all add:star_def single_def orthogonal_def dom_def)
apply(auto)
apply(rule)
apply(auto)
apply(rule)
apply(rule)
apply(auto)
*)

constdefs myS2:: "State"
"myS2 == tick 
         (|oheap = emptyObjHeap(l |-> (LIST, % fn. if fn = head then (Some (rtInt 2)) else None)),
           heap = emptyHeap,
           locals = %x. if x = L then (Some (rtRef(locRef l))) else None,
           clock  = 0,
           heapsz = 0|)"

lemma "\<langle> PUTFIELDop L headDesc Two, myS1\<rangle> 
          \<longrightarrow>\<^sub>o 
          \<langle>rtVoid, myS2\<rangle>"
apply(unfold myS1_def myS2_def emptyHeap_def emptyObjHeap_def Two_def headDesc_def override_def tick_def)
apply(auto)
??
done

constdefs S2:: "ass"
"S2 s == EX s1. 
         ( EX rtv.
           ( S1 s1 &
             \<langle> PUTFIELDop L headDesc Two, s1\<rangle> 
             \<longrightarrow>\<^sub>o 
             \<langle>rtv, s\<rangle>
           )
         )"

lemma "S2 s --> (EX l. (EX obj. (single l obj s)))" (* & is_LIST_object obj)))"*)
apply(simp add: S2_def S1_def single_def emptyState_def)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(auto)
apply(erule eval_PrimOp.elims)
apply(simp_all add: tick_def new_obj_def emptyObjHeap_def override_def newAddr_def emptyLocals_def lupd_def)
apply(clarify)
apply(auto)
apply(erule eval_PrimOp.elims)
apply(simp_all add: tick_def new_obj_def emptyObjHeap_def override_def newAddr_def emptyLocals_def lupd_def)
apply(clarify)
apply(auto)
apply(erule eval_Value.elims)
apply(simp_all add: put_field_def upd_obj_def Two_def)
apply(clarify)
apply(auto)
apply(erule eval_Value.elims)
apply(simp_all add: put_field_def upd_obj_def Two_def override_def)
apply(clarify)
apply(simp_all add: emptyHeap_def Let_def)
apply(rule conjI)
apply(clarify)
apply(clarify)
apply(blast)
done
end