theory Reynolds = ListPred + ListReverseProgram:
(*PARTIAL!!*)
consts ref2loc::"Reference => loc"
primrec
"ref2loc (locRef l) = l"
consts rtval2loc::"RTVal => loc"
primrec
"rtval2loc (rtRef r) = ref2loc r"
(*------------------- Axiomatic semantics -------------------------------*)
consts LetDecsJudgement:: "(ass * LetDecs * ass) set"
       LetDecJudgement:: "(ass * LetDec * ass) set"
       PrimOpJudgement:: "(ass * PrimOp * ass) set"
       PrimOpSomeJudgement:: "(ass * Vname * PrimOp * ass) set"
(*       PrimOpSomeJudgement:: "(ass * Vname * PrimOp * Vname * ass) set"*)

consts interprete1:: "Vname => FieldDesc => State => loc"
primrec
"interprete1 x (FDESC t fld) s = rtval2loc(get_field s (rtval2loc(s<x>)) fld)"

consts interprete2:: "Value => State => RTVal"
primrec
<<<<<<< Reynolds.thy
"listPredLoc [] l1 rtv2 s = (emp s & (rtRef (locRef l1)) = rtv2)"
"listPredLoc (h # t) l1 rtv2 s = 
  ((single l1 (mkLIST h (rtRef nullRef)) s)  
   |
   (EX l. (extStar (single l1 (mkLIST h (rtRef(locRef l)))) (listPredLoc t l rtv2) (restr (oheap s) {l1}) (restr (oheap s) (dom (oheap s) - {l1})) s)))" 
(* da: is first case needed above? *)

=======
"interprete2 (VARval x) s = s<x>"
"interprete2 (INTval x) s = rtInt x"
"interprete2 (NULLval str) s = rtRef nullRef"

constdefs free::"ass => Vname => bool"
"free r x == (ALL s. ((r s) --> (ALL rtv. (r (lupd x rtv s)))))"

constdefs noModification::"LetDec => Vname => bool"
"noModification c x == (ALL s rtv t. ((\<langle>c,s\<rangle> \<longrightarrow>\<^sub>l \<langle>rtv,t\<rangle>) --> (s<x> = t<x>)))" 



inductive PrimOpJudgement intros
  PutFieldOp: 
   "((FDESC t fld) = fdesc &
     (C,fs) = obj &
     newObj = (C, fs(fld |-> rtv)))
    \<Longrightarrow> 
    ((% s. (s<x> = rtRef(locRef ll) & single ll obj s) & rtv = interprete2 v s & obj = get_obj s ll), 
     PUTFIELDop x fdesc v, 
     (% s. (s<x> = rtRef(locRef ll) & single ll newObj s))) \<in> PrimOpJudgement"
(*
inductive PrimOpSomeJudgement intros
  GetFieldOp:
   "(ALL u. (v ~= u) --> (EX ll obj z.
    (P = (% s. (s<x> = rtRef(locRef ll) & single ll obj s &
                obj = get_obj s ll & s<v> = s<u>)) &
     (FDESC t fld) = fdesc &
     (C,fs) = obj &
     fld : dom fs &
     Some(rtv) = fs fld &
     z = (if x=v then u else x) &
     Q = (% s. (s<v> = rtv & s<z> = rtRef(locRef ll) & single ll obj s)))
    ))
    \<Longrightarrow> 
    (P, v, GETFIELDop x fdesc, Q) \<in> PrimOpSomeJudgement"
*)
inductive PrimOpSomeJudgement intros
  GetFieldOp:
   "((FDESC t fld) = fdesc &
     (C,fs) = obj &
     fld : dom fs &
     Some(rtv) = fs fld &
     z = (if x=v then u else x))
    \<Longrightarrow> 
    (% s. (s<x> = rtRef(locRef ll) & single ll obj s & obj = get_obj s ll & s<v> = s<u>), 
     v, GETFIELDop x fdesc, 
     % s. (s<v> = rtv & s<z> = rtRef(locRef ll) & single ll obj s))
    \<in> PrimOpSomeJudgement"
  NewOp:
   "(v ~= u)
    \<Longrightarrow> 
    (% s. (emp s & s<v> = s<u> & newAddr s = locRef ll), v, NEWop C, 
     % s. (s<v> = rtRef(locRef ll) & single ll (C, % f. None) s)) \<in> PrimOpSomeJudgement"

inductive LetDecJudgement intros  
  VOIDdec: "(P,p,Q) \<in> PrimOpJudgement 
            \<Longrightarrow> (P, VOIDdec p, Q) \<in> LetDecJudgement"
  VALdec: "(P,y,p,Q) \<in> PrimOpSomeJudgement
           \<Longrightarrow> (P, VALdec y p, Q) \<in> LetDecJudgement"

consts implies ::"ass => ass => bool" 

inductive LetDecsJudgement intros
  EMPTYdec:"(P, EMPTYdec, Q) \<in> LetDecsJudgement"
  FULLdec:"((P, letdec, Q) \<in> LetDecJudgement &
            (Q, letdecs, R) \<in> LetDecsJudgement)
           \<Longrightarrow>
           (P, FULLdec letdec letdecs, R) \<in> LetDecsJudgement"
(*later:  Conseq:"((implies P P1) &
           (P1, letdecs, Q1) \<in> LetDecsJudgement &
           (implies Q1 Q)
          )
          \<Longrightarrow> (P1, letdecs, Q1) \<in> LetDecsJudgement"
*)
>>>>>>> 1.1.2.2

(*partial soundness of a getfield-letdec:*)
(*
lemma pSoundGetfieldLD: 
  "ALL P I Q s rtv t x v fdesc.
   ( (I = VALdec v (GETFIELDop x fdesc) & 
      P s & 
      (P, I, Q) \<in> LetDecJudgement & 
      (\<langle> I,s \<rangle> \<longrightarrow>\<^sub>l  
       \<langle> rtv,t \<rangle>)
     ) 
     --> Q t
   )"
apply(clarify)
apply(erule LetDecJudgement.elims)
apply(clarify)
apply(auto)
apply(erule PrimOpSomeJudgement.elims)
apply(clarify)
apply(simp_all add:single_def dom_def)
apply(auto)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(auto)
apply(simp_all add: get_obj_def get_local_def get_field_def lupd_def)
oops
apply(simp add: get_field_def lupd_def)???
apply(case_tac "Datatype.the (snd (Datatype.the (oheap sc ll)) fldname)")
apply(auto)
apply(case_tac "oheap sc ll")
apply(auto)
apply(case_tac "oheap sc ll")
apply(auto)
apply(case_tac "oheap sc ll")
apply(auto)
apply(case_tac "oheap sc ll")
apply(auto)
apply(case_tac "oheap sc ll")
apply(auto)
done
*)

(*explicit version of partial soundness of putfield-primop:*)
lemma pSoundPutfield: 
     "ALL P I Q s rtv t.
      ( (P s & (P, I, Q) \<in> PrimOpJudgement & 
         (\<langle> I,s \<rangle> \<longrightarrow>\<^sub>o  
          \<langle> rtv,t \<rangle>)
        ) 
        --> Q t
      )"
apply(clarify)
apply(erule PrimOpJudgement.elims)
apply(clarify)
apply(simp_all add:single_def dom_def)
apply(auto)
apply(erule eval_PrimOp.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(simp_all add: tick_def put_field_def get_obj_def upd_obj_def Let_def
                    get_local_def)
apply(case_tac "xa = ll")
apply(auto)
apply(erule eval_PrimOp.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(simp_all add: tick_def put_field_def get_obj_def upd_obj_def Let_def
                    get_local_def)
apply(auto)
apply(erule eval_PrimOp.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(simp_all add: tick_def put_field_def get_obj_def upd_obj_def Let_def
                    get_local_def)
apply(erule eval_PrimOp.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(simp_all add: tick_def put_field_def get_obj_def upd_obj_def Let_def
                    get_local_def)
done

(*old version of partial soundness of putfield-primop:*)
(*
lemma pSoundPutfield: 
     "ALL P I Q s rtv t.
      ( (P s & (P, I, Q) \<in> PrimOpJudgement & 
         (\<langle> I,s \<rangle> \<longrightarrow>\<^sub>o  
          \<langle> rtv,t \<rangle>)
        ) 
        --> Q t
      )"
apply(clarify)
apply(erule PrimOpJudgement.elims)
apply(clarify)
apply(simp_all add:single_def dom_def)
apply(auto)
apply(erule eval_PrimOp.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(simp_all add: tick_def put_field_def get_obj_def upd_obj_def Let_def
                    get_local_def)
apply(case_tac "xa = ll")
apply(auto)
apply(erule eval_PrimOp.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(simp_all add: tick_def put_field_def get_obj_def upd_obj_def Let_def
                    get_local_def)
apply(auto)
apply(erule eval_PrimOp.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(simp_all add: tick_def put_field_def get_obj_def upd_obj_def Let_def
                    get_local_def)
apply(erule eval_PrimOp.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(simp_all add: tick_def put_field_def get_obj_def upd_obj_def Let_def
                    get_local_def)
done
*)

(*partial soundness of a new-letdec:*)
lemma pSoundNewLD: 
  "ALL P I Q s rtv t v C.
   ( (I = VALdec v (NEWop C) & 
      P s & 
      (P, I, Q) \<in> LetDecJudgement & 
      (\<langle> I,s \<rangle> \<longrightarrow>\<^sub>l 
       \<langle> rtv,t \<rangle>)
     ) 
     --> Q t
   )"
apply(clarify)
apply(erule LetDecJudgement.elims)
apply(clarify)
apply(erule PrimOpSomeJudgement.elims)
apply(clarify)
apply(simp add: dom_def single_def)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(simp_all add: tick_def get_obj_def Let_def get_local_def get_field_def 
                    lupd_def)
apply(auto)
apply(simp_all add: new_obj_def newAddr_def emp_def dom_def)
apply(case_tac "x = l")
apply(auto)
done

(*partial soundness of a getfield-letdec:*)
(*
lemma pSoundGetfieldLD: 
  "ALL P I Q s rtv t x v fdesc.
   ( (I = VALdec v (GETFIELDop x fdesc) & 
      P s & 
      (P, I, Q) \<in> LetDecJudgement & 
      (\<langle> I,s \<rangle> \<longrightarrow>\<^sub>l  
       \<langle> rtv,t \<rangle>)
     ) 
     --> Q t
   )"
apply(clarify)
apply(erule LetDecJudgement.elims)
apply(clarify)
apply(auto)
apply(erule PrimOpSomeJudgement.elims)
apply(clarify)
apply(auto)
apply(erule allE)
apply(auto)
apply(simp add: dom_def single_def)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(simp_all add: tick_def get_obj_def Let_def get_local_def get_field_def 
                    lupd_def)
apply(simp add: get_field_def lupd_def)
apply(case_tac "oheap sc ll")
apply(auto)
apply(case_tac "oheap sc ll")
apply(auto)
done
*)

(*Version with explicitU*)
(*lemma pSoundGetfieldLD: 
  "ALL P I Q s rtv t x v u fdesc.
   ( (I = GETFIELDop x fdesc & 
      P s & 
      (P, v, I, u, Q) \<in> PrimOpSomeJudgement & 
      (\<langle> VALdec v I,s \<rangle> \<longrightarrow>\<^sub>l  
       \<langle> rtv,t \<rangle>)
     ) 
     --> Q t
   )"
apply(clarify)
<<<<<<< Reynolds.thy
apply(simp add: extStar_def single_def twoOneState_def mkState_def twoOneObjHeap_def oneObjHeap_def intCons_def myListOne_def dom_def restr_def orthogonal_def extEq_def override_def emp_def)
done

consts g:: "Fname"
consts loop:: "Fname"

constdefs main:: "LetDecs"
"main == FULLdec (VALdec j (VALop (NULLval LIST))) EMPTYdec"

constdefs result:: "Result"
"result == CHOICEres (CONDhead (VARval i) IStest (NULLval LIST))
                     (FUNres g (FULLvar j EMPTYvar))
                     (FUNres loop (FULLvar i (FULLvar j EMPTYvar)))"

constdefs gBody:: "FunBody"
"gBody == FUNbody EMPTYdec (PRIMres (OPres (VALop (VARval j))))"

constdefs gDec:: "FunDec"
"gDec == FDEC g (FULLal (ARG (REFty LIST) j) EMPTYal) gBody"

constdefs loopBody::"FunBody"
"loopBody == FUNbody (FULLdec (VALdec k (GETFIELDop i tailDesc))
                     (FULLdec (VOIDdec (PUTFIELDop i tailDesc (VARval j)))
                     (FULLdec (VALdec j (VALop (VARval i)))
                     (FULLdec (VALdec i (VALop (VARval k))) EMPTYdec)
                     )))
                     result"

constdefs loopDec:: "FunDec"
"loopDec == FDEC loop (FULLal (ARG (REFty LIST) j) 
                       (FULLal (ARG (REFty LIST) i) 
                       EMPTYal)) 
                      loopBody"

constdefs funs:: "FunDecs"
"funs == FULLfundec gDec (FULLfundec loopDec EMPTYfundec)"

constdefs rev:: "MethodBody"
"rev == MBODY main funs result"
(*types loc = int*)

consts reverse:: "int list => int list"
primrec
"reverse [] = []"
"reverse (h # t) = (reverse t) @ [h]"

constdefs myList:: "int list"
"myList == [2,1]"

constdefs loopInvAux::"(int list) => (int list) => ObjHeap => ObjHeap => ass"
"loopInvAux a b K L s == (i: dom (locals s) & 
               j: dom (locals s) &
               (extStar (listPred a (get_local s i) (rtRef nullRef)) 
                        (listPred b (get_local s j) (rtRef nullRef)) 
                         K L s)
               & 
               reverse myList = (reverse a) @ b
               )"

constdefs loopInv:: "ass"
"loopInv s == (EX a b K L. (loopInvAux a b K L s))"

consts mySingleAux2:: "Reference => Obj => ass"
primrec
"mySingleAux2 nullRef obj s = False"
"mySingleAux2 (locRef l) obj s = single l obj s"

consts mySingleAux1:: "RTVal => Obj => ass"
primrec
"mySingleAux1 (rtRef r) obj s = mySingleAux2 r obj s"
"mySingleAux1 (rtInt n) obj s = False"
"mySingleAux1 (rtBool b) obj s = False"
"mySingleAux1 (rtString str) obj s = False"
"mySingleAux1 (rtVoid) obj s = False"

constdefs mySingle :: "Vname => Obj => ass"
"mySingle x obj s == mySingleAux1 (get_local s x)  obj s"

constdefs loopBeforeOne::"int => (int list) => (int list) => ass"
"loopBeforeOne A a b s == (i: dom (locals s) & 
                     j: dom (locals s) &
                    (EX exK M N K L. (extStar (mySingle i (mkLIST A exK))
                                             ((extStar (listPred a (get_local s k) (rtRef nullRef)) 
                                                       (listPred b (get_local s j) (rtRef nullRef)) 
                                                        K L))
                                            M N s
                              &  
                              reverse myList = (reverse (A # a)) @ b)
                    )  
                   )"

constdefs InitialState :: "State"
"InitialState == lupd i (rtRef (locRef l2)) twoOneState"

lemma AuxLemma1: "((i ~= j & l1 ~= l2 & a = [2,1] & b = [] & L = empty & K = (empty(l1
                           |->(LIST, empty(head|->rtInt 1)(tail
                               |->rtRef nullRef)))
                           (l2|->(LIST, empty(head|->rtInt 2)(tail
                                  |->rtRef (locRef l1)))))) -->
       (
           (listPredLoc a l2 (rtRef nullRef)
                   (| oheap = K, heap = %l. None,
                      locals = (%x. None)(i|->rtRef (locRef l2))(j
                        |->rtRef nullRef),
                      clock = Suc 0, heapsz = 0 |) &
                  b = [] &
                  (orthogonal K L &
                         extEq (K ++ L)
                          (empty(l1
                           |->(LIST, empty(head|->rtInt 1)(tail
                               |->rtRef nullRef)))
                           (l2|->(LIST, empty(head|->rtInt 2)(tail
                                  |->rtRef (locRef l1))))))) &
           [1, 2] = reverse a @ b
       ))"
=======
apply(erule PrimOpSomeJudgement.elims)
apply(clarify)
apply(simp add: dom_def single_def)
>>>>>>> 1.1.2.2
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(simp_all)
<<<<<<< Reynolds.thy
apply(rule)
prefer 2
apply(simp add:orthogonal_def extEq_def dom_def)
apply(simp add:set_diff_def)
apply(subgoal_tac "extStar
                (single l2
                  (LIST, empty(head|->rtInt 2)(tail|->rtRef (locRef l1))))
                (listPredLoc [1] l1 (rtRef nullRef))
                (restr
                  (empty(l1
                   |->(LIST, empty(head|->rtInt 1)(tail|->rtRef nullRef)))
                   (l2|->(LIST, empty(head|->rtInt 2)(tail
                          |->rtRef (locRef l1)))))
                  {l2})
                (restr
                  (empty(l1
                   |->(LIST, empty(head|->rtInt 1)(tail|->rtRef nullRef)))
                   (l2|->(LIST, empty(head|->rtInt 2)(tail
                          |->rtRef (locRef l1)))))
                  {x. x = l1 & x ~= l2})
                (| oheap = empty(l1
                     |->(LIST, empty(head|->rtInt 1)(tail|->rtRef nullRef)))
                     (l2|->(LIST, empty(head|->rtInt 2)(tail
                            |->rtRef (locRef l1)))),
                   heap = %l. None,
                   locals = (%x. None)(i|->rtRef (locRef l2))(j
                     |->rtRef nullRef),
                   clock = Suc 0, heapsz = 0 |)")
apply(simp_all add: extStar_def restr_def)

apply(auto)
apply(simp add: single_def dom_def)
apply(simp add: single_def dom_def)
apply(simp add: orthogonal_def dom_def Int_def)
apply(simp add:extEq_def)
apply(auto)
apply(simp add:override_def)
done

lemma AuxLemma2: "[1,2] = reverse [2,1] @ []"
apply(simp)
=======
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(simp_all add: tick_def get_obj_def Let_def get_local_def get_field_def 
                    lupd_def)
apply(auto)
apply(case_tac "oheap sc ll")
apply(auto)
apply(case_tac "oheap sc ll")
apply(auto)
>>>>>>> 1.1.2.2
done
*)

lemma pSoundPutfieldLD: 
  "ALL P I Q s rtv t x v u fdesc.
   ( (I = VOIDdec (PUTFIELDop x fdesc v) & 
      P s & 
      (P, I, Q) \<in> LetDecJudgement & 
      (\<langle> I,s \<rangle> \<longrightarrow>\<^sub>l  
       \<langle> rtv,t \<rangle>)
     ) 
     --> Q t
   )"
apply(clarify)
apply(erule eval_LetDec.elims)
apply(clarify)
apply(clarify)
apply(erule LetDecJudgement.elims)
apply(clarify)
apply(erule PrimOpJudgement.elims)
apply(clarify)
apply(simp_all add:single_def dom_def)
apply(auto)
apply(erule eval_PrimOp.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(simp_all add: tick_def put_field_def get_obj_def upd_obj_def Let_def
                    get_local_def)
apply(case_tac "x = ll")
apply(auto)
apply(erule eval_PrimOp.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(simp_all add: tick_def put_field_def get_obj_def upd_obj_def Let_def
                    get_local_def)
apply(auto)
apply(erule eval_PrimOp.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(simp_all add: tick_def put_field_def get_obj_def upd_obj_def Let_def
                    get_local_def)
apply(erule eval_PrimOp.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(simp_all add: tick_def put_field_def get_obj_def upd_obj_def Let_def
                    get_local_def)
done


consts v1::"Vname"
consts v2::"Vname"
lemma "ALL ll C I.
       (v1 ~= v1 -->
        (% s. (emp s & s<v1> = s<v2> & newAddr s = locRef ll), 
         VALdec v1 (NEWop C),
         % s. (s<v1> = rtRef(locRef ll) & single ll (C, %f. None) s)
       ) \<in> LetDecJudgement)"
apply(auto)
done

(*For primres and results we use contexts for looking up the 
pre-/post-conditions for basic blocks*)
types cont = "Fname ~=> (ass * ass)"
consts RETURN::"Vname"(*Abadi-Leino style return variable*)
consts PrimResJudgement::"(cont * ass * PrimRes * ass) set"
       ResultJudgement::"(cont * ass * Result * ass) set"
inductive PrimResJudgement intros
  OPres: 
   "(P, RETURN, primop, Q) \<in> PrimOpSomeJudgement
    \<Longrightarrow> 
    (Delta, P, OPres primop, Q) \<in> PrimResJudgement"
  VOIDres:
    "(Delta, P, VOIDres, P) \<in> PrimResJudgement"
  FUNres:
    "Delta f = Some(P,Q)
    \<Longrightarrow> 
    (Delta, P, FUNres f vars, Q) \<in> PrimResJudgement"
(*the OPres rule only works for primpos which return a value - we will need
  another rule for putfield etc. That rule will call PrimOpJudgement*)
consts mkCondition::"CondHead => ass"
consts mkCond::"RTVal => Test => RTVal => bool"
consts lessTest::"RTVal => RTVal => bool"
consts less1test::"int => RTVal => bool"
primrec
"less1test a (rtInt b) = (a<b)"
"less1test a rtVoid = False"
"less1test a (rtBool b) = False"
"less1test a (rtString str) = False"
"less1test a (rtRef r) = False"
primrec
"lessTest (rtInt val1) rtv2 = less1test val1 rtv2"
"lessTest rtVoid rtv2 = False"
"lessTest (rtBool b) rtv2 = False"
"lessTest (rtString str) rtv2 = False"
"lessTest (rtRef r) rtv2 = False"
primrec 
"mkCond rtv1 EQUALStest rtv2 = (rtv1 = rtv2)"
"mkCond rtv1 LESStest rtv2 = lessTest rtv1 rtv2"
(*IStest is obsolete*)
primrec
"mkCondition (CONDhead val1 test val2) s = 
  mkCond (interprete2 val1 s) test (interprete2 val2 s)"
inductive ResultJudgement intros
  PRIMres:
    "(Delta, P, primres, Q) \<in> PrimResJudgement
     \<Longrightarrow>
     (Delta, P, PRIMres primres, Q) \<in> ResultJudgement"
  CHOICEres:
    "(cond = mkCondition condHead &
      (Delta, % s. ((P s) & (cond s)), pres1, Q) \<in> PrimresJudgement &
      (Delta, % s. ((P s) & (~ cond s)), pres2, Q) \<in> PrimresJudgement)
     \<Longrightarrow> 
     (Delta, P, CHOICEres condhead pres1 pres2, Q) \<in> ResultJudgement"

consts FunBodyJudgement::"(cont * ass * FunBody * ass) set"
       FunDecJudgement::"(cont * FunDec) set"
       FunDecsJudgement::"(cont * FunDecs) set"
       MethodBodyJudgement::"(ass * MethodBody * ass) set"
       ProgJudgement::"(ass * Prog * ass) set"
inductive FunBodyJudgement intros
  FUNbody:
    "((P, letdecs, Q) \<in> LetDecsJudgement &
      (Delta, Q, result, R) \<in> ResultJudgement)
     \<Longrightarrow>
     (Delta, P, FUNbody letdecs result, R) \<in> FunBodyJudgement"
inductive FunDecJudgement intros
  FDEC:
    "(Delta f = Some (P,Q) &
      (Delta, P, funbody, Q) \<in> FunBodyJudgement)
     \<Longrightarrow>
     (Delta, FDEC f args funbody) \<in> FunDecJudgement"
inductive FunDecsJudgement intros
  EMPTYfundec:
    "(Delta, EMPTYfundec) \<in> FunDecsJudgement"
  FULLfundec:
    "((Delta, fundec) \<in> FunDecJudgement &
      (Delta, fundecs) \<in> FunDecsJudgement)
     \<Longrightarrow>
     (Delta, FULLfundec fundec fundecs) \<in> FunDecsJudgement"
inductive MethodBodyJudgement intros
  MBODY:
    "(EX Delta. 
         ((P,letdecs,Q) \<in> LetDecsJudgement &
          (Delta, fundecs) \<in> FunDecsJudgement &
          (Delta,Q,result, R) \<in> ResultJudgement
         )
     )
     \<Longrightarrow>
     (P, MBODY letdecs fundecs result,R) \<in> MethodBodyJudgement"
inductive ProgJudgement intros
  PROG:
    "(P, methodbody, Q) \<in> MethodBodyJudgement
     \<Longrightarrow>
     (P, PROG methodbody, Q) \<in> ProgJudgement"

(*--------------------------------------------------------------*)
(*Here is a formalisation of the partial correctness predicate,
  restricted to primops*)

constdefs pSound:: "ass => PrimOp => ass => bool"
"pSound P I Q == (ALL s t rtv. 
                   ((P s & 
                     (\<langle> I,s \<rangle> \<longrightarrow>\<^sub>o
                      \<langle> rtv,t \<rangle>)
                    ) 
                    --> Q t
                   ))"

(* Indeed, the putfield rule is sound -- the following lemma should be 
   extended to all Primops*)
lemma PrimOpSound: 
  "ALL P I Q. ((P,I,Q) \<in> PrimOpJudgement --> pSound P I Q)"
apply(clarify)
apply(simp add:pSound_def)
apply(auto)
(*I would now like to insert the above lemma, via:
  apply(simp add: pSoundPutfield [of "P" "s" "I" "Q" "rtv" "t"])
  or via
  apply(insert pSoundPutfield ...)
  apply(auto or simp)
  but that does not work, independently of whether the free variables
  of the lemma pSoundPutfield are all-quantified or not. 
  So I copy the proof from above manually -- minus its first statement*)
(*apply(clarify)*)
apply(erule PrimOpJudgement.elims)
apply(clarify)
apply(simp_all add:single_def dom_def)
apply(auto)
apply(erule eval_PrimOp.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(simp_all add: tick_def put_field_def get_obj_def upd_obj_def Let_def
                    get_local_def)
apply(case_tac "xa = ll")
apply(auto)
apply(erule eval_PrimOp.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(simp_all add: tick_def put_field_def get_obj_def upd_obj_def Let_def
                    get_local_def)
apply(auto)
apply(erule eval_PrimOp.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(simp_all add: tick_def put_field_def get_obj_def upd_obj_def Let_def
                    get_local_def)
apply(erule eval_PrimOp.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(simp_all add: tick_def put_field_def get_obj_def upd_obj_def Let_def
                    get_local_def)
done

(*Future: extend this to the other syntactic categories*)

(*Rule of consequence:*)
lemma consSound1:
  "(ALL s. (R s --> P s)) --> (pSound P I Q) --> (pSound R I Q)"
apply(clarify)
apply(simp add: pSound_def)
apply(auto)
done

lemma consSound2:
  "(ALL s. (Q s --> S s)) --> (pSound P I Q) --> (pSound P I S)"
apply(clarify)
apply(simp add: pSound_def)
done

lemma consSound:
  "(ALL s. (R s --> P s)) --> (ALL s. (Q s --> S s)) -->
   (pSound P I Q) --> (pSound R I S)" 
apply(clarify)
apply(simp add: consSound1 consSound2)
done

(*Soundness of the frame rule for primops would look like this -- but
  first we have to formalise what the side condition on page 7 means!:*)
constdefs STAR:: "ass => ass => ass" 
"STAR P Q s == (EX K L. (extStar P Q K L s))"

constdefs pSoundLD:: "ass => LetDec => ass => bool"
"pSoundLD P c Q == (ALL s t rtv. 
                     ((P s & 
                       (\<langle> c,s \<rangle> \<longrightarrow>\<^sub>l
                        \<langle> rtv,t \<rangle>)
                      ) 
                      --> Q t
                     ))"

lemma "ALL P Q R c. ( c = VALdec x (NEWop Cn) --> 
       ((ALL x. ((free R x) --> (noModification c x))) --> ((pSoundLD P c Q) --> pSoundLD (STAR P R) c (STAR Q R))))"
apply(clarify)
apply(simp add: free_def noModification_def lupd_def)
apply(case_tac "free R x")
apply(simp add: free_def pSoundLD_def)
apply(auto)
apply(simp add:STAR_def lupd_def)
apply(subgoal_tac "")
apply(erule eval_LetDec.elims)
apply(auto)
apply(erule eval_PrimOp.elims)
apply(auto)
apply(simp add: lupd_def tick_def new_obj_def)
apply(subgoal_tac "Q (s(| oheap := oheap s(l|->(Cn, %fn. None)), clock := Suc (clock s), locals := locals s(x|->rtRef (locRef l)),
                        oheap := K(l|->(Cn, %fn. None)) |)) &
                 (EX L. R (s(| oheap := oheap s(l|->(Cn, %fn. None)), clock := Suc (clock s),
                               locals := locals s(x|->rtRef (locRef l)), oheap := L |)) &
                        orthogonal (K(l|->(Cn, %fn. None))) L & extEq ((K(l|->(Cn, %fn. None))) ++ L) (oheap s(l|->(Cn, %fn. None))))")
apply(auto)
apply(subgoal_tac "P (s(| oheap := K |)) & (EX rtv. \<langle>VALdec x (NEWop Cn),s(| oheap := K |)\<rangle> \<longrightarrow>\<^sub>l \<langle>rtVoid,s(| oheap := oheap s(l|->(Cn, %fn. None)), clock := Suc (clock s), locals := locals s(x|->rtRef (locRef l)),
                  oheap := K(l|->(Cn, %fn. None)) |)\<rangle>)")
apply(auto)
prefer 2
apply(subgoal_tac "\<langle>VALdec x (NEWop Cn),s(| oheap := K |)\<rangle> \<longrightarrow>\<^sub>l \<langle>rtVoid,s
              (| oheap := oheap s(l|->(Cn, %fn. None)), clock := Suc (clock s), locals := locals s(x|->rtRef (locRef l)),
                 oheap := K(l|->(Cn, %fn. None)) |)\<rangle>")
apply(auto)
apply(rule NEWop)
apply(auto)
apply(simp add: newAddr_def Some_def)
prefer 2
apply(rule NEWop)
apply(auto)
apply(simp add: newAddr_def Some_def)
prefer 3
apply(rule)
apply(simp_all add: lupd_def tick_def new_obj_def)
prefer 4
apply(rule)
apply(auto)
prefer 4
apply(subgoal_tac "R (s(| oheap := oheap s(l|->(Cn, %fn. None)), clock := Suc (clock s), locals := locals s(x|->rtRef (locRef l)),
                        oheap := L |)) &
                 orthogonal (K(l|->(Cn, %fn. None))) L & extEq (K(l|->(Cn, %fn. None)) ++ L) (oheap s(l|->(Cn, %fn. None)))")
apply(auto)
apply(simp add:get_local_def)
prefer 2
apply(simp add: orthogonal_def Int_def dom_def)
apply(auto)
apply(simp add: extEq_def override_def newAddr_def)
oops
apply(subgoal_tac "oheap s l = Some(a,ba)")
apply(simp)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(erule eval_PrimOp.elims)
apply(auto)
apply(simp_all add: lupd_def tick_def new_obj_def)
done

(*Try this again
lemma "(pSound P I Q) --> pSound (STAR P R) I (STAR Q R)"
apply(clarify)
apply(simp add: pSound_def)
apply(clarify)
apply(simp add:STAR_def)
apply(clarify)
apply(subgoal_tac "extStar Q R K L t")
apply(auto)
apply(simp add:extStar_def)
apply(auto)
3 goals
??apply(erule PrimOpJudgement.elims)
??apply(clarify)
apply(erule eval_PrimOp.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(simp_all add: tick_def put_field_def get_obj_def upd_obj_def Let_def)
apply(auto)
apply(erule eval_PrimOp.elims)
apply(auto)
*)

lemma "\<langle>v,s\<rangle> \<longrightarrow>\<^sub>v 
       \<langle>interprete2 v s,s\<rangle>"
apply(case_tac v)
apply(auto)
done

(* Total correctness *)
lemma "(P s & (P, v, I, Q) \<in> PrimOpSomeJudgement) -->
       (EX rtv t. (\<langle> VALdec v I,s \<rangle> \<longrightarrow>\<^sub>l
                   \<langle> rtv,t \<rangle>))"
apply(clarify) 
apply(erule PrimOpSomeJudgement.elims) 
(*Getfield:*)
apply(clarify) 
apply(simp add: get_local_def get_obj_def single_def dom_def)
apply(subgoal_tac 
  "\<langle>VALdec v (GETFIELDop x (FDESC t fld)),s\<rangle> 
   \<longrightarrow>\<^sub>l 
   \<langle>rtVoid, lupd v ba (tick s)\<rangle>")
apply(auto)
apply(simp_all add: get_local_def lupd_def get_field_def get_obj_def)
apply(auto)
(*New:*)
apply(subgoal_tac 
  " \<langle>VALdec v (NEWop C),s\<rangle> \<longrightarrow>\<^sub>l 
    \<langle>rtVoid, tick (lupd v (rtRef(locRef ll)) (new_obj ll C s))\<rangle>")
apply(auto)
apply(simp_all add: new_obj_def tick_def lupd_def)
done

(*Putfield:*)
lemma "(P s & (P, I, Q) \<in> PrimOpJudgement) --> 
       (EX rtv t. (\<langle> I,s \<rangle> \<longrightarrow>\<^sub>o 
                   \<langle> rtv,t \<rangle>))"
apply(clarify) 
apply(erule PrimOpJudgement.elims) 
apply(clarify) 
apply(subgoal_tac 
  " \<langle>PUTFIELDop x (FDESC t fld) v,s\<rangle> \<longrightarrow>\<^sub>o 
    \<langle>rtVoid, tick (put_field s ll fld (interprete2 v s))\<rangle>")
apply(auto)
apply(simp_all add: get_field_def get_obj_def get_local_def single_def dom_def
      put_field_def)
apply(case_tac v)
apply(auto)
done

end
