theory ListGr = GrailState:

(*Alpha Lists*)
consts C_List::"Cname => Cname"

consts is_C_object:: "Cname => Obj => bool"
primrec
"is_C_object C (cname,fields) = (cname = C)"

consts is_CList_object:: "Cname => Obj => bool"
primrec
"is_CList_object C (cname,fields) = (cname = C_List C)"

consts head :: "Vname"
constdefs headDesc::"Cname => FieldDesc"
"headDesc C == FDESC (Ty.REFty C) head"

consts tail :: "Vname"
constdefs tailDesc::"Cname => FieldDesc"
"tailDesc C == FDESC (Ty.REFty (C_List C)) tail"

constdefs cons ::"Cname => Reference => Reference => Obj"
"cons C h t == (C_List C, (empty (head |-> (rtRef h)) (tail |-> (rtRef t))))"

(*We now fix C*)
consts C ::"Cname"

consts this::"Vname"
consts JavaLangObject::"Cname"
consts ObjectInitName::"Mname"
constdefs ObjectInitDesc::"MethDesc"
"ObjectInitDesc == MDESC VOIDTy JavaLangObject ObjectInitName []"

(* method init *)
constdefs InitLetDec1:: "LetDec"
"InitLetDec1 == (VOIDdec (INVOKESPECIALop this ObjectInitDesc []))"
constdefs InitLetDec2:: "Vname => LetDec"
"InitLetDec2 H == (VOIDdec (PUTFIELDop this (headDesc C) (VARval H)))"
constdefs InitLetDecs :: "Vname => LetDecs"
"InitLetDecs H == FULLdec InitLetDec1 (FULLdec (InitLetDec2 H) EMPTYdec)"
constdefs InitFunDecs :: "FunDecs"
"InitFunDecs == EMPTYfundec"
constdefs InitResult :: "Result"
"InitResult == PRIMres (OPres (PUTFIELDop this 
                                          (tailDesc C) 
                                          (NULLval (C_List C))
                              )
                       )"
constdefs InitMethBody :: "Vname => MethBody"
"InitMethBody H == MBODY (InitLetDecs H) InitFunDecs InitResult"
consts InitName::"Mname"
consts HEAD::"Vname"
constdefs InitParam::"Arg"
"InitParam == ARG (Ty.REFty C) HEAD"
constdefs InitModifiers:: "Modifiers"
"InitModifiers == MODS PUBLIC None"
constdefs INIT:: "MethDef"
"INIT == METHOD InitModifiers VOIDTy InitName (FULLal InitParam EMPTYal) (InitMethBody HEAD)"

(*method mkList*)
consts L::"Vname"
consts TAIL::"Vname"
consts mkListNNotZeroName::"Fname"
(*"mkListNNotZeroName == n_notZero"*)
consts mkListName::"Mname"
constdefs mkListDesc::"MethDesc"
"mkListDesc == MDESC (REFty (C_List C)) 
                     (C_List C) 
                     mkListName 
                     [Ty.INTty,Ty.REFty (C_List C)]"
constdefs mkListNNotZeroBodyLetDecs::"Vname => Vname => LetDecs"
"mkListNNotZeroBodyLetDecs N ENTRY ==
  FULLdec (VALdec N (BINop SUBop (VARval N) (INTval 1)))
          (FULLdec (VALdec L (NEWop (C_List C)))
                   (FULLdec (VOIDdec (PUTFIELDop L 
                                                 (headDesc C) 
                                                 (VARval ENTRY)))
                            (FULLdec (VALdec TAIL 
                                             (INVOKESTATICop mkListDesc 
                                                           (FULLvar N 
                                                           (FULLvar ENTRY 
                                                            EMPTYvar))))
                                     (FULLdec (VOIDdec (PUTFIELDop L 
                                                                (tailDesc C)
                                                                (VARval TAIL)))
                                              EMPTYdec))))"
constdefs mkListNNotZeroBody::"Vname => Vname => FunBody"
"mkListNNotZeroBody N ENTRY ==
  FUNbody EMPTYdec (PRIMres (OPres (VALop (VARval L))))"
constdefs mkListNNotZeroFun::"Vname => Vname => FunDec"
"mkListNNotZeroFun N ENTRY ==
  FDEC mkListNNotZeroName 
       (FULLal (ARG Ty.INTty N) (FULLal (ARG (Ty.REFty JavaLangObject) ENTRY) 
                                        EMPTYal))
       (mkListNNotZeroBody N ENTRY)"
constdefs mkListFunDecs::"Vname => Vname => FunDecs"
"mkListFunDecs N ENTRY == FULLfundec (mkListNNotZeroFun N ENTRY) EMPTYfundec"
constdefs mkListResult::"Vname => Vname => Result"
"mkListResult N ENTRY == 
   CHOICEres (CONDhead (VARval N) EQUALStest (INTval 0))
             (OPres (VALop (NULLval (C_List C))))
             (FUNres mkListNNotZeroName (FULLvar N (FULLvar ENTRY EMPTYvar)))"
constdefs mkListBody::"Vname => Vname => MethBody"
"mkListBody N ENTRY == MBODY EMPTYdec 
                             (mkListFunDecs N ENTRY) 
                             (mkListResult N ENTRY)"
consts N::"Vname"
consts ENTRY::"Vname"
constdefs mkListParam1::"Arg"
"mkListParam1 == ARG Ty.INTty N"
constdefs mkListParam2::"Arg"
"mkListParam2 == ARG (Ty.REFty JavaLangObject) ENTRY"
constdefs mkListModifiers::"Modifiers"
"mkListModifiers == MODS PUBLIC (Some STATIC)"
constdefs mkList::"MethDef"
"mkList == METHOD mkListModifiers (REFty (C_List C)) mkListName 
           (FULLal mkListParam1 (FULLal mkListParam2 EMPTYal))
           (mkListBody N ENTRY)"
end
