theory GrailListPred = GrailLIST + GrailSeplogic:

(*Reynolds list predicate*)

(*in the following definition, the nullref case is there because we can't 
  call listPred -- this will change once we gat case_syntax working*)
consts listPredLoc:: "(int list) => Loc => RTVal => ass"
consts listPredLocAux:: "int => (int list) => Loc => RTVal => ass"
primrec
"listPredLoc [] l1 rtv2 s = (emp s & (rtRef (locRef l1)) = rtv2)"
"listPredLoc (h # t) l1 rtv2 s = 
  ( if t = [] 
    then (EX r. (single l1 (mkLIST h (rtRef r)) s))
    else (EX l. (extStar (single l1 (mkLIST h (rtRef(locRef l)))) 
                 (listPredLoc t l rtv2) (restr (heap s) {l1}) 
                 (restr (heap s) (dom (heap s) - {l1})) s))
  )" 

consts listPredAux1:: "(int list) => Reference => RTVal => ass"
primrec
"listPredAux1 intlist nullRef rtv2 s = (rtv2 = rtRef(nullRef) & intlist = [])"
"listPredAux1 intlist (locRef l1) rtv2 s = listPredLoc intlist l1 rtv2 s"

consts listPred:: "(int list) => RTVal => RTVal => ass"
primrec
"listPred intlist (rtRef r) rtv2 s = listPredAux1 intlist r rtv2 s"
"listPred intlist rtVoid rtv2 s = False" 
(*"listPred intlist (rtBool b) rtv2 s = False" *)
"listPred intlist (rtInt n) rtv2 s = False" 
(*"listPred intlist (rtString st) rtv2 s = False" *)
end
