theory GrailLIST = GrailState:

consts LIST :: "Cname"
consts is_LIST_object:: "HVal => bool"
primrec
"is_LIST_object (cname,fields) = (cname = LIST)"
(* later we will do INT lists rather than int lists
consts INTCLASS :: "Cname"
consts is_INT_object:: "HVal => bool"
primrec
"is_INT_object (cname,fields) = (cname = INTCLASS)"
*)


consts head :: "Vname"
constdefs headDesc::"FieldDesc"
"headDesc == FDESC Ty.INTty head"
(*later:
constdefs headDesc::"FieldDesc"
"headDesc == FDESC (REFty INTCLASS) head" 
*)

consts tail :: "Vname"
constdefs tailDesc::"FieldDesc"
"tailDesc == FDESC (Ty.REFty LIST) tail"
(*
consts cont :: "Vname"
constdefs contDesc :: "FieldDesc"
"contDesc == FDESC INTty cont"

constdefs mkINT::"int => HVal"
"mkINT n == (INTCLASS, empty ( cont |-> (rtInt n)))"
*)


constdefs cons ::"Reference => Reference => HVal"
"cons h t == (LIST, (empty (head |-> (rtRef h)) (tail |-> (rtRef t))))"

consts mkLIST:: "int => RTVal => HVal"
primrec
"mkLIST h (rtRef r) = (LIST, empty (head |-> (rtInt h)) (tail |-> (rtRef r)))"

end
