(* Time-stamp: <Mon Dec 16 2002 21:46:54 hwloidl> 
   Title:      GrailExamples.thy
   ID:         $Id: GrailExamples.thy,v 1.3 2003/02/22 14:10:31 da Exp $ 
   Author:     ME
   Copyright:  GPL
   Emacs name: Evenings, Mornings, And a Couple of Saturdays

   Example evaluations of dyn sem and various lemmas over resources. 
   All for (almost) full Grail.
*)

theory GrailExamples = GrailDynSem:

subsection "Generic constants"

constdefs one::"int"
"one \<equiv> int 1"
constdefs two::"int"
"two \<equiv> int 2"
constdefs three::"int"
"three \<equiv> two + one"
constdefs four::"int"
"four \<equiv> two + two"

constdefs six::"int"
"six \<equiv> three + three"
constdefs  twentyfour::"int"
"twentyfour \<equiv> six * four"

subsection "Example programs"

subsubsection "foo"

text {*
Simple example mainly testing function call.
Same as foo in CoreGrailExamples but now for methods rather than functions.
*}

consts foo :: "Mname"

constdefs fooRes :: "Result"
"fooRes \<equiv> PRIMres (OPres (INVOKESTATICop (MDESC INTty rootClass foo []) EMPTYvar))"

constdefs fooCall :: "MethBody"
"fooCall \<equiv> MBODY
                         EMPTYdec
                         EMPTYfundec
                         fooRes"

constdefs fooBody :: "MethBody"
"fooBody \<equiv> MBODY
                (FULLdec (VOIDdec (VALop (INTval 1))) EMPTYdec) 
                EMPTYfundec
                (PRIMres (OPres (VALop (INTval 2))))"

constdefs fooMeth :: "Methd"
"fooMeth \<equiv> (| res = INTty, args = EMPTYal, bdy = fooBody, funs = empty |)"

constdefs fooHeap :: "Heap"
"fooHeap \<equiv>  
   emptyHeap"

constdefs fooMStore :: "MethodStore"
"fooMStore \<equiv>  
   let myMMap = empty(foo \<mapsto> fooMeth)
   in let cd = (| super = rootClass, flds = empty, vars = empty, mthds = myMMap |)
   in emptyMStore ( rootClass \<mapsto> cd )"

constdefs fooState :: "State"
"fooState \<equiv> emptyState \<lparr> heap := fooHeap, methodStore := fooMStore \<rparr>"

constdefs one_plus_one :: "FunBody"
"one_plus_one \<equiv> FUNbody 
                         EMPTYdec
                         (PRIMres (OPres (BINop ADDop (INTval 1) (INTval 1))))"

consts xx :: "Vname"
       yy :: "Vname"

constdefs xx_plus_yy :: "FunBody"
"xx_plus_yy \<equiv> FUNbody 
                         (FULLdec (VALdec xx (VALop (INTval 1))) 
                         (FULLdec (VALdec yy (VALop (INTval 2))) EMPTYdec))
                         (PRIMres (OPres (BINop ADDop (VARval xx) (VARval yy))))"

(* Code: \<lambda> () . 2 *)
(* Comment: a very verbose proof, explicitly naming all rules of the dyn sem *)

lemma "\<langle>fooCall,emptyState\<rangle> \<longrightarrow>\<^sub>m \<langle>rtInt 2, tick (tick emptyState)\<rangle>"

apply (unfold fooCall_def)
apply (rule MBODY)
apply (rule EMPTYdec)
apply (rule EMPTYfundec)
apply (unfold fooRes_def)
apply (rule PRIMres)
apply (rule OPres)
apply (rule INVOKESTATICop)
apply (unfold grab_mdesc_def)
apply (simp_all)
apply (rule conjI)
apply (simp_all)
apply (unfold get_method_def)
apply (unfold methodStore_def)

(* doesn't get body out of store *)
apply (simp)
apply (simp)

apply (simp)
apply (simp)
apply (simp)
apply (rule
apply (unfold methodStore_def)


