theory AbstrVerif = ListPred + ListReverseProgram:

(*--------------------- Abstract verification ----------------------------*)
(*This is an attempt to verify Reynolds reversal foundationally,
  but not axiomatically*)

constdefs nil::"RTVal"
"nil == rtRef(nullRef)"

lemma LemmaListPredEmpty: "listPred [] rtv nil s --> (rtv = nil)"
apply(clarify)
apply(simp add:nil_def)
apply(case_tac rtv)
apply(auto)
apply(case_tac Reference)
apply(auto)
done

consts L:: "int list"

constdefs P1a::"ass"
"P1a s == (EX alpha beta.((star (listPred alpha (s<i>) nil)
                                (listPred beta (s<j>) nil) s) &
                           (rev L = (rev alpha) @ beta) &
                           (s<i> ~= nil)))"
constdefs P1b::"ass"
"P1b s == (EX a alpha beta. ((star (listPred (a#alpha) (s<i>) nil)
                                   (listPred beta (s<j>) nil) s) &
                             rev L = (rev (a#alpha)) @ beta))"
constdefs P1cAUX::"int => int list => int list => RTVal => loc => ass"
"P1cAUX a alpha beta K l s == (s<i> = rtRef(locRef l) &
            (star (star (single l (mkLIST a K)) 
                        (listPred alpha K nil))
                  (listPred beta (s<j>) nil) s) &
            rev L = (rev (a#alpha)) @ beta)"
constdefs P1c::"ass"
"P1c s == (EX A Alpha Beta KK ll. (P1cAUX A Alpha Beta KK ll s))"

lemma LemmaDomOverride: "(M1 x = E & x ~:dom M2) --> ((M1 ++ M2) x = E)"
apply(clarify)
apply(simp add: dom_def override_def)
done

lemma "ALL s. (head ~= tail --> P1b s --> P1c s)"
apply(clarify)
apply(simp add: P1b_def P1c_def)
apply(auto)
apply(case_tac "alpha")
apply(auto)
apply(subgoal_tac "EX l. (s<i> = rtRef(locRef l))")
prefer 2
apply(simp add: star_def nil_def)
apply(case_tac "s<i>")
apply(auto)
apply(case_tac "Reference")
apply(auto)
apply(subgoal_tac "EX flds. (get_obj s l = (LIST,flds))")
apply(auto)
apply(case_tac "flds tail")
apply(simp add: get_obj_def single_def star_def)
apply(auto)
apply(subgoal_tac "oheap s l = K l")
apply(subgoal_tac "flds = empty(head|->rtInt a)(tail|->rtRef r)")
apply(auto)
apply(case_tac "l : dom (oheap s)")
apply(auto)
apply(rule)
apply(case_tac "x = head")
apply(auto)
apply(case_tac "l: dom La")
apply(simp add: orthogonal_def Int_def)
apply(case_tac "Some (LIST, flds)")
apply(simp add: override_def dom_def)
apply(simp add: override_def dom_def empty_def)
apply(auto)
apply(subgoal_tac "(K ++ La) l = Some (LIST, empty(head|->rtInt a)(tail|->rtRef r))")
apply(insert LemmaDomOverride)(* [of "K" "l" "Some (LIST, empty(head|->rtInt a)(tail|->rtRef r))" "M2" ])*)
apply(case_tac "(K ++ La) l")
apply(simp)
apply(simp)
apply(subgoal_tac "P1cAUX a [] beta kk l s")
oops
apply(rule exI)
apply(auto)
apply(simp add: P1cAUX_def star_def)
apply(auto)
apply(subgoal_tac "(EX Ka.
                     single l (mkLIST a kk)
                      (s(| oheap := K, oheap := Ka |)) &
                     (EX L. listPred alpha kk nil
                             (s(| oheap := K, oheap := L |)) &
                            orthogonal Ka L & Ka ++ L = K)) &
                 (EX L. listPred beta (s<j>) nil (s(| oheap := L |)) &
                        orthogonal K L & K ++ L = oheap s)")
apply(auto)
apply(subgoal_tac "single l (mkLIST a kk) (s(| oheap := K, oheap := restr K {l} |)) &
              (EX L. listPred alpha kk nil (s(| oheap := K, oheap := L |)) &
                     orthogonal (restr K {l}) L & (restr K {l}) ++ L = K)")
apply(auto)
apply(simp add: single_def restr_def dom_def get_obj_def)
apply(rule)
apply(auto)
apply(case_tac "K l")
apply(auto)
apply(case_tac "alpha")
apply(auto)
apply(simp add: single_def)
apply(simp add: extStar_def dom_def restr_def single_def)
apply(case_tac "K l")
apply(auto)
apply(case_tac "alpha")
apply(auto)
apply(simp add: single_def)
apply(simp add: extStar_def dom_def restr_def single_def)
apply(case_tac "alpha")
apply(auto)
apply(simp add: single_def)
apply(auto)
apply(subgoal_tac "kk = rtRef r")
apply(auto)
apply(subgoal_tac "oheap s l = Some (LIST, empty(head|->rtInt a)(tail|->rtRef r))")
apply(auto)
apply(subgoal_tac "La l = None")
prefer 2
apply(simp add: orthogonal_def dom_def)
apply(auto)
prefer 3
apply(case_tac "alpha")
apply(auto)
apply(subgoal_tac "listPred [] kk nil (s(| oheap := K, oheap := empty |)) &
                 orthogonal (restr K {l}) empty & restr K {l} ++ empty = K")
apply(auto)
apply(simp add: nil_def empty_def)
oops
apply(simp add: override_def)
apply(case_tac "(K ++ La) l")
apply(auto)
apply(subgoal_tac "(%x. option_case (K x) Some (La x)) l = Some (LIST, empty(head|->rtInt a)(tail|->rtRef r))")
apply(auto)



apply(case_tac "(%x. option_case (K x) Some (La x)) l")
apply(auto)
apply(simp add: override_def dom_def)
apply(auto)
apply(simp add: extStar_def dom_def restr_def single_def)
apply(simp add: extStar_def dom_def restr_def single_def)
apply(case_tac "alpha")
apply(simp add: extStar_def dom_def restr_def single_def)
apply(auto)

done

lemma "P1a s --> P1b s"
apply(clarify)
apply(simp add:P1a_def P1b_def)
apply(auto)
apply(subgoal_tac "star (listPred ((hd alpha) # (tl alpha)) (s<i>) nil) (listPred beta (s<j>) nil)
            s &
           List.rev alpha @ beta = List.rev (tl alpha) @ (hd alpha) # beta")
apply(auto)
apply(subgoal_tac "(hd alpha) # (tl alpha) = alpha")
apply(auto)
apply(case_tac alpha)
apply(auto)
apply(simp add: star_def)
apply(auto)
apply(insert LemmaListPredEmpty)
apply(auto)
apply(case_tac alpha)
apply(auto)
apply(simp add: star_def)
apply(insert LemmaListPredEmpty)
apply(auto)
done

(* ---------------- before 06/01/2003 -------------------------------- *)
constdefs InvAUX :: "int list => RTVal => int list => RTVal => loc set => 
                     loc set => ass"
"InvAUX a v b w K H s == extStar (listPred a v nil) 
                             (listPred b w nil) 
                             (restr (oheap s) K)
                             (restr (oheap s) H) 
                             s"

constdefs Inv::"ass"
"Inv s == (EX a b. ((reverse L = (reverse a) @ b) & 
                      (EX K H. InvAUX a (s<i>) b (s<j>) K H s))
            )"

constdefs Loop1Aux2::"int list => int list => loc set => loc set => ass"
"Loop1Aux2 a b G F t == (extStar (listPred a (t<k>) nil) 
                             (listPred b (t<j>) nil) 
                             (restr (oheap t) G)
                             (restr (oheap t) F)
                             t)"
constdefs Loop1Aux::"int => int list => int list 
                     => loc set => loc set => ass"
"Loop1Aux A a b K H s == 
  extStar (listPred [A] (s<i>) (s<k>))
          (% t. (EX G F. Loop1Aux2 a b G F t))
          (restr (oheap s) K)
          (restr (oheap s) H)
          s"


constdefs Loop1::" int => int list => int list => ass"
"Loop1 A a b s == ((reverse L = (reverse (A # a)) @ b) & 
                  (EX K H. Loop1Aux A a b K H s))"

constdefs LI1::"LetDec"
"LI1 == VALdec k (GETFIELDop i tailDesc)"

lemma lp1: "
  (((listPred ll v w s) & ll ~= []) --> (EX l. ( v = rtRef(locRef l) & l : dom(oheap s))))"
apply(auto)
apply(case_tac "ll")
apply(auto)
apply(case_tac "v")
apply(auto)
apply(case_tac "Reference")
apply(auto)
apply(case_tac "list")
apply(simp_all add: dom_def single_def extStar_def extEq_def restr_def 
                    orthogonal_def)
apply(auto)
done

lemma lp2: 
  "(listPred [] v nil s) --> (v = nil)"
apply(auto)
apply(case_tac "v")
apply(auto)
apply(case_tac "Reference")
apply(auto)
done

constdefs PHI :: "loc => Fields=> ass"
"PHI l Flds s == (get_obj s l = (LIST, Flds)
                  & head : dom Flds & tail : dom Flds)"

lemma linv1: "ALL s l. 
  ((head ~= tail & i ~= j & j ~= k & i ~= k & l1 ~= l2 & Inv s & 
              s<i> = rtRef (locRef l)) --> 
              (EX Flds. (PHI l Flds s)))"
apply(clarify)
apply(simp add: get_local_def Inv_def get_obj_def InvAUX_def extStar_def 
                nil_def restr_def)
apply(auto)
apply(case_tac "a")
(*case []*)
  apply(simp)
(*Case cons*)
  apply(simp)
  apply(case_tac "list")
  apply(auto)
  apply(subgoal_tac "PHI l (snd (get_obj s l)) s")
  apply(auto)
  apply(case_tac "l:K")
  apply(simp_all add: single_def dom_def PHI_def get_obj_def)
  apply(case_tac "l:K")
  apply(simp_all add: single_def extStar_def dom_def restr_def)
done

lemma UpdateAux[simp]: "S(| oheap := A, oheap := B |) = S(|oheap := B|)"
apply(auto)
done

lemma UpdateAUX: "S(| clock := A, locals := B, oheap := C, oheap := D|) =
                  S(| clock := A, locals := B, oheap := D|)"
apply(auto)
done

lemma L1partial:
   "ALL s t v l. (
    (head ~= tail & i ~= j & j ~= k & i ~= k & l1 ~= l2 & Inv s & 
     s<i> = rtRef (locRef l) &
       (\<langle> LI1,s \<rangle> \<longrightarrow>\<^sub>l 
        \<langle> v,t \<rangle>))
    --> (EX A a b. Loop1 A a b t))"
apply(clarify)
apply(simp add: Inv_def InvAUX_def extStar_def extEq_def orthogonal_def restr_def extEq_def dom_def)
apply(auto)
apply(simp add: get_local_def override_def LI1_def)
apply(erule eval_LetDec.elims)
apply(auto)
apply(erule eval_PrimOp.elims)
apply(auto)
apply(erule eval_Value.elims)
apply(auto)
apply(simp add: get_local_def tailDesc_def nil_def)
apply(auto)
apply(case_tac "a")
(* case a = [] *)
  apply(simp add:tick_def get_field_def lupd_def Loop1_def get_local_def 
                 extStar_def nil_def)
(* case a = aa # list *)
  apply(subgoal_tac "Loop1 aa list b (lupd k (get_field sa l tail) (tick sa))")
  apply(auto)
  apply(simp add: Loop1_def extStar_def restr_def)
  apply(case_tac "list")
  apply(auto)
  apply(subgoal_tac "Loop1Aux aa [] b {l} (dom (oheap (lupd' k|->get_field sa l tail tick sa) ) - {l} ) (lupd' k|->get_field sa l tail tick sa)")
  apply(auto) 
  apply(simp add: Loop1Aux_def)
  apply(simp add: extStar_def get_local_def lupd_def restr_def tick_def)
  apply(auto)
  apply(subgoal_tac "single l (LIST, empty(head|->rtInt aa)(tail|->rtRef r))
                  (sa(| clock := Suc (clock sa),
                        locals := locals sa(k|->get_field sa l tail),
                        oheap := %a. if a = l then oheap sa a else None |))")
  apply(auto)
  apply(simp add: single_def dom_def)
  apply(rule)
  apply(rule)
  apply(rule)
  apply(simp_all)
  apply(subgoal_tac 
  "oheap sa l = Some (LIST, empty(head|->rtInt aa)(tail|->rtRef r))")
  apply(clarify)
  apply(simp)
  apply(case_tac "l:K")
  apply(simp_all)
  apply(subgoal_tac 
  "oheap sa l = Some (LIST, empty(head|->rtInt aa)(tail|->rtRef r))")
  apply(clarify)
  apply(case_tac "l:K")
  apply(simp_all)
  apply(subgoal_tac "Loop1Aux2 [] b (K-{l}) H
               (sa(| clock := Suc (clock sa),
                     locals := locals sa(k|->get_field sa l tail),
                     oheap :=
                       %a. if a : dom (oheap sa) & a ~= l then oheap sa a
                           else None |))")
  apply(auto)
  apply(simp add: dom_def Loop1Aux2_def extStar_def)
  apply(simp add: get_local_def nil_def restr_def override_def upd_obj_def)
  apply(auto)
  apply(simp add: get_field_def get_obj_def)
  apply(case_tac "(Datatype.the (snd (Datatype.the (oheap sa l)) tail))")
  apply(auto)
oops

(* ok till here 
  apply(auto)
   apply(case_tac "l:K")
  apply(simp_all)
  apply(clarify)
  apply(simp add: Loop1_def)
  apply(subgoal_tac "Loop1Aux aa list b {l} (dom (oheap (lupd' k|->get_field sa l tail tick sa) ) - {l} ) (lupd' k|->get_field sa l tail tick sa)")
  apply(auto) 
  apply(simp add: Loop1Aux_def)
  apply(simp add: extStar_def get_local_def lupd_def restr_def tick_def)
  apply(auto)
  apply(simp add: dom_def emp_def orthogonal_def get_field_def
                  get_obj_def extEq_def override_def)
  apply(subgoal_tac "single l
               (LIST, empty(head|->rtInt aa)(tail|->rtRef (locRef la)))
               (sa(| clock := Suc (clock sa),
                     locals := locals sa(k
                       |->Datatype.the
                           (snd (Datatype.the (oheap sa l)) tail)),
                     oheap := %a. if a = l then oheap sa a else None,
                     oheap :=
                       %a. if a = l then if a = l then oheap sa a else None
                           else None |)) &
              rtRef (locRef la) =              Datatype.the (snd (Datatype.the (oheap sa l)) tail)")
  apply(auto)
  apply(simp add: single_def dom_def)
  apply(rule)
  apply(rule)
  apply(rule)
  apply(simp_all)
  apply(subgoal_tac 
  "oheap sa l = Some (LIST, empty(head|->rtInt aa)(tail|->rtRef (locRef la)))")
  apply(clarify)
  apply(simp)
  apply(case_tac "l:K")
  apply(simp_all)
  apply(case_tac "l:K")
  apply(simp_all)
  apply(simp add: single_def dom_def)
  apply(clarify)
  apply(subgoal_tac 
  "oheap sa l = Some (LIST, empty(head|->rtInt aa)(tail|->rtRef (locRef la)))")
  apply(simp_all)
  apply(case_tac "l:K")
  apply(simp_all)
*)
(* now 3 goals left *)
  prefer 2
  apply(simp add: orthogonal_def dom_def)
  apply(auto)
(* now 2 goals left *)
  prefer 2
  apply(simp add: extEq_def override_def dom_def)
  apply(auto)
(* copy from here...*)

  apply(case_tac "oheap sa lb")
  apply(auto)
(* now 1 goal left *)
  apply(simp add: get_field_def get_obj_def)
  apply(subgoal_tac "Loop1Aux2 list b (K - {l}) H
               (sa(| clock := Suc (clock sa),
                     locals := locals sa(k
                       |->Datatype.the
                           (snd (Datatype.the (oheap sa l)) tail)),
                     oheap :=
                       %a. if a : dom (oheap sa) & a ~= l then oheap sa a
                           else None |))")
  apply(auto)
  apply(simp add: dom_def Loop1Aux2_def extStar_def)
  apply(simp add: get_local_def nil_def restr_def override_def upd_obj_def)
  apply(auto)
  apply(subgoal_tac "Datatype.the (snd (Datatype.the (oheap sa l)) tail) = rtRef (locRef la)")
  apply(auto)
  apply(case_tac "list")
  apply(simp_all)
  apply(auto)
  apply(subgoal_tac "extStar
               (single la
                 (LIST, empty(head|->rtInt a)(tail|->rtRef (locRef lb))))
               (listPredLoc lista lb (rtRef nullRef))
               (restr
                 (%a. if a : K & a ~= l
                      then if (EX aa b. oheap sa a = Some (aa, b)) & a ~= l
                           then oheap sa a else None
                      else None)
                 {la})
               (restr
                 (%a. if a : K & a ~= l
                      then if (EX aa b. oheap sa a = Some (aa, b)) & a ~= l
                           then oheap sa a else None
                      else None)
                 (dom (%a. if a : K & a ~= l
                           then if (EX aa b. oheap sa a = Some (aa, b)) &
                                   a ~= l
                                then oheap sa a else None
                           else None) -
                  {la}))
               (sa(| clock := Suc (clock sa),
                     locals := locals sa(k|->rtRef (locRef la)),
                     oheap :=
                       %a. if (EX aa b. oheap sa a = Some (aa, b)) & a ~= l
                           then oheap sa a else None,
                     oheap :=
                       %a. if a : K & a ~= l
                           then if (EX aa b. oheap sa a = Some (aa, b)) &
                                   a ~= l
                                then oheap sa a else None
                           else None |))")
  apply(auto)
  apply(simp add: extStar_def restr_def single_def dom_def)
  apply(rule)
  apply(rule)
  apply(rule)
  apply(rule)
  apply(rule)
  apply(case_tac "oheap sa la")
  apply(simp)
  apply(simp)
  apply(rule)
  apply(simp)
  apply(clarify)
  apply(simp_all add: orthogonal_def extEq_def dom_def override_def Int_def 
                      lupd_def extStar_def restr_def dom_def extEq_def)
  apply(auto)
  apply(case_tac "lb:K")
  apply(simp)
  apply(simp_all add: single_def dom_def restr_def extEq_def extStar_def)
  apply(clarify)
  apply(simp_all add: orthogonal_def override_def dom_def)
  apply(simp_all add: Int_def)
  apply(case_tac "la:K")
  apply(simp_all)
  apply(case_tac "oheap sa la")
  apply(simp_all)
  apply(case_tac "la = l")
oops
  apply(simp_all)
  apply(case_tac "oheap sa l")
  apply(simp_all)
apply()
done
(*
lemma L1:"(Inv s & (s<i> ~= nil)) --> 
      (EX v t. \<langle> LI1,s \<rangle> \<longrightarrow>\<^sub>l 
               \<langle> v,t \<rangle>) "
apply(clarify)
apply(subgoal_tac "\<langle>LI1,s\<rangle> \<longrightarrow>\<^sub>l 
                   \<langle>get_field s (rtval2loc (s<i>)) tail,
                            lupd k (get_field s (rtval2loc(s<i>)) tail) s\<rangle>")
apply(auto)
apply(simp add:LI1_def Inv_def InvAUX_def get_local_def lupd_def get_field_def extStar_def restr_def)
apply(auto)
oops
done

