(* 
   Title:      GrailTest1.thy
   ID:         $Id: GrailTest1.thy,v 1.1 2003/02/15 09:43:55 da Exp $ 
   Author:     Hans-Wolfgang Loidl

   Example evaluations of dyn sem and various lemmas over resources,
   for (almost) full Grail.  

   FIXME: currently broken
*)

theory GrailTest1 = GrailDef:

subsubsection "Predicates over Resource Consumption"

constdefs 
  needsTime :: "MethBody \<Rightarrow> Time \<Rightarrow> bool"
 "needsTime \<equiv> (\<lambda> c. \<lambda> n. (\<exists> s. \<exists> v. (\<langle>c,emptyState\<rangle> \<longrightarrow>\<^sub>m \<langle>v,s\<rangle>) & (clock s) = n))"

  boundedTime :: "MethBody \<Rightarrow> Time \<Rightarrow> bool"
 "boundedTime \<equiv> (\<lambda> c. \<lambda> n. (\<exists> s. \<exists> v. (\<langle>c,emptyState\<rangle> \<longrightarrow>\<^sub>m \<langle>v,s\<rangle>) & (clock s) <= n))"

  needsTimeWithState :: "State \<Rightarrow> MethBody \<Rightarrow> Time \<Rightarrow> bool"
 "needsTimeWithState \<equiv> (\<lambda> s. \<lambda> c. \<lambda> n. (? s'. ? v. (\<langle>c,s\<rangle> \<longrightarrow>\<^sub>m \<langle>v,s'\<rangle>) & (clock s') = n))"

  boundedTimeWithState :: "State \<Rightarrow> MethBody \<Rightarrow> Time \<Rightarrow> bool"
 "boundedTimeWithState \<equiv> (\<lambda> s. \<lambda> c. \<lambda> n. (? s'. ? v. (\<langle>c,s\<rangle> \<longrightarrow>\<^sub>m \<langle>v,s'\<rangle>) & (clock s') <= n))"

  boundedTimeV :: "Value \<Rightarrow> Time \<Rightarrow> bool"
 "boundedTimeV \<equiv> (\<lambda> c. \<lambda> n. (\<exists> s. \<exists> v. (\<langle>c,emptyState\<rangle> \<longrightarrow>\<^sub>v \<langle>v,s\<rangle>) & (clock s) <= n))"

subsection "Generic constants"

constdefs one::"int"
"one \<equiv> int 1"
constdefs two::"int"
"two \<equiv> int 2"
constdefs three::"int"
"three \<equiv> two + one"
constdefs four::"int"
"four \<equiv> two + two"

constdefs six::"int"
"six \<equiv> three + three"
constdefs  twentyfour::"int"
"twentyfour \<equiv> six * four"

subsection "Example programs"

subsubsection "Function Calls"

(* Code:    (\<lambda> (). 2) () *)
(* Comment: A Lemma over time consumption of evaluation *)

consts c2 :: "Fname"
consts c2M :: "Mname"

constdefs c2Res :: "Result"
"c2Res \<equiv> PRIMres (FUNres c2 EMPTYvar)"

constdefs c2Call :: "FunBody"
"c2Call \<equiv> FUNbody 
                         EMPTYdec
                         c2Res"

constdefs c2Fun :: "FunBody"
"c2Fun \<equiv> FUNbody 
                (FULLdec (VOIDdec (VALop (INTval 1))) EMPTYdec) 
                (PRIMres (OPres (VALop (INTval 2))))"

constdefs c2MBody :: "MethBody"
"c2MBody \<equiv> (MBODY 
                    EMPTYdec 
                    EMPTYfundec 
                    (PRIMres (FUNres c2 EMPTYvar)))"

constdefs c2Mthd :: "Methd"
"c2Mthd \<equiv> \<lparr> res = INTty, args = EMPTYal, bdy = c2MBody, funs = empty(c2 \<mapsto> (EMPTYal, c2Fun)) \<rparr>"

constdefs c2Heap :: "Heap"
"c2Heap \<equiv>  emptyHeap"

(* MUST use this def, without let, to make proof work *)
constdefs c2MStore2 :: "MethodStore"
"c2MStore2 \<equiv>  
   emptyMStore ( rootClass \<mapsto> \<lparr> super = rootClass, flds = empty, vars = empty, mthds = empty(c2M \<mapsto> c2Mthd) \<rparr> )"

constdefs c2State2 :: "State"
"c2State2 \<equiv> emptyState \<lparr> heap := c2Heap, methodStore := c2MStore2 \<rparr>"

subsubsection "foo"

text {*
Simple example mainly testing function call.
Same as foo in CoreGrailExamples but now for methods rather than functions.


 invokestatic rootClass.foo ()

 foo () {
  let 
    () = 1
  in 
    2
*}

consts foo :: "Mname"

constdefs fooRes :: "Result"
"fooRes \<equiv> PRIMres (OPres (INVOKESTATICop (MDESC INTty rootClass foo []) EMPTYvar))"

constdefs fooCall :: "MethBody"
"fooCall \<equiv> MBODY
                         EMPTYdec
                         EMPTYfundec
                         fooRes"

constdefs fooBody :: "MethBody"
"fooBody \<equiv> MBODY
                (FULLdec (VOIDdec (VALop (INTval 1))) EMPTYdec) 
                EMPTYfundec
                (PRIMres (OPres (VALop (INTval 2))))"

constdefs fooMeth :: "Methd"
"fooMeth \<equiv> (| res = INTty, args = EMPTYal, bdy = fooBody, funs = empty |)"

constdefs fooHeap :: "Heap"
"fooHeap \<equiv>  
   emptyHeap"

constdefs fooMStore :: "MethodStore"
"fooMStore \<equiv>  
   let myMMap = empty(foo \<mapsto> fooMeth)
   in let cd = \<lparr> super = rootClass, flds = empty, vars = empty, mthds = myMMap \<rparr>
   in emptyMStore ( rootClass \<mapsto> cd )"

(* MUST use this def, without let, to make proof work *)
constdefs fooMStore2 :: "MethodStore"
"fooMStore2 \<equiv>  
   emptyMStore ( rootClass \<mapsto> \<lparr> super = rootClass, flds = empty, vars = empty, mthds = empty(foo \<mapsto> fooMeth) \<rparr> )"

constdefs fooState :: "State"
"fooState \<equiv> emptyState \<lparr> heap := fooHeap, methodStore := fooMStore \<rparr>"

constdefs fooState2 :: "State"
"fooState2 \<equiv> emptyState \<lparr> heap := fooHeap, methodStore := fooMStore2 \<rparr>"

subsubsection "inc"

text {*
 Simple example mainly testing function call and parameter passing.

 inc (int i) {
   let 
     j+1
   in 
     return j;
 }
*}

consts inc :: "Mname"
consts i :: "Vname"
consts j :: "Vname"

constdefs incRes :: "Result"
"incRes \<equiv> PRIMres (OPres (INVOKESTATICop (MDESC INTty rootClass inc []) EMPTYvar))"

constdefs incCall :: "MethBody"
"incCall \<equiv> MBODY
                         EMPTYdec
                         EMPTYfundec
                         incRes"

constdefs incBody :: "MethBody"
"incBody \<equiv> MBODY
                (FULLdec (VALdec j 
                           (BINop ADDop (VARval i) (INTval 1)))
                   EMPTYdec) 
                EMPTYfundec
                (PRIMres (OPres (VALop (VARval j))))"

constdefs incMeth :: "Methd"
"incMeth \<equiv> \<lparr> res = RTy.INTty, args = FULLal (ARG Ty.INTty i) EMPTYal, bdy = incBody, funs = empty \<rparr>"

constdefs incHeap :: "Heap"
"incHeap \<equiv>  
   emptyHeap"

constdefs incMStore :: "MethodStore"
"incMStore \<equiv>  
   emptyMStore ( rootClass \<mapsto> \<lparr> super = rootClass, flds = empty, vars = empty, mthds = empty(inc \<mapsto> incMeth) \<rparr> )"

constdefs incState :: "State"
"incState \<equiv> emptyState \<lparr> heap := incHeap, methodStore := incMStore \<rparr>"

subsection "fac"

consts n :: "Vname"
       acc :: "Vname"
       m :: "Vname"
consts fac :: "Fname"
consts elseBranch :: "Fname"
consts facTwo :: "Fname"
consts facThree :: "Fname"
consts facM :: "Mname"
consts facC :: "Cname"

constdefs thenPres:: "PrimRes"
"thenPres \<equiv> OPres (VALop (VARval n))"

constdefs elsePres:: "PrimRes"
"elsePres \<equiv> FUNres elseBranch (FULLvar n (FULLvar acc EMPTYvar))"

constdefs facBody::"FunBody"
"facBody \<equiv> 
  FUNbody EMPTYdec (CHOICEres (CONDhead (VARval n) LESStest (INTval one)) thenPres elsePres)"

constdefs elseBody::"FunBody"
"elseBody \<equiv> 
  FUNbody (FULLdec (VALdec acc (BINop MULop (VARval acc) (VARval n))) 
            (FULLdec (VALdec n (BINop SUBop (VARval n) (INTval one))) EMPTYdec))
          (PRIMres (FUNres fac (FULLvar n (FULLvar acc EMPTYvar))))"

constdefs facTwoBody :: "FunBody"
"facTwoBody \<equiv> 
   FUNbody 
     (FULLdec (VALdec n (VALop (INTval (int 2)))) 
       (FULLdec (VALdec acc (VALop (INTval (int 1))))  EMPTYdec))
     (PRIMres (FUNres fac (FULLvar n (FULLvar acc EMPTYvar))))"

constdefs facTwoCall :: "Result"
"facTwoCall \<equiv> PRIMres (FUNres facTwo EMPTYvar)"

constdefs facThreeBody :: "FunBody"
"facThreeBody \<equiv> 
   FUNbody 
     (FULLdec (VALdec n (VALop (INTval (int 3)))) 
       (FULLdec (VALdec acc (VALop (INTval (int 1))))  EMPTYdec))
     (PRIMres (FUNres fac (FULLvar n (FULLvar acc EMPTYvar))))"

constdefs facThreeCall :: "Result"
"facThreeCall \<equiv> PRIMres (FUNres facThree EMPTYvar)"

constdefs facUMap :: "UMap"
"facUMap \<equiv>  
  empty ( fac \<mapsto> ((FULLal (ARG Ty.INTty acc) (FULLal (ARG Ty.INTty n) EMPTYal)), facBody) )
        ( elseBranch \<mapsto> ((FULLal (ARG Ty.INTty n) (FULLal (ARG Ty.INTty acc) EMPTYal)), elseBody))
        ( facTwo \<mapsto> (EMPTYal, facTwoBody) ) " 

(*
constdefs facUMap :: "UMap"
"facUMap \<equiv>  
  \<lambda> a . case a of 
           fac \<Rightarrow> Some ((FULLal (ARG INTty acc) (FULLal (ARG INTty n) EMPTYal)), facBody) 
         | elseBranch \<Rightarrow> Some ((FULLal (ARG INTty n) (FULLal (ARG INTty acc) EMPTYal)), elseBody) 
         | facThree \<Rightarrow> Some (EMPTYal, facThreeBody) 
         | otherwise \<Rightarrow> None "
*)
constdefs facMthd :: "Methd"
 "facMthd \<equiv> \<lparr> 
                    res = RTy.INTty, 
                    args = (FULLal (ARG Ty.INTty acc) (FULLal (ARG Ty.INTty n) EMPTYal)), 
                    bdy = MBODY EMPTYdec EMPTYfundec facThreeCall, 
                    funs = facUMap 
                   \<rparr>"

constdefs facClass :: "Class"
 "facClass \<equiv> \<lparr> 
                     super = rootClass, 
                     flds = empty, 
                     vars = empty, 
                     mthds = empty (facM \<mapsto> facMthd)
                    \<rparr>"

constdefs facMStore :: "MethodStore"
 "facMStore \<equiv> empty (facC \<mapsto> facClass)"

(* ToDo: use an instantiate function rather than lets *)
constdefs facState :: "State"
 "facState \<equiv> let s = emptyState \<lparr> methodStore := facMStore, CC := facC, CM := facM \<rparr> 
             in let sv = new_Addr s
             in let a = the_Loc (the_Ref sv)
             in let s' = new_obj a facC s
             in s' \<lparr> locals := (locals s') (This \<mapsto> sv) \<rparr> "

constdefs facState2 :: "State"
 "facState2 \<equiv> emptyState \<lparr> methodStore := facMStore, CC := facC, CM := facM \<rparr> "

constdefs Fac:: "nat \<Rightarrow> FunBody"
"Fac k \<equiv> 
  FUNbody (FULLdec (VALdec acc (VALop (INTval one)))
           (FULLdec (VALdec n (VALop (INTval (int k)))) EMPTYdec))
          (PRIMres (FUNres fac (FULLvar acc (FULLvar n EMPTYvar))))"

constdefs FacZero:: "FunBody"
"FacZero \<equiv> Fac 0"
constdefs FacOne:: "FunBody"
"FacOne \<equiv> Fac 1"
constdefs FacTwo:: "FunBody"
"FacTwo \<equiv> Fac 2"
constdefs FacThree:: "FunBody"
"FacThree \<equiv> Fac (1+2)"
constdefs FacFour:: "FunBody"
"FacFour \<equiv> Fac (2+2)"

consts facSpec:: "nat \<Rightarrow> int"
recdef facSpec "measure (\<lambda> k . k)"
"facSpec 0 = int 1" 
"facSpec k = (int k) * (facSpec (k-(nat 1)))"

subsection "others"

constdefs one_plus_one :: "FunBody"
"one_plus_one \<equiv> FUNbody 
                         EMPTYdec
                         (PRIMres (OPres (BINop ADDop (INTval 1) (INTval 1))))"

consts xx :: "Vname"
       yy :: "Vname"

constdefs xx_plus_yy :: "FunBody"
"xx_plus_yy \<equiv> FUNbody 
                         (FULLdec (VALdec xx (VALop (INTval 1))) 
                         (FULLdec (VALdec yy (VALop (INTval 2))) EMPTYdec))
                         (PRIMres (OPres (BINop ADDop (VARval xx) (VARval yy))))"

section "Resource lemmas"


lemma "\<langle>MBODY EMPTYdec EMPTYfundec (PRIMres (OPres (VALop (INTval 1)))),emptyState\<rangle> \<longrightarrow>\<^sub>m \<langle>rtInt 1, emptyState (| clock := 1 |) \<rangle>"

apply (rule MBODY)
defer 1
apply (rule EMPTYdec)
apply (rule EMPTYfundec)
apply (rule PRIMres)
apply (rule OPres)
apply (rule VALop)
apply (rule INTval)
apply (simp_all add: tick_def)
apply (simp)+
done
(* OK *)

(* Code: \<lambda> () . 2 *)
(* Comment: a very verbose proof, explicitly naming all rules of the dyn sem *)

lemma a1: "methodStore fooState = fooMStore"

apply (unfold fooState_def)
apply (simp)
done

lemma a2: "methodStore fooState2 = fooMStore2"

apply (unfold fooState2_def)
apply (simp)
done

(* lemma "cn : dom ms ==> get_method s cn mn \<noteq> None" *)

lemma b1: "get_method fooState2 rootClass foo = fooMeth"

apply (unfold get_method_def)
apply (simp add: a2)
apply (unfold fooMStore2_def)
apply (simp)
done

lemma "boundedTimeWithState fooState2 fooCall  10"

apply (unfold boundedTimeWithState_def)
apply (rule exI)+
apply (unfold fooCall_def)
apply (rule conjI)
apply (rule MBODY)
defer 1
apply (rule EMPTYdec)
apply (rule EMPTYfundec)
apply (unfold fooRes_def)
apply (rule PRIMres)
apply (rule OPres)
apply (rule INVOKESTATICop)
apply (unfold grab_mdesc_def)
apply (simp_all)
apply (rule conjI)
apply (simp_all)
apply (simp add: b1)
apply (unfold fooMeth_def)
apply (simp)
apply (unfold fooBody_def)
apply (rule MBODY)
defer 1
apply (rule FULLdec)
apply (rule VOIDdec)
apply (rule VALop)
apply (rule INTval)
apply (simp_all)
apply (rule EMPTYdec)
apply (rule EMPTYfundec)
apply (rule PRIMres)
apply (rule OPres)
apply (rule VALop)
apply (rule INTval)
apply (unfold fooState2_def)
apply (simp_all)
apply (simp add: tick_def)
done
(* OK *)

lemma c2_b1: "get_method c2State2 rootClass c2M = c2Mthd"

apply (unfold get_method_def)
apply (unfold c2State2_def)
apply (simp)
apply (unfold c2MStore2_def)
apply (simp)
done

lemma c2_b2: "get_funbody2 c2State2 rootClass c2M c2 = c2Fun"

apply (unfold get_funbody2_def)
apply (unfold c2State2_def)
apply (simp)
apply (unfold c2MStore2_def)
apply (simp)
apply (unfold c2Mthd_def)
apply (simp)
done

(* A resource lemma over code including function calls *)
lemma "boundedTimeWithState c2State2 
        (MBODY 
          EMPTYdec 
          EMPTYfundec 
          (PRIMres (OPres (INVOKESTATICop (MDESC INTty rootClass c2M []) EMPTYvar)))) 
       10"

apply (unfold boundedTimeWithState_def)
apply (rule exI)+
apply (rule conjI)
apply (rule MBODY)
defer 1
apply (rule EMPTYdec)
apply (rule EMPTYfundec)
apply (rule PRIMres)
apply (rule OPres)
apply (rule INVOKESTATICop)
apply (unfold grab_mdesc_def)
apply (simp_all)
apply (rule conjI)
apply (simp_all)
apply (simp add: c2_b1)
apply (unfold c2Mthd_def)
apply (simp)
apply (unfold c2MBody_def)
apply (rule MBODY)
defer 1
apply (rule EMPTYdec)
apply (rule EMPTYfundec)
apply (rule PRIMres)
apply (rule FUNres)
apply (unfold get_funbody2_def)
apply (simp add: c2_b2)
apply (unfold c2State2_def)
apply (simp add: c2_b2)
apply (unfold c2MStore2_def)
apply (simp add: c2_b2)
apply (unfold c2Mthd_def)
apply (simp add: c2_b2)
apply (unfold c2Fun_def)
apply (rule FUNbody)
defer 1
apply (rule FULLdec)
apply (rule VOIDdec)
apply (rule VALop)
apply (rule INTval)
apply (simp)
apply (rule EMPTYdec)
apply (rule PRIMres)
apply (rule OPres)
apply (rule VALop)
apply (rule INTval)
apply (simp_all)
apply (simp_all add:tick_def)
done
(* OK *)

lemma inc_time: "boundedTimeWithState incState
                  (MBODY 
                    EMPTYdec 
                    EMPTYfundec 
                    incRes)
             3"

apply (unfold boundedTimeWithState_def)
apply (rule exI)+
apply (unfold incRes_def)
apply (rule conjI)
apply (rule MBODY)
defer 1
apply (rule EMPTYdec)
apply (rule EMPTYfundec)
apply (rule PRIMres)
apply (rule OPres)
apply (rule INVOKESTATICop)
apply (unfold grab_mdesc_def)
apply (simp_all)
apply (rule conjI)
apply (simp_all)
apply (unfold incState_def)
apply (unfold get_method_def)
apply (simp)
apply (unfold incMStore_def)
apply (simp)
apply (unfold incMeth_def)
apply (simp)
apply (unfold incBody_def)
apply (rule MBODY)
defer 1
apply (rule FULLdec)
apply (rule VALdec)
apply (rule BINop)
apply (rule VARval)
apply (simp_all)
apply (rule INTval)
apply (rule EMPTYdec)
apply (rule EMPTYfundec)
apply (rule PRIMres)
apply (rule OPres)
apply (rule VALop)
apply (rule VARval)
apply (unfold lupd_def)
apply (simp_all)
apply (simp add: tick_def)
done
(* OK *)

lemma inc_time: "boundedTimeWithState incState
                  (MBODY 
                    EMPTYdec 
                    EMPTYfundec 
                    incRes)
             2"

apply (unfold boundedTimeWithState_def)
apply (rule exI)+
apply (unfold incRes_def)
apply (rule conjI)
apply (rule MBODY)
defer 1
apply (rule EMPTYdec)
apply (rule EMPTYfundec)
apply (rule PRIMres)
apply (rule OPres)
apply (rule INVOKESTATICop)
apply (unfold grab_mdesc_def)
apply (simp_all)
apply (rule conjI)
apply (simp_all)
apply (unfold incState_def)
apply (unfold get_method_def)
apply (simp)
apply (unfold incMStore_def)
apply (simp)
apply (unfold incMeth_def)
apply (simp)
apply (unfold incBody_def)
apply (rule MBODY)
defer 1
apply (rule FULLdec)
apply (rule VALdec)
apply (rule BINop)
apply (rule VARval)
apply (simp_all)
apply (rule INTval)
apply (rule EMPTYdec)
apply (rule EMPTYfundec)
apply (rule PRIMres)
apply (rule OPres)
apply (rule VALop)
apply (rule VARval)
apply (unfold lupd_def)
apply (simp_all)
apply (simp add: tick_def)
oops
(* returns False, stating that it needs more than 2 ticks *)

subsubsection "Factorial"

lemma fac_a1: "methodStore facState2 = facMStore"

apply (unfold facState2_def)
apply (simp)
done

lemma fac_a2: "get_method facState2 facC facM = facMthd"

apply (unfold get_method_def)
apply (simp add: fac_a1)
apply (unfold facMStore_def)
apply (simp)
apply (unfold facClass_def)
apply (simp)
done

lemma fac_a3: "CC facState2 = facC"
by (unfold facState2_def, simp)

lemma fac_a4: "CM facState2 = facM"
by (unfold facState2_def, simp)

lemma fac_s1[intro!]: "\<forall> s . CC (tick s) = CC s"
by (unfold tick_def, simp)

lemma fac_s2[intro!]: "\<forall> s . CM (tick s) = CM s"
by (unfold tick_def, simp)

lemma fac_s3[intro!]: "\<forall> s . methodStore (tick s) = methodStore s"
by (unfold tick_def, simp)

lemma fac_s4[intro!]: "\<forall> s . heap (tick s) = heap s"
by (unfold tick_def, simp)

lemma fac_s5[intro!]: "\<forall> s . locals (tick s) = locals s"
by (unfold tick_def, simp)

lemma fac_s6[intro!]: "\<forall> s . frameStack (tick s) = frameStack s"
by (unfold tick_def, simp)

lemma fac_s7[intro!]: "\<forall> s . \<forall> x . get_local (tick s) x = get_local s x"
apply (rule allI)+
apply (unfold get_local_def)
apply (unfold tick_def)
apply (simp)
done

(*
lemma fac_s8[intro!]: "\<forall> s . \<forall> val . \<lbrakk> \<langle>val,(tick s)\<rangle> \<longrightarrow>\<^sub>v \<langle>v,(tick s)\<rangle> \<rbrakk> 
                                      \<Longrightarrow>
                                      \<langle>val,s\<rangle> \<longrightarrow>\<^sub>v \<langle>v,s\<rangle>"
*)

lemma fac_b1: "\<lbrakk> fac \<noteq> elseBranch \<and> fac \<noteq> facTwo \<rbrakk> 
               \<Longrightarrow>
               get_funbody2 facState2 facC facM facTwo = facTwoBody"

apply (unfold get_funbody2_def)
apply (unfold facState2_def)
apply (unfold facMStore_def)
apply (unfold facClass_def)
apply (unfold facMthd_def)
apply (simp)
apply (unfold facUMap_def)
apply (simp)
done

lemma fac_b2: "\<lbrakk> fac \<noteq> elseBranch \<and> fac \<noteq> facTwo \<rbrakk> 
               \<Longrightarrow>
               get_funbody2 facState2 facC facM fac = facBody"

apply (unfold get_funbody2_def)
apply (unfold facState2_def)
apply (unfold facMStore_def)
apply (unfold facClass_def)
apply (unfold facMthd_def)
apply (simp)
apply (unfold facUMap_def)
apply (simp)
done

lemma fac_b3: "\<forall> s . \<forall> c . \<forall> m . \<forall> f . get_funbody2 (tick s) c m f = get_funbody2 s c m f"
by (unfold get_funbody2_def, unfold tick_def, simp)

lemma fac2_true: "\<lbrakk> fac \<noteq> elseBranch \<and> fac \<noteq> facTwo \<and> n \<noteq> acc \<and> elseBranch \<noteq> facTwo \<rbrakk> 
               \<Longrightarrow>
             boundedTimeWithState facState2
                  (MBODY 
                    EMPTYdec 
                    EMPTYfundec 
                    (PRIMres (FUNres facTwo EMPTYvar)))
             16"

apply (unfold boundedTimeWithState_def)
apply (rule exI)+
apply (rule conjI)
apply (rule MBODY)
defer 1
apply (rule EMPTYdec)
apply (rule EMPTYfundec)
apply (rule PRIMres)
apply (rule FUNres)
apply (simp add: fac_a3 fac_a4)
apply (simp add: fac_b1) 
apply (unfold facTwoBody_def)
apply (rule FUNbody)
defer 1
apply (rule FULLdec)
apply (rule VALdec)
apply (rule VALop)
apply (rule INTval)
apply (unfold lupd_def)
apply (simp)
prefer 2
apply (rule FULLdec)
apply (rule VALdec)
apply (rule VALop)
apply (rule INTval)
apply (simp_all)
apply (rule EMPTYdec)
apply (rule PRIMres)
apply (rule FUNres)
apply (unfold lupd_def)
apply (simp_all)
apply (simp add: fac_s1 fac_s2 fac_s3 fac_s4 fac_s5 fac_s6 fac_a3 fac_a4 fac_b2)+
apply (unfold get_funbody2_def)
apply (unfold facState2_def)
apply (unfold facMStore_def)
apply (unfold facClass_def)
apply (unfold facMthd_def)
apply (simp add: fac_s3)
apply (unfold facUMap_def)
apply (simp)
(* body of fac retrieved from env; n=2 *)
apply (unfold facBody_def)
apply (rule FUNbody)
defer 1
apply (rule EMPTYdec)
apply (rule CHOICEres_False)
apply (rule CONDhead)
apply (rule VARval)
apply (simp add: fac_s1 fac_s2 fac_s3 fac_s4 fac_s5 fac_s6 fac_s7)+
apply (rule INTval)
apply (unfold evalTest_def)
apply (unfold get_local_def)
apply (simp)
apply (unfold btoi_def)
apply (unfold one_def)
apply (simp)
apply (unfold elsePres_def)
apply (rule FUNres)
apply (unfold get_funbody2_def)
apply (simp add: fac_s3 fac_s2 fac_s1)
apply (unfold elseBody_def)
apply (rule FUNbody)
defer 1
apply (rule FULLdec)
apply (rule VALdec)
apply (rule BINop)
apply (rule VARval)
apply (simp)
apply (rule VARval)
apply (simp)
apply (unfold lupd_def)
apply (simp_all)
apply (rule FULLdec)
apply (rule VALdec)
apply (rule BINop)
apply (rule VARval)
apply (simp)
apply (rule INTval)
apply (unfold lupd_def)
apply (simp_all)
apply (rule EMPTYdec)
apply (rule PRIMres)
apply (rule FUNres)
(* recursive call; n=1 *)
apply (simp add: fac_b3)
apply (unfold get_funbody2_def)
apply (simp add: fac_s3 fac_s2 fac_s1)
(* fct body extracted from env *)
apply (rule FUNbody)
defer 1
apply (rule EMPTYdec)
apply (rule CHOICEres_False)
apply (rule CONDhead)
apply (rule VARval)
apply (simp add: fac_s1 fac_s2 fac_s3 fac_s4 fac_s5 fac_s6 fac_s7)+
apply (rule INTval)
apply (unfold evalTest_def)
apply (unfold get_local_def)
apply (simp)
apply (unfold btoi_def)
apply (unfold one_def)
apply (unfold evalBOP_def)
apply (simp)
apply (rule FUNres)
apply (unfold get_funbody2_def)
apply (simp add: fac_s3 fac_s2 fac_s1)
apply (rule FUNbody)
defer 1
apply (rule FULLdec)
apply (rule VALdec)
apply (rule BINop)
apply (rule VARval)
apply (simp)
apply (rule VARval)
apply (simp)
apply (unfold lupd_def)
apply (simp_all)
apply (rule FULLdec)
apply (rule VALdec)
apply (rule BINop)
apply (rule VARval)
apply (simp)
apply (rule INTval)
apply (unfold lupd_def)
apply (simp_all)
apply (rule EMPTYdec)
apply (rule PRIMres)
apply (rule FUNres)
(* recursive call; n=0 BASE CASE *)
apply (simp add: fac_b3)
apply (unfold get_funbody2_def)
apply (simp add: fac_s3 fac_s2 fac_s1)
(* fct body extracted from env *)
apply (rule FUNbody)
defer 1
apply (rule EMPTYdec)
apply (rule CHOICEres_True)
apply (rule CONDhead)
apply (rule VARval)
apply (simp add: fac_s1 fac_s2 fac_s3 fac_s4 fac_s5 fac_s6 fac_s7)+
apply (rule INTval)
apply (unfold evalTest_def)
apply (unfold get_local_def)
apply (simp)
apply (unfold btoi_def)
apply (unfold evalBOP_def)
apply (simp)
apply (unfold thenPres_def)
apply (rule OPres)
apply (rule VALop)
apply (rule VARval)
apply (simp_all)
apply (simp_all add: tick_def clock_update_def)
done
(* OK *)

(* same as above but smaller step count => should produce False *)
lemma fac2_false: "\<lbrakk> fac \<noteq> elseBranch \<and> fac \<noteq> facTwo \<and> n \<noteq> acc \<and> elseBranch \<noteq> facTwo \<rbrakk> 
               \<Longrightarrow>
             boundedTimeWithState facState2
                  (MBODY 
                    EMPTYdec 
                    EMPTYfundec 
                    (PRIMres (FUNres facTwo EMPTYvar)))
             10"



apply (unfold boundedTimeWithState_def)
apply (rule exI)+
apply (rule conjI)
apply (rule MBODY)
defer 1
apply (rule EMPTYdec)
apply (rule EMPTYfundec)
apply (rule PRIMres)
apply (rule FUNres)
apply (simp add: fac_a3 fac_a4)
apply (simp add: fac_b1) 
apply (unfold facTwoBody_def)
apply (rule FUNbody)
defer 1
apply (rule FULLdec)
apply (rule VALdec)
apply (rule VALop)
apply (rule INTval)
apply (unfold lupd_def)
apply (simp)
prefer 2
apply (rule FULLdec)
apply (rule VALdec)
apply (rule VALop)
apply (rule INTval)
apply (simp_all)
apply (rule EMPTYdec)
apply (rule PRIMres)
apply (rule FUNres)
apply (unfold lupd_def)
apply (simp_all)
apply (simp add: fac_s1 fac_s2 fac_s3 fac_s4 fac_s5 fac_s6 fac_a3 fac_a4 fac_b2)+
apply (unfold get_funbody2_def)
apply (unfold facState2_def)
apply (unfold facMStore_def)
apply (unfold facClass_def)
apply (unfold facMthd_def)
apply (simp add: fac_s3)
apply (unfold facUMap_def)
apply (simp)
(* body of fac retrieved from env; n=2 *)
apply (unfold facBody_def)
apply (rule FUNbody)
defer 1
apply (rule EMPTYdec)
apply (rule CHOICEres_False)
apply (rule CONDhead)
apply (rule VARval)
apply (simp add: fac_s1 fac_s2 fac_s3 fac_s4 fac_s5 fac_s6 fac_s7)+
apply (rule INTval)
apply (unfold evalTest_def)
apply (unfold get_local_def)
apply (simp)
apply (unfold btoi_def)
apply (unfold one_def)
apply (simp)
apply (unfold elsePres_def)
apply (rule FUNres)
apply (unfold get_funbody2_def)
apply (simp add: fac_s3 fac_s2 fac_s1)
apply (unfold elseBody_def)
apply (rule FUNbody)
defer 1
apply (rule FULLdec)
apply (rule VALdec)
apply (rule BINop)
apply (rule VARval)
apply (simp)
apply (rule VARval)
apply (simp)
apply (unfold lupd_def)
apply (simp_all)
apply (rule FULLdec)
apply (rule VALdec)
apply (rule BINop)
apply (rule VARval)
apply (simp)
apply (rule INTval)
apply (unfold lupd_def)
apply (simp_all)
apply (rule EMPTYdec)
apply (rule PRIMres)
apply (rule FUNres)
(* recursive call; n=1 *)
apply (simp add: fac_b3)
apply (unfold get_funbody2_def)
apply (simp add: fac_s3 fac_s2 fac_s1)
(* fct body extracted from env *)
apply (rule FUNbody)
defer 1
apply (rule EMPTYdec)
apply (rule CHOICEres_False)
apply (rule CONDhead)
apply (rule VARval)
apply (simp add: fac_s1 fac_s2 fac_s3 fac_s4 fac_s5 fac_s6 fac_s7)+
apply (rule INTval)
apply (unfold evalTest_def)
apply (unfold get_local_def)
apply (simp)
apply (unfold btoi_def)
apply (unfold one_def)
apply (unfold evalBOP_def)
apply (simp)
apply (rule FUNres)
apply (unfold get_funbody2_def)
apply (simp add: fac_s3 fac_s2 fac_s1)
apply (rule FUNbody)
defer 1
apply (rule FULLdec)
apply (rule VALdec)
apply (rule BINop)
apply (rule VARval)
apply (simp)
apply (rule VARval)
apply (simp)
apply (unfold lupd_def)
apply (simp_all)
apply (rule FULLdec)
apply (rule VALdec)
apply (rule BINop)
apply (rule VARval)
apply (simp)
apply (rule INTval)
apply (unfold lupd_def)
apply (simp_all)
apply (rule EMPTYdec)
apply (rule PRIMres)
apply (rule FUNres)
(* recursive call; n=0 BASE CASE *)
apply (simp add: fac_b3)
apply (unfold get_funbody2_def)
apply (simp add: fac_s3 fac_s2 fac_s1)
(* fct body extracted from env *)
apply (rule FUNbody)
defer 1
apply (rule EMPTYdec)
apply (rule CHOICEres_True)
apply (rule CONDhead)
apply (rule VARval)
apply (simp add: fac_s1 fac_s2 fac_s3 fac_s4 fac_s5 fac_s6 fac_s7)+
apply (rule INTval)
apply (unfold evalTest_def)
apply (unfold get_local_def)
apply (simp)
apply (unfold btoi_def)
apply (unfold evalBOP_def)
apply (simp)
apply (unfold thenPres_def)
apply (rule OPres)
apply (rule VALop)
apply (rule VARval)
apply (simp_all)
apply (simp_all add: tick_def clock_update_def)
oops
(* yields False, which means the computation takes more than 10 steps! *)

lemma fac_time: "boundedTimeWithState facState2 
                  (MBODY 
                    EMPTYdec 
                    EMPTYfundec 
                    (PRIMres (OPres (INVOKESTATICop (MDESC INTty facC facM []) EMPTYvar)))) 
                 10" 

apply (unfold boundedTimeWithState_def)
apply (rule exI)+
apply (rule conjI)
apply (rule MBODY)
defer 1
apply (rule EMPTYdec)
apply (rule EMPTYfundec)
apply (rule PRIMres)
apply (rule OPres)
apply (rule INVOKESTATICop)
apply (unfold grab_mdesc_def)
apply (simp_all)
apply (rule conjI)
apply (simp_all)
(* stuck *)


apply (simp add: b5)
apply (unfold facMthd_def)
apply (simp)
apply (rule MBODY)
defer 1
apply (rule EMPTYdec)
apply (rule EMPTYfundec)
apply (unfold facThreeCall_def)
apply (rule PRIMres)
apply (rule FUNres)
apply (simp_all)
prefer 2
apply (unfold get_funbody2_def)
apply (simp_all)
apply (unfold obj_class_def)
apply (unfold get_obj_def)
apply (simp_all)


(*
lemma a3: "methodStore incState = incMStore"

apply (unfold incState_def)
apply (simp)
done



lemma i1: "get_method incState rootClass inc = incMeth"

apply (unfold get_method_def)
apply (simp add: a3)
apply (unfold incMStore_def)
apply (simp)
done

lemma "boundedTimeWithState incState incCall  10"

apply (unfold boundedTimeWithState_def)
apply (rule exI)+
apply (unfold incCall_def)
apply (rule conjI)
apply (rule MBODY)
apply (rule EMPTYdec)
apply (rule EMPTYfundec)
apply (unfold incRes_def)
apply (rule PRIMres)
apply (rule OPres)
apply (rule INVOKESTATICop)
apply (unfold grab_mdesc_def)
apply (simp_all)
apply (rule conjI)
apply (simp_all)
apply (simp add: i1)
apply (unfold incMeth_def)
apply (simp)
apply (unfold incBody_def)
apply (rule MBODY)
apply (rule FULLdec)
apply (rule VALdec)
apply (rule BINop)
apply (rule VARval)
prefer 2
apply (rule INTval)
apply (simp_all)
apply (rule EMPTYdec)
apply (rule EMPTYfundec)
apply (rule PRIMres)
apply (rule OPres)
apply (rule VALop)
apply (rule VARval)
apply (simp_all)
apply (unfold evalBOP_def)
apply (simp_all)







*)
