(* 
   File:       GrailAbsynDec.thy
   ID:         $Id: GrailAbsynDec.thy,v 1.5 2003/02/20 16:50:21 da Exp $
   Authors:    Lennart Beringer, Hans-Wolfgang Loidl, David Aspinall
   Copyright:  University of Edinburgh, Ludwig-Maximilians Universitt, Mnchen

   Based on progs/Grail/gdf/src/GrailAbsyn.sml.

   This part of the abstract syntax covers definitions of programs,
   in terms of class, method, and function declarations.  These 
   are (pre-)processed to produce a class environment which is
   the representation used by the operational semantics.

   FIXME:  add "elaboration" of declarations here which
     transforms a program into a class environment.
*)

header {* Abstract syntax for Grail declarations *}

theory GrailAbsynDec = GrailAbsyn:

text {* The Isabelle representation of Grail abstract syntax for
	method declarations corresponds to what is translated
	by gdf.  This part of the abstract syntax is not used
	during the dynamic semantics. *}

text {* First, modifiers: *}

datatype AccModifiers = PUBLIC | PROTECTED | PRIVATE

datatype BModifiers = STATIC | FINAL

datatype Modifiers = MODS "AccModifiers" "BModifiers option"

text {* then method declarations: *}

datatype FunDec = FDEC "Fname" "Arg list" "LetDecs"

datatype MethBody = MBODY "FunDec list" "LetDecs" 

datatype MethDef  = METHOD "Modifiers" "RTy" "Mname" "Arg list" "MethBody"

datatype FieldDef = FIELD "Modifiers" "RTy" "Fname"

datatype ClassDef = CLASS "Cname" "FieldDef list" "MethDef list"

text {* and finally, the top level: *}

datatype Prog = PROG "ClassDef list"

end
