(* 
   File:       GrailAbsyn.thy
   ID:         $Id: GrailAbsyn.thy,v 1.6 2003/02/24 19:56:29 da Exp $
   Authors:    Lennart Beringer, Hans-Wolfgang Loidl, David Aspinall
   Copyright:  University of Edinburgh, Ludwig-Maximilians Universitt, Mnchen

   Representation of abstract syntax of Grail.  

   Based on progs/Grail/gdf/src/GrailAbsyn.sml.

   This part just covers exactly what is used for the operational semantics
   (modulo additional type information):  essentially just method bodies.   
   Syntax for declaration of classes, fields, etc are included in GrailAbsynDec.
*)

header {* Abstract syntax of Grail method bodies *}

theory GrailAbsyn = Main:

text {* The main Isabelle representation of Grail abstract syntax just 
   includes what is needed for the operational semantics, essentially
   the pieces that make up method bodies. *}

typedecl
  Vname     --{* names of variables *}
typedecl
  Fldname   --{* names of fields *}
typedecl
  Fname     --{* names of functions, i.e., labels of basic blocks *}
typedecl
  Cname     --{* names of classes *}
typedecl
  Mname     --{* names of methods *}

datatype Ty = (* many of these aren't accessible from Grail *)
    INTty 
  | BOOLEANty 
  | REFty "string"
  | ARRAYty "Ty"

datatype RTy = 
    INTty 
  | BOOLEANty 
  | REFty "string"
  | ARRAYty "Ty"
  | VOIDTy

(* Expressions *)

datatype Value = 
                 VARval Vname
               | INTval int
               | NULLval Cname

datatype MethDesc  = MDESC RTy Cname Mname "Ty list" (* NB: Cname added *)

datatype FieldDesc = FDESC Ty Cname Fldname          (* NB: Cname added 13/2/03 *)

datatype Test = EQUALStest | IStest | LESStest

datatype BinOp = ADDop | SUBop | MULop

datatype PrimOp =
    VALop Value
  | BINop BinOp Value Value
  | NEWop Cname                            (* simplification for the time being *)
  | GETFIELDop Vname FieldDesc
  | PUTFIELDop Vname FieldDesc Value
  | GETSTATICop FieldDesc
  | PUTSTATICop FieldDesc Value
  | INVOKESTATICop MethDesc "Vname list"

(*  | INVOKEVIRTUALop "Vname" "MethDesc" "Value list" *)
(*  | INVOKESPECIALop "Vname" "MethDesc" "Value list" *)
(* NB: a few other PrimOps missing *)

datatype PrimRes = OPres PrimOp
                 | VOIDres
                 | FUNres Fname "Vname list"

datatype LetDecs = 
		   VALdec Vname PrimOp LetDecs
                 | VOIDdec PrimOp LetDecs
                 | PRIMres PrimRes
                 | CHOICEres Value Test Value PrimRes PrimRes 

datatype Arg = ARG Ty Vname

end
