theory CoreGrailTrans = CoreGrailAbsyn + jGrail_path + jGrailInstructions:


(* instructions used:

iload, istore,
sipush, ldc,
iadd, isub, imul,
if_icmpeq, if_icmplt,
goto, ireturn, return,

*)



(* Constant Pool and local variable stuff *)

types CP = "int list" (* max, entries *)
  locals = "(string list)"

consts
  locate :: "locals \<Rightarrow> string \<Rightarrow> nat \<Rightarrow> nat option"

primrec (* Returns the position in a given list of a given element, else None *)
  "locate [] s i    = None"
  "locate (h#t) s i = (if s=h then Some(i)
                          else locate t s (i+1))"
constdefs
  localIndex  :: "locals \<Rightarrow> string \<Rightarrow> nat option"
  "localIndex l s == locate l s 0"

  insINT :: "CP \<Rightarrow> int \<Rightarrow> (CP \<times> nat)"
  "insINT cp i == (cp@[i],length cp)"



(* Function table stuff *)

types
  FT     = "(Fname \<times> nat) list" (* table of function declaration points *)

datatype
  almostCODE = GOTOlabel "Fname" (* for lookup in FT later *)
             | INSTR "jGrailInstr" (* just a wrapper *)

consts
  getFunction :: "FT \<Rightarrow> string \<Rightarrow> nat option" (* function table lookup *)
  the_instr :: "almostCODE \<Rightarrow> jGrailInstr option" 
  the_label :: "almostCODE \<Rightarrow> Fname option"
  resolveGOTOlabels :: "FT \<Rightarrow> almostCODE list \<Rightarrow> nat \<Rightarrow> jGrailInstr list"
  wrap :: "jGrailInstr list \<Rightarrow> almostCODE list"

primrec
  "getFunction [] s = None"
  "getFunction (h#t) s = (let (n,p) = h in
                             (if s=n then Some(p)
                             else getFunction t s))"

primrec
  "the_instr (GOTOlabel f) = None"
  "the_instr (INSTR i) = Some(i)"
  
primrec
  "the_label (INSTR i) = None"
  "the_label (GOTOlabel f) = Some(f)"

primrec
  "resolveGOTOlabels ft []    n = []"
  "resolveGOTOlabels ft (h#t) n = (if ((the_instr h) = None) then
                                      (let
                                          absolute = getFunction ft (the(the_label h))
                                      in 
                                          (if (absolute=None) then
                                              (goto -1) # (resolveGOTOlabels ft t (n+1))
                                          else
                                              (let
                                                  int_abs = int(the(absolute));
                                                  int_n = int(n);
                                                  relative = int_abs - int_n
                                              in
                                                  (goto relative) # (resolveGOTOlabels ft t (n+1)))))
                                  else
                                      (the(the_instr h)) # (resolveGOTOlabels ft t (n+1)))"









(*primrec



  "resolveGOTOlabels ft [] n = []"
  "resolveGOTOlabels ft (h#t) n = (let i = the_instr h in 
                             (if i=None then
                                 (if (getFunction ft (the(the_label h))=None) then
                                     (goto -1) # resolveGOTOlabels ft t (n+1)
                                 else
                                     (let
                                         n_abs = the(getFunction ft (the(the_label h)));
                                         n_rel = int(n_abs-n)
                                     in
                                         (goto n_rel) # resolveGOTOlabels ft t (n+1))
                                 )
                             else
                                 (the i) # resolveGOTOlabels ft t (n+1)))"
*)
primrec
  "wrap [] = []"
  "wrap (h#t) = (INSTR h)#(wrap t)"



(* Translation functions *)

consts
  tValue      :: "[     CP, locals, Value     ] \<Rightarrow>      CP          \<times> jGrailInstr list"
  tVarList    :: "[     CP, locals, VarList   ] \<Rightarrow>      CP          \<times> jGrailInstr list"
  tTest       :: "[nat,             Test      ] \<Rightarrow>                    jGrailInstr list" (* nat is offset *)
  tBinOp      :: "                  BinOp       \<Rightarrow>                    jGrailInstr list"
  tPrimOp     :: "[     CP, locals, PrimOp    ] \<Rightarrow>      CP          \<times> jGrailInstr list"
  tPrimRes    :: "[     CP, locals, PrimRes   ] \<Rightarrow>      CP          \<times> almostCODE  list"
  tCondHead   :: "[nat, CP, locals, CondHead  ] \<Rightarrow>      CP          \<times> jGrailInstr list" (* nat is offset *)
  tResult     :: "[     CP, locals, Result    ] \<Rightarrow>      CP          \<times> almostCODE  list"
  tArg        :: "[         locals, Arg       ] \<Rightarrow>           locals"
  tArgList    :: "[         locals, ArgList   ] \<Rightarrow>           locals"
  tLetDec     :: "[     CP, locals, LetDec    ] \<Rightarrow>      CP \<times> locals \<times> jGrailInstr list"
  tLetDecs    :: "[     CP, locals, LetDecs   ] \<Rightarrow>      CP \<times> locals \<times> jGrailInstr list"
  tFunBody    :: "[     CP, locals, FunBody   ] \<Rightarrow>      CP \<times> locals \<times> almostCODE  list"
  tFunDec     :: "[nat, CP, locals, FunDec    ] \<Rightarrow> FT \<times> CP \<times> locals \<times> almostCODE  list" (* nat is code length *)
  tFunDecs    :: "[nat, CP, locals, FunDecs   ] \<Rightarrow> FT \<times> CP \<times> locals \<times> almostCODE  list" (* nat is code length *)
  tMethodBody :: "[     CP, locals, MethodBody] \<Rightarrow>      CP \<times> locals \<times> jGrailInstr list"
  tProg       :: "                  Prog        \<Rightarrow>      CP \<times> locals \<times> jGrailInstr list"


primrec (* Value = VARval "Vname" | INTval "int" | NULLval "string" *)
  "tValue cp locals (VARval v) =
      (let
          index = localIndex locals v
      in
          (if (index=None) then
              (cp,[sipush 1000])
          else
              (cp,[iload (the index)])))"

  (* range is just a guess - 3 byte integers *)
  "tValue cp locals (INTval i) =
      (if (i<=8388607 & (-8388608)<=i) then
          (cp,[sipush i])
      else
          (let
              (cp',n)=insINT cp i
          in
              (cp',[ldc n])))"

  "tValue cp locals (NULLval s) = (cp,[])" (*!!! NOT USED !!!*)


primrec (* VarList = EMPTYvar | FULLvar "Vname" "VarList" *)
  "tVarList cp locals EMPTYvar = (cp,[])"

  "tVarList cp locals (FULLvar h t) =
      (let
          (cp',  code)  = (tValue   cp  locals (VARval h));
          (cp'', code') = (tVarList cp' locals t)
      in
          (cp'', code @ code'))" (* Does order of variables need reversed? *)


primrec (* Test = EQUALStest | IStest | LESStest *)
  "tTest offset (EQUALStest) = [if_icmpeq (int offset+1)]"
  "tTest offset (IStest)     = []" (*!!! NOT USED !!!*)
  "tTest offset (LESStest)   = [if_icmplt (int offset+1)]"


primrec (* BinOp = ADDop | SUBop | MULop *)
  "tBinOp ADDop = [iadd]"
  "tBinOp SUBop = [isub]"
  "tBinOp MULop = [imul]"


primrec (* PrimOp = VALop "Value" | BINop "BinOp" "Value" "Value" *)
  "tPrimOp cp locals (VALop v) = tValue cp locals v"
      
  "tPrimOp cp locals (BINop B v v') =
      (let
          (cp',  code)   = tValue cp  locals  v;
          (cp'', code')  = tValue cp' locals  v';
                 code''  = tBinOp             B
      in
          (cp'', code @ code' @ code''))"


primrec (* PrimRes = OPres "PrimOp" | VOIDres | FUNres "string" "VarList" *)
  "tPrimRes cp locals (OPres p) =
      (let
          (cp', code) = tPrimOp cp locals p
      in
          (cp', wrap (code @ [ireturn])))"

  "tPrimRes cp locals (VOIDres) = (cp, wrap [return])"

  "tPrimRes cp locals (FUNres s vs) = 
      (let
          (cp', code) = tVarList cp locals vs
      in
          (cp', [GOTOlabel s]))" (* to be looked up later *) (*(wrap code) @*)


primrec (* CondHead = CONDhead "Value" "Test" "Value" *)
  "tCondHead offset cp locals (CONDhead v t v') =
      (let
          (cp',  code)   = tValue cp   locals   v;
          (cp'', code')  = tValue cp'  locals   v';
                 code''  = tTest  offset        t
      in
          (cp'', code @ code' @ code''))"


primrec (* Result = PRIMres "PrimRes" | CHOICEres "CondHead" "PrimRes" "PrimRes" *)
  "tResult cp locals (PRIMres p) = tPrimRes cp locals p"

  "tResult cp locals (CHOICEres h p p') =
      (let
          (cp',   code)   = tPrimRes  cp  locals   p;
          (cp'',  code')  = tPrimRes  cp' locals  p';
          offset = length code';
          (cp''', code'') = tCondHead offset cp'' locals h
      in
          (cp''', (wrap code'') @ code' @ code))"


primrec (*LetDec = VALdec "string" "PrimOp" | VOIDdec "PrimOp" *)
  "tLetDec cp locals (VALdec s p) =
      (let
          index = localIndex locals s
      in
          (let
              (index', locals')  = (if (index=None) then
                                       (length locals, locals@[s])
                                   else
                                       (the index, locals));
              (cp', code) = tPrimOp cp locals p
          in
              (cp', locals', code @ [istore index'])))"

  "tLetDec cp locals (VOIDdec p) =
      (let
          (cp', code) = (tPrimOp cp locals p)
      in
          (cp', locals, code))"


primrec (* LetDecs = EMPTYdec | FULLdec "LetDec" "LetDecs" *)
  "tLetDecs cp locals EMPTYdec = (cp,locals,[])"

  "tLetDecs cp locals (FULLdec h t) =
      (let
          (cp',  locals',  code)  = (tLetDec  cp  locals  h);
          (cp'', locals'', code') = (tLetDecs cp' locals' t)
      in
          (cp'', locals'', code @ code'))"


primrec (* FunBody = FUNbody "LetDecs" "Result" *)
  "tFunBody cp locals (FUNbody l r)  =
      (let
          (cp',  locals',  code)  = (tLetDecs cp  locals  l);
          (cp'',           code') = (tResult  cp' locals' r)
      in 
          (cp'', locals', (wrap code) @ code'))"


primrec (* Arg = ARG Ty Vname *)
  "tArg locals (ARG t n) = 
      (let
          index = localIndex locals n
      in
          (if (index=None) then
              locals@[n]
          else
              locals))"


primrec (* ArgList = EMPTYal | FULLal "Arg" "ArgList" *)
  "tArgList locals EMPTYal = locals"

  "tArgList locals (FULLal a as) =
      (let
          locals' = tArg locals a;
          locals'' = tArgList locals' as
      in
          locals'')"



primrec (* FunDec = FDEC "string" "(Ty * Vname) list" "FunBody" *)
  "tFunDec l cp locals (FDEC s a b) =
      (let
          ft = [(s,l)];
          locals' = tArgList locals a;
          (cp', locals'', code) = (tFunBody cp locals' b)
      in
          (ft, cp', locals'', code))" (* ft contains an entry for this function *)


primrec (* FunDecs = EMPTYfundec | FULLfundec "FunDec" "FunDecs" *)
  "tFunDecs l cp locals EMPTYfundec = ([], cp, locals, [])"

  "tFunDecs l cp locals (FULLfundec h t) =
      (let
          (ft,  cp',  locals',  code)  = (tFunDec  l      cp  locals  h);
          l' = length code;
          (ft', cp'', locals'', code') = (tFunDecs (l+l') cp' locals' t)
      in
          (ft@ft', cp'', locals'', code @ code'))"


primrec (* MethodBody = MBODY "LetDecs" "FunDecs" "Result" *)
  "tMethodBody cp locals (MBODY lds fds res) =
      (let
          (    cp',   locals',  code)   = (tLetDecs     cp   locals  lds);
          (    cp'',            code')  = (tResult      cp'  locals' res);
          len = (length code) + (length code');
          (ft, cp''', locals'', code'') = (tFunDecs len cp'' locals' fds)
      in
          (cp''', locals'', (resolveGOTOlabels ft ((wrap code) @ code' @ code'') 0)))"


primrec (* Prog = PROG MethodBody *)
  "tProg (PROG M) = tMethodBody [] [] M"


end
