(* 
   Title:      CoreGrailState.thy
   ID:         $Id: CoreGrailState.thy,v 1.1 2003/02/15 09:06:15 da Exp $
   Author:     ME
   Copyright:  GPL
   Language:   Klingon
*)

theory CoreGrailState = CoreGrailAbsyn:

text {* Locations, i.e.\ abstract references to objects *}
typedecl  loc

datatype Reference = nullRef 
                   | locRef "loc"

datatype RTVal = rtVoid 
               | rtBool "bool" 
               | rtInt "int" 
               | rtString "string" 
               | rtRef "Reference"

consts
 the_Int    :: "RTVal \<Rightarrow> int"
 the_Bool   :: "RTVal \<Rightarrow> bool"
 the_String :: "RTVal \<Rightarrow> string"
 the_Ref    :: "RTVal \<Rightarrow> Reference"

primrec
 "the_Int  (rtInt i) = i"
primrec
 "the_Bool (rtBool b) = b"
primrec
 "the_String  (rtString s) = s"

types 
  Fields = "Fname \<leadsto> RTVal"  (* field name, defining class, value *)
  Obj = "Cname * Fields" (*class instance with class name and fields*)

  (* Vname now in CoreGrailAbsSyn.thy; was: Vname = "string"   *)
  (* now: heap component in State; was: ClosEnv = "Fname => (ValEnv * Var list * LetDec list * Result)" *)
  (* now: locals component in State; was: ValEnv = "Var => RTVal" *)

text {* private: *}
types   (* Heap   = "loc   \<leadsto> Obj" *) (* for full Grail *)
        Locals = "Vname \<leadsto> RTVal" 
        Heap = "Fname \<leadsto> (ArgList \<times> FunBody)"  (* for Core Grail *)

text {* For now time and size are both measured in plain nats. For time we could
        use a table mapping instructions to frequencies instead *}
types   Time = nat
        HeapSz = nat

text {* private: *}
record  State
        = heap   :: Heap
          locals :: Locals
          clock  :: Time
          heapsz :: HeapSz          

translations
  "Fields" \<leftharpoondown> (type)"Vname => RTVal option"
  "Obj"    \<leftharpoondown> (type)"Cname * Fields"
  "State"  \<leftharpoondown> (type)"(|heap :: Heap, locals :: Locals, clock :: Time, heapsz :: HeapSz|)"

consts
  method :: "Cname => (Mname \<leadsto> MethodBody)"
  field  :: "Cname => (Fname \<leadsto> Ty)"

constdefs
  body :: "Cname * Mname => MethodBody"
 "body \<equiv> \<lambda>(C,m). the (method C m)"

constdefs
  init_vars:: "('a \<leadsto> 'b) => ('a \<leadsto> RTVal)"
 "init_vars m \<equiv> option_map (\<lambda>T. rtRef nullRef) o m"
  
constdefs
  (* set state to "empty" *)
  del_locs     :: "State => State"
 "del_locs s \<equiv> s (| locals := empty, clock := 0, heapsz := 0 |)"

  (* BUGGY *)
  (* initialise with values from another state 
  init_locs     :: "Cname => Mname => State => State"
 "init_locs C m s \<equiv> s (| locals := locals s ++ 
                         init_vars (map_of (lcl (the (method C m)))) |)"
  *)

constdefs
  (* juggling with locations *)
  set_locs  :: "State => State => State"
 "set_locs s s' \<equiv> s' (| locals := locals s |)"

constdefs
  get_local     :: "State => Vname => RTVal"    ("_<_>" [99,99] 599) (* bloody high prec *)
 "get_local s x  \<equiv> the ((locals s) x)"
  get_local_Int :: "State => Vname => int"    ("_<_>\<^sub>i" [99,99] 599) (* bloody high prec *)
 "get_local_Int s x  \<equiv> the_Int (the ((locals s) x))"
  get_local_Bool :: "State => Vname => bool"    ("_<_>\<^sub>b" [99,99] 599) (* bloody high prec *)
 "get_local_Bool s x  \<equiv> the_Bool (the ((locals s) x))"

constdefs
  get_body :: "Fname \<Rightarrow> State \<Rightarrow> FunBody"
 "get_body f s \<equiv> snd (the (heap s f))"

(*
 "get_body f s \<equiv> case snd (the (heap s f)) of 
                   FUNbody decs res \<Rightarrow> (decs,res)"
*)
--{* local function: *}
(* all obj stuff turned off for now 

constdefs
  get_obj       :: "State => loc => Obj"
 "get_obj s a \<equiv> the (heap s a)"

constdefs
  obj_class     :: "State => loc => Cname"
 "obj_class s a \<equiv> fst (get_obj s a)"

  get_field     :: "State => loc => Vname => RTVal"
 "get_field s a f \<equiv> the (snd (get_obj s a) f)"

constdefs
  new_obj    :: "loc => Cname => State => State"
 "new_obj a C \<equiv> hupd (a \<mapsto> (C,init_vars (field C)))"

constdefs
  upd_obj    :: "loc => Fname => RTVal => State => State"
 "upd_obj a f v s \<equiv> let (C,fs) = the (heap s a) in hupd(a\<mapsto>(C,fs(f\<mapsto>v))) s"

constdefs
  new_Addr      :: "State => RTVal"
 "new_Addr s == rtRef (SOME v. (\<exists>r. v = locRef r \<and> (heap s) r = None) | v = nullRef)"

*)

constdefs
--{* local function: *}
 (* Version for full Grail 
  hupd       :: "loc => Obj => State => State"   ("hupd'(_|->_')" [10,10] 1000)
 "hupd a obj s \<equiv> s (| heap   := ((heap   s)(a\<mapsto>obj))|)"
 *)
  hupd       :: "Fname \<Rightarrow> ArgList \<Rightarrow> FunBody \<Rightarrow> State \<Rightarrow> State"  ("hupd' (_|->_,_) _")
 "hupd fname arglist b s \<equiv> s \<lparr> heap   := ((heap   s)(fname\<mapsto>(arglist,b)))\<rparr>"

constdefs
  lupd       :: "Vname => RTVal => State => State"              ("lupd' (_|->_) _")
 "lupd x v s   \<equiv> s \<lparr> locals := ((locals s)(x\<mapsto>v  ))\<rparr>"

syntax (xsymbols)
  hupd       :: "loc => Obj => State => State"   ("hupd'(_\<mapsto>_')" [10,10] 1000)
  lupd       :: "Vname => RTVal => State => State" ("lupd'(_\<mapsto>_')" [10,10] 1000)

constdefs
  tick :: "State \<Rightarrow> State"
 "tick s \<equiv> s (| clock := (clock s)+1 |)"

  elapsedTime :: "State \<Rightarrow> Time \<Rightarrow> bool"
 "elapsedTime s c \<equiv> clock s = c"

  requiredHeap :: "State \<Rightarrow> HeapSz \<Rightarrow> bool"
 "requiredHeap s z \<equiv> heapsz s = z"
  
(* Initial settings for environments *)

constdefs emptyLocals ::"Locals"
"emptyLocals \<equiv> (\<lambda> x . None)"

constdefs emptyHeap :: "Heap"
"emptyHeap \<equiv> (\<lambda> l . None)"

constdefs emptyState :: "State"
"emptyState \<equiv> \<lparr> heap = emptyHeap, locals = emptyLocals, clock = 0, heapsz = 0 \<rparr>"


lemma [simp]:
  "clock emptyState = 0"
apply (unfold emptyState_def)
apply (simp add:CoreGrailState.State.clock_update_def)
done

lemma get_body_nodec:
  "!! f. !! s. get_body f s = get_body f (s (| locals := empty |))"
apply (unfold get_body_def)
apply (simp)
done

end