(*  Title:      GrailTHY/CoreGrailHoare.thy
    ID:         $Id: CoreGrailHoare.thy,v 1.1 2003/02/15 09:06:15 da Exp $
    Author:     \<exists> x. this.author == x
    Copyright   GPL
*)

header "Hoare-style Axiomatic Semantics"

theory CoreGrailHoare = CoreGrailState + CoreGrailDynSem:

(* maybe define in AbsSyn.thy *)

consts 
  This :: vname --{* This pointer *}
  Par  :: vname --{* method parameter *}
  Res  :: vname --{* method result *}

section "Aux"

subsection "Sums"

(* hide const In0 In1 *)

syntax
  fun_sum :: "('a => 'c) => ('b => 'c) => (('a+'b) => 'c)" (infixr "'(+')"80)
translations
 "fun_sum" == "sum_case"

consts    the_Inl  :: "'a + 'b \<Rightarrow> 'a"
          the_Inr  :: "'a + 'b \<Rightarrow> 'b"
primrec  "the_Inl (Inl a) = a"
primrec  "the_Inr (Inr b) = b"

datatype ('a1, 'a2) sum2 = In1 'a1 | In2 'a2

datatype ('a1, 'a2, 'a3, 'a4, 'a5, 'a6, 'a7, 'a8, 'a9, 'a10, 'a11, 'a12) sum3 = InResult 'a1 | InPrimRes 'a2 | InCondHead 'a3 | InPrimOp 'a4 | InValue 'a5 | InLetDec 'a6 | InLetDecs 'a7 | InArg 'a8 | InArgList 'a9 | InFunBody 'a10 | InFunDec 'a11 | InFunDecs 'a12

consts 
          the_InResult :: "('a1, 'a2, 'a3, 'a4, 'a5, 'a6, 'a7, 'a8, 'a9, 'a10, 'a11, 'a12) sum3 \<Rightarrow> 'a1"
          the_InPrimRes :: "('a1, 'a2, 'a3, 'a4, 'a5, 'a6, 'a7, 'a8, 'a9, 'a10, 'a11, 'a12) sum3 \<Rightarrow> 'a2"
          the_InCondHead :: "('a1, 'a2, 'a3, 'a4, 'a5, 'a6, 'a7, 'a8, 'a9, 'a10, 'a11, 'a12) sum3 \<Rightarrow> 'a3"
          the_InPrimOp :: "('a1, 'a2, 'a3, 'a4, 'a5, 'a6, 'a7, 'a8, 'a9, 'a10, 'a11, 'a12) sum3 \<Rightarrow> 'a4"
          the_InValue :: "('a1, 'a2, 'a3, 'a4, 'a5, 'a6, 'a7, 'a8, 'a9, 'a10, 'a11, 'a12) sum3 \<Rightarrow> 'a5"
          the_InLetDec :: "('a1, 'a2, 'a3, 'a4, 'a5, 'a6, 'a7, 'a8, 'a9, 'a10, 'a11, 'a12) sum3 \<Rightarrow> 'a6"
          the_InLetDecs :: "('a1, 'a2, 'a3, 'a4, 'a5, 'a6, 'a7, 'a8, 'a9, 'a10, 'a11, 'a12) sum3 \<Rightarrow> 'a7"
          the_InArg :: "('a1, 'a2, 'a3, 'a4, 'a5, 'a6, 'a7, 'a8, 'a9, 'a10, 'a11, 'a12) sum3 \<Rightarrow> 'a8"
          the_InArgList :: "('a1, 'a2, 'a3, 'a4, 'a5, 'a6, 'a7, 'a8, 'a9, 'a10, 'a11, 'a12) sum3 \<Rightarrow> 'a9"
          the_InFunBody :: "('a1, 'a2, 'a3, 'a4, 'a5, 'a6, 'a7, 'a8, 'a9, 'a10, 'a11, 'a12) sum3 \<Rightarrow> 'a10"
          the_InFunDec :: "('a1, 'a2, 'a3, 'a4, 'a5, 'a6, 'a7, 'a8, 'a9, 'a10, 'a11, 'a12) sum3 \<Rightarrow> 'a11"
          the_InFunDecs :: "('a1, 'a2, 'a3, 'a4, 'a5, 'a6, 'a7, 'a8, 'a9, 'a10, 'a11, 'a12) sum3 \<Rightarrow> 'a12"

primrec  "the_InResult (InResult a) = a"
primrec  "the_InPrimRes (InPrimRes b) = b"
primrec  "the_InCondHead (InCondHead c) = c"
primrec  "the_InPrimOp (InPrimOp a) = a"
primrec  "the_InValue (InValue b) = b"
primrec  "the_InLetDec (InLetDec c) = c"
primrec  "the_InLetDecs (InLetDecs a) = a"
primrec  "the_InArg (InArg b) = b"
primrec  "the_InArgList (InArgList b) = b"
primrec  "the_InFunBody (InFunBody c) = c"
primrec  "the_InFunDec (InFunDec c) = c"
primrec  "the_InFunDecs (InFunDecs c) = c"

subsection "terms"

(* all possible syntactic constructs in one sum *)
types "Term" = "(Result,   
		 PrimRes,            
		 CondHead, 
		 PrimOp,   
		 Value,   
		 LetDec,   
		 LetDecs,  
		 Arg,      
		 ArgList,  
		 FunBody,  
		 FunDec,   
		 FunDecs)  sum3"
(*
translations
  "sig"   <= (type) "mname * ty list"
  "var"   <= (type) "Term.var"
  "expr"  <= (type) "Term.expr"
  "stmt"  <= (type) "Term.stmt"
  "term"  <= (type) "(expr+stmt, var, expr list) sum3"
*)

section "Semantics"

subsection "Types"

types 
      Vvar   =        "RTVal * (RTVal \<Rightarrow> State \<Rightarrow> State)"
      (* Vvar   =        "RTVal * (RTVal \<Rightarrow> State \<Rightarrow> State)" *)
      AxVal  =        "RTVal"
                      (* "(RTVal, Vvar) sum2" *)

(* ???
translations
     "vvar" <= (type) "val * (val \<Rightarrow> state \<Rightarrow> state)"
     "vals" <= (type)"(val, vvar, val list) sum3"
*)

types PlainAssn = "State \<Rightarrow> bool"
      Assn = "AxVal \<Rightarrow> State \<Rightarrow> Vname list \<Rightarrow> bool"
      Triple = "Assn * Term *  Assn"

translations
  "Assn"   \<leftharpoondown> (type)"AxVal \<Rightarrow> State \<Rightarrow> Vname list \<Rightarrow> bool"
  "Triple" \<leftharpoondown> (type)"Assn * Term *  Assn"

consts   hoare   :: "(Triple set *  Triple set) set"
syntax (xsymbols)
 "@hoare"  :: "[Triple set,  Triple set    ] \<Rightarrow> bool" ("_ |\<turnstile>/ _" [61,61]    60)
 "@hoare1" :: "[Triple set,  Assn,Term,Assn] \<Rightarrow> bool" 
                                   ("_ \<turnstile>/ ({(1_)}/ (_)/ {(1_)})" [61,3,90,3]60)

syntax
 "@hoare"  :: "[Triple set,  Triple set    ] \<Rightarrow> bool" ("_ ||-/ _" [61,61] 60)
 "@hoare1" :: "[Triple set,  Assn,Term,Assn] \<Rightarrow> bool" 
                                  ("_ |-/ ({(1_)}/ (_)/ {(1_)})" [61,3,90,3] 60)


translations "A |\<turnstile> C"        \<rightleftharpoons> "(A,C) \<in> hoare"
             "A  \<turnstile> {P}c{Q}"  \<rightleftharpoons> "A |\<turnstile> {(P,c,Q)}"


subsection "Aux fcts"

constdefs
  if_then_else :: "bool \<Rightarrow> PrimRes \<Rightarrow> PrimRes \<Rightarrow> Term"
 "if_then_else b p1 p2 \<equiv> case b of
                                   True \<Rightarrow> InPrimRes p1
                                 | False \<Rightarrow> InPrimRes p2"

constdefs 
  axBOP :: "BinOp \<Rightarrow> Value \<Rightarrow> Value \<Rightarrow> State \<Rightarrow> RTVal"
 "axBOP binop N M s \<equiv>
   (case N of 
       VARval vn \<Rightarrow> 
	     (case M of 
	         VARval vm \<Rightarrow> evalBOP binop (s<vn>) (s<vm>)
	       | INTval i  \<Rightarrow> evalBOP binop (s<vn>) (rtInt i)
	       | NULLval s \<Rightarrow> (rtBool False))
     | INTval i \<Rightarrow>
	     (case M of 
	         VARval vm \<Rightarrow> evalBOP binop (rtInt i) (s<vm>)
	       | INTval j  \<Rightarrow> evalBOP binop (rtInt i) (rtInt j)
	       | NULLval s \<Rightarrow> (rtBool False))
     | NULLval s \<Rightarrow> (rtBool False))"

constdefs 
  axTest :: "Test \<Rightarrow> Value \<Rightarrow> Value \<Rightarrow> State \<Rightarrow> RTVal"
 "axTest test N M s \<equiv>
   (case N of 
       VARval vn \<Rightarrow> 
	     (case M of 
	         VARval vm \<Rightarrow> evalTest test (s<vn>) (s<vm>)
	       | INTval i  \<Rightarrow> evalTest test (s<vn>) (rtInt i)
	       | NULLval s \<Rightarrow> (rtBool False))
     | INTval i \<Rightarrow>
	     (case M of 
	         VARval vm \<Rightarrow> evalTest test (rtInt i) (s<vm>)
	       | INTval j  \<Rightarrow> evalTest test (rtInt i) (rtInt j)
	       | NULLval s \<Rightarrow> (rtBool False))
     | NULLval s \<Rightarrow> (rtBool False))"


subsection "Hoare Logic Rules"

(* only one function hoare, rest are macros *)

(*
consts
 hoare_Result   :: "(Triple set * Triple_Result set) set"
 hoare_PrimRes  :: "(Triple set * Triple_PrimRes set) set"
 hoare_CondHead :: "(Triple set * Triple_CondHead set) set"
 hoare_PrimOp   :: "(Triple set * Triple_PrimOp set) set"
 hoare_Value    :: "(Triple set * Triple_Value set) set"
 hoare_LetDec   :: "(Triple set * Triple_LetDec set) set"
 hoare_LetDecs  :: "(Triple set * Triple_LetDecs set) set"
 hoare_Arg      :: "(Triple set * Triple_Arg set) set"
 hoare_ArgList  :: "(Triple set * Triple_ArgList set) set"
 hoare_FunBody  :: "(Triple set * Triple_FunBody set) set"
 hoare_FunDec   :: "(Triple set * Triple_FunDec set) set"
 hoare_FunDecs  :: "(Triple set * Triple_FunDecs set) set"
*)
syntax
 hoare_Result   :: "[Triple set, Assn,Result,Assn] \<Rightarrow> bool"   ("_ \<parallel>-\<^sub>r {_} _ {_}")
 hoare_PrimRes  :: "[Triple set, Assn,PrimRes,Assn] \<Rightarrow> bool"   ("_ \<parallel>-\<^sub>p {_} _ {_}")
 hoare_CondHead :: "[Triple set, Assn,CondHead,Assn] \<Rightarrow> bool"   ("_ \<parallel>-\<^sub>c {_} _ {_}")
 hoare_PrimOp   :: "[Triple set, Assn,PrimOp,Assn] \<Rightarrow> bool"   ("_ \<parallel>-\<^sub>o {_} _ {_}")
 hoare_Value    :: "[Triple set, Assn,Value,Assn] \<Rightarrow> bool"   ("_ \<parallel>-\<^sub>v {_} _ {_}")
 hoare_LetDec   :: "[Triple set, Assn,LetDec,Assn] \<Rightarrow> bool"   ("_ \<parallel>-\<^sub>l {_} _ {_}")
 hoare_LetDecs  :: "[Triple set, Assn,LetDecs,Assn] \<Rightarrow> bool"   ("_ \<parallel>-\<^sub>1 {_} _ {_}")
 hoare_Arg      :: "[Triple set, Assn,Arg,Assn] \<Rightarrow> bool"   ("_ \<parallel>-\<^sub>a {_} _ {_}")
 hoare_ArgList  :: "[Triple set, Assn,ArgList,Assn] \<Rightarrow> bool"   ("_ \<parallel>-\<^sub>2 {_} _ {_}")
 hoare_FunBody  :: "[Triple set, Assn,FunBody,Assn] \<Rightarrow> bool"   ("_ \<parallel>-\<^sub>b {_} _ {_}")
 hoare_FunDec   :: "[Triple set, Assn,FunDec,Assn] \<Rightarrow> bool"   ("_ \<parallel>-\<^sub>f {_} _ {_}")
 hoare_FunDecs  :: "[Triple set, Assn,FunDecs,Assn] \<Rightarrow> bool"   ("_ \<parallel>-\<^sub>3 {_} _ {_}")

translations
 "A \<parallel>-\<^sub>r {P} c {Q}" == "A \<turnstile> {P} InResult c {Q}"
 "A \<parallel>-\<^sub>p {P} c {Q}" == "A \<turnstile> {P} InPrimRes c {Q}"
 "A \<parallel>-\<^sub>c {P} c {Q}" == "A \<turnstile> {P} InCondHead c {Q}"
 "A \<parallel>-\<^sub>o {P} c {Q}" == "A \<turnstile> {P} InPrimOp c {Q}"
 "A \<parallel>-\<^sub>v {P} c {Q}" == "A \<turnstile> {P} InValue c {Q}"
 "A \<parallel>-\<^sub>l {P} c {Q}" == "A \<turnstile> {P} InLetDec c {Q}"
 "A \<parallel>-\<^sub>1 {P} c {Q}" == "A \<turnstile> {P} InLetDecs c {Q}"
 "A \<parallel>-\<^sub>a {P} c {Q}" == "A \<turnstile> {P} InArg c {Q}"
 "A \<parallel>-\<^sub>2 {P} c {Q}" == "A \<turnstile> {P} InArgList c {Q}"
 "A \<parallel>-\<^sub>b {P} c {Q}" == "A \<turnstile> {P} InFunBody c {Q}"
 "A \<parallel>-\<^sub>f {P} c {Q}" == "A \<turnstile> {P} InFunDec c {Q}"
 "A \<parallel>-\<^sub>3 {P} c {Q}" == "A \<turnstile> {P} InFunDecs c {Q}"

(* DOESN'T WORK, YET *)
inductive hoare intros
 VARval:  "A \<parallel>-\<^sub>v {\<lambda> r s z. P (s<x>) s z} VARval x {P}"
 INTval:  "A \<parallel>-\<^sub>v {\<lambda> r s z. P (rtInt i) s z} INTval i {P}"
 NULLval: "A \<parallel>-\<^sub>v {\<lambda> r s z. P (rtVoid) s z} NULLval str {P}"

 VALop: "\<lbrakk> A \<parallel>-\<^sub>v  {P} x {Q} \<rbrakk> 
         \<Longrightarrow> 
         A \<parallel>-\<^sub>o  {P} VALop x {Q}"


 BINop: "\<lbrakk> A \<parallel>-\<^sub>v {P} v1 {Q}; 
           A \<parallel>-\<^sub>v {P} v2 {Q} \<rbrakk>
         \<Longrightarrow>
         A \<parallel>-\<^sub>o {\<lambda> r s z. P (axBOP b v1 v2 s) s z} BINop b v1 v2 {Q}"


 OPres: "\<lbrakk> A \<parallel>-\<^sub>o {P} p {Q} \<rbrakk> 
         \<Longrightarrow>
         A \<parallel>-\<^sub>p {P} OPres p {Q}"

 VOIDres: "A \<parallel>-\<^sub>p {P} VOIDres {P}"

 (* see rule 'Call' in NanoJava, but no "address" arg 'a' to assertion, and
    ignoring Params and This(?) when rolling your state for the fct call *)
 (* ToDo: nuke This, <Res>, set_locs*) 
 FUNres: "\<lbrakk> A \<parallel>-\<^sub>p {P} f {Q}; 
            A \<parallel>-\<^sub>3 {Q} xs {R};
            \<forall>p ls. A \<parallel>-\<^sub>f {\<lambda>s'. \<exists>s. R p s \<and> ls = s \<and> 
                          s' = s }
                  get_body f s {\<lambda>s. S (s<Res>) (set_locs ls s)} \<rbrakk> 
          \<Longrightarrow>
          A \<parallel>-\<^sub>b {P} FUNres f xs {S}"

 PRIMres: "\<lbrakk> A \<parallel>-\<^sub>p {P} pres {Q} \<rbrakk> 
           \<Longrightarrow>  
           A \<parallel>-\<^sub>r {P} PRIMres pres {Q}"

 CHOICEres: "\<lbrakk> A \<parallel>-\<^sub>c {P} head {P1} ; 
               \<forall> b. A \<turnstile> {\<lambda> r s z. P1 (rtBool b) s z} if_then_else b p1 p2 {Q} \<rbrakk> 
             \<Longrightarrow> 
             A \<parallel>-\<^sub>r {P} CHOICEres head p1 p2 {Q}"

 FUNbody: "\<lbrakk> A \<parallel>-\<^sub>1 {P} decls {P'} \<and> A \<parallel>-\<^sub>r {P'} decls {Q} \<rbrakk>
           \<Longrightarrow>
           A \<parallel>-\<^sub>b {P} FUNbody decls res {Q}"

 CONDhead: "\<lbrakk> A \<parallel>-\<^sub>v {P} v1 {Q} ;  A \<parallel>-\<^sub>v {P} v2 {Q} \<rbrakk> 
            \<Longrightarrow>
            A \<parallel>-\<^sub>c {\<lambda> r s z. P (axTest t v1 v2 s) s z} CONDhead v1 t v2 {Q}"

 EMPTYdec: "A \<parallel>-\<^sub>1 {P} EMPTYdec {P}"

 FULLdec:  "\<lbrakk> A \<parallel>-\<^sub>d {P} l {P'} \<and> A \<parallel>-\<^sub>1 {P'} ls {Q} \<rbrakk>
            \<Longrightarrow>
            A \<parallel>-\<^sub>1 {P} FULLdec l ls {Q}"

 VALdec: "\<lbrakk> A \<parallel>-\<^sub>p {P} p {\<lambda>v s. Q (lupd (x\<mapsto>v) s)} \<rbrakk> 
          \<Longrightarrow>
          A \<parallel>-\<^sub>l  {P} VALdec x p {Q}"

 VOIDdec: "\<lbrakk> A \<parallel>-\<^sub>p {P} p {Q} \<rbrakk> 
           \<Longrightarrow>
           A \<parallel>-\<^sub>l {P} VOIDdec p {Q}"

 (* ToDo: keep type info *)
 ARG: "A \<parallel>-\<^sub>a {\<lambda> r s. P r s} ARG ty vname {P}"

 EMPTYal: "A \<parallel>-\<^sub>2 {P} EMPTYal {P}"

 FULLal:  "\<lbrakk> A \<parallel>-\<^sub>a {P} a {P'} \<and> A \<parallel>-\<^sub>2 {P'} as {Q} \<rbrakk>
           \<Longrightarrow>
           A \<parallel>-\<^sub>2 {P} FULLal a as {Q}"

 EMPTYfundec:  "A \<parallel>-\<^sub>f {P} EMPTYfundec {P}"

 FULLfundec: "\<lbrakk> A \<parallel>-\<^sub>f {P} f {P'} \<and> A \<parallel>-\<^sub>3 {P'} fs {Q} \<rbrakk>
              \<Longrightarrow>
              A \<parallel>-\<^sub>3 {P} FULLfundec f fs {Q}"
 
 FDEC:  "\<lbrakk> A \<parallel>-\<^sub>b {\<lambda> r s. P r (hupd fname args b s)} b {Q} \<rbrakk> 
         \<Longrightarrow>
         A \<parallel>-\<^sub>v {P} FDEC fname args b {Q}"

end

